/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.view;

import com.parablu.epa.common.service.notification.NotificationHelper;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.common.view.BaseView;
import com.parablu.epa.service.alarm.BlusyncThreadHelper;
import com.parablu.epa.view.BackupManagerView;
import com.parablu.epa.view.FontsManager;
import com.parablu.epa.view.RestoreBackup;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackUpPreferenceView
extends BaseView {
    Logger logger = LoggerFactory.getLogger(BackUpPreferenceView.class);
    FontsManager fontsManager;
    private Group backupPanelSubGroup = null;
    private Label backupEnableDisableLabel = null;
    private Label backuEnableDisableInfoLabel = null;
    private Label backupFrequencyLbl = null;
    public CCombo backupFrequencyDaysCombo = null;
    private Label backupFrequencyDaysLabel = null;
    public CCombo backupFrequencyHoursCombo = null;
    private Label backupFrequencyHoursLabel = null;
    public CCombo backupFrequencyMinutesCombo = null;
    private Label backupFrequencyMinutesLabel = null;
    public boolean enableAutoBackupToggle;
    private TimerTask backupTimerTask = null;
    private Timer backupTimer = null;
    Button manualBackupButton = null;
    public Button backupEnableButton = null;
    private Button backupFrequencyApplyButton = null;
    public int backupFrequency = 10;

    public BackUpPreferenceView(Composite composite) {
        this.mainParentComposite = composite;
        if ("true".equals(SettingHelper.getBackupLicenced())) {
            this.generateBackUpPreferencesUI();
        } else {
            this.generateDefaultBackUpPreferencesUI();
        }
    }

    private void generateDefaultBackUpPreferencesUI() {
        Display display = Display.getCurrent();
        this.fontsManager = new FontsManager(display);
        this.enableAutoBackupToggle = SettingHelper.isEnableAutomaticBackUp();
        this.backupFrequency = SettingHelper.getBackUpIntervalInMins();
        this.baseGroup = new Composite(this.mainParentComposite, 4);
        GridLayout baseGroupGridLayout = new GridLayout();
        baseGroupGridLayout.marginWidth = 5;
        baseGroupGridLayout.marginHeight = 10;
        baseGroupGridLayout.marginTop = 10;
        baseGroupGridLayout.marginLeft = 10;
        baseGroupGridLayout.marginRight = 10;
        baseGroupGridLayout.numColumns = 1;
        GridData gridData = new GridData(1808);
        this.baseGroup.setLayout((Layout)baseGroupGridLayout);
        this.baseGroup.setLayoutData((Object)gridData);
        Composite backupNotificationsComposite = new Composite(this.baseGroup, 2048);
        GridLayout backupNotificationsCompositeLayout = new GridLayout();
        backupNotificationsCompositeLayout.marginWidth = 5;
        backupNotificationsCompositeLayout.marginTop = 5;
        backupNotificationsCompositeLayout.marginLeft = 5;
        backupNotificationsCompositeLayout.marginRight = 5;
        backupNotificationsCompositeLayout.marginBottom = 5;
        backupNotificationsCompositeLayout.numColumns = 1;
        backupNotificationsComposite.setLayout((Layout)backupNotificationsCompositeLayout);
        backupNotificationsComposite.setLayoutData((Object)new GridData(768));
        Label label = new Label(backupNotificationsComposite, 64);
        label.setText("Backup is not enabled for this user.\nPlease contact your cloud administrator.");
        label.setFont(this.fontsManager.getMediumNormalFont());
        GridData gridData1 = new GridData(1808);
        gridData1.widthHint = 300;
        label.setLayoutData((Object)gridData1);
    }

    private void generateBackUpPreferencesUI() {
        Display display = Display.getCurrent();
        this.fontsManager = new FontsManager(display);
        this.enableAutoBackupToggle = SettingHelper.isEnableAutomaticBackUp();
        this.backupFrequency = SettingHelper.getBackUpIntervalInMins();
        this.baseGroup = new Composite(this.mainParentComposite, 4);
        GridLayout baseGroupGridLayout = new GridLayout();
        baseGroupGridLayout.marginWidth = 5;
        baseGroupGridLayout.marginHeight = 0;
        baseGroupGridLayout.marginTop = 5;
        baseGroupGridLayout.marginLeft = 0;
        baseGroupGridLayout.marginRight = 0;
        baseGroupGridLayout.numColumns = 1;
        this.baseGroup.setLayout((Layout)baseGroupGridLayout);
        this.baseGroup.setLayoutData((Object)new GridData(1808));
        Composite backupNotificationsComposite = new Composite(this.baseGroup, 4);
        GridLayout backupNotificationsCompositeLayout = new GridLayout();
        backupNotificationsCompositeLayout.horizontalSpacing = 20;
        backupNotificationsCompositeLayout.verticalSpacing = 30;
        backupNotificationsCompositeLayout.marginWidth = 5;
        backupNotificationsCompositeLayout.marginHeight = 0;
        backupNotificationsCompositeLayout.marginTop = 15;
        backupNotificationsCompositeLayout.marginLeft = 5;
        backupNotificationsCompositeLayout.marginRight = 5;
        backupNotificationsCompositeLayout.marginBottom = 50;
        backupNotificationsCompositeLayout.numColumns = 1;
        backupNotificationsComposite.setLayout((Layout)backupNotificationsCompositeLayout);
        backupNotificationsComposite.setLayoutData((Object)new GridData(1808));
        this.backupPanelSubGroup = new Group(backupNotificationsComposite, 0);
        if (SettingHelper.getBackupLicenced().equalsIgnoreCase("true")) {
            this.logger.debug("enable automaticbackup:" + SettingHelper.isEnableAutomaticBackUp());
            this.backupPanelSubGroup.setVisible(false);
        }
        GridLayout backupPanelSubGroupGridLayout = new GridLayout();
        backupPanelSubGroupGridLayout.makeColumnsEqualWidth = false;
        backupPanelSubGroupGridLayout.numColumns = 2;
        backupPanelSubGroupGridLayout.horizontalSpacing = 15;
        backupPanelSubGroupGridLayout.marginWidth = 0;
        backupPanelSubGroupGridLayout.marginLeft = 5;
        backupPanelSubGroupGridLayout.marginRight = 0;
        backupPanelSubGroupGridLayout.verticalSpacing = 8;
        this.backupPanelSubGroup.setLayout((Layout)backupPanelSubGroupGridLayout);
        this.backupPanelSubGroup.setText("Backup Settings");
        this.backupPanelSubGroup.setFont(this.fontsManager.getSmallNormalFont());
        GridData backupPanelSubGroupGridData = new GridData(768);
        backupPanelSubGroupGridData.horizontalSpan = 2;
        this.backupPanelSubGroup.setLayoutData((Object)backupPanelSubGroupGridData);
        this.backupEnableDisableLabel = new Label((Composite)this.backupPanelSubGroup, 0);
        if (this.enableAutoBackupToggle) {
            this.backupEnableDisableLabel.setText("Automatic Backup is Enabled");
        } else {
            this.backupEnableDisableLabel.setText("Automatic Backup is Disabled");
        }
        this.backupEnableDisableLabel.setFont(this.fontsManager.getMediumNormalFont());
        this.backupEnableDisableLabel.setLayoutData((Object)new GridData());
        this.backupEnableButton = new Button((Composite)this.backupPanelSubGroup, 8);
        this.backupEnableButton.setToolTipText("This will synchronize the selected folders with the rest of your devices configured with BluSync");
        GridData backupEnableButtonGridLayout = new GridData();
        backupEnableButtonGridLayout.horizontalIndent = 5;
        this.backupEnableButton.setLayoutData((Object)backupEnableButtonGridLayout);
        this.backupEnableButton.setSelection(this.enableAutoBackupToggle);
        this.backupEnableButton.setFont(this.fontsManager.getMediumBoldFont());
        this.backupEnableButton.setEnabled(true);
        this.backupEnableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (BackUpPreferenceView.this.enableAutoBackupToggle) {
                    BackUpPreferenceView.this.disableAutomaticBackup();
                } else {
                    BackUpPreferenceView.this.enableAutomaticBackup();
                }
            }
        });
        this.backuEnableDisableInfoLabel = new Label((Composite)this.backupPanelSubGroup, 64);
        GridData backupsComponentInfoLabelData = new GridData(512);
        backupsComponentInfoLabelData.widthHint = 260;
        backupsComponentInfoLabelData.horizontalSpan = 2;
        this.backuEnableDisableInfoLabel.setText("(Turns on automatic Backup)");
        this.backuEnableDisableInfoLabel.setFont(this.fontsManager.getSmallItalicFont());
        this.backuEnableDisableInfoLabel.setLayoutData((Object)backupsComponentInfoLabelData);
        this.backupFrequencyLbl = new Label((Composite)this.backupPanelSubGroup, 64);
        this.backupFrequencyLbl.setText("Backup Interval:");
        this.backupFrequencyLbl.setFont(this.fontsManager.getMediumNormalFont());
        this.backupFrequencyLbl.setLayoutData((Object)new GridData());
        Composite backupTimerComposite = new Composite((Composite)this.backupPanelSubGroup, 0);
        GridLayout backupTimerGridLayout = new GridLayout();
        backupTimerGridLayout.numColumns = 6;
        backupTimerComposite.setLayout((Layout)backupTimerGridLayout);
        backupTimerGridLayout.makeColumnsEqualWidth = false;
        this.backupFrequencyDaysLabel = new Label(backupTimerComposite, 0);
        this.backupFrequencyDaysLabel.setText("Days");
        this.backupFrequencyDaysLabel.setFont(this.fontsManager.getExtraSmallNormalFont());
        this.backupFrequencyHoursLabel = new Label(backupTimerComposite, 0);
        this.backupFrequencyHoursLabel.setText("   Hrs  ");
        this.backupFrequencyHoursLabel.setFont(this.fontsManager.getExtraSmallNormalFont());
        this.backupFrequencyMinutesLabel = new Label(backupTimerComposite, 0);
        this.backupFrequencyMinutesLabel.setText("   Mins");
        this.backupFrequencyMinutesLabel.setFont(this.fontsManager.getExtraSmallNormalFont());
        Composite backupTimerCompositeForMins = new Composite(backupTimerComposite, 0);
        GridData backupTimerCompositeForMinsGridData = new GridData();
        backupTimerCompositeForMinsGridData.horizontalSpan = 4;
        backupTimerCompositeForMins.setLayoutData((Object)backupTimerCompositeForMinsGridData);
        GridLayout backupTimerCompositeForMinsGridLayout = new GridLayout();
        backupTimerCompositeForMinsGridLayout.numColumns = 6;
        backupTimerCompositeForMinsGridLayout.marginLeft = -7;
        backupTimerGridLayout.makeColumnsEqualWidth = false;
        backupTimerCompositeForMins.setLayout((Layout)backupTimerCompositeForMinsGridLayout);
        this.backupFrequencyDaysCombo = new CCombo(backupTimerCompositeForMins, 782);
        this.backupFrequencyDaysCombo.setItems(new String[]{"0", "1", "2", "3", "4", "5", "6", "7"});
        this.backupFrequencyDaysCombo.setText(String.valueOf(this.backupFrequency / 1440));
        this.backupFrequencyDaysCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BackUpPreferenceView.this.backupFrequencyApplyButton.setEnabled(true);
            }
        });
        this.backupFrequencyHoursCombo = new CCombo(backupTimerCompositeForMins, 782);
        this.backupFrequencyHoursCombo.setItems(new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23"});
        this.backupFrequencyHoursCombo.setText(String.valueOf(this.backupFrequency / 60 % 24));
        this.backupFrequencyHoursCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BackUpPreferenceView.this.backupFrequencyApplyButton.setEnabled(true);
            }
        });
        this.backupFrequencyMinutesCombo = new CCombo(backupTimerCompositeForMins, 520);
        GridData backupFrequencyMinutesComboGridData = new GridData();
        this.backupFrequencyMinutesCombo.setLayoutData((Object)backupFrequencyMinutesComboGridData);
        this.backupFrequencyMinutesCombo.setItems(new String[]{"0", "5", "10", "15", "20", "25", "30", "35", "40", "45", "50", "55"});
        this.backupFrequencyMinutesCombo.setText(String.valueOf(this.backupFrequency % 60));
        this.backupFrequencyMinutesCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BackUpPreferenceView.this.backupFrequencyApplyButton.setEnabled(true);
            }
        });
        this.backupFrequencyApplyButton = new Button((Composite)this.backupPanelSubGroup, 8);
        GridData backupFrequencyApplyButtonGridLayout = new GridData();
        backupFrequencyApplyButtonGridLayout.horizontalIndent = 190;
        backupFrequencyApplyButtonGridLayout.verticalIndent = 0;
        backupFrequencyApplyButtonGridLayout.horizontalSpan = 2;
        this.backupFrequencyApplyButton.setLayoutData((Object)backupFrequencyApplyButtonGridLayout);
        this.backupFrequencyApplyButton.setText("Apply Interval");
        this.backupFrequencyApplyButton.setFont(this.fontsManager.getMediumNormalFont());
        this.backupFrequencyApplyButton.setEnabled(true);
        this.backupFrequencyApplyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BackUpPreferenceView.this.saveNewBackupFrequency();
                BackUpPreferenceView.this.backupFrequencyApplyButton.setEnabled(false);
            }
        });
        Composite buttonComposite = new Composite(backupNotificationsComposite, 0x1000000);
        GridLayout buttonCompositeGridLayout = new GridLayout();
        buttonCompositeGridLayout.marginTop = 10;
        buttonCompositeGridLayout.marginHeight = 0;
        buttonCompositeGridLayout.marginWidth = 10;
        buttonCompositeGridLayout.marginLeft = 0;
        buttonCompositeGridLayout.makeColumnsEqualWidth = false;
        buttonCompositeGridLayout.horizontalSpacing = 10;
        buttonCompositeGridLayout.numColumns = 1;
        buttonCompositeGridLayout.marginBottom = 20;
        buttonComposite.setLayout((Layout)buttonCompositeGridLayout);
        GridData buttonCompositeGridData = new GridData(768);
        buttonCompositeGridData.horizontalSpan = 2;
        buttonComposite.setLayoutData((Object)buttonCompositeGridData);
        Button buttonAddFolders = new Button(buttonComposite, 524288);
        buttonAddFolders.setText("Configure folders for backup");
        buttonAddFolders.setFont(this.fontsManager.getMediumNormalFont());
        buttonAddFolders.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    BackupManagerView backupManagerView = new BackupManagerView(BackUpPreferenceView.this.mainParentComposite.getShell());
                    backupManagerView.open();
                }
                catch (Exception e1) {
                    BackUpPreferenceView.this.logger.error("Exception in add folders: ", (Throwable)e1);
                }
            }
        });
        buttonAddFolders.setFont(this.fontsManager.getSmallNormalFont());
        Button buttonRestore = new Button(buttonComposite, 524288);
        buttonRestore.setText("Restore Backed-up device");
        buttonRestore.setFont(this.fontsManager.getMediumNormalFont());
        if ("true".equals(SettingHelper.getRestoreEnabled())) {
            buttonRestore.setVisible(true);
        } else {
            buttonRestore.setVisible(false);
        }
        buttonRestore.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    RestoreBackup restorebackup = new RestoreBackup(BackUpPreferenceView.this.mainParentComposite.getShell());
                    restorebackup.setText("Restore Backup");
                    restorebackup.startRestoreBackup();
                    restorebackup.openShell();
                }
                catch (Exception e1) {
                    BackUpPreferenceView.this.logger.error("Exception in button restore: ", (Throwable)e1);
                }
            }
        });
        buttonRestore.setFont(this.fontsManager.getSmallNormalFont());
        if (this.enableAutoBackupToggle) {
            this.changeImageAndTextOfEnableBackupButton(true);
            this.diableOtherBackupOptions(this.enableAutoBackupToggle);
        } else {
            this.changeImageAndTextOfEnableBackupButton(false);
            this.diableOtherBackupOptions(this.enableAutoBackupToggle);
        }
    }

    private void enableAutomaticBackup() {
        this.changeImageAndTextOfEnableBackupButton(true);
        this.enableAutoBackupToggle = true;
        SettingHelper.setTempEnableAutomaticBackUp((boolean)true);
        this.diableOtherBackupOptions(this.enableAutoBackupToggle);
        SettingHelper.applyChangesToSharedPreferences((boolean)true);
        this.backupEnableDisableLabel.setText("Automatic Backup is Enabled");
        this.backupEnableDisableLabel.getParent().layout();
    }

    private void disableAutomaticBackup() {
        this.changeImageAndTextOfEnableBackupButton(false);
        this.enableAutoBackupToggle = false;
        SettingHelper.setTempEnableAutomaticBackUp((boolean)false);
        this.diableOtherBackupOptions(this.enableAutoBackupToggle);
        SettingHelper.applyChangesToSharedPreferences((boolean)true);
        this.backupEnableDisableLabel.setText("Automatic Backup is Disabled");
        this.backupEnableDisableLabel.getParent().layout();
    }

    protected void applyChangesToBackupSettings(int backupFrequency, boolean backupEnable) {
        boolean appliedSuccessfully;
        if (backupFrequency != -1) {
            SettingHelper.setTempBackUpIntervalInMins((int)backupFrequency);
        }
        if (appliedSuccessfully = SettingHelper.applyChangesToSharedPreferences((boolean)true)) {
            this.updateUIBasedOnChoice(backupEnable);
            BlusyncThreadHelper.resetBackupTimer();
        }
        if (this.mainParentComposite.getShell() == null) {
            return;
        }
        MessageBox msg = new MessageBox(this.mainParentComposite.getShell(), 34);
        msg.setText("Settings Saved");
        msg.setMessage("Backup settings updated");
        msg.open();
    }

    private void saveNewBackupFrequency() {
        int syncFrequency;
        int syncFrequencyHours = 0;
        int syncFrequencyDays = 0;
        int syncFrequencyMinutes = 1;
        boolean change = false;
        if (this.backupFrequencyDaysCombo.getSelectionIndex() != -1) {
            syncFrequencyDays = Integer.parseInt(this.backupFrequencyDaysCombo.getItem(this.backupFrequencyDaysCombo.getSelectionIndex())) * 24 * 60;
            change = true;
        }
        if (this.backupFrequencyHoursCombo.getSelectionIndex() != -1) {
            syncFrequencyHours = Integer.parseInt(this.backupFrequencyHoursCombo.getItem(this.backupFrequencyHoursCombo.getSelectionIndex())) * 60;
            change = true;
        }
        if (this.backupFrequencyMinutesCombo.getSelectionIndex() != -1) {
            syncFrequencyMinutes = Integer.parseInt(this.backupFrequencyMinutesCombo.getItem(this.backupFrequencyMinutesCombo.getSelectionIndex()));
            change = true;
        }
        if ((syncFrequency = !change || !this.backupFrequencyMinutesCombo.isEnabled() ? -1 : syncFrequencyDays + syncFrequencyHours + syncFrequencyMinutes) == 0) {
            MessageBox msg = new MessageBox(this.mainParentComposite.getShell(), 34);
            msg.setText("Invalid Choice");
            msg.setMessage("You cannot have a sync interval of zero. Please select a different value");
            msg.open();
        } else {
            this.applyChangesToBackupSettings(syncFrequency, this.enableAutoBackupToggle);
        }
    }

    private void updateUIBasedOnChoice(boolean backupEnable) {
        if (backupEnable && NotificationHelper.getMainStatus() == 100) {
            NotificationHelper.setCurrentActivityState((int)12);
        } else if (!backupEnable && NotificationHelper.getMainStatus() == 100) {
            NotificationHelper.setCurrentActivityState((int)9);
        }
    }

    public void disoposeAllWidgets() {
        this.stopBackupTimer();
        if (this.baseGroup != null) {
            this.baseGroup.dispose();
        }
        this.fontsManager.disposeFonts();
    }

    public void startBackupTimer() {
        if (this.backupTimer == null) {
            this.backupTimer = new Timer();
        }
        if (this.backupTimerTask == null) {
            this.backupTimerTask = new TimerTask(){

                @Override
                public void run() {
                }
            };
            this.backupTimer.schedule(this.backupTimerTask, 1000L, 1000L);
        }
    }

    public void stopBackupTimer() {
        if (this.backupTimer != null) {
            this.backupTimer.cancel();
            this.logger.debug("BackupTimer stopped");
        }
        this.backupTimerTask = null;
        this.backupTimer = null;
    }

    private void diableOtherBackupOptions(boolean enableBlusyncToggle2) {
        if (!this.backupFrequencyDaysCombo.isDisposed() && !this.backupFrequencyDaysCombo.getParent().isDisposed()) {
            this.backupFrequencyDaysCombo.setEnabled(enableBlusyncToggle2);
        }
        if (!this.backupFrequencyHoursCombo.isDisposed() && !this.backupFrequencyHoursCombo.getParent().isDisposed()) {
            this.backupFrequencyHoursCombo.setEnabled(enableBlusyncToggle2);
        }
        if (!this.backupFrequencyMinutesCombo.isDisposed() && !this.backupFrequencyMinutesCombo.getParent().isDisposed()) {
            this.backupFrequencyMinutesCombo.setEnabled(enableBlusyncToggle2);
        }
        if (!this.backupFrequencyLbl.isDisposed() && !this.backupFrequencyLbl.getParent().isDisposed()) {
            this.backupFrequencyLbl.setEnabled(enableBlusyncToggle2);
        }
        if (!this.backupFrequencyDaysLabel.isDisposed() && !this.backupFrequencyDaysLabel.getParent().isDisposed()) {
            this.backupFrequencyDaysLabel.setEnabled(enableBlusyncToggle2);
        }
        if (!this.backupFrequencyMinutesLabel.isDisposed() && !this.backupFrequencyMinutesLabel.getParent().isDisposed()) {
            this.backupFrequencyMinutesLabel.setEnabled(enableBlusyncToggle2);
        }
        if (!this.backupFrequencyHoursLabel.isDisposed() && !this.backupFrequencyHoursLabel.getParent().isDisposed()) {
            this.backupFrequencyHoursLabel.setEnabled(enableBlusyncToggle2);
        }
        if (!this.backupFrequencyApplyButton.isDisposed() && !this.backupFrequencyApplyButton.getParent().isDisposed()) {
            this.backupFrequencyApplyButton.setEnabled(enableBlusyncToggle2);
        }
    }

    private void changeImageAndTextOfEnableBackupButton(boolean state) {
        if (state) {
            this.backupEnableButton.setText("Disable");
            this.backupEnableButton.setFont(this.fontsManager.getMediumNormalFont());
        } else {
            this.backupEnableButton.setText("Enable");
            this.backupEnableButton.setFont(this.fontsManager.getMediumNormalFont());
        }
        this.backupEnableButton.getParent().layout();
    }
}

