/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.pkcs;

import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERConstructedSequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.pkcs.ContentInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;

public class SignedData
implements DEREncodable,
PKCSObjectIdentifiers {
    private DERInteger version;
    private DERObject digestAlgorithms;
    private ContentInfo contentInfo;
    private DERObject certificates;
    private DERObject crls;

    public SignedData(ASN1Sequence aSN1Sequence) {
        Enumeration enumeration = aSN1Sequence.getObjects();
        this.version = (DERInteger)enumeration.nextElement();
        this.digestAlgorithms = ((DERSet)enumeration.nextElement()).getSequence();
        this.contentInfo = ContentInfo.getInstance(enumeration.nextElement());
        while (enumeration.hasMoreElements()) {
            DERObject dERObject = (DERObject)enumeration.nextElement();
            if (!(dERObject instanceof DERTaggedObject)) continue;
            DERTaggedObject dERTaggedObject = (DERTaggedObject)dERObject;
            switch (dERTaggedObject.getTagNo()) {
                case 0: {
                    this.certificates = dERTaggedObject.getObject();
                    break;
                }
                case 1: {
                    this.crls = dERTaggedObject.getObject();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown tag value " + dERTaggedObject.getTagNo());
                }
            }
        }
    }

    public DERInteger getVersion() {
        return this.version;
    }

    public ContentInfo getContentInfo() {
        return this.contentInfo;
    }

    public DERObject getCertficates() {
        return this.certificates;
    }

    public DERObject getDERObject() {
        DERConstructedSequence dERConstructedSequence = new DERConstructedSequence();
        dERConstructedSequence.addObject(this.version);
        dERConstructedSequence.addObject(this.digestAlgorithms);
        dERConstructedSequence.addObject(this.contentInfo);
        if (this.certificates != null) {
            dERConstructedSequence.addObject(new DERTaggedObject(false, 0, this.certificates));
        }
        if (this.crls != null) {
            dERConstructedSequence.addObject(new DERTaggedObject(false, 1, this.crls));
        }
        return dERConstructedSequence;
    }
}

