/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.service.support;

import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.core.adapter.api.SupportAdapter;
import com.parablu.epa.core.adapter.pcb.BackupAdapter;
import com.parablu.epa.core.adapter.tcp.ListnerAdapter;
import com.parablu.epa.core.constant.StringLiterals;
import com.parablu.epa.core.element.LogFileElementList;
import com.parablu.epa.core.element.LogFileInfoElement;
import com.parablu.epa.core.element.NewSupportElement;
import com.parablu.epa.core.to.DisplayTo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SupportHelper {
    private static SupportAdapter supportAdapter;
    private static boolean supportRequestInitiated;
    private static String supportRequestId;
    private static ListnerAdapter listnerAdapter;
    private static Logger logger;

    private SupportHelper() {
    }

    public static int sendNewSupportLogs(String cloudName, String userName, String deviceName, boolean sendLogs, boolean sendHistoricalLogs, boolean sendDbs, boolean sendSetupLogs, String eventList) {
        supportRequestInitiated = true;
        String requestId = null;
        NewSupportElement supportElement = new NewSupportElement();
        LogFileElementList logFileElementList = new LogFileElementList();
        List<LogFileInfoElement> fileInfoElementList = SupportHelper.getLogFileInfo(sendHistoricalLogs, sendDbs, sendSetupLogs);
        logFileElementList.setLogFiles(fileInfoElementList);
        supportElement.setId(String.valueOf(System.currentTimeMillis()));
        supportElement.setCloudName(cloudName);
        supportElement.setDeviceName(deviceName);
        supportElement.setTimestamp(String.valueOf(System.currentTimeMillis()));
        supportElement.setUserName(userName);
        supportElement.setFileElementList(logFileElementList);
        String token = null;
        try {
            token = SettingHelper.readTokenFromFile();
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception geting token:" + e.getMessage());
        }
        if (!sendLogs) {
            supportRequestInitiated = false;
            return 1;
        }
        logger.debug("Compressing Files");
        File file = SupportHelper.compressAllLogs(sendHistoricalLogs, sendDbs, sendSetupLogs);
        if (file == null) {
            supportRequestInitiated = false;
            return 1;
        }
        logger.debug("Sending Support File");
        supportAdapter = new SupportAdapter(SettingHelper.getKeystorePath());
        if (!supportAdapter.sendSupportLogFile(file, cloudName, userName, SettingHelper.getCurrentCloudIpAddress(), token, SettingHelper.getDeviceUUId())) {
            logger.debug("Send Support File failed ..");
            SupportHelper.deleteZipFiles(file);
            supportRequestInitiated = false;
            return 1;
        }
        logger.debug("Sending prelim request");
        if (supportAdapter.sendSupportMessage(cloudName, supportElement, SettingHelper.getCurrentCloudIpAddress(), token, SettingHelper.getDeviceUUId(), eventList, userName)) {
            requestId = supportAdapter.getRequestID();
            if (requestId == null) {
                logger.debug("Support Request ID is null");
                supportRequestInitiated = false;
                return 1;
            }
            supportRequestId = requestId;
            SupportHelper.deleteZipFiles(file);
            supportRequestInitiated = false;
            return 2;
        }
        supportRequestId = requestId;
        SupportHelper.deleteZipFiles(file);
        supportRequestInitiated = false;
        return 1;
    }

    private static void deleteZipFiles(File file) {
        try {
            file.delete();
            SupportHelper.deleteLogFile("Service_logs.zip");
            SupportHelper.deleteLogFile("Historical_logs.zip");
            SupportHelper.deleteLogFile("Databases.zip");
            SupportHelper.deleteLogFile("Setup_logs.zip");
            SupportHelper.deleteLogFile("BluSync_logs.zip");
        }
        catch (Exception e) {
            logger.error("Error in delete Zip files  :" + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static File compressAllLogs(boolean sendHistoricalLogs, boolean sendDbs, boolean sendSetupLogs) {
        try {
            String basePath = SupportHelper.getBasePath();
            File logZip = new File(basePath + StringLiterals.FILE_SEPARATOR + "pblog.zip");
            if (logZip.exists()) {
                logZip.delete();
            }
            try (ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(logZip));){
                logZip.createNewFile();
                if (!sendHistoricalLogs) {
                    File debugFile = new File(basePath + StringLiterals.FILE_SEPARATOR + "BluSync.debug");
                    File warnFile = new File(basePath + StringLiterals.FILE_SEPARATOR + "BluSync.warn");
                    File errorFile = new File(basePath + StringLiterals.FILE_SEPARATOR + "BluSync.error");
                    File infoFile = new File(basePath + StringLiterals.FILE_SEPARATOR + "BluSync.info");
                    SupportHelper.addEntryToZip(debugFile, zipOutputStream);
                    SupportHelper.addEntryToZip(warnFile, zipOutputStream);
                    SupportHelper.addEntryToZip(errorFile, zipOutputStream);
                    SupportHelper.addEntryToZip(infoFile, zipOutputStream);
                }
                if (SettingHelper.getOsName().toLowerCase().contains("win")) {
                    File serviceLogFile = new File(basePath + StringLiterals.FILE_SEPARATOR + "Service_logs.zip");
                    SupportHelper.addEntryToZip(serviceLogFile, zipOutputStream);
                    logger.debug("adding service logs");
                }
                if (sendHistoricalLogs) {
                    File historicalLogFile = new File(basePath + StringLiterals.FILE_SEPARATOR + "Historical_logs.zip");
                    SupportHelper.addEntryToZip(historicalLogFile, zipOutputStream);
                    logger.debug("adding historical logs");
                }
                if (sendDbs) {
                    File Dbfolder = new File(basePath + StringLiterals.FILE_SEPARATOR + "Databases.zip");
                    SupportHelper.addEntryToZip(Dbfolder, zipOutputStream);
                    logger.debug("adding dbs");
                }
                if (SettingHelper.getOsName().toLowerCase().contains("win") && sendSetupLogs) {
                    File setupLogFile = new File(basePath + StringLiterals.FILE_SEPARATOR + "Setup_logs.zip");
                    SupportHelper.addEntryToZip(setupLogFile, zipOutputStream);
                    logger.debug("adding setup logs");
                }
                IOUtils.closeQuietly((OutputStream)zipOutputStream);
                File file = logZip;
                return file;
            }
            catch (IOException e) {
                logger.error("IOException while entering to zip", (Throwable)e);
                return null;
            }
        }
        catch (Exception e) {
            logger.error("Error in compressLogs..." + e.getMessage());
        }
        return null;
    }

    private static String getBasePath() {
        String basePath = SettingHelper.getOsName().toLowerCase().contains("win") ? SettingHelper.getParabluBlusyncAppDataFolderUrl() : SettingHelper.getUserHome() + StringLiterals.FILE_SEPARATOR + ".ParaBlu" + StringLiterals.FILE_SEPARATOR + "ParaBlu" + StringLiterals.FILE_SEPARATOR + "Blusync";
        return basePath;
    }

    public static void addEntryToZip(File logFile, ZipOutputStream zipOutputStream) throws IOException {
        try {
            if (logFile.exists()) {
                ZipEntry zipEntry = new ZipEntry(logFile.getName());
                zipOutputStream.putNextEntry(zipEntry);
                FileInputStream fileInputStream = new FileInputStream(logFile);
                IOUtils.copy((InputStream)fileInputStream, (OutputStream)zipOutputStream);
                fileInputStream.close();
                zipOutputStream.closeEntry();
            }
        }
        catch (Exception e) {
            logger.error("Error in add  entry to zip file .." + e.getMessage());
        }
    }

    public static boolean isSupportRequestInitiated() {
        return supportRequestInitiated;
    }

    public static void setSupportRequestInitiated(boolean supportRequestInitiated) {
        SupportHelper.supportRequestInitiated = supportRequestInitiated;
    }

    public static String getSupportRequestId() {
        return supportRequestId;
    }

    public static void setSupportRequestId(String supportRequestId) {
        SupportHelper.supportRequestId = supportRequestId;
    }

    public static boolean checkDeviceBlocked() {
        logger.debug("check the selected device to restore is blocked or not");
        BackupAdapter backupAdapter = new BackupAdapter(SettingHelper.getCloudName(), SettingHelper.getKeystorePath());
        try {
            List listDevices = backupAdapter.getAllRegisteredDevicesByUser(SettingHelper.getCurrentCloudIpAddress(), null, SettingHelper.readTokenFromFile());
            Iterator deviceList = listDevices.iterator();
            if (deviceList != null) {
                while (deviceList.hasNext()) {
                    if (!SettingHelper.getDeviceUUId().equalsIgnoreCase(((DisplayTo)deviceList.next()).getDeviceUid())) continue;
                    logger.debug("device is not blocked");
                    return true;
                }
            }
        }
        catch (Exception e) {
            logger.debug(e.toString());
            logger.trace("" + e);
            logger.error("exception" + e.getMessage());
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static File compressHistoricalLogs() {
        try {
            File[] files;
            String basePath = SupportHelper.getBasePath();
            ArrayList<File> filesList = new ArrayList<File>();
            File filepath = new File(basePath);
            for (File file2 : files = filepath.listFiles()) {
                if (!file2.getName().toLowerCase().startsWith("Blusync".toLowerCase())) continue;
                File logfile = new File(file2.getAbsolutePath());
                filesList.add(logfile);
            }
            File logZip = new File(basePath + StringLiterals.FILE_SEPARATOR + "Historical_logs.zip");
            if (logZip.exists()) {
                logZip.delete();
            }
            try (ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(logZip));){
                logZip.createNewFile();
                for (File file2 : filesList) {
                    SupportHelper.addEntryToZip(file2, zipOutputStream);
                }
                IOUtils.closeQuietly((OutputStream)zipOutputStream);
                File file = logZip;
                return file;
            }
            catch (IOException e) {
                logger.error("IOException while entering to zip", (Throwable)e);
                return null;
            }
        }
        catch (Exception e) {
            logger.error("Error in compress HistoricalLogs ...", (Throwable)e);
        }
        return null;
    }

    private static void copyFilesUnderTempToinstallationdir(String basePath, String basePathforService, List<File> TotalFilesList) {
        try {
            File[] fileslist1;
            File[] fileslist;
            File baseFolder = new File(basePath);
            String appdataFolder = baseFolder.getParentFile().getParentFile().getParent();
            File temp = new File(appdataFolder + StringLiterals.FILE_SEPARATOR + "Local" + StringLiterals.FILE_SEPARATOR + "Temp");
            logger.debug("..." + temp.getAbsolutePath());
            for (File file : fileslist = temp.listFiles()) {
                if (!file.getName().startsWith("Setup Log")) continue;
                logger.debug("..." + file.getAbsolutePath());
                File source = new File(file.getAbsolutePath());
                File dest = new File(baseFolder + StringLiterals.FILE_SEPARATOR + file.getName());
                FileUtils.copyFile((File)source, (File)dest);
            }
            for (File file : fileslist1 = baseFolder.listFiles()) {
                if (!file.getName().startsWith("Setup Log")) continue;
                File logfile = new File(file.getAbsolutePath());
                TotalFilesList.add(logfile);
            }
        }
        catch (Exception e) {
            logger.error("Error in copyFilesUnderTempToinstallationdir..." + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static File compressLogfile() {
        try {
            String basePath = SupportHelper.getBasePath();
            File debugFile = new File(basePath + StringLiterals.FILE_SEPARATOR + "BluSync.debug");
            File warnFile = new File(basePath + StringLiterals.FILE_SEPARATOR + "BluSync.warn");
            File errorFile = new File(basePath + StringLiterals.FILE_SEPARATOR + "BluSync.error");
            File infoFile = new File(basePath + StringLiterals.FILE_SEPARATOR + "BluSync.info");
            File zipfile = new File(basePath + StringLiterals.FILE_SEPARATOR + "Historical_logs.zip");
            File logZip = new File(basePath + StringLiterals.FILE_SEPARATOR + "pblog.zip");
            if (logZip.exists()) {
                logZip.delete();
            }
            try (ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(logZip));){
                logZip.createNewFile();
                SupportHelper.addEntryToZip(debugFile, zipOutputStream);
                SupportHelper.addEntryToZip(warnFile, zipOutputStream);
                SupportHelper.addEntryToZip(errorFile, zipOutputStream);
                SupportHelper.addEntryToZip(infoFile, zipOutputStream);
                SupportHelper.addEntryToZip(zipfile, zipOutputStream);
                if (SettingHelper.getOsName().toLowerCase().contains("win")) {
                    File serviceLogFile = new File(basePath + StringLiterals.FILE_SEPARATOR + "Service_logs.zip");
                    SupportHelper.addEntryToZip(serviceLogFile, zipOutputStream);
                    logger.debug("adding service logs");
                }
                IOUtils.closeQuietly((OutputStream)zipOutputStream);
                File file = logZip;
                return file;
            }
            catch (IOException e) {
                logger.error("IOException while entering to zip", (Throwable)e);
                return null;
            }
        }
        catch (Exception e) {
            logger.error("Error in compressLogfile..." + e.getMessage());
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static File compressServiceLogs() {
        try {
            String basePath = SupportHelper.getBasePath();
            String basePathforService = SettingHelper.getInstallationDir() + StringLiterals.FILE_SEPARATOR + "Blusync";
            File debugFileforService = new File(basePathforService + StringLiterals.FILE_SEPARATOR + "ParabluService.debug");
            File warnFileforService = new File(basePathforService + StringLiterals.FILE_SEPARATOR + "ParabluService.warn");
            File errorFileforService = new File(basePathforService + StringLiterals.FILE_SEPARATOR + "ParabluService.error");
            File infoFileforService = new File(basePathforService + StringLiterals.FILE_SEPARATOR + "ParabluService.info");
            File vssapiProvider = new File(basePathforService + StringLiterals.FILE_SEPARATOR + "vssapiProvider.log");
            File logZip = new File(basePath + StringLiterals.FILE_SEPARATOR + "Service_logs.zip");
            if (logZip.exists()) {
                logZip.delete();
            }
            try (ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(logZip));){
                logZip.createNewFile();
                SupportHelper.addEntryToZip(debugFileforService, zipOutputStream);
                SupportHelper.addEntryToZip(warnFileforService, zipOutputStream);
                SupportHelper.addEntryToZip(errorFileforService, zipOutputStream);
                SupportHelper.addEntryToZip(infoFileforService, zipOutputStream);
                SupportHelper.addEntryToZip(vssapiProvider, zipOutputStream);
                IOUtils.closeQuietly((OutputStream)zipOutputStream);
                File file = logZip;
                return file;
            }
            catch (IOException e) {
                logger.error("IOException while entering to zip", (Throwable)e);
                return null;
            }
        }
        catch (Exception e) {
            logger.error("Error in compressServiceLogs..." + e.getMessage());
        }
        return null;
    }

    private static void deleteLogFile(String fileName) {
        try {
            String basePath = SupportHelper.getBasePath();
            File file1 = new File(basePath + StringLiterals.FILE_SEPARATOR + fileName);
            if (file1.exists()) {
                file1.delete();
            }
        }
        catch (Exception e) {
            logger.error("Error to delete Log File ..." + e.getMessage());
        }
    }

    private static List<LogFileInfoElement> getLogFileInfo(boolean sendHistoricalLogs, boolean sendDbs, boolean sendSetupLogs) {
        ArrayList<LogFileInfoElement> logFilesList = null;
        try {
            logFilesList = new ArrayList<LogFileInfoElement>();
            ArrayList<File> files = new ArrayList<File>();
            if (sendDbs) {
                logger.debug("adding dbs");
                File dbs = SupportHelper.compressDbs();
                files.add(dbs);
            }
            if (SettingHelper.getOsName().toLowerCase().contains("win") && sendSetupLogs) {
                logger.debug("adding setup logs");
                File setupLogs = SupportHelper.compressSetupLogs();
                if (setupLogs != null) {
                    files.add(setupLogs);
                }
            }
            if (SettingHelper.getOsName().toLowerCase().contains("win")) {
                logger.debug("adding service logs");
                File serviceLogFile = SupportHelper.compressServiceLogs();
                files.add(serviceLogFile);
            }
            if (!sendHistoricalLogs) {
                logger.debug("adding logs");
                String basePath = SupportHelper.getBasePath();
                File debugFile = new File(basePath + StringLiterals.FILE_SEPARATOR + "BluSync.debug");
                File warnFile = new File(basePath + StringLiterals.FILE_SEPARATOR + "BluSync.warn");
                File errorFile = new File(basePath + StringLiterals.FILE_SEPARATOR + "BluSync.error");
                File infoFile = new File(basePath + StringLiterals.FILE_SEPARATOR + "BluSync.info");
                files.add(debugFile);
                files.add(warnFile);
                files.add(errorFile);
                files.add(infoFile);
            }
            if (sendHistoricalLogs) {
                logger.debug("adding historical logs...");
                File historicalLogFile = SupportHelper.compressHistoricalLogs();
                files.add(historicalLogFile);
            }
            for (File file : files) {
                LogFileInfoElement fileInfoElement = new LogFileInfoElement();
                fileInfoElement.setFilename(file.getName());
                fileInfoElement.setSize(String.valueOf(file.length()));
                fileInfoElement.setLastModified(String.valueOf(file.lastModified()));
                logFilesList.add(fileInfoElement);
            }
        }
        catch (Exception e) {
            logger.error("Error in get LogFileInfo..." + e.getMessage());
        }
        return logFilesList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static File compresslogs() {
        try {
            String basePath = SupportHelper.getBasePath();
            File debugFile = new File(basePath + StringLiterals.FILE_SEPARATOR + "BluSync.debug");
            File warnFile = new File(basePath + StringLiterals.FILE_SEPARATOR + "BluSync.warn");
            File errorFile = new File(basePath + StringLiterals.FILE_SEPARATOR + "BluSync.error");
            File infoFile = new File(basePath + StringLiterals.FILE_SEPARATOR + "BluSync.info");
            ArrayList<File> files = new ArrayList<File>();
            files.add(debugFile);
            files.add(warnFile);
            files.add(errorFile);
            files.add(infoFile);
            File logZip = new File(basePath + StringLiterals.FILE_SEPARATOR + "BluSync_logs.zip");
            if (logZip.exists()) {
                logZip.delete();
            }
            try (ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(logZip));){
                logZip.createNewFile();
                for (File file2 : files) {
                    SupportHelper.addEntryToZip(file2, zipOutputStream);
                }
                IOUtils.closeQuietly((OutputStream)zipOutputStream);
                File file = logZip;
                return file;
            }
            catch (IOException e) {
                logger.error("IOException while entering to zip", (Throwable)e);
                return null;
            }
        }
        catch (Exception e) {
            logger.error("Error in compress logs .. ", (Throwable)e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static File compressDbs() {
        try {
            String basePath = SupportHelper.getBasePath();
            File dbFolder = new File(basePath + StringLiterals.FILE_SEPARATOR + "databases");
            File[] files = dbFolder.listFiles();
            ArrayList<File> filesList = new ArrayList<File>();
            for (File file2 : files) {
                File logfile = new File(file2.getAbsolutePath());
                filesList.add(logfile);
            }
            File logZip = new File(basePath + StringLiterals.FILE_SEPARATOR + "Databases.zip");
            if (logZip.exists()) {
                logZip.delete();
            }
            try (ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(logZip));){
                logZip.createNewFile();
                for (File file2 : filesList) {
                    SupportHelper.addEntryToZip(file2, zipOutputStream);
                }
                IOUtils.closeQuietly((OutputStream)zipOutputStream);
                File file = logZip;
                return file;
            }
            catch (IOException e) {
                logger.error("IOException while entering to zip", (Throwable)e);
                return null;
            }
        }
        catch (Exception e) {
            logger.error("Error in compress DBs .. ", (Throwable)e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static File compressSetupLogs() {
        try {
            String basePath = SupportHelper.getBasePath();
            String basePathforService = SettingHelper.getInstallationDir() + StringLiterals.FILE_SEPARATOR + "Blusync";
            ArrayList<File> totalFilesList = new ArrayList<File>();
            SupportHelper.copySetupLogFilesUnderWindows(basePathforService, totalFilesList);
            SupportHelper.copyFilesUnderTempToinstallationdir(basePath, basePathforService, totalFilesList);
            File logZip = new File(basePath + StringLiterals.FILE_SEPARATOR + "Setup_logs.zip");
            if (logZip.exists()) {
                logZip.delete();
            }
            try (ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(logZip));){
                logZip.createNewFile();
                for (File file2 : totalFilesList) {
                    SupportHelper.addEntryToZip(file2, zipOutputStream);
                    file2.delete();
                }
                IOUtils.closeQuietly((OutputStream)zipOutputStream);
                File file = logZip;
                return file;
            }
            catch (IOException e) {
                logger.error("IOException while entering to zip", (Throwable)e);
                return null;
            }
        }
        catch (Exception e) {
            logger.error("Error Error in compress setp logs.. .. ", (Throwable)e);
        }
        return null;
    }

    private static void copySetupLogFilesUnderWindows(String basePathforService, List<File> filesList) {
        try {
            File[] files;
            listnerAdapter.copySetupLogs(SettingHelper.getCurrentCloudIpAddress(), SettingHelper.getCloudName(), SettingHelper.getDeviceUUId(), SettingHelper.getUserHome());
            File setupLogs = new File(basePathforService);
            for (File file : files = setupLogs.listFiles()) {
                if (!file.getName().startsWith("Setup Log")) continue;
                File logfile = new File(file.getAbsolutePath());
                filesList.add(logfile);
            }
        }
        catch (Exception e) {
            logger.error("Error inside copySetupLogFilesUnderWindows ..." + e.getMessage());
        }
    }

    static {
        supportRequestInitiated = false;
        supportRequestId = null;
        listnerAdapter = new ListnerAdapter();
        logger = LoggerFactory.getLogger(SupportHelper.class);
    }
}

