/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.dao;

import com.parablu.epa.common.dao.BaseDAO;
import com.parablu.epa.core.constant.BluSyncSQLConstants;
import com.parablu.epa.core.dao.FullBackupInfoTableDAO;
import com.parablu.epa.core.to.FullBackupInfoTO;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FullBackupInfoTableDAOImpl
extends BaseDAO
implements FullBackupInfoTableDAO {
    private Logger logger = LoggerFactory.getLogger(FullBackupInfoTableDAOImpl.class);
    private static final String DELETEFROM = "delete from ";

    public FullBackupInfoTableDAOImpl(String uRL) {
        super(uRL);
    }

    public boolean alterTable() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean clearEntireTable() {
        FullBackupInfoTableDAOImpl fullBackupInfoTableDAOImpl = this;
        synchronized (fullBackupInfoTableDAOImpl) {
            String query = "delete from FULLBACKUPINFO";
            boolean success = false;
            this.statement = null;
            if (this.getConnection()) {
                try {
                    this.statement = this.conn.prepareStatement("delete from FULLBACKUPINFO");
                    this.statement.execute();
                    success = true;
                }
                catch (SQLException exception) {
                    this.logger.error("SQLException while deleting from fullbackup info table", (Throwable)exception);
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    this.closeConnection();
                }
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createBackupInfoTable() {
        this.logger.debug("creating table fullbackup info>>>>>>>");
        FullBackupInfoTableDAOImpl fullBackupInfoTableDAOImpl = this;
        synchronized (fullBackupInfoTableDAOImpl) {
            String query = BluSyncSQLConstants.CREATE_FULL_BACKUP_INFO_TABLE_QUERY;
            boolean success = false;
            this.statement = null;
            if (this.getConnection()) {
                try {
                    this.statement = this.conn.prepareStatement(query);
                    this.statement.execute();
                    success = true;
                }
                catch (SQLException exception) {
                    this.logger.error("SQLException while creating fullbackup info table", (Throwable)exception);
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    this.closeConnection();
                }
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FullBackupInfoTO> getBackupInfoDetails() {
        FullBackupInfoTableDAOImpl fullBackupInfoTableDAOImpl = this;
        synchronized (fullBackupInfoTableDAOImpl) {
            String query = "select * from FULLBACKUPINFO";
            ArrayList<FullBackupInfoTO> infos = null;
            this.statement = null;
            ResultSet resultSet = null;
            if (this.getConnection()) {
                try {
                    this.statement = this.conn.prepareStatement("select * from FULLBACKUPINFO");
                    resultSet = this.statement.executeQuery();
                    infos = new ArrayList<FullBackupInfoTO>();
                    if (resultSet != null) {
                        while (resultSet.next()) {
                            FullBackupInfoTO fullBackupInfoTO = new FullBackupInfoTO();
                            fullBackupInfoTO.setPolicyGroupName(resultSet.getString("policyGroupName"));
                            fullBackupInfoTO.setFullBackupStartDate(Long.parseLong(resultSet.getString("fullbackupstartdate")));
                            fullBackupInfoTO.setFullBackup(Boolean.parseBoolean(resultSet.getString("isfullBackup")));
                            infos.add(fullBackupInfoTO);
                        }
                    }
                }
                catch (SQLException exception) {
                    this.logger.trace("" + exception);
                    this.logger.error("SQLException while getting info from fullbackupinfotable ", (Object)exception.getMessage());
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException e) {
                            this.logger.error("SQLException while closing result set for geting fullbackup info" + e);
                        }
                        catch (RuntimeException e) {
                            this.logger.error("Runtime Exception...", (Object)e.getMessage());
                        }
                    }
                    this.closeConnection();
                }
            }
            return infos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insertIntoBackupInfoTable(FullBackupInfoTO fullBackupInfoTO) {
        FullBackupInfoTableDAOImpl fullBackupInfoTableDAOImpl = this;
        synchronized (fullBackupInfoTableDAOImpl) {
            String query = "insert into FULLBACKUPINFO(policyGroupName,fullbackupstartdate,isfullBackup) values(?,?,?);";
            boolean success = false;
            this.statement = null;
            if (this.getConnection()) {
                try {
                    this.statement = this.conn.prepareStatement("insert into FULLBACKUPINFO(policyGroupName,fullbackupstartdate,isfullBackup) values(?,?,?);");
                    this.statement.setString(1, fullBackupInfoTO.getPolicyGroupName());
                    this.statement.setString(2, String.valueOf(fullBackupInfoTO.getFullBackupStartDate()));
                    this.statement.setString(3, Boolean.toString(fullBackupInfoTO.isFullBackup()));
                    this.statement.execute();
                    success = true;
                }
                catch (SQLException exception) {
                    this.logger.error("SQLException while inserting info of full backup on demand ", (Throwable)exception);
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    this.closeConnection();
                }
            }
            return success;
        }
    }
}

