/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.core.adapter.api;

import com.parablu.epa.core.adapter.BaseAdapter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiAdapter
extends BaseAdapter {
    private Logger logger = LoggerFactory.getLogger(ApiAdapter.class);
    private static final String PRIVATE_URI = "/DnsAPI/api/cloud/ip/";

    public ApiAdapter(String keyStore) {
        super(keyStore);
    }

    public ApiAdapter(InputStream inputStream) {
        super(inputStream);
    }

    public void getCloudIPFromAmazon(String cloudName, String[] ipAddress, String[] ports) {
        HttpResponse response = null;
        try {
            URI uri = this.formHttpsUri("dns.parablu.com", PRIVATE_URI + cloudName);
            HttpGet httpGet = new HttpGet(uri);
            this.logger.debug("the uri is:" + uri);
            response = this.httpclient.execute((HttpUriRequest)httpGet);
        }
        catch (Exception e) {
            this.logger.error("Exception in getCloudIPFromAmazon" + e);
        }
        if (response == null) {
            this.logger.debug("response for getCloudIPFromAmazon is null");
            return;
        }
        if (response.getStatusLine().getStatusCode() == 200) {
            if (response.getFirstHeader("PUBLIC_IP") != null) {
                ipAddress[1] = response.getFirstHeader("PUBLIC_IP").getValue();
            }
            if (response.getFirstHeader("LOCAL_IP") != null) {
                ipAddress[0] = response.getFirstHeader("LOCAL_IP").getValue();
            }
            if (response.getFirstHeader("WIFI_IP") != null) {
                ipAddress[2] = response.getFirstHeader("WIFI_IP").getValue();
            }
            if (response.getFirstHeader("http-port") != null) {
                ports[0] = response.getFirstHeader("http-port").getValue();
            }
            if (response.getFirstHeader("https-port") != null) {
                ports[1] = response.getFirstHeader("https-port").getValue();
            }
        }
        if (response.getEntity() != null && response.getEntity().isStreaming()) {
            try {
                response.getEntity().getContent().close();
            }
            catch (IllegalStateException e) {
                this.logger.error("IllegalStateException " + e);
            }
            catch (IOException e) {
                this.logger.error("IOException " + e);
            }
        }
    }
}

