/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.dao;

import com.parablu.epa.common.dao.BaseDAO;
import com.parablu.epa.core.constant.BluSyncSQLConstants;
import com.parablu.epa.core.dao.RestoreActivityDAO;
import com.parablu.epa.core.to.RestoreActivityTO;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestoreActivityHistoryDAOImpl
extends BaseDAO
implements RestoreActivityDAO {
    private Logger logger = LoggerFactory.getLogger(RestoreActivityHistoryDAOImpl.class);
    private static final String SELECTFROM = "select * from ";

    public RestoreActivityHistoryDAOImpl(String uRL) {
        super(uRL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createRestoreActivityHistoryDB() {
        RestoreActivityHistoryDAOImpl restoreActivityHistoryDAOImpl = this;
        synchronized (restoreActivityHistoryDAOImpl) {
            this.statement = null;
            boolean success = false;
            boolean gotConnection = this.getConnectionForCreatingDatabase();
            if (gotConnection) {
                try {
                    this.statement = this.conn.prepareStatement(BluSyncSQLConstants.CREATE_RESTORE_ACTIVITY_TABLE_QUERY);
                    this.statement.execute();
                    this.statement.close();
                    success = true;
                }
                catch (SQLException e) {
                    this.logger.error("sqlExeception in CREATE__RESTORE_ACTIVITY_TABLE" + e);
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    this.closeConnection();
                }
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addEventToRestoreActivity(RestoreActivityTO activityTO) {
        RestoreActivityHistoryDAOImpl restoreActivityHistoryDAOImpl = this;
        synchronized (restoreActivityHistoryDAOImpl) {
            String tempActivityBatchStatus = activityTO.getRestoreBatchStatus();
            String tempActivityBatchId = activityTO.getRestoreBatchId();
            String restoredSize = String.valueOf(activityTO.getTotalRestoredSize());
            String restoredCount = activityTO.getTotalRestoreCount();
            String restoreType = activityTO.getRestoreType();
            String restoreDestDeviceUUID = activityTO.getDeviceuid();
            String restorDeviceUUID = activityTO.getRestoreDeviceUUID();
            String restorePath = activityTO.getRestoredFolder();
            String restoreDestPath = activityTO.getSelectedDestinationPath();
            String sqlQuery = new StringBuffer().append("INSERT INTO ").append("RestoreActivityHistory").append(" (").append("restoreBatchStatus").append(",").append("restoreBatchID").append(",").append("restoreTotalSize").append(",").append("restoreCount").append(",").append("restoreType").append(",").append("destDeviceUUID").append(",").append("restoreDeviceUUID").append(",").append("restorePath").append(",").append("restoreDestPath").append(")").append(" Values(?,?,?,?,?,?,?,?,?);").toString();
            this.statement = null;
            boolean success = false;
            boolean gotConnection = this.getConnection();
            if (gotConnection) {
                try {
                    this.statement = this.conn.prepareStatement(sqlQuery, 1);
                    this.statement.setString(1, tempActivityBatchStatus);
                    this.statement.setString(2, tempActivityBatchId);
                    this.statement.setString(3, restoredSize);
                    this.statement.setString(4, restoredCount);
                    this.statement.setString(5, restoreType);
                    this.statement.setString(6, restoreDestDeviceUUID);
                    this.statement.setString(7, restorDeviceUUID);
                    this.statement.setString(8, restorePath);
                    this.statement.setString(9, restoreDestPath);
                    this.statement.execute();
                    success = true;
                }
                catch (SQLException e) {
                    this.logger.error("SQLException while inserting into Restore Activity Table" + e);
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    this.closeConnection();
                }
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateEventToRestoreActivityHistoryTable(RestoreActivityTO activityTO) {
        RestoreActivityHistoryDAOImpl restoreActivityHistoryDAOImpl = this;
        synchronized (restoreActivityHistoryDAOImpl) {
            String restoreBatchId = activityTO.getRestoreBatchId();
            String restoreBatchStatus = activityTO.getRestoreBatchStatus();
            String restoredSize = String.valueOf(activityTO.getTotalRestoredSize());
            String restoreCount = activityTO.getTotalRestoreCount();
            int restoreStatusCode = activityTO.getRestoreStatusCode();
            String sqlQuery = "Update RestoreActivityHistory set restoreBatchStatus=?,restoreTotalSize=?,restoreCount=?,restoreStatusCode=? where restoreBatchID=?;";
            this.statement = null;
            boolean success = false;
            boolean gotConnection = this.getConnection();
            if (gotConnection) {
                try {
                    this.statement = this.conn.prepareStatement("Update RestoreActivityHistory set restoreBatchStatus=?,restoreTotalSize=?,restoreCount=?,restoreStatusCode=? where restoreBatchID=?;");
                    this.statement.setString(1, restoreBatchStatus);
                    this.statement.setString(2, restoredSize);
                    this.statement.setString(3, restoreCount);
                    this.statement.setInt(4, restoreStatusCode);
                    this.statement.setString(5, restoreBatchId);
                    this.statement.execute();
                    this.statement.close();
                    success = true;
                }
                catch (SQLException e) {
                    this.logger.trace("" + e);
                    this.logger.error("SQLException while updating restore activity Table" + e.getMessage());
                    e.printStackTrace();
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    this.closeConnection();
                }
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RestoreActivityTO getCurrentStatusFromRestoreActivityHistoryTable(boolean getLatestRecord) {
        RestoreActivityHistoryDAOImpl restoreActivityHistoryDAOImpl = this;
        synchronized (restoreActivityHistoryDAOImpl) {
            String sqlQuery = new StringBuffer().append(SELECTFROM).append("RestoreActivityHistory").append(" order by ").append("restoreBatchID").append(" DESC LIMIT 1").toString();
            if (!getLatestRecord) {
                sqlQuery = new StringBuffer().append(SELECTFROM).append("RestoreActivityHistory").append(" where rowid is ((select Count(*) from ").append("RestoreActivityHistory").append(")-1)").toString();
                this.logger.debug("........in side get last Before record......");
            }
            this.logger.debug("........in side get last Before record......" + sqlQuery);
            this.statement = null;
            ResultSet getcurNameRes = null;
            RestoreActivityTO currentActivity = null;
            boolean gotConnection = this.getConnection();
            if (gotConnection) {
                try {
                    this.statement = this.conn.prepareStatement(sqlQuery);
                    getcurNameRes = this.statement.executeQuery();
                    if (getcurNameRes != null && getcurNameRes.next()) {
                        currentActivity = new RestoreActivityTO();
                        currentActivity.setRestoreBatchStatus(getcurNameRes.getString("restoreBatchStatus"));
                        currentActivity.setRestoreBatchId(getcurNameRes.getString("restoreBatchID"));
                        if (getcurNameRes.getString("restoreTotalSize") != null) {
                            currentActivity.setTotalRestoredSize(Long.parseLong(getcurNameRes.getString("restoreTotalSize")));
                        } else {
                            currentActivity.setTotalRestoredSize(0L);
                        }
                        if (getcurNameRes.getString("restoreType") != null) {
                            currentActivity.setRestoreType(getcurNameRes.getString("restoreType"));
                        } else {
                            currentActivity.setRestoreType("Agent");
                        }
                        currentActivity.setTotalRestoreCount(getcurNameRes.getString("restoreCount"));
                        currentActivity.setDeviceuid(getcurNameRes.getString("destDeviceUUID"));
                        currentActivity.setRestoreDeviceUUID(getcurNameRes.getString("restoreDeviceUUID"));
                        currentActivity.setRestoredFolder(getcurNameRes.getString("restorePath"));
                        currentActivity.setSelectedDestinationPath(getcurNameRes.getString("restoreDestPath"));
                    }
                    this.statement.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    this.logger.error("SQLException while selecting from restore activity Table" + e);
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    if (getcurNameRes != null) {
                        try {
                            getcurNameRes.close();
                        }
                        catch (SQLException e) {
                            this.logger.error("SQLException while closing result set getcurNameRes in restore actvity" + e);
                        }
                        catch (RuntimeException e) {
                            this.logger.error("Runtime Exception...", (Object)e.getMessage());
                        }
                    }
                    this.closeConnection();
                }
                getcurNameRes = null;
            }
            return currentActivity;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean alterTable() {
        RestoreActivityHistoryDAOImpl restoreActivityHistoryDAOImpl = this;
        synchronized (restoreActivityHistoryDAOImpl) {
            this.statement = null;
            boolean success = false;
            boolean gotConnection = this.getConnection();
            if (gotConnection) {
                try {
                    this.statement = this.conn.prepareStatement("ALTER table RestoreActivityHistory ADD COLUMN restoreTotalSize TEXT;");
                    this.statement.execute();
                    this.statement.close();
                    success = true;
                }
                catch (SQLException e) {
                    this.logger.trace("" + e);
                    this.logger.info("SQL Exeception in ALTER_RESTORE_ACTIVITY_TABLE restoreTotalSize" + e.getMessage());
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                try {
                    this.statement = this.conn.prepareStatement("ALTER table RestoreActivityHistory ADD COLUMN restoreCount TEXT;");
                    this.statement.execute();
                    this.statement.close();
                    success = true;
                }
                catch (SQLException e) {
                    this.logger.trace("" + e);
                    this.logger.info("SQL Exeception in ALTER_RESTORE_ACTIVITY_TABLE restoreCount" + e.getMessage());
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                try {
                    this.statement = this.conn.prepareStatement("ALTER table RestoreActivityHistory ADD COLUMN restoreType TEXT;");
                    this.statement.execute();
                    this.statement.close();
                    success = true;
                }
                catch (SQLException e) {
                    this.logger.trace("" + e);
                    this.logger.info("SQL Exeception in ALTER_RESTORE_ACTIVITY_TABLE restoreType" + e.getMessage());
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                try {
                    this.statement = this.conn.prepareStatement("ALTER table RestoreActivityHistory ADD COLUMN restoreStatusCode INTEGER;");
                    this.statement.execute();
                    this.statement.close();
                    success = true;
                }
                catch (SQLException e) {
                    this.logger.trace("" + e);
                    this.logger.info("SQL Exeception in ALTER_RESTORE_ACTIVITY_TABLE restoreType" + e.getMessage());
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                try {
                    this.statement = this.conn.prepareStatement("ALTER table RestoreActivityHistory ADD COLUMN destDeviceUUID TEXT;");
                    this.statement.execute();
                    this.statement.close();
                    success = true;
                }
                catch (SQLException e) {
                    this.logger.trace("" + e);
                    this.logger.info("SQL Exeception in ALTER_RESTORE_ACTIVITY_TABLE destDeviceUUID" + e.getMessage());
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                try {
                    this.statement = this.conn.prepareStatement("ALTER table RestoreActivityHistory ADD COLUMN restoreDeviceUUID TEXT;");
                    this.statement.execute();
                    this.statement.close();
                    success = true;
                }
                catch (SQLException e) {
                    this.logger.trace("" + e);
                    this.logger.info("SQL Exeception in ALTER_RESTORE_ACTIVITY_TABLE restoreDeviceUUID" + e.getMessage());
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                try {
                    this.statement = this.conn.prepareStatement("ALTER table RestoreActivityHistory ADD COLUMN restorePath TEXT;");
                    this.statement.execute();
                    this.statement.close();
                    success = true;
                }
                catch (SQLException e) {
                    this.logger.trace("" + e);
                    this.logger.info("SQL Exeception in ALTER_RESTORE_ACTIVITY_TABLE restorePath" + e.getMessage());
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                try {
                    this.statement = this.conn.prepareStatement("ALTER table RestoreActivityHistory ADD COLUMN restoreDestPath TEXT;");
                    this.statement.execute();
                    this.statement.close();
                    success = true;
                }
                catch (SQLException e) {
                    this.logger.trace("" + e);
                    this.logger.info("SQL Exeception in ALTER_RESTORE_ACTIVITY_TABLE restoreDestPath" + e.getMessage());
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    this.closeConnection();
                }
            }
            return success;
        }
    }
}

