/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.core.adapter;

import com.parablu.epa.core.adapter.MySSLSocketFactory;
import com.parablu.epa.core.adapter.SkipX509HostnameVerifier;
import com.parablu.epa.core.exception.CrawlAdapterException;
import com.parablu.epa.core.service.proxy.ProxyDetector;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.SingleClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseAdapter
extends ProxyDetector {
    protected DefaultHttpClient httpclient = null;
    private static Scheme sch = null;
    private static Scheme httpsch = null;
    private static final int HTTPS_PORT = 443;
    private static final int HTTP_PORT = 80;
    protected static final int HTTP_CONNECTION_TIMEOUT = 60000;
    protected static final int HTTP_SO_TIMEOUT = 300000;
    protected static final int HTTP_SO_LINGER = 30;
    protected static final int HTTP_OK = 200;
    protected static final String URL_PATH_SEPERATOR = "/";
    protected String cloudName;
    protected static final String APPLICATION_XML = "application/xml";
    protected static final String CONTENT_TYPE = "Content-Type";
    protected static final String TEXT_XML = "text/xml";
    protected static final String CONTENT_ENCODING = "Content-Encoding";
    protected static final String GZIP_ENCODING = "gzip";
    protected static final String HTTP_PROTOCOL = "http";
    protected static final String HTTPS_PROTOCOL = "https";
    protected static final String PARACLOUD_URL = "/paracloud";
    protected static final String API_HOST_ADDRESS = "dns.parablu.com";
    protected static final String SUPPORT_HOST_ADDRESS = "supportapi.parablu.com";
    private static Logger logger = LoggerFactory.getLogger(BaseAdapter.class);
    protected static final String PARACLOUD_BASE_REQUESTPARAMETER = "/cloud";
    private static final String URI_SYNTAX_EXCEPTION_HTTPS = "URISyntaxException https: ";
    protected static final String PMS_URL = "/paracloud";
    protected static final String PRIVACY_GATEWAY_URL = "/BluKryptBuilder";

    protected BaseAdapter(String keyStore) {
        this((String)null, keyStore);
    }

    protected BaseAdapter(String cloudName, String keyStorePath) {
        this.createConnection(cloudName, keyStorePath);
    }

    private void createConnection(String cloudName, String keyStorePath) {
        this.cloudName = URL_PATH_SEPERATOR + cloudName;
        SchemeRegistry registry = new SchemeRegistry();
        if (sch == null) {
            BaseAdapter.initializeScheme(keyStorePath);
        }
        if (sch != null) {
            registry.register(sch);
            registry.register(httpsch);
        }
        BasicHttpParams params = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)60000);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)300000);
        HttpConnectionParams.setLinger((HttpParams)params, (int)30);
        SingleClientConnManager m = new SingleClientConnManager(registry);
        this.httpclient = new DefaultHttpClient((ClientConnectionManager)m, (HttpParams)params);
        ProxyDetector.setProxyDetails(this.httpclient);
    }

    public void resetClientConnection(String cloudName, String keyStorePath) {
        if (this.httpclient != null) {
            logger.debug("set reset client connection to null ..");
            this.httpclient = null;
        }
        this.createConnection(cloudName, keyStorePath);
    }

    protected BaseAdapter(InputStream instream) {
        this(instream, null);
    }

    protected BaseAdapter(InputStream instream, String cloudName) {
        this.cloudName = URL_PATH_SEPERATOR + cloudName;
        SchemeRegistry registry = new SchemeRegistry();
        if (sch == null) {
            BaseAdapter.initializeScheme(instream);
        }
        if (sch != null) {
            registry.register(sch);
            registry.register(httpsch);
        }
        BasicHttpParams params = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)60000);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)300000);
        HttpConnectionParams.setLinger((HttpParams)params, (int)30);
        SingleClientConnManager m = new SingleClientConnManager(registry);
        this.httpclient = new DefaultHttpClient((ClientConnectionManager)m, (HttpParams)params);
        ProxyDetector.setProxyDetails(this.httpclient);
        IOUtils.closeQuietly((InputStream)instream);
    }

    private static void initializeScheme(String keyStorePath) {
        try (FileInputStream instream = new FileInputStream(new File(keyStorePath));){
            BaseAdapter.registerSchemeForKeystoreStream("JKS", instream);
        }
        catch (Exception e) {
            logger.error("Exception in initializeScheme: ", (Throwable)e);
        }
    }

    private static void initializeScheme(InputStream instream) {
        try {
            BaseAdapter.registerSchemeForKeystoreStream("BKS", instream);
        }
        catch (Exception e) {
            logger.error("Exception in registerSchemeForKeystoreStream: ", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)instream);
        }
    }

    private static void registerSchemeForKeystoreStream(String keystoreType, InputStream instream) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, KeyManagementException, UnrecoverableKeyException {
        KeyStore trustStore = KeyStore.getInstance(keystoreType);
        trustStore.load(instream, "changeit".toCharArray());
        MySSLSocketFactory socketFactory = new MySSLSocketFactory(trustStore);
        socketFactory.setHostnameVerifier(new SkipX509HostnameVerifier());
        sch = new Scheme(HTTPS_PROTOCOL, (SocketFactory)socketFactory, 443);
        httpsch = new Scheme(HTTP_PROTOCOL, 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory());
    }

    protected String encodeUTFBase64(String input) {
        try {
            return Base64.encodeBase64String((byte[])input.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            logger.debug("UnsupportedEncodingException", (Throwable)e);
            return input;
        }
    }

    protected String decodeBase64UTFString(String encodedString) {
        String decodedString = encodedString;
        try {
            decodedString = new String(Base64.decodeBase64((String)encodedString), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.debug("UnsupportedEncodingException", (Throwable)e);
        }
        return decodedString;
    }

    protected URI formHttpsUri(String iP, String requestParams) {
        URI uri;
        try {
            uri = new URI(HTTPS_PROTOCOL, iP, requestParams, null);
        }
        catch (URISyntaxException e) {
            throw new CrawlAdapterException(URI_SYNTAX_EXCEPTION_HTTPS + e);
        }
        return uri;
    }

    protected URI formHttpsUri(String iP, int port, String requestParams) {
        URI uri;
        try {
            uri = new URI(HTTPS_PROTOCOL, null, iP, port, requestParams, null, null);
        }
        catch (URISyntaxException e) {
            throw new CrawlAdapterException(URI_SYNTAX_EXCEPTION_HTTPS + e);
        }
        return uri;
    }

    protected URI formHttpUri(String iP, int port, String requestParams) {
        URI uri;
        try {
            uri = new URI(HTTP_PROTOCOL, null, iP, port, requestParams, null, null);
        }
        catch (URISyntaxException e) {
            throw new CrawlAdapterException(URI_SYNTAX_EXCEPTION_HTTPS + e);
        }
        return uri;
    }

    protected URI formHttpUri(String iP, String requestParams) {
        URI uri;
        try {
            uri = new URI(HTTP_PROTOCOL, iP, requestParams, null);
        }
        catch (URISyntaxException e) {
            throw new CrawlAdapterException(URI_SYNTAX_EXCEPTION_HTTPS + e);
        }
        return uri;
    }
}

