/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.service.settings;

import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.core.constant.StringLiterals;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackupHelper {
    private static Logger logger = LoggerFactory.getLogger(BackupHelper.class);

    public static String getParabluInstallDirectory() {
        String basePath = SettingHelper.getOsName().toLowerCase().contains("win") ? SettingHelper.getParabluBlusyncAppDataFolderUrl() : SettingHelper.getUserHome() + StringLiterals.FILE_SEPARATOR + ".ParaBlu" + StringLiterals.FILE_SEPARATOR + "ParaBlu" + StringLiterals.FILE_SEPARATOR + "Blusync";
        return basePath;
    }

    public static void deleteContentOfFailedfilesLog() throws FileNotFoundException {
        String basePath = BackupHelper.getParabluInstallDirectory();
        File logFile = new File(basePath + StringLiterals.FILE_SEPARATOR + "failedFile.csv");
        if (logFile.exists()) {
            PrintWriter writer = new PrintWriter(logFile);
            writer.print("");
            writer.close();
        }
    }

    public static File getFailedFilesLogFile() throws IOException, FileNotFoundException {
        File file;
        String basePath = BackupHelper.getParabluInstallDirectory();
        File logFile = new File(basePath + StringLiterals.FILE_SEPARATOR + "failedFile.csv");
        File logZip = new File(basePath + StringLiterals.FILE_SEPARATOR + "failedFilesLogs.zip");
        if (logZip.exists()) {
            logZip.delete();
        }
        if (logFile.length() <= 0L) {
            logger.debug("file content is null");
            return null;
        }
        ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(logZip));
        try {
            logZip.createNewFile();
            BackupHelper.addEntryToZip(logFile, zipOutputStream);
            IOUtils.closeQuietly((OutputStream)zipOutputStream);
            file = logZip;
        }
        catch (Throwable throwable) {
            try {
                try {
                    zipOutputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                logger.error("IOException while entering to zip", (Throwable)e);
                return null;
            }
        }
        zipOutputStream.close();
        return file;
    }

    public static void addEntryToZip(File logFile, ZipOutputStream zipOutputStream) throws IOException {
        if (logFile.exists()) {
            ZipEntry zipEntry = new ZipEntry(logFile.getName());
            zipOutputStream.putNextEntry(zipEntry);
            FileInputStream fileInputStream = new FileInputStream(logFile);
            IOUtils.copy((InputStream)fileInputStream, (OutputStream)zipOutputStream);
            fileInputStream.close();
            zipOutputStream.closeEntry();
        }
    }
}

