/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.transform;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.simpleframework.xml.transform.DefaultMatcher;
import org.simpleframework.xml.transform.Matcher;
import org.simpleframework.xml.transform.Transform;
import org.simpleframework.xml.transform.TransformCache;
import org.simpleframework.xml.transform.TransformException;

public class Transformer {
    private final TransformCache cache;
    private final Matcher matcher;
    private final Map error;

    public Transformer(Matcher matcher) {
        this.matcher = new DefaultMatcher(matcher);
        this.error = new ConcurrentHashMap();
        this.cache = new TransformCache();
    }

    public Object read(String value, Class type) throws Exception {
        Transform transform = this.lookup(type);
        if (transform == null) {
            throw new TransformException("Transform of %s not supported", type);
        }
        return transform.read(value);
    }

    public String write(Object value, Class type) throws Exception {
        Transform transform = this.lookup(type);
        if (transform == null) {
            throw new TransformException("Transform of %s not supported", type);
        }
        return transform.write(value);
    }

    public boolean valid(Class type) throws Exception {
        return this.lookup(type) != null;
    }

    private Transform lookup(Class type) throws Exception {
        if (!this.error.containsKey(type)) {
            Transform transform = (Transform)this.cache.get(type);
            if (transform != null) {
                return transform;
            }
            return this.match(type);
        }
        return null;
    }

    private Transform match(Class type) throws Exception {
        Transform transform = this.matcher.match(type);
        if (transform != null) {
            this.cache.put(type, transform);
        } else {
            this.error.put(type, this);
        }
        return transform;
    }
}

