/*
 * Decompiled with CFR 0.152.
 */
package com.pg.timer;

import com.pg.domain.FileInfo;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.service.UtilService;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class FileThreadUtil {
    private UtilService utilService;
    private static FileThreadUtil singleton = new FileThreadUtil();
    private static Logger logger = Logger.getLogger(FileThreadUtil.class);
    private Set<FileInfo> filesInProgress = ConcurrentHashMap.newKeySet();
    private Set<String> parentFilesInProgress = ConcurrentHashMap.newKeySet();
    ThreadPoolExecutor executor = null;

    private FileThreadUtil() {
    }

    public void setUtilService(UtilService utilService) {
        this.utilService = utilService;
    }

    public static FileThreadUtil getInstance() {
        return singleton;
    }

    public boolean isFileReadyForUpload(FileInfo fileInfo) {
        if (!this.filesInProgress.contains(fileInfo)) {
            this.filesInProgress.add(fileInfo);
            return true;
        }
        return false;
    }

    public void removeFileFromProgressList(FileInfo fileInfo) {
        this.filesInProgress.remove(fileInfo);
    }

    public void addFile(String fileId) {
        if (!this.parentFilesInProgress.contains(fileId)) {
            this.parentFilesInProgress.add(fileId);
        }
    }

    public void removeFile(String fileId) {
        if (this.parentFilesInProgress.contains(fileId)) {
            this.parentFilesInProgress.remove(fileId);
        }
    }

    public boolean isParentFileUploaded(String fileId) {
        return !this.parentFilesInProgress.contains(fileId);
    }

    public ThreadPoolExecutor getExecutor() {
        long threadSize = this.utilService.getThreadSize(1, "");
        if (threadSize == 0L) {
            threadSize = PCHelperConstant.getThreadLimit();
        }
        if (this.executor == null) {
            logger.debug((Object)" executor is null");
            ArrayBlockingQueue<Runnable> queue = new ArrayBlockingQueue<Runnable>(100);
            this.executor = new ThreadPoolExecutor((int)threadSize, (int)threadSize + 10, 0L, TimeUnit.MILLISECONDS, queue);
            logger.debug((Object)" NEWEXECUTOR CREATED>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
        } else {
            logger.debug((Object)" NEWEXECUTOR already assigned>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
        }
        return this.executor;
    }
}

