/*
 * Decompiled with CFR 0.152.
 */
package com.pg.timer;

import com.parablu.pcbd.domain.Cloud;
import com.pg.domain.FileInfo;
import com.pg.element.DeletedUser;
import com.pg.element.DeletedUsersElement;
import com.pg.helper.constant.GeneralHelperConstant;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.helper.utils.MemoryStore;
import com.pg.service.UploadService;
import com.pg.service.UtilService;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.bson.types.ObjectId;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.quartz.QuartzJobBean;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class BackupUploadLatestJob
extends QuartzJobBean
implements Job {
    private static Logger logger = LoggerFactory.getLogger(BackupUploadLatestJob.class);
    private static final String IS_JOB_RUNNING = "isJobRunning";
    private static final String UPLOAD = "/upload/";
    public static final String ENCRYPTED = "/encrypted/";
    public static final String CHUNK = "/chunk/";
    private static final String BLACK_LIST_USERS = "BlackListUsers";
    private static List<FileInfo> fileInfoList = null;
    private TimerTask backupTimerTask = null;
    private Timer backupTimer = null;
    private UploadService uploadService;
    private UtilService utilService;
    private Set<String> filesUnderProcess = new HashSet<String>();

    public void setUploadService(UploadService uploadService) {
        this.uploadService = uploadService;
    }

    public void setUtilService(UtilService utilService) {
        this.utilService = utilService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        if (!PCHelperConstant.isJobEnabled((String)"backupUploadLatestJobTrigger")) {
            logger.debug("BackupUploadLatestJob ............. disabled");
            return;
        }
        logger.debug("@@@@BackupUploadJob started ..... " + PCHelperConstant.getODBCallFrequency());
        ExecutorService executor = null;
        try {
            boolean isJobsShouldStop = PCHelperConstant.isJobsStopEnabled();
            if (isJobsShouldStop) {
                logger.debug("stopJobsEnabled in privacygateway.properties so return");
                return;
            }
            Cloud cloud = this.utilService.getCloud(1);
            List deletedUsersElements = this.utilService.getAllDeletedUsers(1);
            List<String> deletedUserList = this.getDeletedUsersFromElements(deletedUsersElements);
            long threadSize = this.utilService.getThreadSize(cloud.getCloudId(), cloud.getCloudName());
            if (threadSize == 0L) {
                threadSize = PCHelperConstant.getThreadLimit();
            }
            logger.debug(" threads val........" + threadSize);
            int threadSizeVal = (int)threadSize;
            executor = Executors.newFixedThreadPool(threadSizeVal);
            fileInfoList = this.uploadService.getFilesForUpload(cloud.getCloudName());
            ExecutorCompletionService<String> pool = new ExecutorCompletionService<String>(executor);
            this.checkThreadStatusAndStartUpload(cloud, executor, pool, deletedUserList);
            for (int i = 0; i < threadSizeVal; ++i) {
                logger.debug("Creating thread for first time>>>>>>>>> i value::" + i);
                this.callUploadFiles(cloud, executor, pool, deletedUserList);
            }
            logger.debug(" exit upload part..........");
        }
        catch (Exception e) {
            logger.error(" exception in backup upload job......." + e.getMessage());
            logger.trace("exception in backup upload job ......." + e);
        }
    }

    private void callUploadFiles(Cloud cloud, ExecutorService executor, CompletionService<String> pool, List<String> deletedUserList) {
        logger.debug("Files to backup ............... :");
        Runnable uploadJob = () -> this.uploadFiles(cloud, executor, pool, deletedUserList);
        pool.submit(uploadJob, "");
    }

    private void uploadFiles(Cloud cloud, ExecutorService executor, CompletionService<String> pool, List<String> deletedUserList) {
        do {
            logger.debug("....inside while loop..........");
            FileInfo fileInfo = null;
            try {
                boolean isTomcatRunning = true;
                if (MemoryStore.get((String)IS_JOB_RUNNING) != null) {
                    isTomcatRunning = (Boolean)MemoryStore.get((String)IS_JOB_RUNNING);
                }
                logger.debug("........Is tomcat job running........." + isTomcatRunning);
                if (!isTomcatRunning) {
                    logger.error("..Tomcat job is going to be stopped.. so stopping upload ....");
                    return;
                }
                logger.debug("message list......................................." + fileInfoList.size());
                fileInfo = this.getFileForProcessing(cloud, deletedUserList);
                if (fileInfo != null) {
                    this.processMessage(fileInfo, cloud);
                    logger.error(fileInfo.getId() + " %%%%%%% upload completed for file ...." + fileInfo.getFileName());
                }
                logger.debug("Thread ready for next File .... " + fileInfoList.size());
            }
            catch (Exception e) {
                logger.error("exception inside BackupUploadJob .... " + e.getMessage());
                logger.trace("exception inside BackupUploadJob ...." + e);
            }
            if (fileInfo == null || !StringUtils.isNotEmpty((String)fileInfo.getId())) continue;
            this.filesUnderProcess.remove(fileInfo.getId());
        } while (!CollectionUtils.isEmpty(fileInfoList));
        logger.error("no files to upload so wait and then retry>>>>");
        try {
            Thread.sleep(30000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.callUploadFiles(cloud, executor, pool, deletedUserList);
    }

    private synchronized FileInfo getFileForProcessing(Cloud cloud, List<String> deletedUserList) {
        if (CollectionUtils.isEmpty(fileInfoList) && CollectionUtils.isEmpty(fileInfoList = this.getMessagesToProcess(cloud, deletedUserList))) {
            return null;
        }
        FileInfo fileInfo = fileInfoList.get(0);
        if (fileInfo != null) {
            if (this.filesUnderProcess.contains(fileInfo.getId())) {
                fileInfoList.remove(fileInfo);
                return this.getFileForProcessing(cloud, deletedUserList);
            }
            fileInfoList.remove(fileInfo);
            this.filesUnderProcess.add(fileInfo.getId());
        }
        logger.debug("...after list size....." + fileInfoList.size());
        return fileInfo;
    }

    private List<FileInfo> getMessagesToProcess(Cloud cloud, List<String> deletedUserList) {
        List latestList = this.uploadService.getFilesForUpload(cloud.getCloudName());
        int i = 0;
        for (FileInfo fileInfo : latestList) {
            Set blackUsersList;
            String userName = fileInfo.getUserName().toLowerCase();
            if (deletedUserList.contains(userName)) {
                logger.debug("it contains deleted user so remove from message queue.....");
                this.acknowlwdgeAndCloseSession(cloud, fileInfo);
                continue;
            }
            Object obj = MemoryStore.get((String)BLACK_LIST_USERS);
            if (obj != null && (blackUsersList = (Set)obj).contains(userName)) {
                logger.debug("it contains #blackList# user so remove from message queue.....userName:" + fileInfo.getUserName());
                this.uploadService.moveFailedFilesToBkpQueue(cloud.getCloudName(), fileInfo);
                this.uploadService.deleteUploadedFiles(fileInfo, cloud.getCloudName());
                continue;
            }
            String userBlockedForWrite = "429_" + fileInfo.getUserName();
            Object userBlockedFor429 = MemoryStore.get((String)userBlockedForWrite);
            if (userBlockedFor429 != null) {
                this.uploadService.moveFailedFilesToBkpQueue(cloud.getCloudName(), fileInfo);
                this.uploadService.deleteUploadedFiles(fileInfo, cloud.getCloudName());
                continue;
            }
            String unMappedUser = "404_" + fileInfo.getUserName();
            Object unMappedUser404 = MemoryStore.get((String)unMappedUser);
            if (unMappedUser404 != null) {
                this.utilService.saveFailedFile(cloud.getCloudId(), fileInfo);
                this.uploadService.deleteUploadedFiles(fileInfo, cloud.getCloudName());
                continue;
            }
            fileInfoList.add(fileInfo);
            ++i;
        }
        return fileInfoList;
    }

    public void checkThreadStatusAndStartUpload(final Cloud cloud, final ExecutorService executor, final CompletionService<String> pool, final List<String> deletedUserList) {
        if (this.backupTimer == null) {
            this.backupTimer = new Timer();
        }
        if (this.backupTimerTask == null) {
            this.backupTimerTask = new TimerTask(){

                @Override
                public void run() {
                    try {
                        logger.error("Check the task is completed>>>>>>>>");
                        Future future = pool.take();
                        if (future.isDone()) {
                            logger.debug("Thread is completed so assign new task>>>>>>>>>>>");
                            BackupUploadLatestJob.this.callUploadFiles(cloud, executor, pool, deletedUserList);
                        }
                    }
                    catch (Exception e) {
                        logger.error("Error in checkThreadStatusAndStartUpload", (Throwable)e);
                        logger.trace("" + e);
                    }
                }
            };
            this.backupTimer.schedule(this.backupTimerTask, 1000L, 1000L);
        }
    }

    private boolean uploadFile(FileInfo fileInfo, Cloud cloud) {
        boolean isFileUploaded = false;
        try {
            isFileUploaded = this.uploadService.uploadAllFilesToCloud(cloud.getCloudName(), fileInfo, cloud, null);
        }
        catch (Exception e) {
            logger.debug("" + e);
            logger.error(fileInfo.getFileName() + "#####FILE NOT UPLOADED SUCCESSFULLY .. " + e.getMessage());
        }
        return isFileUploaded;
    }

    private void deleteUnReferencedChunk(String deviceUUID, String cloudName, String name, String batchId, String fileName) {
        if (!StringUtils.isEmpty((String)deviceUUID)) {
            String parabluBaseMountFolder = PCHelperConstant.getParabluFolderBasePath();
            String chunkPath = parabluBaseMountFolder + cloudName + UPLOAD + deviceUUID + CHUNK;
            String encryptedPath = parabluBaseMountFolder + cloudName + UPLOAD + deviceUUID + ENCRYPTED;
            String filePath = parabluBaseMountFolder + cloudName + UPLOAD + deviceUUID + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
            if (!StringUtils.isEmpty((String)batchId)) {
                chunkPath = parabluBaseMountFolder + cloudName + UPLOAD + deviceUUID + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + batchId + CHUNK;
                encryptedPath = parabluBaseMountFolder + cloudName + UPLOAD + deviceUUID + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + batchId + ENCRYPTED;
                filePath = parabluBaseMountFolder + cloudName + UPLOAD + deviceUUID + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + batchId + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
            }
            try {
                File deleteOrgFile;
                File deleteChunkFile = new File(chunkPath + name);
                File deleteEncryptedFile = new File(encryptedPath + name);
                if (deleteChunkFile.exists()) {
                    deleteChunkFile.delete();
                }
                if (deleteEncryptedFile.exists()) {
                    deleteEncryptedFile.delete();
                }
                if ((deleteOrgFile = new File(filePath + fileName)).exists()) {
                    deleteOrgFile.delete();
                }
            }
            catch (Exception e) {
                logger.error("Error trying to clean files ..... " + e.getMessage());
                logger.trace("" + e);
            }
        }
    }

    private void deleteEncryptedChunks(String deviceUUID, String cloudName, String name, String batchId, String fileName) {
        if (!StringUtils.isEmpty((String)deviceUUID)) {
            String parabluBaseMountFolder = PCHelperConstant.getParabluFolderBasePath();
            String encryptedPath = parabluBaseMountFolder + cloudName + UPLOAD + deviceUUID + ENCRYPTED;
            if (!StringUtils.isEmpty((String)batchId)) {
                encryptedPath = parabluBaseMountFolder + cloudName + UPLOAD + deviceUUID + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + batchId + ENCRYPTED;
            }
            try {
                File deleteEncryptedFile = new File(encryptedPath + name);
                if (deleteEncryptedFile.exists()) {
                    deleteEncryptedFile.delete();
                }
            }
            catch (Exception e) {
                logger.error("Error trying to clean files ..... " + e.getMessage());
                logger.trace("" + e);
            }
        }
    }

    public void processMessage(FileInfo fileInfo, Cloud cloud) {
        try {
            logger.debug("Processing " + fileInfo.getFileName());
            String userBlockedForWrite = "429_" + fileInfo.getUserName();
            Object userBlockedFor429 = MemoryStore.get((String)userBlockedForWrite);
            String userUnMapped = "404_" + fileInfo.getUserName();
            Object userUnMapped404 = MemoryStore.get((String)userUnMapped);
            if (userBlockedFor429 != null) {
                logger.error(fileInfo.getUserName() + "........user acct has too many requests ........move file to bkp queue .............");
                this.uploadService.moveFailedFilesToBkpQueue(cloud.getCloudName(), fileInfo);
                this.uploadService.deleteUploadedFiles(fileInfo, cloud.getCloudName());
            } else if (userUnMapped404 != null) {
                logger.error(fileInfo.getUserName() + "........unmapped user.............");
                this.utilService.saveFailedFile(cloud.getCloudId(), fileInfo);
                this.uploadService.deleteUploadedFiles(fileInfo, cloud.getCloudName());
            } else {
                boolean isFileUploaded = this.uploadFile(fileInfo, cloud);
                if (isFileUploaded) {
                    this.acknowlwdgeAndCloseSession(cloud, fileInfo);
                } else {
                    logger.error(fileInfo.getFileName() + "................move file to bkp queue .............");
                    this.uploadService.moveFailedFilesToBkpQueue(cloud.getCloudName(), fileInfo);
                    this.uploadService.deleteUploadedFiles(fileInfo, cloud.getCloudName());
                }
                logger.debug(" message status.............. " + isFileUploaded);
            }
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception inside BackupUploadJob Processor PooledConnectionFactory !" + e.getMessage());
        }
        this.deleteFileEncryptedChunks(cloud, fileInfo);
    }

    private void deleteFileEncryptedChunks(Cloud cloud, FileInfo fileInfo) {
        if (fileInfo == null) {
            return;
        }
        for (String name : fileInfo.getChunkFiles()) {
            int occurance = StringUtils.countMatches((String)name, (String)".");
            if (occurance > 1) {
                name = name.substring(0, name.lastIndexOf(46));
            }
            this.deleteEncryptedChunks(fileInfo.getDeviceUUID(), cloud.getCloudName(), name, fileInfo.getBatchId(), fileInfo.getFileName());
        }
    }

    private void acknowlwdgeAndCloseSession(Cloud cloud, FileInfo fileInfo) {
        for (String name : fileInfo.getChunkFiles()) {
            int occurance = StringUtils.countMatches((String)name, (String)".");
            if (occurance > 1) {
                name = name.substring(0, name.lastIndexOf(46));
            }
            this.deleteUnReferencedChunk(fileInfo.getDeviceUUID(), cloud.getCloudName(), name, fileInfo.getBatchId(), fileInfo.getFileName());
        }
        this.uploadService.deleteUploadedFiles(fileInfo, cloud.getCloudName());
        this.uploadService.removeBackupFromTempDb(cloud, new ObjectId(fileInfo.getId()));
        logger.debug(fileInfo.getFileName() + ".....file deleted ..... " + fileInfo.getId());
    }

    private List<String> getDeletedUsersFromElements(List<DeletedUsersElement> deletedUsersElements) {
        ArrayList<String> delUsers = new ArrayList<String>();
        for (DeletedUsersElement deletedUsersElement : deletedUsersElements) {
            for (DeletedUser deletedUser : deletedUsersElement.getDeletedUsers()) {
                delUsers.add(deletedUser.getUserName().toLowerCase());
            }
        }
        return delUsers;
    }
}

