/*
 * Decompiled with CFR 0.152.
 */
package com.pg.timer;

import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.FileRevision;
import com.parablu.pcbd.domain.SyncPolicy;
import com.parablu.pcbd.domain.User;
import com.pg.domain.FileInfo;
import com.pg.helper.constant.GeneralHelperConstant;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.service.UtilService;
import com.pg.sync.service.SyncCloudUploadService;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.AgeFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang.time.DateUtils;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class BlukryptDeleteExpiredSyncFilesJob
extends QuartzJobBean {
    private static Logger logger = LoggerFactory.getLogger(BlukryptDeleteExpiredSyncFilesJob.class);
    private static final String GATEWAY_NAME = PCHelperConstant.getComponentName();
    private UtilService utilService;
    private static final String ERROR_TRYING_TO_DELETE = " error trying to delete ..... ";
    private static final long DAY_IN_MS = 86400000L;
    private SyncCloudUploadService syncCloudUploadService;
    private static final String ERROR_TRYING_TO_DELETE_FILES_FROM_PG = " error trying to delete files from pg .......";

    public void setUtilService(UtilService utilService) {
        this.utilService = utilService;
    }

    public void setSyncCloudUploadService(SyncCloudUploadService syncCloudUploadService) {
        this.syncCloudUploadService = syncCloudUploadService;
    }

    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        if (!PCHelperConstant.isJobEnabled((String)"blukryptDeleteExpiredSyncFilesTrigger")) {
            logger.debug("BlukryptDeleteExpiredSyncFilesJob ............. disabled");
            return;
        }
        logger.debug("Start of BlukryptDeleteExpiredSyncFilesJob ...................");
        int cloudId = 1;
        int noOfDays = 0;
        Cloud cloud = this.utilService.getCloud(cloudId);
        String cloudName = cloud.getCloudName();
        List users = this.utilService.getAllUser(cloudId);
        for (User user : users) {
            SyncPolicy syncPolicy;
            if (StringUtils.isEmpty((Object)user.getSyncPolicyName()) || (syncPolicy = this.utilService.getSyncpolicyByName(cloudId, user.getSyncPolicyName())) == null || (noOfDays = syncPolicy.getNoOfDaysToPurgeFile()) <= 0) continue;
            long filesExpiredDate = System.currentTimeMillis() - (long)noOfDays * 86400000L;
            String path = PCHelperConstant.getPropertyFileValueDefaultSyncUploadPath((String)cloudName) + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + "chunk";
            List files = this.utilService.getAllSyncFilesToBeDeletedByUserName(cloudId, filesExpiredDate, user.getUserName());
            if (!CollectionUtils.isEmpty((Collection)files)) {
                for (FileRevision fileRevision : files) {
                    if (fileRevision == null) continue;
                    this.deleteFilesFromPGOrCloud(cloud, fileRevision);
                    this.deleteFileEntryIfFileShared(fileRevision);
                    this.deleteFilesFromDb(cloud, fileRevision);
                    this.utilService.removeBackupFromTempDb(cloud, fileRevision.getId(), true);
                    this.updateDailySyncOverView(cloudId, filesExpiredDate, fileRevision.getSize());
                }
                this.deleteFiles(path, noOfDays);
            }
            logger.error("@@@@End of BlukryptDeleteExpiredSyncFilesJob ..... ");
        }
    }

    private void updateDailySyncOverView(int cloudId, long filesExpiredDate, double size) {
        try {
            filesExpiredDate = this.convertDateWithTimeStampToDate(filesExpiredDate);
            this.utilService.updateDailySyncOverView(cloudId, filesExpiredDate, size);
        }
        catch (Exception e) {
            logger.error("Exception:" + e);
            logger.trace("Exception" + e.getMessage());
        }
    }

    private long convertDateWithTimeStampToDate(long filesExpiredDate) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd.00.00.00");
        Date resultdate = new Date(filesExpiredDate);
        String a = sdf.format(resultdate);
        Date date = sdf.parse(a);
        long milliseconds = date.getTime();
        return milliseconds;
    }

    private void deleteFilesFromDb(Cloud cloud, FileRevision revision) {
        try {
            logger.debug(revision.getLastModifiedTime() + " deleteFilesFromDb............. " + revision.getConsolidatedImage().getFileName() + " ... user name ...." + revision.getUserName());
            try {
                this.utilService.deleteRevision(cloud.getCloudId(), revision.getId().toString(), revision.getConsolidatedImage().getId().toString());
                this.utilService.updateUserSyncOverview(revision.getUserName(), revision.getSize());
                this.utilService.updateSyncOverview(revision.getSize());
            }
            catch (Exception e) {
                logger.debug(ERROR_TRYING_TO_DELETE + e);
                logger.error(ERROR_TRYING_TO_DELETE + e.getMessage());
            }
        }
        catch (Exception e) {
            logger.debug(ERROR_TRYING_TO_DELETE_FILES_FROM_PG + e);
            logger.error(ERROR_TRYING_TO_DELETE_FILES_FROM_PG + e.getMessage());
        }
    }

    private void deleteFilesFromPGOrCloud(Cloud cloud, FileRevision fileRevision) {
        try {
            String cloudName = cloud.getCloudName();
            FileInfo fileInfo = this.syncCloudUploadService.getFileFromPG(cloudName, fileRevision.getId().toString(), true);
            logger.debug(fileRevision.getId().toString() + "file recieved from pg ......" + fileInfo);
            if (fileInfo != null) {
                String deviceTempPath = PCHelperConstant.getPropertyFileValueDefaultSyncUploadPath((String)cloudName) + fileInfo.getDeviceUUID();
                String chunkFilePath = deviceTempPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + "chunk";
                for (String fileName : fileInfo.getChunkFiles()) {
                    try {
                        logger.debug("Cloud upload  FILE started ..... " + fileName);
                        File file = new File(chunkFilePath + "/" + fileName);
                        if (file.exists()) {
                            logger.debug(" file exists............." + file.getPath() + "......." + file.getName());
                            logger.debug(fileInfo.getUploadedTimestamp() + " files to be deleted ............. " + fileInfo.getFileName() + " ... user name ...." + fileInfo.getUserName());
                            try {
                                this.syncCloudUploadService.deleteUploadedFiles(fileInfo, cloudName, GATEWAY_NAME);
                            }
                            catch (Exception e) {
                                logger.debug(ERROR_TRYING_TO_DELETE + e);
                                logger.error(ERROR_TRYING_TO_DELETE + e.getMessage());
                            }
                            file.delete();
                            int dedupCount = 1;
                            String destPath = file.getPath() + "_" + dedupCount;
                            String path = file.getPath();
                            while (new File(destPath).exists()) {
                                File dedupFile = new File(destPath);
                                if (!dedupFile.exists()) continue;
                                if (dedupCount >= 2) {
                                    file = new File(path + "_" + (dedupCount - 1));
                                }
                                FileUtils.copyFile((File)dedupFile, (File)file);
                                dedupFile.delete();
                                destPath = path + "_" + ++dedupCount;
                            }
                            continue;
                        }
                        this.utilService.dereferanceSyncTable(cloud.getCloudId(), cloud.getCloudName(), fileRevision.getUserName(), fileRevision.getId().toString());
                    }
                    catch (Exception e) {
                        logger.debug(" error trying to delete local file ......." + e);
                        logger.error(" error trying to delete local file ......." + e.getMessage());
                    }
                }
            } else {
                this.utilService.dereferanceSyncTable(cloud.getCloudId(), cloud.getCloudName(), fileRevision.getUserName(), fileRevision.getId().toString());
            }
            logger.debug(" after deleting  files from pg ... ");
        }
        catch (Exception e) {
            logger.debug(ERROR_TRYING_TO_DELETE_FILES_FROM_PG + e);
            logger.error(ERROR_TRYING_TO_DELETE_FILES_FROM_PG + e.getMessage());
        }
    }

    private void deleteFileEntryIfFileShared(FileRevision revision) {
        this.utilService.deleteSharedFileImage(revision.getConsolidatedImage().getDevicePath(), revision.getConsolidatedImage().getFileName(), revision.getUserName());
    }

    private void deleteFiles(String path, int noOfDays) {
        Date oldestAllowedFileDate = DateUtils.addDays((Date)new Date(), (int)noOfDays);
        File targetDir = new File(path);
        logger.debug(" Target Directory path to delete old files ........." + path);
        if (targetDir.isDirectory()) {
            Iterator filesToDelete = FileUtils.iterateFiles((File)targetDir, (IOFileFilter)new AgeFileFilter(oldestAllowedFileDate), (IOFileFilter)TrueFileFilter.INSTANCE);
            while (filesToDelete.hasNext()) {
                File fileToDelete = (File)filesToDelete.next();
                FileUtils.deleteQuietly((File)fileToDelete);
            }
        }
    }
}

