/*
 * Decompiled with CFR 0.152.
 */
package com.pg.timer;

import com.parablu.pcbd.domain.BlackListUser;
import com.parablu.pcbd.domain.Cloud;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.service.UtilService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.util.CollectionUtils;

@DisallowConcurrentExecution
public class BlackListUserCleanerJob
extends QuartzJobBean {
    private static Logger logger = LoggerFactory.getLogger(BlackListUserCleanerJob.class);
    private UtilService utilService;

    public UtilService getUtilService() {
        return this.utilService;
    }

    public void setUtilService(UtilService utilService) {
        this.utilService = utilService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        if (!PCHelperConstant.isJobEnabled((String)"blackListUserCleanerJobTrigger")) {
            logger.debug("BlackListUserCleanerJob ............... disabled");
            return;
        }
        int cloudId = 1;
        Cloud cloud = this.utilService.getCloud(cloudId);
        List blackListUsers = this.utilService.getAllBlackListUsers(cloudId);
        logger.debug("************* Black List User Cleaner Job started ***********" + CollectionUtils.isEmpty((Collection)blackListUsers));
        List localBlackListUsers = this.utilService.getAllUniqueBlackListUsersFromLocal(cloudId, cloud.getCloudName());
        logger.debug("@@@@BlackListUserFilesRetryJob started .... ");
        ArrayList<String> blackListUsersFromMain = new ArrayList<String>();
        for (BlackListUser blackListUser : blackListUsers) {
            logger.debug("..check user... " + blackListUser.getUserName());
            blackListUsersFromMain.add(blackListUser.getUserName());
        }
        localBlackListUsers.removeAll(blackListUsersFromMain);
        logger.debug("..localBlackListUsers..." + localBlackListUsers.size());
        logger.debug("************* Black List User Cleaner Job started ***********");
        if (!CollectionUtils.isEmpty((Collection)localBlackListUsers)) {
            localBlackListUsers.parallelStream().forEach(userName -> {
                logger.debug("... unique users list ..." + userName);
                this.utilService.restoreMultiFileForBlackListUser(userName, cloud);
                logger.debug("... user file moved... ");
            });
        }
    }
}

