/*
 * Decompiled with CFR 0.152.
 */
package com.pg.timer;

import com.parablu.pcbd.domain.ChunkDetail;
import com.parablu.pcbd.domain.Cloud;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.service.UploadService;
import com.pg.service.UtilService;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.springframework.scheduling.quartz.QuartzJobBean;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class UserOneDriveDataAndChunkDeleteJob
extends QuartzJobBean
implements Job {
    private static Logger logger = LogManager.getLogger(UserOneDriveDataAndChunkDeleteJob.class);
    private UploadService uploadService;
    private UtilService utilService;
    public static final String CHUNK_DETAIL = "CHUNK_DETAIL";

    public UtilService getUtilService() {
        return this.utilService;
    }

    public void setUtilService(UtilService utilService) {
        this.utilService = utilService;
    }

    public void setUploadService(UploadService uploadService) {
        this.uploadService = uploadService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        if (!PCHelperConstant.isJobEnabled((String)"backupUploadLatestJobTrigger")) {
            logger.debug("UserOneDriveDataAndChunkDeleteJob ............. disabled");
            return;
        }
        try {
            boolean isJobsShouldStop = PCHelperConstant.isJobsStopEnabled();
            if (isJobsShouldStop) {
                logger.debug("stopJobsEnabled in privacygateway.properties so return");
                return;
            }
            logger.debug("UserOneDriveDataAndChunkDeleteJob  started .....");
            Cloud cloud = this.utilService.getCloud(1);
            ChunkDetail chunkDetail = this.utilService.getDeletedChunkDetail(cloud.getCloudId());
            if (chunkDetail != null) {
                boolean isUserDataDeleted;
                logger.debug("...start to delete all user chunk entries....." + chunkDetail.getUserName());
                if (!StringUtils.isEmpty((CharSequence)chunkDetail.getUserName()) && (isUserDataDeleted = this.uploadService.deleteUserFolderInsidePB(chunkDetail))) {
                    logger.debug("..user data deleted ..so try deleting chunkdetail entries..");
                    this.utilService.deleteChunkEntries(cloud.getCloudId(), chunkDetail);
                    logger.debug("..completed user data deleted ..so try deleting chunkdetail entries..");
                }
                logger.debug("...end of delete all user chunk entries....." + chunkDetail.getUserName());
            }
            logger.debug(" exited  onedrive user deletion..........");
        }
        catch (Exception e) {
            logger.error(" exception in UserOneDriveDataAndChunkDeleteJob......." + e.getMessage());
            logger.trace("exception in UserOneDriveDataAndChunkDeleteJob ......." + e);
        }
    }
}

