/*
 * Decompiled with CFR 0.152.
 */
package com.pg.timer;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.parablu.pcbd.domain.CMBackUpImage;
import com.parablu.pcbd.domain.CPBackupBatch;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.Device;
import com.pg.element.FileStatusElement;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.service.UploadService;
import com.pg.service.UtilService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.springframework.scheduling.quartz.QuartzJobBean;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class SPCapacityManualMgmtJob
extends QuartzJobBean
implements Job {
    private static Logger logger = LogManager.getLogger(SPCapacityManualMgmtJob.class);
    private static final String STOPPED_BACKUP_ERROR_CODE = "1207";
    private static final String PAUSED_BACKUP_ERROR_CODE = "1992";
    private UploadService uploadService;
    private UtilService utilService;
    private Set<String> filesUnderProcess = new HashSet<String>();

    public void setUploadService(UploadService uploadService) {
        this.uploadService = uploadService;
    }

    public void setUtilService(UtilService utilService) {
        this.utilService = utilService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        block33: {
            if (!PCHelperConstant.isJobEnabled((String)"spCapacityManualMgmtJobTrigger")) {
                logger.debug("SPCapacityManualMgmtJob ............. disabled");
                return;
            }
            final Cloud cloud = this.utilService.getCloud(1);
            boolean isSPArchivingEnabled = this.isSPArchivingEnabled(cloud);
            if (!PCHelperConstant.isParacloud() || !isSPArchivingEnabled) {
                logger.debug(PCHelperConstant.isParacloud() + "...not main machine..sleep for 30 mins." + isSPArchivingEnabled);
                try {
                    Thread.sleep(TimeUnit.MINUTES.toMinutes(30L));
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                return;
            }
            logger.debug("@@@@SPCapacityManualMgmtJob started ..... ");
            try {
                boolean isJobsShouldStop = PCHelperConstant.isJobsStopEnabled();
                if (isJobsShouldStop) {
                    logger.debug("stopJobsEnabled in privacygateway.properties so return");
                    return;
                }
                long batchStartTime = System.currentTimeMillis();
                CPBackupBatch cpBackupBatch = new CPBackupBatch();
                boolean pausedCase = false;
                String backupBatchId = "";
                CPBackupBatch existBackupBatch = this.utilService.getCPBackupBatch(cloud.getCloudId(), Device.TYPE.SHAREPOINT.name());
                if (existBackupBatch != null && existBackupBatch.isManualJob()) {
                    List latestList;
                    if (existBackupBatch != null) {
                        logger.debug(".....inside exist....");
                        cpBackupBatch = existBackupBatch;
                        if (existBackupBatch != null && existBackupBatch.getStatus().equalsIgnoreCase("PAUSED")) {
                            logger.debug(".....inside 2....");
                            pausedCase = true;
                            backupBatchId = existBackupBatch.getId().toString();
                            boolean startedCaseExists = true;
                            do {
                                Thread.sleep(TimeUnit.SECONDS.toMillis(20L));
                                existBackupBatch = this.utilService.getLatestCPBackupBatch(cloud.getCloudId(), Device.TYPE.SHAREPOINT.name());
                                logger.debug(".....inside 3...." + existBackupBatch);
                                if (existBackupBatch != null && existBackupBatch.getStatus().equalsIgnoreCase("PAUSED")) {
                                    startedCaseExists = true;
                                    logger.debug(".....inside 4...." + existBackupBatch);
                                    continue;
                                }
                                startedCaseExists = false;
                                logger.debug(".....inside 5...." + existBackupBatch);
                            } while (startedCaseExists);
                        }
                    }
                    if (!pausedCase) {
                        cpBackupBatch.setStatus(CPBackupBatch.STATUS.STARTED.toString());
                        cpBackupBatch.setProductType(Device.TYPE.SHAREPOINT.name());
                        if (existBackupBatch == null) {
                            // empty if block
                        }
                        backupBatchId = this.utilService.saveCPBackupBatch(cloud.getCloudId(), cpBackupBatch);
                    }
                    if (CollectionUtils.isEmpty((Collection)(latestList = this.uploadService.getFilesForArchiving(cloud.getCloudName(), false, Device.TYPE.SHAREPOINT.name())))) {
                        logger.debug("@@@@SPCapacityManualMgmtJob no files to process wait for a min ..... ");
                        logger.debug("@@@@SPCapacityManualMgmtJob no files to process wait for a min end..... ");
                    }
                    boolean i = false;
                    latestList.removeAll(Collections.singleton(null));
                    String errorCode = "";
                    boolean lastRecord = false;
                    if (CollectionUtils.isEmpty((Collection)latestList)) {
                        lastRecord = true;
                    }
                    do {
                        String backupBatchIdFinal = backupBatchId;
                        if (!CollectionUtils.isEmpty((Collection)latestList)) {
                            ThreadFactoryBuilder threadFactoryBuilder = new ThreadFactoryBuilder().setNameFormat("SPCP-$$%d$$");
                            CountDownLatch latch = new CountDownLatch(latestList.size());
                            ExecutorService executorService = Executors.newFixedThreadPool(10, threadFactoryBuilder.build());
                            for (CMBackUpImage cmBackUpImage : latestList) {
                                Runnable uploadJob = () -> this.processBkpImage(cmBackUpImage, backupBatchIdFinal, cloud, latch);
                                executorService.submit(uploadJob);
                            }
                            try {
                                latch.await();
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            executorService.shutdown();
                        }
                        if ((existBackupBatch = this.utilService.getLatestCPBackupBatch(cloud.getCloudId(), Device.TYPE.SHAREPOINT.name())) != null && StringUtils.isNotEmpty((String)existBackupBatch.getErrorCode())) {
                            logger.debug(",,,,errorcode11...." + existBackupBatch.getErrorCode());
                            if (existBackupBatch.getErrorCode().equals(STOPPED_BACKUP_ERROR_CODE)) {
                                errorCode = STOPPED_BACKUP_ERROR_CODE;
                                break;
                            }
                            if (existBackupBatch.getErrorCode().equals(PAUSED_BACKUP_ERROR_CODE)) {
                                errorCode = PAUSED_BACKUP_ERROR_CODE;
                                break;
                            }
                        }
                        if (!StringUtils.isEmpty((String)errorCode)) {
                            lastRecord = true;
                        }
                        String uploadedFiles = existBackupBatch.getUploadedFiles();
                        logger.debug("....completed  file batch..." + uploadedFiles);
                        try {
                            if (!StringUtils.isEmpty((String)uploadedFiles)) {
                                String[] parts = uploadedFiles.split("/");
                                int actualNoOfFiles = Integer.parseInt(parts[1]);
                                int noOfFilesBackedup = Integer.parseInt(parts[0]);
                                logger.debug(uploadedFiles + "....totalfiles...." + actualNoOfFiles + "..." + noOfFilesBackedup);
                                if (actualNoOfFiles != 0 && noOfFilesBackedup != 0 && actualNoOfFiles == noOfFilesBackedup) {
                                    lastRecord = true;
                                }
                            }
                        }
                        catch (Exception e) {
                            logger.trace(" Exception  :" + e);
                            logger.error(" Exception  :" + e.getMessage());
                        }
                        if (!lastRecord) {
                            latestList = this.uploadService.getFilesForArchiving(cloud.getCloudName(), false, Device.TYPE.SHAREPOINT.name());
                            latestList.removeAll(Collections.singleton(null));
                        } else {
                            latestList = new ArrayList();
                        }
                        logger.debug(lastRecord + ",,,,errorcode...." + errorCode);
                        logger.debug(CollectionUtils.isEmpty(latestList) + ".....batch size...." + latestList.size());
                    } while (!lastRecord || !CollectionUtils.isEmpty(latestList));
                    logger.debug(",,,,errorcode...." + errorCode);
                    if (StringUtils.isEmpty((String)errorCode) || "0".equalsIgnoreCase(errorCode)) {
                        logger.debug(",,,,wait 2 min before complete...." + errorCode);
                        Thread.sleep(TimeUnit.MINUTES.toMillis(2L));
                        cpBackupBatch = this.utilService.getCPBackupBatch(cloud.getCloudId(), Device.TYPE.SHAREPOINT.name());
                        cpBackupBatch.setBatchEndTimestamp(System.currentTimeMillis());
                        cpBackupBatch.setStatus(CPBackupBatch.STATUS.COMPLETED.toString());
                        this.utilService.saveCPBackupBatch(cloud.getCloudId(), cpBackupBatch);
                    } else {
                        final Timer timer = new Timer();
                        timer.scheduleAtFixedRate(new TimerTask(){
                            int counter = 0;

                            @Override
                            public void run() {
                                logger.debug("Message printed at " + this.counter + " seconds.");
                                CPBackupBatch existBackupBatch = SPCapacityManualMgmtJob.this.utilService.getCPBackupBatch(cloud.getCloudId(), Device.TYPE.SHAREPOINT.name());
                                if (existBackupBatch != null && StringUtils.isNotEmpty((String)existBackupBatch.getErrorCode()) && existBackupBatch.getErrorCode().equals(SPCapacityManualMgmtJob.PAUSED_BACKUP_ERROR_CODE)) {
                                    if (this.counter > 10) {
                                        this.counter -= 10;
                                    }
                                } else {
                                    timer.cancel();
                                }
                                this.counter += 10;
                                if (this.counter >= 1200) {
                                    timer.cancel();
                                }
                            }
                        }, 0L, 10000L);
                    }
                    logger.debug(" ...completed capacity mgmt..........");
                    break block33;
                }
                logger.debug("...no manual SHAREPOINT job...");
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error(" exception in backup upload job......." + e.getMessage());
                logger.trace("exception in backup upload job ......." + e);
            }
        }
    }

    private void processBkpImage(CMBackUpImage cmBackUpImage, String backupBatchId, Cloud cloud, CountDownLatch latch) {
        logger.debug(cmBackUpImage.getId().toString() + "&&&&&&&&&&&&&DATE&&&&&&&&&&&&" + SPCapacityManualMgmtJob.getDateInFormat(cmBackUpImage.getLastModifiedTime()));
        boolean lastRecord = false;
        CPBackupBatch existBackupBatch = this.utilService.getLatestCPBackupBatch(cloud.getCloudId(), Device.TYPE.SHAREPOINT.name());
        String errorCode = "";
        if (existBackupBatch != null && StringUtils.isNotEmpty((String)existBackupBatch.getErrorCode())) {
            logger.debug(",,,,errorcode11...." + existBackupBatch.getErrorCode());
            if (existBackupBatch.getErrorCode().equals(STOPPED_BACKUP_ERROR_CODE)) {
                errorCode = STOPPED_BACKUP_ERROR_CODE;
                lastRecord = true;
            } else if (existBackupBatch.getErrorCode().equals(PAUSED_BACKUP_ERROR_CODE)) {
                errorCode = PAUSED_BACKUP_ERROR_CODE;
                lastRecord = true;
            }
        }
        String uploadedFiles = existBackupBatch.getUploadedFiles();
        try {
            if (!StringUtils.isEmpty((String)uploadedFiles)) {
                String[] parts = uploadedFiles.split("/");
                int actualNoOfFiles = Integer.parseInt(parts[1]);
                int noOfFilesBackedup = Integer.parseInt(parts[0]);
                logger.debug(uploadedFiles + "....totalfiles...." + actualNoOfFiles + "..." + noOfFilesBackedup);
                if (actualNoOfFiles != 0 && noOfFilesBackedup != 0 && actualNoOfFiles == noOfFilesBackedup) {
                    lastRecord = true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.trace(" Exception  :" + e);
            logger.error(" Exception  :" + e.getMessage());
        }
        if (!lastRecord) {
            boolean fileProcessed = this.processFiles(cmBackUpImage, cloud, backupBatchId);
            long size = 0L;
            if (fileProcessed) {
                size = cmBackUpImage.getSizeInBytes();
            }
        }
        latch.countDown();
    }

    private FileStatusElement uploadFile(CMBackUpImage cmBackUpImage, Cloud cloud, String cpBackupBatchId) {
        FileStatusElement element = new FileStatusElement();
        try {
            element = this.uploadService.createLinks(cloud, cmBackUpImage, cpBackupBatchId);
        }
        catch (Exception e) {
            logger.debug("" + e);
            logger.error(cmBackUpImage.getId().toString() + "#####FILE NOT UPLOADED SUCCESSFULLY .. " + e.getMessage());
        }
        return element;
    }

    private static String getDateInFormat(Long deviceCreatedDate) {
        String dateStringFormat = "";
        if (deviceCreatedDate == null || deviceCreatedDate == 0L) {
            return dateStringFormat;
        }
        try {
            SimpleDateFormat df2 = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
            Date dateD = new Date(deviceCreatedDate);
            dateStringFormat = df2.format(dateD).replaceAll(":", ".");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dateStringFormat;
    }

    public boolean processFiles(CMBackUpImage cmBackUpImage, Cloud cloud, String cpBackupBatchId) {
        boolean isFileUploaded = false;
        try {
            String idVal = cmBackUpImage.getId().toString();
            logger.debug("Processing " + idVal);
            FileStatusElement element = this.uploadFile(cmBackUpImage, cloud, cpBackupBatchId);
            isFileUploaded = element.isUploadStatus();
            if (isFileUploaded) {
                this.uploadService.deleteCPMgtImage(cloud.getCloudId(), cmBackUpImage.getId(), Device.TYPE.SHAREPOINT.name());
            } else {
                this.uploadService.moveCPMgtImage(cloud.getCloudId(), cmBackUpImage, Device.TYPE.SHAREPOINT.name());
            }
            logger.debug(" message status.............. " + isFileUploaded);
            if (cmBackUpImage != null && cmBackUpImage.getId().toString() != null) {
                this.filesUnderProcess.remove(idVal);
            }
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception inside SPCapacityManualMgmtJob Processor PooledConnectionFactory !" + e.getMessage());
        }
        return isFileUploaded;
    }

    public void updateBackupBatch(CPBackupBatch backupBatchOdb, Cloud cloud, int uploadedFiles, Long size) {
        logger.debug("calling backup Batch ..." + backupBatchOdb.getNoOfFiles());
        try {
            int cloudId = cloud.getCloudId();
            if (size == null) {
                size = 0L;
            }
            this.utilService.updateCPBackupBatch(cloudId, backupBatchOdb.getId().toString(), uploadedFiles, size);
            CPBackupBatch backupBatch = this.utilService.getCPBackupBatchById(cloudId, backupBatchOdb.getId().toString());
            if (!StringUtils.isEmpty((String)backupBatch.getUploadedFiles())) {
                String[] parts = backupBatch.getUploadedFiles().split("/");
                try {
                    Integer uploadedFilesLast = Integer.parseInt(parts[0]);
                    Integer totalUploaded = Integer.parseInt(parts[1]);
                    logger.debug("...uploadedfiles..." + uploadedFilesLast + "/" + totalUploaded);
                    if (uploadedFilesLast > totalUploaded) {
                        this.utilService.updateCPBackupBatch(cloudId, backupBatchOdb.getId().toString(), -1, Long.valueOf(-size.longValue()));
                        return;
                    }
                }
                catch (Exception e) {
                    logger.trace("Exception  :" + e);
                    logger.error("Exception  :" + e.getMessage());
                }
            }
            logger.debug("[backupBatch][" + backupBatchOdb.getUserName() + "][" + backupBatchOdb.getDeviceUUID() + "][" + backupBatchOdb.getId() + "][" + backupBatchOdb.getStatus() + "][" + backupBatchOdb.getBatchStartTimestamp() + "][" + backupBatchOdb.getBatchEndTimestamp() + "]");
        }
        catch (Exception e) {
            logger.trace("Error failed to save backupBatch ..." + e);
            logger.error("Error failed to save backupBatch ..." + e.getMessage());
        }
        logger.debug("end of calling backup Batch ...");
    }

    private boolean isSPArchivingEnabled(Cloud cloud) {
        boolean isSPArchivingEnabled = false;
        List licenseDetails = cloud.getCloudCustomisableDetails();
        for (CloudCustomisableDetails license : licenseDetails) {
            if (license == null || !"SP Archiving Enabled".equalsIgnoreCase(license.getName())) continue;
            isSPArchivingEnabled = true;
            break;
        }
        return isSPArchivingEnabled;
    }
}

