/*
 * Decompiled with CFR 0.152.
 */
package com.pg.timer;

import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.SIEMCredentials;
import com.pg.dao.UtilDao;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.service.SIEMService;
import com.pg.service.UtilService;
import java.io.File;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.springframework.scheduling.quartz.QuartzJobBean;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class SIEMLogsUploadJob
extends QuartzJobBean
implements Job {
    private static Logger logger = LogManager.getLogger(SIEMLogsUploadJob.class);
    private SIEMService siemService;
    private UtilService utilService;
    private UtilDao utilDao;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeInternal(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        long jobTimestamp = System.currentTimeMillis();
        if (!PCHelperConstant.isJobEnabled((String)"siemLogsUploadJobTrigger")) {
            logger.debug("siemLogsUploadJob is disabled");
            return;
        }
        logger.debug("siemLogsUploadJob started");
        String filePath = null;
        try {
            boolean isJobsShouldStop = PCHelperConstant.isJobsStopEnabled();
            if (isJobsShouldStop) {
                logger.debug("stopJobsEnabled is true in privacygateway.properties");
                return;
            }
            SIEMCredentials siemCredentials = this.siemService.getSIEMCredentials();
            if (siemCredentials == null) {
                logger.debug("SIEM Credentials in SIEMLogsUploadJob is null; will not run job");
                return;
            }
            Cloud cloud = this.utilService.getCloud(1);
            filePath = this.siemService.convertAuditHistoryToCEF(cloud.getCloudName(), jobTimestamp);
            if (filePath != null && !filePath.isEmpty()) {
                logger.debug("File Path of SIEM logs : " + filePath);
                if (this.uploadLogsToCloud(cloud, filePath, siemCredentials)) {
                    this.siemService.updateLastUploadedTimestamp(jobTimestamp);
                    logger.debug("SIEM logs uploaded to cloud successfully");
                } else {
                    logger.debug("SIEM logs upload to cloud failed");
                }
            }
        }
        catch (Exception e) {
            logger.error("Exception occurred while running siem logs upload job : " + e.getMessage());
            logger.error("Exception Stacktrace : ", (Throwable)e);
        }
        finally {
            if (filePath != null && !filePath.isEmpty()) {
                this.deleteSIEMFileFromPG(filePath);
            }
        }
    }

    private void deleteSIEMFileFromPG(String filePath) {
        try {
            File siemFile = new File(filePath);
            if (siemFile.exists()) {
                siemFile.delete();
            }
        }
        catch (Exception e) {
            logger.error("Exception occurred while deleting siem file from PG : " + e.getMessage());
            logger.error("Exception Stacktrace : ", (Throwable)e);
        }
    }

    private boolean uploadLogsToCloud(Cloud cloud, String filePath, SIEMCredentials siemCredentials) {
        boolean uploadStatus = false;
        if (siemCredentials != null && siemCredentials.getProvider().equalsIgnoreCase("odb")) {
            uploadStatus = this.siemService.uploadFileToODB(cloud, filePath, siemCredentials.getOdbLoginId());
        } else if (siemCredentials != null) {
            uploadStatus = this.siemService.uploadFileToCloud(siemCredentials, filePath);
        } else {
            logger.debug("SIEM Credentials are null, will not upload logs to cloud");
        }
        return uploadStatus;
    }

    private boolean checkLicenseEnabledForFeature(List<CloudCustomisableDetails> licenseDetails, String featureType) {
        boolean featureEnabled = false;
        for (CloudCustomisableDetails license : licenseDetails) {
            if (license == null || !featureType.equalsIgnoreCase(license.getName())) continue;
            featureEnabled = true;
            break;
        }
        return featureEnabled;
    }

    public void setSiemService(SIEMService siemService) {
        this.siemService = siemService;
    }

    public void setUtilService(UtilService utilService) {
        this.utilService = utilService;
    }

    public void setUtilDao(UtilDao utilDao) {
        this.utilDao = utilDao;
    }
}

