/*
 * Decompiled with CFR 0.152.
 */
package com.pg.timer;

import com.parablu.pcbd.domain.BlockedDeviceUser;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.DeviceBackupOverView;
import com.parablu.pcbd.domain.User;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.service.UtilService;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.scheduling.quartz.QuartzJobBean;

@DisallowConcurrentExecution
public class DeleteBlockedUserDeviceDataCleanerJob
extends QuartzJobBean {
    private static Logger logger = LogManager.getLogger(DeleteBlockedUserDeviceDataCleanerJob.class);
    private UtilService utilService;

    public UtilService getUtilService() {
        return this.utilService;
    }

    public void setUtilService(UtilService utilService) {
        this.utilService = utilService;
    }

    public static void deleteFilesOlderThan(File directory, long cutoffDate) {
        if (directory.exists() && directory.isDirectory()) {
            try {
                FileUtils.deleteDirectory((File)directory);
            }
            catch (IOException e) {
                logger.error("....unable to delete path...." + directory);
            }
        }
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        if (!PCHelperConstant.isJobEnabled((String)"deleteBlockedUserDeviceDataCleanerJobTrigger")) {
            logger.debug("Delete BlockedUserDevice Data CleanerJob ............... disabled");
            return;
        }
        logger.debug("************* Delete Blocked UserDevice DataCleanerJob started ***********");
        int cloudId = 1;
        Cloud cloud = this.utilService.getCloud(cloudId);
        List blockedUsers = this.utilService.getAllBlockedUsers(cloudId);
        for (User blockUser : blockedUsers) {
            List blockedDevices = this.utilService.getAllBlockedDevices(cloudId, blockUser.getUserName());
            for (Device device : blockedDevices) {
                BlockedDeviceUser blockedDeviceUser;
                DeviceBackupOverView deviceBackupOverView = this.utilService.getDeviceBkpOverviewForDeviceUUID(cloudId, device.getDeviceUUID());
                String pathname = "/parablu/" + cloud.getCloudName() + "/upload/" + device.getDeviceUUID();
                File targetDir = new File(pathname);
                if (!targetDir.exists()) continue;
                logger.debug("...delete files if any....." + blockUser.getUserName() + "....." + device.getDeviceName());
                long cutoffDate = System.currentTimeMillis() - (long)(cloud.getNoDayOldFilesDelForBlockedUser() * 24 * 60 * 60 * 1000);
                logger.debug(deviceBackupOverView.getLastHeardTime() + "...cutoffdate...." + cutoffDate);
                if (deviceBackupOverView.getLastHeardTime() >= cutoffDate || (blockedDeviceUser = this.utilService.getBlockedDeviceUser(cloudId, device.getDeviceUUID(), blockUser.getUserName())) == null || blockedDeviceUser.isDataDeleted()) continue;
                logger.debug("...delete-user-data....." + blockUser.getUserName() + "....." + device.getDeviceUUID());
                DeleteBlockedUserDeviceDataCleanerJob.deleteFilesOlderThan(targetDir, cutoffDate);
                this.utilService.updateBlockedDeviceDataProgress(cloudId, device.getDeviceUUID(), blockUser.getUserName(), true);
            }
        }
        logger.debug("************* Delete Blocked UserDevice DataCleanerJob ended ***********");
    }
}

