/*
 * Decompiled with CFR 0.152.
 */
package com.pg.timer;

import com.parablu.pcbd.domain.Cloud;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.service.UploadService;
import com.pg.service.UtilService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.springframework.scheduling.quartz.QuartzJobBean;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class BlobFuseCheckJob
extends QuartzJobBean
implements Job {
    private static Logger logger = LogManager.getLogger(BlobFuseCheckJob.class);
    private UploadService uploadService;
    private UtilService utilService;

    public void setUploadService(UploadService uploadService) {
        this.uploadService = uploadService;
    }

    public void setUtilService(UtilService utilService) {
        this.utilService = utilService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        if (!PCHelperConstant.isJobEnabled((String)"blobFuseCheckJobTrigger")) {
            logger.debug("BlobFuseCheckJobTrigger ............. disabled");
            return;
        }
        logger.debug("@@@@BlobFuseCheckJobTrigger started ..... ");
        try {
            Cloud cloud = this.utilService.getCloud(1);
            this.utilService.updateblobFuseDeatils(cloud.getCloudId(), cloud);
            logger.debug(" BlobFuseCheckJobTrigger completed..........");
        }
        catch (Exception e) {
            logger.error(" exception in BlobFuseCheckJobTrigger......." + e.getMessage());
        }
    }
}

