/*
 * Decompiled with CFR 0.152.
 */
package com.pg.timer;

import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.Device;
import com.pg.controller.BaseController;
import com.pg.domain.FileInfo;
import com.pg.element.DeletedUser;
import com.pg.element.DeletedUsersElement;
import com.pg.element.FileStatusElement;
import com.pg.helper.constant.GeneralHelperConstant;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.helper.utils.MemoryStore;
import com.pg.service.UploadService;
import com.pg.service.UtilService;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.springframework.scheduling.quartz.QuartzJobBean;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class BackupUploadLatestJob
extends QuartzJobBean
implements Job {
    private static Logger logger = LogManager.getLogger(BackupUploadLatestJob.class);
    private static final String IS_JOB_RUNNING = "isJobRunning";
    private static final String UPLOAD = "/upload/";
    public static final String ENCRYPTED = "/encrypted/";
    public static final String CHUNK = "/chunk/";
    private static final String BLACK_LIST_USERS = "BlackListUsers";
    private static List<FileInfo> fileInfoList = null;
    private TimerTask backupTimerTask = null;
    private Timer backupTimer = null;
    private UploadService uploadService;
    private UtilService utilService;
    private Set<String> filesUnderProcess = new HashSet<String>();
    private static final String COUNT_429 = "CountOf429";

    public void setUploadService(UploadService uploadService) {
        this.uploadService = uploadService;
    }

    public void setUtilService(UtilService utilService) {
        this.utilService = utilService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        if (!PCHelperConstant.isJobEnabled((String)"backupUploadLatestJobTrigger")) {
            logger.debug("BackupUploadLatestJob ............. disabled");
            return;
        }
        logger.debug("@@@@BackupUploadJob started ..... " + PCHelperConstant.getODBCallFrequency());
        ExecutorService executor = null;
        try {
            boolean isJobsShouldStop = PCHelperConstant.isJobsStopEnabled();
            if (isJobsShouldStop) {
                logger.debug("stopJobsEnabled in privacygateway.properties so return");
                return;
            }
            Cloud cloud = this.utilService.getCloud(1);
            boolean success = this.utilService.resetBusyFlag(cloud.getCloudName());
            logger.debug("reset busy falg is done:" + success);
            List deletedUsersElements = this.utilService.getAllDeletedUsers(1);
            List<String> deletedUserList = this.getDeletedUsersFromElements(deletedUsersElements);
            long threadSize = PCHelperConstant.getThreadLimit();
            logger.debug(" threads val........" + threadSize);
            int threadSizeVal = (int)threadSize;
            executor = Executors.newFixedThreadPool(threadSizeVal);
            fileInfoList = this.uploadService.getFilesForUpload(cloud.getCloudName(), true);
            ExecutorCompletionService<String> pool = new ExecutorCompletionService<String>(executor);
            this.checkThreadStatusAndStartUpload(cloud, executor, pool, deletedUserList);
            for (int i = 0; i < threadSizeVal; ++i) {
                logger.debug("Creating thread for first time>>>>>>>>> i value::" + i);
                this.callUploadFiles(cloud, executor, pool, deletedUserList);
            }
            logger.debug(" exit upload part..........");
        }
        catch (Exception e) {
            logger.error(" exception in backup upload job......." + e.getMessage());
            logger.trace("exception in backup upload job ......." + e);
        }
    }

    private void callUploadFiles(Cloud cloud, ExecutorService executor, CompletionService<String> pool, List<String> deletedUserList) {
        BaseController.printLogs((String)"Files to backup ............... :", (boolean)PCHelperConstant.isBrevityLogging());
        Runnable uploadJob = () -> this.uploadFiles(cloud, executor, pool, deletedUserList);
        pool.submit(uploadJob, "");
    }

    private void uploadFiles(Cloud cloud, ExecutorService executor, CompletionService<String> pool, List<String> deletedUserList) {
        do {
            BaseController.printLogs((String)"....inside while loop..........", (boolean)PCHelperConstant.isBrevityLogging());
            FileInfo fileInfo = null;
            try {
                boolean isTomcatRunning = true;
                if (MemoryStore.get((String)IS_JOB_RUNNING) != null) {
                    isTomcatRunning = (Boolean)MemoryStore.get((String)IS_JOB_RUNNING);
                }
                BaseController.printLogs((String)("........Is tomcat job running........." + isTomcatRunning), (boolean)PCHelperConstant.isBrevityLogging());
                if (!isTomcatRunning) {
                    logger.error("..Tomcat job is going to be stopped.. so stopping upload ....");
                    return;
                }
                Object countOf429 = MemoryStore.get((String)COUNT_429);
                if (countOf429 != null) {
                    int count = (Integer)countOf429;
                    logger.debug("....429 get count " + countOf429);
                    int countOfContinuous429 = PCHelperConstant.getCountOfContinuous429();
                    if (countOfContinuous429 == 0) {
                        countOfContinuous429 = 50;
                    }
                    if (count >= countOfContinuous429) {
                        int timeToSleep = PCHelperConstant.getDelayIn429CaseInSec();
                        logger.debug("....429 count " + count + " is greater than " + countOfContinuous429 + ", so sleep for " + timeToSleep + " min");
                        if (timeToSleep != 0) {
                            Thread.sleep(TimeUnit.MINUTES.toMillis(timeToSleep));
                        } else {
                            logger.debug("....429 count " + count + " is greater than " + countOfContinuous429 + ", so sleep for 3 min");
                            Thread.sleep(TimeUnit.MINUTES.toMillis(3L));
                        }
                        logger.debug("....429 sleep compelted ");
                        MemoryStore.delete((String)COUNT_429);
                    }
                }
            }
            catch (Exception e) {
                logger.trace("" + e);
                logger.error("Exception While adding in 429 count :" + e.getMessage());
            }
            try {
                BaseController.printLogs((String)("message list......................................." + fileInfoList.size()), (boolean)PCHelperConstant.isBrevityLogging());
                fileInfo = this.getFileForProcessing(cloud, deletedUserList);
                if (fileInfo != null) {
                    fileInfo.setBusy(false);
                    this.processMessage(fileInfo, cloud);
                    logger.error(fileInfo.getId() + " %%%%%%% upload completed for file ...." + fileInfo.getFileName());
                }
                BaseController.printLogs((String)("Thread ready for next File .... " + fileInfoList.size()), (boolean)PCHelperConstant.isBrevityLogging());
            }
            catch (Exception e) {
                logger.error("exception inside BackupUploadJob .... " + e.getMessage());
                logger.trace("exception inside BackupUploadJob ...." + e);
            }
            if (fileInfo == null || !StringUtils.isNotEmpty((String)fileInfo.getId())) continue;
            this.filesUnderProcess.remove(fileInfo.getId());
        } while (!CollectionUtils.isEmpty(fileInfoList));
        logger.error("no files to upload so wait and then retry>>>>");
        try {
            int timeToSleep = PCHelperConstant.getDelayInUploadInSec();
            BaseController.printLogs((String)("Sleep for " + timeToSleep + " secs"), (boolean)PCHelperConstant.isBrevityLogging());
            if (timeToSleep != 0) {
                Thread.sleep(TimeUnit.SECONDS.toMillis(timeToSleep));
                BaseController.printLogs((String)("Sleep for " + timeToSleep + " secs completed"), (boolean)PCHelperConstant.isBrevityLogging());
            } else {
                BaseController.printLogs((String)"Sleep for 5 secs", (boolean)PCHelperConstant.isBrevityLogging());
                Thread.sleep(TimeUnit.SECONDS.toMillis(5L));
                BaseController.printLogs((String)"Sleep for 5 secs completed", (boolean)PCHelperConstant.isBrevityLogging());
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.callUploadFiles(cloud, executor, pool, deletedUserList);
    }

    private synchronized FileInfo getFileForProcessing(Cloud cloud, List<String> deletedUserList) {
        if (CollectionUtils.isEmpty(fileInfoList) && CollectionUtils.isEmpty(fileInfoList = this.getMessagesToProcess(cloud, deletedUserList))) {
            return null;
        }
        FileInfo fileInfo = fileInfoList.get(0);
        if (fileInfo != null) {
            if (this.filesUnderProcess.contains(fileInfo.getId())) {
                fileInfoList.remove(fileInfo);
                return this.getFileForProcessing(cloud, deletedUserList);
            }
            fileInfoList.remove(fileInfo);
            this.filesUnderProcess.add(fileInfo.getId());
            fileInfo = this.uploadService.getFileFromPG(cloud.getCloudName(), fileInfo.getId());
            fileInfo.setBusy(true);
            this.uploadService.saveFileInfoBusy(cloud.getCloudName(), fileInfo.getUserName(), fileInfo);
        }
        logger.debug("...after list size....." + fileInfoList.size());
        return fileInfo;
    }

    private List<FileInfo> getMessagesToProcess(Cloud cloud, List<String> deletedUserList) {
        List latestList = this.uploadService.getFilesForUpload(cloud.getCloudName(), false);
        if (CollectionUtils.isEmpty((Collection)latestList)) {
            try {
                Thread.sleep(TimeUnit.MINUTES.toMillis(5L));
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        int i = 0;
        for (FileInfo fileInfo : latestList) {
            Set blackUsersList;
            String userName = fileInfo.getUserName().toLowerCase();
            if (deletedUserList.contains(userName)) {
                logger.debug("it contains deleted user so remove from message queue.....");
                this.acknowlwdgeAndCloseSession(cloud, fileInfo, 200);
                continue;
            }
            Object obj = MemoryStore.get((String)BLACK_LIST_USERS);
            if (obj != null && (blackUsersList = (Set)obj).contains(userName)) {
                logger.debug("it contains #blackList# user so remove from message queue.....userName:" + fileInfo.getUserName());
                this.uploadService.moveFailedFilesToBkpQueueAndDeleteInLocal(cloud.getCloudName(), fileInfo, true);
                continue;
            }
            String userBlockedForWrite = "429_" + fileInfo.getUserName();
            Object userBlockedFor429 = MemoryStore.get((String)userBlockedForWrite);
            if (userBlockedFor429 != null) {
                this.uploadService.moveFailedFilesToBkpQueueAndDeleteInLocal(cloud.getCloudName(), fileInfo, true);
                continue;
            }
            String unMappedUser = "404_" + fileInfo.getUserName();
            Object unMappedUser404 = MemoryStore.get((String)unMappedUser);
            if (unMappedUser404 != null) {
                this.uploadService.moveFailedFilesToBkpQueueAndDeleteInLocal(cloud.getCloudName(), fileInfo, true);
                continue;
            }
            fileInfoList.add(fileInfo);
            ++i;
        }
        return fileInfoList;
    }

    public void checkThreadStatusAndStartUpload(final Cloud cloud, final ExecutorService executor, final CompletionService<String> pool, final List<String> deletedUserList) {
        if (this.backupTimer == null) {
            this.backupTimer = new Timer();
        }
        if (this.backupTimerTask == null) {
            this.backupTimerTask = new TimerTask(){

                @Override
                public void run() {
                    try {
                        BaseController.printLogs((String)"Check the task is completed>>>>>>>>", (boolean)PCHelperConstant.isBrevityLogging());
                        Future future = pool.take();
                        if (future.isDone()) {
                            logger.debug("Thread is completed so assign new task>>>>>>>>>>>");
                            BackupUploadLatestJob.this.callUploadFiles(cloud, executor, pool, deletedUserList);
                        }
                    }
                    catch (Exception e) {
                        logger.error("Error in checkThreadStatusAndStartUpload", (Throwable)e);
                        logger.trace("" + e);
                    }
                }
            };
            this.backupTimer.schedule(this.backupTimerTask, 1000L, 1000L);
        }
    }

    private FileStatusElement uploadFile(FileInfo fileInfo, Cloud cloud) {
        FileStatusElement element = new FileStatusElement();
        try {
            element = this.uploadService.uploadAllFilesToCloud(cloud.getCloudName(), fileInfo, cloud, null);
        }
        catch (Exception e) {
            logger.debug("" + e);
            logger.error(fileInfo.getFileName() + "#####FILE NOT UPLOADED SUCCESSFULLY .. " + e.getMessage());
        }
        return element;
    }

    private void deleteUnReferencedChunk(String deviceUUID, String cloudName, String name, String batchId, String fileName) {
        if (!StringUtils.isEmpty((String)deviceUUID)) {
            String parabluBaseMountFolder = PCHelperConstant.getParabluFolderBasePath();
            String chunkPath = parabluBaseMountFolder + cloudName + UPLOAD + deviceUUID + CHUNK;
            String encryptedPath = parabluBaseMountFolder + cloudName + UPLOAD + deviceUUID + ENCRYPTED;
            String filePath = parabluBaseMountFolder + cloudName + UPLOAD + deviceUUID + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
            if (!StringUtils.isEmpty((String)batchId)) {
                chunkPath = parabluBaseMountFolder + cloudName + UPLOAD + deviceUUID + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + batchId + CHUNK;
                encryptedPath = parabluBaseMountFolder + cloudName + UPLOAD + deviceUUID + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + batchId + ENCRYPTED;
                filePath = parabluBaseMountFolder + cloudName + UPLOAD + deviceUUID + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + batchId + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
            }
            try {
                File deleteOrgFile;
                File deleteChunkFile = new File(chunkPath + name);
                File deleteEncryptedFile = new File(encryptedPath + name);
                if (deleteChunkFile.exists()) {
                    deleteChunkFile.delete();
                }
                if (deleteEncryptedFile.exists()) {
                    deleteEncryptedFile.delete();
                }
                if ((deleteOrgFile = new File(filePath + fileName)).exists()) {
                    deleteOrgFile.delete();
                }
            }
            catch (Exception e) {
                logger.error("Error trying to clean files ..... " + e.getMessage());
                logger.trace("" + e);
            }
        }
    }

    private void deleteEncryptedChunks(String deviceUUID, String cloudName, String name, String batchId, String fileName) {
        if (!StringUtils.isEmpty((String)deviceUUID)) {
            String parabluBaseMountFolder = PCHelperConstant.getParabluFolderBasePath();
            String encryptedPath = parabluBaseMountFolder + cloudName + UPLOAD + deviceUUID + ENCRYPTED;
            if (!StringUtils.isEmpty((String)batchId)) {
                encryptedPath = parabluBaseMountFolder + cloudName + UPLOAD + deviceUUID + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + batchId + ENCRYPTED;
            }
            try {
                File deleteEncryptedFile = new File(encryptedPath + name);
                if (deleteEncryptedFile.exists()) {
                    deleteEncryptedFile.delete();
                }
            }
            catch (Exception e) {
                logger.error("Error trying to clean files ..... " + e.getMessage());
                logger.trace("" + e);
            }
        }
    }

    public void processMessage(FileInfo fileInfo, Cloud cloud) {
        try {
            logger.debug("Processing " + fileInfo.getFileName());
            String userBlockedForWrite = "429_" + fileInfo.getUserName();
            Object userBlockedFor429 = MemoryStore.get((String)userBlockedForWrite);
            String userUnMapped = "404_" + fileInfo.getUserName();
            Object userUnMapped404 = MemoryStore.get((String)userUnMapped);
            if (userBlockedFor429 != null) {
                logger.error(fileInfo.getUserName() + "........user acct has too many requests ........move file to bkp queue .............");
                this.uploadService.moveFailedFilesToBkpQueueAndDeleteInLocal(cloud.getCloudName(), fileInfo, true);
            } else if (userUnMapped404 != null) {
                logger.error(fileInfo.getUserName() + "........unmapped user.............");
                this.uploadService.moveFailedFilesToBkpQueueAndDeleteInLocal(cloud.getCloudName(), fileInfo, true);
            } else {
                FileStatusElement element = this.uploadFile(fileInfo, cloud);
                boolean isFileUploaded = element.isUploadStatus();
                if (isFileUploaded) {
                    this.acknowlwdgeAndCloseSession(cloud, fileInfo, element.getUploadStatuscode());
                } else {
                    logger.error(fileInfo.getFileName() + "................move file to bkp queue .............");
                    boolean isUserBlackListed = false;
                    if (element.getUploadStatuscode() == 404 || element.getUploadStatuscode() == 503 || element.getUploadStatuscode() == 429 || element.getUploadStatuscode() == 403 || element.getUploadStatuscode() == 6789) {
                        isUserBlackListed = true;
                    }
                    fileInfo = this.uploadService.getFileFromPG(cloud.getCloudName(), fileInfo.getId());
                    logger.debug("...moved to diff queue..." + fileInfo.getUploadedChunks());
                    fileInfo.setBusy(false);
                    if (element.getUploadStatuscode() == 6789) {
                        this.uploadService.moveFailedFilesToDiffQueueAndDeleteInLocal(cloud.getCloudName(), fileInfo, true);
                    } else {
                        this.uploadService.moveFailedFilesToBkpQueueAndDeleteInLocal(cloud.getCloudName(), fileInfo, true);
                    }
                }
                logger.debug(" message status.............. " + isFileUploaded);
            }
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception inside BackupUploadJob Processor PooledConnectionFactory !" + e.getMessage());
        }
        this.deleteFileEncryptedChunks(cloud, fileInfo);
    }

    private void deleteFileEncryptedChunks(Cloud cloud, FileInfo fileInfo) {
        if (fileInfo == null) {
            return;
        }
        for (String name : fileInfo.getChunkFiles()) {
            int occurance = StringUtils.countMatches((String)name, (String)".");
            if (occurance > 1) {
                name = name.substring(0, name.lastIndexOf(46));
            }
            this.deleteEncryptedChunks(fileInfo.getDeviceUUID(), cloud.getCloudName(), name, fileInfo.getBatchId(), fileInfo.getFileName());
        }
    }

    private void acknowlwdgeAndCloseSession(Cloud cloud, FileInfo fileInfo, int fileUploadStatusCode) {
        logger.debug("fileUploadStatusCode...." + fileUploadStatusCode);
        if (fileUploadStatusCode != 203) {
            for (String name : fileInfo.getChunkFiles()) {
                int occurance = StringUtils.countMatches((String)name, (String)".");
                if (occurance > 1) {
                    name = name.substring(0, name.lastIndexOf(46));
                }
                this.deleteUnReferencedChunk(fileInfo.getDeviceUUID(), cloud.getCloudName(), name, fileInfo.getBatchId(), fileInfo.getFileName());
            }
            String path = "/parablu/tmp-chunk/upload/localwrite/" + fileInfo.getId() + ".json";
            if (new File(path).exists()) {
                new File(path).delete();
            }
        }
        this.uploadService.deleteUploadedFiles(fileInfo, cloud.getCloudName());
        if (fileInfo.getId().startsWith("ALREADY_EXISTS-")) {
            String fileInfoId = fileInfo.getId().replace("ALREADY_EXISTS-", "");
            Device device = this.utilService.getDeviceForUUID(cloud.getCloudId(), fileInfo.getDeviceUUID());
            fileInfoId = fileInfoId.replace("-" + device.getDestCollection(), "");
            fileInfo.setId(fileInfoId);
        }
        this.uploadService.removeBackupFromTempDb(cloud, new ObjectId(fileInfo.getId()));
        logger.debug(fileInfo.getFileName() + ".....file deleted ..... " + fileInfo.getId());
    }

    private List<String> getDeletedUsersFromElements(List<DeletedUsersElement> deletedUsersElements) {
        ArrayList<String> delUsers = new ArrayList<String>();
        for (DeletedUsersElement deletedUsersElement : deletedUsersElements) {
            for (DeletedUser deletedUser : deletedUsersElement.getDeletedUsers()) {
                delUsers.add(deletedUser.getUserName().toLowerCase());
            }
        }
        return delUsers;
    }

    private boolean isODBEnabled(List<CloudCustomisableDetails> licenseDetails) {
        boolean isODBEnabled = false;
        for (CloudCustomisableDetails license : licenseDetails) {
            if (license == null || !"ODB Enabled".equalsIgnoreCase(license.getName())) continue;
            isODBEnabled = true;
            break;
        }
        return isODBEnabled;
    }
}

