/*
 * Decompiled with CFR 0.152.
 */
package com.pg.timer;

import com.parablu.paracloud.element.CloudPropertyElement;
import com.parablu.pcbd.domain.Cloud;
import com.pg.helper.constant.GeneralHelperConstant;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.service.UtilService;
import java.io.File;
import java.io.FilenameFilter;
import java.text.SimpleDateFormat;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.scheduling.quartz.QuartzJobBean;

public class SyncDeleteJob
extends QuartzJobBean {
    private static Logger logger = LogManager.getLogger(SyncDeleteJob.class);
    public static final String ZIP_EXTENSION = ".zip";
    public static final String SYNC_DOWNLOAD = "sync-download";
    public static final String SYNC_UPLOAD = "sync-upload";
    public static final String PORTAL = "Portal";
    public static final String ENCRYPTED = "encrypted";
    public static final String CHUNK = "chunk";
    public static final String TEMP_DOWNLOAD_SYNC = "tempdownloadsync";
    public static final String MERGE = "merge";
    private static long maxDurationInMs = 604800000L;
    private UtilService utilService;

    public void setUtilService(UtilService utilService) {
        this.utilService = utilService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        logger.debug("-----------------------action=delete sync file and folder from server, status=started-----------------------");
        if (!PCHelperConstant.isJobEnabled((String)"syncDeleteTrigger")) {
            logger.debug("SyncDeleteJob ............. disabled");
            return;
        }
        Cloud cloud = this.utilService.getCloud(1);
        String downloadPath = PCHelperConstant.getPropertyFileValueParacloudMountPoint() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + cloud.getCloudName() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + SYNC_DOWNLOAD + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
        logger.debug("the Sync-download path is={}", (Object)downloadPath);
        String uploadPath = PCHelperConstant.getPropertyFileValueParacloudMountPoint() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + cloud.getCloudName() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + SYNC_UPLOAD + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + PORTAL + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
        logger.debug("the Sync-upload path is={}", (Object)uploadPath);
        CloudPropertyElement cloudPropertyElement = this.utilService.getCloudPropertyElement(1);
        if (cloudPropertyElement.getDaysToDeleteLocalSyncFilesAndFolders() > 0) {
            maxDurationInMs = cloudPropertyElement.getDaysToDeleteLocalSyncFilesAndFolders() * 1000 * 60 * 60 * 24;
        }
        logger.debug("maxDurationInMs={}", (Object)maxDurationInMs);
        this.deleteSyncDownloadFiles(downloadPath);
        this.deleteSyncUploadFiles(uploadPath);
    }

    private void deleteSyncDownloadFiles(String path) {
        logger.debug("Inside sync-download delete");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd hh:mm:ss");
        FilenameFilter textFilefilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                String lowerCaseName = name.toLowerCase();
                return lowerCaseName.endsWith(SyncDeleteJob.ZIP_EXTENSION) || lowerCaseName.matches("\\d+");
            }
        };
        File syncDownloadDirectory = new File(path);
        File[] filesList = syncDownloadDirectory.listFiles(textFilefilter);
        if (filesList != null) {
            for (File file : filesList) {
                try {
                    logger.debug("file/folder name={},  file last modified={}", (Object)file.getName(), (Object)sdf.format(file.lastModified()));
                    long durationOfFile = Math.abs(System.currentTimeMillis() - file.lastModified());
                    logger.debug("the time duration of file/folder since it is modified present in server is={}", (Object)durationOfFile);
                    if (durationOfFile > maxDurationInMs && !file.isDirectory()) {
                        logger.debug("the file={} is eligible for cleanup", (Object)file.getName());
                        boolean isSuccess = file.delete();
                        logger.debug("the deletion of the file={}, status={}", (Object)file.getName(), (Object)isSuccess);
                        continue;
                    }
                    if (durationOfFile <= maxDurationInMs || !file.isDirectory()) continue;
                    logger.debug("the folder={} is eligible for cleanup", (Object)file.getName());
                    FileUtils.deleteDirectory((File)file);
                }
                catch (Exception e) {
                    logger.error("Error trying to perform operations on file ..... " + e.getMessage());
                }
            }
        }
    }

    private void deleteSyncUploadFiles(String path) {
        logger.debug("Inside sync-upload delete");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd hh:mm:ss");
        FilenameFilter textFilefilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                String lowerCaseName = name.toLowerCase();
                return !lowerCaseName.equals(SyncDeleteJob.ENCRYPTED) && !lowerCaseName.equals(SyncDeleteJob.CHUNK) && !lowerCaseName.equals(SyncDeleteJob.TEMP_DOWNLOAD_SYNC) && !lowerCaseName.equals(SyncDeleteJob.MERGE);
            }
        };
        File syncUploadDirectory = new File(path);
        File[] foldersToBeDeleted = syncUploadDirectory.listFiles(textFilefilter);
        if (foldersToBeDeleted != null) {
            logger.debug("folders size={}", (Object)foldersToBeDeleted.length);
            for (File folder : foldersToBeDeleted) {
                try {
                    logger.debug("folder name={}, folder last modified={}", (Object)folder.getName(), (Object)sdf.format(folder.lastModified()));
                    long durationOfFolder = Math.abs(System.currentTimeMillis() - folder.lastModified());
                    logger.debug("the time duration of folder since it is modified present in server is={}", (Object)durationOfFolder);
                    if (durationOfFolder <= maxDurationInMs || !folder.exists() || !folder.isDirectory()) continue;
                    logger.debug("the folder={} is eligible for cleanup", (Object)folder.getName());
                    FileUtils.deleteDirectory((File)folder);
                }
                catch (Exception e) {
                    logger.error("an exception has occurred while deleting={}", (Throwable)e);
                }
            }
        }
    }
}

