/*
 * Decompiled with CFR 0.152.
 */
package com.pg.timer;

import com.parablu.pcbd.domain.Cloud;
import com.pg.element.DeletedUser;
import com.pg.element.DeletedUsersElement;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.service.DeleteExternalStorageDataService;
import com.pg.service.UtilService;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.StatefulJob;
import org.springframework.scheduling.quartz.QuartzJobBean;

public class DeleteExternalStorageDataTimer
extends QuartzJobBean
implements StatefulJob {
    private static Logger logger = LogManager.getLogger(DeleteExternalStorageDataTimer.class);
    private DeleteExternalStorageDataService deleteExternalStorageDataService;
    private UtilService utilService;

    public void setDeleteExternalStorageDataService(DeleteExternalStorageDataService deleteExternalStorageDataService) {
        this.deleteExternalStorageDataService = deleteExternalStorageDataService;
    }

    public void setUtilService(UtilService utilService) {
        this.utilService = utilService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        if (!PCHelperConstant.isJobEnabled((String)"deleteExternalStorageDataTimer")) {
            logger.debug("DeleteExternalStorageDataTimer ........... disabled");
            return;
        }
        logger.debug("@@@ Delete JOB STARTED for delete blob...");
        try {
            boolean isJobsShouldStop = PCHelperConstant.isJobsStopEnabled();
            if (isJobsShouldStop) {
                logger.debug("stopJobsEnabled in privacygateway.properties so return");
                return;
            }
            Cloud cloud = this.utilService.getCloud(1);
            List usersForCloud = this.utilService.getAllDeletedUsers(1);
            this.deleteExternalStorageDataService.deleteExternalStorageData(cloud);
            for (DeletedUsersElement cloudUsersElement : usersForCloud) {
                int cloudId = cloudUsersElement.getCloudId();
                String cloudName = cloudUsersElement.getCloudName();
                for (DeletedUser user : cloudUsersElement.getDeletedUsers()) {
                    logger.debug(user + "<<<<<<<<<<username for delete");
                    this.triggerJobToDeleteUserData(cloudId, cloudName, user, cloud);
                }
            }
            logger.debug("@@@@ Delete JOB ENDED...");
        }
        catch (Exception e) {
            logger.debug("" + e);
        }
    }

    private void triggerJobToDeleteUserData(int cloudId, String cloudName, DeletedUser user, Cloud cloud) {
        this.deleteMntPathForUser(cloudId, cloudName, user);
    }

    private void deleteMntPathForUser(int cloudId, String cloudName, DeletedUser user) {
        List deviceUUIDs = user.getDeviceUUIDs();
        for (String deviceUUID : deviceUUIDs) {
            String mntPath = PCHelperConstant.getParabluFolderBasePath() + cloudName + "/upload/" + deviceUUID;
            try {
                FileUtils.deleteDirectory((File)new File(mntPath));
            }
            catch (IOException e) {
                logger.debug("" + e);
                logger.error("Error in deleting Directory");
            }
        }
    }
}

