/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.udc.service.impl;

import com.parablu.bluvault.udc.service.PciAuthorizationTokensService;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.pcbd.dao.PciAuthorizationTokensDao;
import com.parablu.pcbd.dao.SettingsDao;
import com.parablu.pcbd.dao.UserDao;
import com.parablu.pcbd.domain.CloudStorageType;
import com.parablu.pcbd.domain.MSGTokens;
import com.parablu.pcbd.domain.PciAuthorizationTokens;
import com.parablu.pcbd.domain.Proxy;
import com.parablu.pcbd.domain.User;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.bson.types.ObjectId;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class PciAuthorizationTokensServiceImpl
implements PciAuthorizationTokensService {
    private static Logger logger = LoggerFactory.getLogger(PciAuthorizationTokensServiceImpl.class);
    private static final String TOKEN_URL = "https://login.windows.net/common/oauth2/token";
    private PciAuthorizationTokensDao pciAuthorizationTokensDao;
    private UserDao userDao;
    private SettingsDao settingsDao;
    private static final String UTF_8 = "UTF-8";

    public void setPciAuthorizationTokensDao(PciAuthorizationTokensDao pciAuthorizationTokensDao) {
        this.pciAuthorizationTokensDao = pciAuthorizationTokensDao;
    }

    public void setUserDao(UserDao userDao) {
        this.userDao = userDao;
    }

    @Override
    public void savePciAuthorizationTokens(int cloudId, String cloudName, PciAuthorizationTokens pciAuthorizationTokens) {
        this.pciAuthorizationTokensDao.savePciAuthorizationTokens(cloudId, cloudName, pciAuthorizationTokens);
    }

    @Override
    public PciAuthorizationTokens getPciAuthorizationTokensForUserId(int cloudId, String cloudName, ObjectId userId) {
        return this.pciAuthorizationTokensDao.getPciAuthorizationTokensForUserId(cloudId, cloudName, userId);
    }

    @Override
    public void saveCloudStorageType(int cloudId, String cloudName, CloudStorageType cloudStorageType) {
        this.pciAuthorizationTokensDao.saveCloudStorageType(cloudId, cloudName, cloudStorageType);
    }

    @Override
    public CloudStorageType getCloudStorageTypeByName(int cloudId, String cloudName, String name) {
        return this.pciAuthorizationTokensDao.getCloudStorageTypeByName(cloudId, cloudName, name);
    }

    @Override
    public boolean checkOneDriveConn() {
        boolean result = false;
        URL url = null;
        URLConnection conn = null;
        try {
            url = new URL("https://login.windows.net/");
            java.net.Proxy proxy = this.getProxy(1);
            conn = proxy == null ? url.openConnection() : url.openConnection(proxy);
            conn.setConnectTimeout(1800000);
            HttpURLConnection connection = (HttpURLConnection)conn;
            int responseCode = connection.getResponseCode();
            logger.debug("...responseCode..." + responseCode);
            if (responseCode == 200) {
                result = true;
                return result;
            }
        }
        catch (Exception e) {
            logger.trace(" Exception  :" + e);
            logger.error(" ERROR trying to get access token ... " + e.getMessage());
        }
        return result;
    }

    @Override
    public String getAccessTokenForOffice365(int cloudId, String cloudName, PciAuthorizationTokens pciAuthorizationTokens) {
        logger.debug("****** INSIDE PCI....." + pciAuthorizationTokens);
        String accessToken = "";
        URL url = null;
        URLConnection conn = null;
        String data = null;
        try {
            String line;
            java.net.Proxy proxy = this.getProxy(cloudId);
            data = URLEncoder.encode("grant_type", UTF_8) + "=" + URLEncoder.encode("refresh_token", UTF_8);
            data = data + "&" + URLEncoder.encode("refresh_token", UTF_8) + "=" + URLEncoder.encode(pciAuthorizationTokens.getRefreshToken(), UTF_8);
            data = data + "&" + URLEncoder.encode("client_id", UTF_8) + "=" + URLEncoder.encode(pciAuthorizationTokens.getClientId(), UTF_8);
            data = data + "&" + URLEncoder.encode("client_secret", UTF_8) + "=" + URLEncoder.encode(pciAuthorizationTokens.getClientSecret(), UTF_8);
            url = new URL(TOKEN_URL);
            conn = proxy == null ? url.openConnection() : url.openConnection(proxy);
            conn.setDoOutput(true);
            conn.setConnectTimeout(1800000);
            OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
            wr.write(data);
            wr.flush();
            HttpURLConnection connection = (HttpURLConnection)conn;
            if (connection.getResponseCode() == 400) {
                logger.debug("TOKEN has expired for user ...... " + pciAuthorizationTokens.getAccountId());
                return "";
            }
            BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            StringBuilder response = new StringBuilder("");
            while ((line = rd.readLine()) != null) {
                response.append(line);
            }
            wr.close();
            rd.close();
            JSONObject jsonObject = new JSONObject(response.toString());
            accessToken = jsonObject.optString("access_token");
        }
        catch (Exception e) {
            logger.trace(" Exception  :" + e);
            logger.error(" ERROR trying to get access token ... " + e.getMessage());
        }
        return accessToken;
    }

    @Override
    public PciAuthorizationTokens getPciAuthorizationTokensForServiceAccount(int cloudId, String cloudName) {
        return this.pciAuthorizationTokensDao.getPciAuthorizationTokensForServiceAccount(cloudId, cloudName);
    }

    @Override
    public void updateAllUserTokens(int cloudId, String cloudName) {
        List users = this.userDao.getAllUsers(cloudId, cloudName);
        PciAuthorizationTokens authorizationTokens = this.getPciAuthorizationTokensForServiceAccount(cloudId, cloudName);
        if (authorizationTokens != null) {
            for (User user : users) {
                if (authorizationTokens.getUserId().toString().equals(user.getUserId().toString())) continue;
                PciAuthorizationTokens pciAuthorizationTokens = new PciAuthorizationTokens();
                BeanUtils.copyProperties((Object)authorizationTokens, (Object)pciAuthorizationTokens);
                pciAuthorizationTokens.setUserId(user.getUserId());
                pciAuthorizationTokens.setEmailId(user.getEmailId());
                pciAuthorizationTokens.setServiceAccount(false);
                this.pciAuthorizationTokensDao.savePciAuthorizationTokens(cloudId, cloudName, pciAuthorizationTokens);
            }
        }
    }

    @Override
    public List<PciAuthorizationTokens> getAllPciAuthorizationTokens(int cloudId, String cloudName) {
        return this.pciAuthorizationTokensDao.getAllPciAuthorizationTokens(cloudId, cloudName);
    }

    @Override
    public void deletePciAuthorizationTokensForUserId(int cloudId, String cloudName, ObjectId userId) {
        this.pciAuthorizationTokensDao.deletePciAuthorizationTokensForUserId(cloudId, cloudName, userId);
    }

    private java.net.Proxy getProxy(int cloudId) {
        int port;
        String host;
        String passwordVal;
        String userNameVal;
        Proxy proxy = this.settingsDao.getProxy(cloudId);
        if (proxy != null) {
            userNameVal = proxy.getUserName();
            passwordVal = proxy.getPassword();
            host = proxy.getHost();
            port = Integer.parseInt(proxy.getPort());
        } else {
            userNameVal = PCHelperConstant.getProxyUserName();
            passwordVal = PCHelperConstant.getProxyPassword();
            host = PCHelperConstant.getProxyHost();
            port = PCHelperConstant.getProxyPort();
        }
        final String userName = userNameVal;
        final String password = passwordVal;
        if (StringUtils.isEmpty((String)userName) || StringUtils.isEmpty((String)password) || StringUtils.isEmpty((String)host) || port <= 0) {
            return null;
        }
        Authenticator authenticator = new Authenticator(){

            @Override
            public PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(userName, password.toCharArray());
            }
        };
        Authenticator.setDefault(authenticator);
        return new java.net.Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, port));
    }

    public void setSettingsDao(SettingsDao settingsDao) {
        this.settingsDao = settingsDao;
    }

    @Override
    public String getAccessTokenForODBBackup(int cloudId) {
        return this.pciAuthorizationTokensDao.getAccessTokenForODBBackup(cloudId);
    }

    @Override
    public boolean updateTokenForODBBackup(int cloudId) {
        return this.pciAuthorizationTokensDao.updateTokenForODBBackup(cloudId);
    }

    @Override
    public void saveMSGTokens(int cloudId, MSGTokens msgTokens) {
        this.pciAuthorizationTokensDao.saveMSGTokens(cloudId, msgTokens);
    }

    @Override
    public MSGTokens getMSGTokens(int cloudId) {
        return this.pciAuthorizationTokensDao.getMSGTokens(cloudId);
    }

    @Override
    public MSGTokens getMSGTokensForUserId(int cloudId, ObjectId userId) {
        return this.pciAuthorizationTokensDao.getMSGTokensForUserId(cloudId, userId);
    }
}

