/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.udc.service.impl;

import com.parablu.bluvault.udc.service.MiniCloudAccessControlService;
import com.parablu.helper.exceptions.BaseException;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.MiniCloudElement;
import com.parablu.paracloud.element.MiniCloudElementList;
import com.parablu.pcbd.dao.ConsolidatedImageDao;
import com.parablu.pcbd.dao.MiniCloudDao;
import com.parablu.pcbd.dao.PersonDao;
import com.parablu.pcbd.dao.UserDao;
import com.parablu.pcbd.dao.UserGroupDao;
import com.parablu.pcbd.dao.UserMiniCloudMappingDao;
import com.parablu.pcbd.domain.ConsolidatedImage;
import com.parablu.pcbd.domain.Group;
import com.parablu.pcbd.domain.MiniCloud;
import com.parablu.pcbd.domain.MiniCloudGroupMapping;
import com.parablu.pcbd.domain.Person;
import com.parablu.pcbd.domain.User;
import com.parablu.pcbd.domain.UserCloudAccessControl;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;

public class MiniCloudAccessControlServiceImpl
implements MiniCloudAccessControlService {
    private static Logger logger = LoggerFactory.getLogger(MiniCloudAccessControlServiceImpl.class);
    private MiniCloudDao miniCloudDao;
    private UserDao userDao;
    private UserMiniCloudMappingDao userMiniCloudMappingDao;
    private ConsolidatedImageDao consolidatedImageDao;
    private static final String EXCEPTION = " Exception  :";
    private UserGroupDao userGroupDao;
    private PersonDao personDao;

    public void setPersonDao(PersonDao personDao) {
        this.personDao = personDao;
    }

    public void setUserGroupDao(UserGroupDao userGroupDao) {
        this.userGroupDao = userGroupDao;
    }

    public void setConsolidatedImageDao(ConsolidatedImageDao consolidatedImageDao) {
        this.consolidatedImageDao = consolidatedImageDao;
    }

    public void setUserMiniCloudMappingDao(UserMiniCloudMappingDao userMiniCloudMappingDao) {
        this.userMiniCloudMappingDao = userMiniCloudMappingDao;
    }

    public void setUserDao(UserDao userDao) {
        this.userDao = userDao;
    }

    public void setMiniCloudDao(MiniCloudDao miniCloudDao) {
        this.miniCloudDao = miniCloudDao;
    }

    @Override
    public boolean createMiniCloud(int cloudId, String userName, String cloudName, MiniCloudElement miniCloudElement) {
        ConsolidatedImage consolidatedImage = this.consolidatedImageDao.getMiniCloudRecordIfExistsWithoutRegex(cloudId, miniCloudElement.getMiniCloudName());
        if (consolidatedImage != null && consolidatedImage.isPresent()) {
            return false;
        }
        MiniCloud miniCloud = new MiniCloud();
        BeanUtils.copyProperties((Object)miniCloudElement, (Object)miniCloud);
        miniCloud.setOwner(userName);
        this.miniCloudDao.saveMiniCloud(cloudId, cloudName, miniCloud);
        return true;
    }

    @Override
    public UserCloudAccessControl validateAccess(int cloudId, String cloudName, String userName, String miniCloudName) {
        User user = this.userDao.getUserInfoByName(cloudId, cloudName, userName);
        MiniCloud miniCloud = this.miniCloudDao.getMiniCloudByName(cloudId, cloudName, miniCloudName);
        return this.userMiniCloudMappingDao.getMiniCloudByName(cloudId, cloudName, user.getUserId(), miniCloud.getId());
    }

    @Override
    public boolean createAccessControlMapping(int cloudId, String cloudName, String userName, List<MiniCloudElement> miniCloudList) {
        if (miniCloudList == null) {
            logger.debug("mini list is nNULL.");
            return false;
        }
        User user = this.userDao.getUserInfoByName(cloudId, cloudName, userName);
        logger.debug("$$$$$$$$$$$$$$$$$$$$$$$: " + user.getUserName());
        for (MiniCloudElement miniCloudElement : miniCloudList) {
            UserCloudAccessControl u = new UserCloudAccessControl();
            MiniCloud miniCloud = this.miniCloudDao.getMiniCloudByName(cloudId, cloudName, miniCloudElement.getMiniCloudName());
            if (miniCloud == null) {
                logger.debug("MINI CLOUD IS NULL");
                continue;
            }
            logger.debug("mini cloud here is : " + miniCloud.getMiniCloudName());
            u.setMiniCloudFK(miniCloud.getId());
            u.setUserFK(user.getUserId());
            this.userMiniCloudMappingDao.saveMiniCloud(cloudId, cloudName, u);
        }
        return true;
    }

    @Override
    public void createAccessControlMapping(int cloudId, List<String> userNames, String miniCloudName) {
        MiniCloud miniCloud = this.miniCloudDao.getMiniCloudByName(cloudId, "", miniCloudName);
        if (miniCloud == null) {
            logger.debug("MINI CLOUD IS NULL");
        } else {
            this.miniCloudDao.deleteUserCloudAccessControlMappingForUser(cloudId, miniCloud);
            this.miniCloudDao.deleteGroupMappingForMC(cloudId, miniCloud);
            for (String userName : userNames) {
                User user = this.userDao.getUserInfoByName(cloudId, "", userName);
                Group group = null;
                if (user == null) {
                    group = this.userGroupDao.getGroupByName(cloudId, userName);
                }
                if (user == null && group == null) {
                    logger.debug("User IS NULL");
                    continue;
                }
                if (user != null && user.getUserName().equalsIgnoreCase(miniCloud.getOwner())) continue;
                if (user != null) {
                    UserCloudAccessControl u = new UserCloudAccessControl();
                    u.setMiniCloudFK(miniCloud.getId());
                    u.setUserFK(user.getUserId());
                    this.userMiniCloudMappingDao.saveMiniCloud(cloudId, "", u);
                }
                if (group == null) continue;
                MiniCloudGroupMapping miniCloudGroupMapping = new MiniCloudGroupMapping();
                miniCloudGroupMapping.setGroup(group);
                miniCloudGroupMapping.setMiniCloud(miniCloud);
                this.userGroupDao.saveMCGroupMapping(cloudId, miniCloudGroupMapping);
                List ldapUserList = this.personDao.findUsersInGroup(group.getGroupName());
                ldapUserList.removeAll(Collections.singleton(null));
                for (Person person : ldapUserList) {
                    logger.debug(" inside group ......... " + person.getFullName());
                    user = this.userDao.getUserInfoByName(cloudId, "", person.getFullName());
                    if (user == null || user.getUserName().equalsIgnoreCase(miniCloud.getOwner())) continue;
                    UserCloudAccessControl u = new UserCloudAccessControl();
                    u.setMiniCloudFK(miniCloud.getId());
                    u.setUserFK(user.getUserId());
                    this.userMiniCloudMappingDao.saveMiniCloud(cloudId, "", u);
                }
            }
        }
    }

    @Override
    public MiniCloudElementList getAllMiniClouds(int cloudId, String cloudName) {
        List clouds = this.miniCloudDao.getAllMiniCloud(cloudId, cloudName);
        ArrayList<MiniCloudElement> cloudElements = new ArrayList<MiniCloudElement>();
        MiniCloudElementList cloudElementList = new MiniCloudElementList();
        for (MiniCloud cloud : clouds) {
            ArrayList<ObjectId> userIds = new ArrayList<ObjectId>();
            StringBuilder assignedUsers = new StringBuilder("");
            MiniCloudElement cloudElement = new MiniCloudElement();
            BeanUtils.copyProperties((Object)cloud, (Object)cloudElement);
            cloudElement.setId(cloud.getId().toString());
            List accessControlMappingsByMiniCloud = this.userMiniCloudMappingDao.getAccessControlMappingsByMiniCloud(cloudId, cloudName, cloud.getId());
            for (UserCloudAccessControl accessControl : accessControlMappingsByMiniCloud) {
                userIds.add(accessControl.getUserFK());
            }
            List list = this.userMiniCloudMappingDao.getGroupMappingsByMiniCloud(cloudId, cloud.getId());
            ArrayList<String> attachedUsersList = new ArrayList<String>();
            if (!CollectionUtils.isEmpty(userIds)) {
                List attachedUsers = this.userDao.getAllUsers(cloudId, userIds);
                for (User user : attachedUsers) {
                    if (user.getUserName().equalsIgnoreCase(cloud.getOwner())) continue;
                    logger.debug(cloud.getMiniCloudName() + " minicloud user iteration ....... " + user.getUserName());
                    attachedUsersList.add(user.getUserName());
                }
            }
            if (!CollectionUtils.isEmpty((Collection)list)) {
                for (MiniCloudGroupMapping miniCloudGroupMapping : list) {
                    if (miniCloudGroupMapping == null) continue;
                    String groupName = miniCloudGroupMapping.getGroup().getGroupName();
                    if (StringUtils.isEmpty((String)assignedUsers.toString())) {
                        assignedUsers.append(groupName);
                    } else {
                        assignedUsers.append("," + groupName);
                    }
                    List personList = this.personDao.findUsersInGroup(groupName);
                    for (Person person : personList) {
                        logger.debug(person.getFullName() + "  Remove user becoz he/she is part of group .." + groupName);
                        attachedUsersList.remove(person.getFullName());
                    }
                }
            }
            for (String userName : attachedUsersList) {
                if (StringUtils.isEmpty((String)assignedUsers.toString())) {
                    assignedUsers.append(userName);
                    continue;
                }
                assignedUsers.append("," + userName);
            }
            cloudElement.setAssignedUsers(assignedUsers.toString());
            cloudElements.add(cloudElement);
        }
        cloudElementList.setMiniClouds(cloudElements);
        return cloudElementList;
    }

    @Override
    public MiniCloudElementList getAllActiveMiniCloudsForSync(int cloudId) {
        List clouds = this.miniCloudDao.getAllActiveMiniCloudsForSync(cloudId);
        ArrayList<MiniCloudElement> cloudElements = new ArrayList<MiniCloudElement>();
        MiniCloudElementList cloudElementList = new MiniCloudElementList();
        for (MiniCloud cloud : clouds) {
            MiniCloudElement cloudElement = new MiniCloudElement();
            BeanUtils.copyProperties((Object)cloud, (Object)cloudElement);
            cloudElement.setId(cloud.getId().toString());
            cloudElements.add(cloudElement);
        }
        cloudElementList.setMiniClouds(cloudElements);
        return cloudElementList;
    }

    @Override
    public MiniCloudElementList getAllMiniCloudsForUser(int cloudId, String cloudName, ObjectId userId) {
        List cloudAccessControls = this.userMiniCloudMappingDao.getAccessControlMappingsByUser(cloudId, cloudName, userId);
        ArrayList<MiniCloudElement> cloudElements = new ArrayList<MiniCloudElement>();
        MiniCloudElementList cloudElementList = new MiniCloudElementList();
        for (UserCloudAccessControl cloudAccessControl : cloudAccessControls) {
            MiniCloud miniCloud = this.miniCloudDao.getMiniCloudByID(cloudId, cloudName, cloudAccessControl.getMiniCloudFK());
            if (miniCloud == null) continue;
            MiniCloudElement cloudElement = new MiniCloudElement();
            BeanUtils.copyProperties((Object)miniCloud, (Object)cloudElement);
            cloudElement.setId(miniCloud.getId().toString());
            cloudElements.add(cloudElement);
        }
        cloudElementList.setMiniClouds(cloudElements);
        return cloudElementList;
    }

    @Override
    public UserCloudAccessControl validateAccessForUser(int cloudId, String cloudName, User user, String miniCloudName) {
        MiniCloud miniCloud = this.miniCloudDao.getMiniCloudByName(cloudId, cloudName, miniCloudName);
        return this.userMiniCloudMappingDao.getMiniCloudByName(cloudId, cloudName, user.getUserId(), miniCloud.getId());
    }

    @Override
    public boolean validateMiniCloudOperationAccessForUser(int cloudId, String cloudName, User user, String miniCloudName) {
        MiniCloud miniCloud = this.miniCloudDao.getMiniCloudByName(cloudId, cloudName, miniCloudName);
        if (miniCloud == null) {
            return true;
        }
        UserCloudAccessControl u = this.userMiniCloudMappingDao.getMiniCloudByName(cloudId, cloudName, user.getUserId(), miniCloud.getId());
        return u != null;
    }

    @Override
    public boolean validateMiniCloudOperationAccessForUser(int cloudId, String cloudName, String userName, String miniCloudName) {
        User user = this.userDao.getUserInfoByName(cloudId, cloudName, userName);
        if (user == null) {
            throw new BaseException("User not found");
        }
        return this.validateMiniCloudOperationAccessForUser(cloudId, cloudName, user, miniCloudName);
    }

    @Override
    public MiniCloudElementList getAllMiniCloudsForUser(int cloudId, String cloudName, String userName) {
        User user = this.userDao.getUserInfoByName(cloudId, cloudName, userName);
        if (user == null) {
            throw new BaseException("User not found");
        }
        List cloudAccessControls = this.userMiniCloudMappingDao.getAccessControlMappingsByUser(cloudId, cloudName, user.getUserId());
        ArrayList<MiniCloudElement> cloudElements = new ArrayList<MiniCloudElement>();
        MiniCloudElementList cloudElementList = new MiniCloudElementList();
        for (UserCloudAccessControl cloudAccessControl : cloudAccessControls) {
            MiniCloud miniCloud = this.miniCloudDao.getMiniCloudByID(cloudId, cloudName, cloudAccessControl.getMiniCloudFK());
            if (miniCloud == null) continue;
            MiniCloudElement cloudElement = new MiniCloudElement();
            BeanUtils.copyProperties((Object)miniCloud, (Object)cloudElement);
            cloudElement.setId(miniCloud.getId().toString());
            cloudElements.add(cloudElement);
        }
        cloudElementList.setMiniClouds(cloudElements);
        return cloudElementList;
    }

    @Override
    public List<User> getAllUserForMiniCloud(int cloudId, String cloudName, String miniCloudName) {
        MiniCloud miniCloud = this.miniCloudDao.getMiniCloudByName(cloudId, cloudName, miniCloudName);
        ArrayList<User> users = new ArrayList<User>();
        if (miniCloudName == null) {
            return null;
        }
        List accessControls = this.userMiniCloudMappingDao.getAccessControlMappingsByMiniCloud(cloudId, cloudName, miniCloud.getId());
        for (UserCloudAccessControl uca : accessControls) {
            User user = this.userDao.getUserInfo(cloudId, uca.getUserFK() + "");
            if (user == null || !user.isActive()) continue;
            users.add(user);
        }
        return users;
    }

    @Override
    public boolean isMiniCloud(int cloudId, String cloudName, String miniCloudName) {
        MiniCloud miniCloud = this.miniCloudDao.getMiniCloudByName(cloudId, cloudName, miniCloudName);
        return miniCloud != null;
    }

    @Override
    public void updateOwnershipForMC(int cloudId, String userName, String miniCloudName) {
        this.miniCloudDao.updateOwnershipForMC(cloudId, userName, miniCloudName);
    }

    @Override
    public MiniCloud getMiniCloudByName(int cloudId, String miniCloudName) {
        return this.miniCloudDao.getMiniCloudByName(cloudId, "", miniCloudName);
    }

    @Override
    public List<MiniCloudGroupMapping> getGroupMappingsByMiniCloud(int cloudId, ObjectId miniCloudId) {
        return this.userMiniCloudMappingDao.getGroupMappingsByMiniCloud(cloudId, miniCloudId);
    }

    @Override
    public void deleteUserAccessForMinicloud(int cloudId, ObjectId miniCloudId) {
        this.userMiniCloudMappingDao.deleteUserAccessForMinicloud(cloudId, miniCloudId);
    }

    @Override
    public boolean createExcelForMiniClouds(MiniCloudElementList cloudElementList) {
        if (!CollectionUtils.isEmpty((Collection)cloudElementList.getMiniClouds())) {
            return this.createMiniCloudsExcelForXlsx(cloudElementList);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean createMiniCloudsExcelForXlsx(MiniCloudElementList cloudElementList) {
        try (XSSFWorkbook workbook = new XSSFWorkbook();){
            List<List> recordToAdd = this.updateMiniCloudElementValuesToExcel(cloudElementList);
            this.createExcelForMiniCloudsXlsx(recordToAdd, workbook);
            this.writeExcelForMiniCloudsXlsx(workbook);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            return false;
        }
    }

    private void writeExcelForMiniCloudsXlsx(XSSFWorkbook workbook) {
        try (FileOutputStream fos = new FileOutputStream(new File(PCHelperConstant.getPropertyFileValueParacloudMountPoint() + "/reports/MiniClouds.xlsx"));){
            XSSFCellStyle hsfstyle = workbook.createCellStyle();
            hsfstyle.setBorderBottom((short)1);
            hsfstyle.setFillBackgroundColor((short)245);
            workbook.write((OutputStream)fos);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
    }

    private List<List> updateMiniCloudElementValuesToExcel(MiniCloudElementList cloudElementList) {
        ArrayList<List> recordToAdd = new ArrayList<List>();
        List<String> headerRow = this.createHeaderRowForMiniCloudXlsx();
        recordToAdd.add(headerRow);
        for (MiniCloudElement miniCloudElemenent : cloudElementList.getMiniClouds()) {
            List<String> firstRow = this.loadDataOnRowForMiniCloudXlsx(miniCloudElemenent);
            recordToAdd.add(firstRow);
        }
        return recordToAdd;
    }

    private List<String> loadDataOnRowForMiniCloudXlsx(MiniCloudElement miniCloudElemenent) {
        ArrayList<String> firstRow = new ArrayList<String>();
        firstRow.add(miniCloudElemenent.getMiniCloudName());
        firstRow.add(miniCloudElemenent.getOwner());
        if (StringUtils.isNotEmpty((String)miniCloudElemenent.getAssignedUsers())) {
            firstRow.add(miniCloudElemenent.getAssignedUsers());
        } else {
            firstRow.add("");
        }
        return firstRow;
    }

    private List<String> createHeaderRowForMiniCloudXlsx() {
        ArrayList<String> headerRow = new ArrayList<String>();
        headerRow.add("Mini Cloud Name");
        headerRow.add("Owner");
        headerRow.add("Assigned Users");
        return headerRow;
    }

    void createExcelForMiniCloudsXlsx(List<List> l1, XSSFWorkbook workbook) throws Exception {
        XSSFSheet firstSheet = workbook.createSheet("Mini Clouds");
        int rownum = 0;
        try {
            for (int j = 0; j < l1.size(); ++j) {
                XSSFRow row = firstSheet.createRow(rownum);
                List l2 = l1.get(j);
                for (int k = 0; k < l2.size(); ++k) {
                    Cell cell = row.createCell(k);
                    cell.setCellValue((String)l2.get(k));
                    if (rownum != 0) continue;
                    XSSFCellStyle cellStyle = workbook.createCellStyle();
                    cellStyle.setFillForegroundColor((short)51);
                    cellStyle.setFillPattern((short)1);
                    XSSFFont font = workbook.createFont();
                    font.setFontName("Arial");
                    font.setFontHeightInPoints((short)10);
                    font.setBoldweight((short)10);
                    cellStyle.setFont((Font)font);
                    cell.setCellStyle((CellStyle)cellStyle);
                }
                ++rownum;
            }
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
    }
}

