/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.udc.service.impl;

import com.parablu.bluvault.udc.service.CloudSettingsService;
import com.parablu.helper.constant.GeneralHelperConstant;
import com.parablu.helper.utils.ObjectDiffFinder;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.CloudAndHostMachineDataElement;
import com.parablu.paracloud.element.CloudCredentialElement;
import com.parablu.paracloud.element.CloudPropertyElement;
import com.parablu.paracloud.element.CloudRegistrationElement;
import com.parablu.paracloud.element.SmtpElement;
import com.parablu.paracloud.util.JaxBSerializerHelper;
import com.parablu.paracloud.util.ParacloudUtils;
import com.parablu.pcbd.dao.CloudDao;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCredentials;
import com.parablu.pcbd.domain.CloudProperties;
import com.parablu.pcbd.domain.SmtpCredentials;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HttpsURLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.StringUtils;

public class CloudSettingsServiceImpl
implements CloudSettingsService {
    private static Logger logger = LoggerFactory.getLogger(CloudSettingsServiceImpl.class);
    private CloudDao cloudDao;
    private static final String IO_EXCEPTION = " IOException  :";
    private static final String EXCEPTION = "Exception  ";

    public void setCloudDao(CloudDao cloudDao) {
        this.cloudDao = cloudDao;
    }

    @Override
    public Cloud registerCloud(CloudAndHostMachineDataElement cloudAndHostMachineDataElement) {
        String localIp = ParacloudUtils.getLocalIP();
        String publicIp = ParacloudUtils.getPublicIP();
        Cloud cloud = null;
        if (localIp == null || localIp.isEmpty()) {
            localIp = publicIp;
        }
        try {
            cloudAndHostMachineDataElement.setCloudLocalIP(localIp);
            cloudAndHostMachineDataElement.setCloudPublicIP(publicIp);
            String xmlResponse = this.sendRegisterRequestToAmazon(cloudAndHostMachineDataElement);
            if (xmlResponse == null) {
                logger.debug("Response null");
                return null;
            }
            cloud = this.createCloudElementFromResponseData(xmlResponse);
            if (cloud != null && cloud.getCloudName() == null) {
                logger.debug("cloud name is null");
                return null;
            }
        }
        catch (Exception e) {
            logger.debug(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
        return cloud;
    }

    @Override
    public Cloud registerCloudWithAmazon(CloudAndHostMachineDataElement cloudAndHostMachineDataElement) throws IOException {
        String publicIP = ParacloudUtils.getPublicIP();
        Cloud cloud = null;
        cloudAndHostMachineDataElement.setCloudPublicIP(publicIP);
        cloudAndHostMachineDataElement.setCloudLocalIP(publicIP);
        String xmlResponse = this.sendRegisterRequestToAmazon(cloudAndHostMachineDataElement);
        if (xmlResponse == null) {
            return null;
        }
        try {
            cloud = this.createCloudElementFromResponseData(xmlResponse);
            if (cloud != null && cloud.getCloudName() == null) {
                return null;
            }
        }
        catch (Exception e) {
            logger.debug(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
        return cloud;
    }

    private Cloud createCloudElementFromResponseData(String xmlResponse) {
        Cloud cloud = new Cloud();
        CloudRegistrationElement cloudRegElement = JaxBSerializerHelper.unmarshallCloudRegistrationElement((String)xmlResponse);
        cloud.setCloudRegistrationUUId(cloudRegElement.getCloudUUID());
        cloud.setCloudSizeAllowed(cloudRegElement.getCloudSizeAllowed());
        cloud.setNoOfDevicesAllowed(0);
        cloud.setNoOfUsersAllowed(cloudRegElement.getTotalNoOfUsers());
        cloud.setStatusCode(cloudRegElement.getStatus());
        cloud.setValidityPeriod(cloudRegElement.getValidityPeriod());
        cloud.setCloudName(cloudRegElement.getCloudName());
        return cloud;
    }

    private String sendRegisterRequestToAmazon(CloudAndHostMachineDataElement cloudAndHostMachineDataElement) throws IOException {
        HttpsURLConnection conn;
        String requestXML = JaxBSerializerHelper.marshallCloudAndHostMachineDataElement((CloudAndHostMachineDataElement)cloudAndHostMachineDataElement);
        int status = -1;
        if (requestXML == null) {
            return null;
        }
        StringBuilder urlWithParams = new StringBuilder("https://crm.parablu.com/api").append("/cloud/register");
        try {
            URL url = new URL(urlWithParams.toString());
            conn = (HttpsURLConnection)url.openConnection();
        }
        catch (MalformedURLException ex) {
            logger.trace(" MalformedURLException  :" + ex);
            logger.error(" MalformedURLException  :" + ex.getMessage());
            return null;
        }
        catch (IOException ex) {
            logger.trace(IO_EXCEPTION + ex);
            logger.error(IO_EXCEPTION + ex.getMessage());
            return null;
        }
        conn.setDoOutput(true);
        conn.setDoInput(true);
        try {
            conn.setRequestMethod("POST");
        }
        catch (ProtocolException e) {
            logger.trace(" ProtocolException  :" + e);
            logger.error(" ProtocolException  :" + e.getMessage());
            return null;
        }
        conn.setRequestProperty("Content-type", "application/xml");
        try (OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());){
            wr.write(requestXML);
            wr.flush();
        }
        catch (IOException ex) {
            logger.trace(IO_EXCEPTION + ex);
            logger.error(IO_EXCEPTION + ex.getMessage());
            return null;
        }
        try {
            status = conn.getResponseCode();
        }
        catch (IOException ex) {
            logger.trace(IO_EXCEPTION + ex);
            logger.error(IO_EXCEPTION + ex.getMessage());
            return null;
        }
        if (status != 200) {
            return null;
        }
        StringBuilder responseXml = new StringBuilder();
        String iline = null;
        try (BufferedReader bufR = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));){
            while ((iline = bufR.readLine()) != null) {
                responseXml.append(iline);
            }
        }
        catch (IOException e) {
            logger.trace(IO_EXCEPTION + e);
            logger.error(IO_EXCEPTION + e.getMessage());
            return null;
        }
        return responseXml.toString();
    }

    @Override
    public void saveCloudToDatabase(Cloud cloud) {
        new File(PCHelperConstant.getPropertyFileValueParacloudMountPoint() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + cloud.getCloudName()).mkdirs();
        new File(PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloud.getCloudName())).mkdirs();
        new File(PCHelperConstant.getPropertyFileValueParabluBackupFolderBasePath((String)cloud.getCloudName())).mkdirs();
        new File(PCHelperConstant.getPropertyFileValueParabluFolderBasePath((String)cloud.getCloudName())).mkdirs();
        this.cloudDao.saveCloud(cloud);
    }

    @Override
    public void createNewCloud(Cloud cloud) {
        this.cloudDao.createNewCloud(cloud);
    }

    @Override
    public void saveCloudCredentials(int cloudId, CloudCredentials cloudCredentials) {
        this.cloudDao.saveCloudCredentials(cloudId, cloudCredentials);
    }

    @Override
    public List<CloudCredentialElement> getAllCloudCredentials(int cloudId) {
        List list = this.cloudDao.getAllCloudCredentials(cloudId);
        ArrayList<CloudCredentialElement> ccElementList = new ArrayList<CloudCredentialElement>();
        for (CloudCredentials cc : list) {
            CloudCredentialElement element = new CloudCredentialElement();
            BeanUtils.copyProperties((Object)cc, (Object)element);
            ccElementList.add(element);
        }
        return ccElementList;
    }

    @Override
    public boolean deleteCloudCredentials(int cloudId, String identity) {
        return this.cloudDao.deleteCloudCredentials(cloudId, identity);
    }

    @Override
    public void saveSmtpCredentials(int cloudId, SmtpElement smtpElement) {
        SmtpCredentials credentials = this.cloudDao.getSmtpCredentials(cloudId);
        if (credentials == null) {
            credentials = new SmtpCredentials();
        }
        BeanUtils.copyProperties((Object)smtpElement, (Object)credentials);
        credentials.setSmtpAuth(String.valueOf(smtpElement.getSmtpAuth()));
        this.cloudDao.saveSmtpCredentials(cloudId, credentials);
    }

    @Override
    public String saveCloudProperties(int cloudId, CloudPropertyElement cloudPropertyElement) {
        CloudPropertyElement existingCloudPropertyElement = new CloudPropertyElement();
        CloudProperties cloudProperties = this.cloudDao.getCloudProperties(cloudId);
        if (cloudProperties == null) {
            cloudProperties = new CloudProperties();
        }
        BeanUtils.copyProperties((Object)cloudProperties, (Object)existingCloudPropertyElement);
        logger.debug("cloud property azure vm>" + cloudProperties.getAzureVM());
        logger.debug("cloud property azure vm>" + cloudPropertyElement.getAzureVM());
        logger.debug("new cloud property ssl>" + cloudProperties.getSslAuthEnabled());
        logger.debug("bulk email delay>>" + cloudProperties.getBulkEmailDelay());
        BeanUtils.copyProperties((Object)cloudPropertyElement, (Object)cloudProperties);
        String response = this.findCloudPropertyDiff(existingCloudPropertyElement, cloudPropertyElement);
        this.cloudDao.saveCloudProperties(cloudId, cloudProperties);
        this.initiateCloudProperties(cloudId);
        return response;
    }

    private String findCloudPropertyDiff(CloudPropertyElement existingCloudPropertyElement, CloudPropertyElement cloudPropertyElement) {
        StringBuilder changedFields = new StringBuilder();
        ObjectDiffFinder objectDiffFinder = new ObjectDiffFinder();
        objectDiffFinder.finder((Object)existingCloudPropertyElement, (Object)cloudPropertyElement);
        objectDiffFinder.visiter(objectDiffFinder);
        ArrayList changes = new ArrayList(objectDiffFinder.changes);
        HashMap<String, String> fieldChanges = new HashMap<String, String>();
        for (Map change : changes) {
            Set keys = change.keySet();
            String propertyName = "";
            String newValue = "";
            String oldValue = "";
            for (String key : keys) {
                if (!StringUtils.isEmpty(change.get(key)) && key.contains("newValue")) {
                    newValue = change.get(key).toString();
                }
                if (key.contains("propertyName")) {
                    propertyName = change.get(key).toString();
                }
                if (StringUtils.isEmpty(change.get(key)) || !key.contains("oldValue")) continue;
                oldValue = change.get(key).toString();
            }
            if (!StringUtils.isEmpty((Object)propertyName)) {
                fieldChanges.put(propertyName, "\"" + oldValue + "\" => \"" + newValue + "\"");
                logger.debug("Actual Data" + propertyName + "\"" + oldValue + "\" => \"" + newValue + "\"");
                continue;
            }
            logger.debug("field changes is empty ");
        }
        for (String field : fieldChanges.keySet()) {
            String key = field;
            key = key.contains("solrUrl") ? "Solr URL" : (key.contains("supportMail") ? "Support Mail" : (key.contains("emailToAdminOnly") ? "Emails To Admin Only" : (key.contains("canAdminRestoreAll") ? "Can Admin Restore All" : (key.contains("defaultBkpPolicyName") ? "Default Backup Policy Name" : (key.contains("defaultSyncPolicyName") ? "Default Sync Policy Name" : (key.contains("defaultGuestSyncPolicyName") ? "Default Guest Sync Policy Name" : (key.contains("defaultO365PolicyName") ? "Default O365 Policy Name" : (key.contains("azureVM") ? "Azure VM" : (key.contains("localAD") ? "Local AD" : (key.contains("sslAuthEnabled") ? "SSl Auth Enabled" : (key.contains("reportRows") ? "Report Rows" : (key.contains("isCrawlEnabled") ? "Is Crawl Enabled" : (key.contains("isShareFileNameEnabled") ? "Is Share File Name Enabled" : (key.contains("maxCrawlHit") ? "Maximum Crawl Hit" : (key.contains("mongoReadPreference") ? "Mongo Read Preference" : (key.contains("emailBkpGroupName") ? "Email Backup Group Name" : (key.contains("emailSyncGroupName") ? "Email Sync Group Name" : (key.contains("bkpGroupEmail") ? "Backup Group Email" : (key.contains("syncGroupEmail") ? "Sync Group Email" : (key.contains("chunkUpdateMaxRetry") ? "Maximum Retry for Chunk Update" : (key.contains("clientMailName") ? "Client Mail Name" : (key.contains("clientSupportMailName") ? "Client Support Mail Name" : (key.contains("adfsUrl") ? "ADFS URL" : (key.contains("isDomainCheckEnabled") ? "Is Domain Check Enabled" : (key.contains("bulkEmailDelay") ? "Bulk Email Delay (In Seconds)" : (key.contains("isEmailNotifierForRestoreEnabled") ? "Notify Through Email For Restores" : (key.contains("isEmailNotifierEnabledForFirstBackupCompletion") ? "Notify Through Email For First Backup Completion" : (key.contains("daysToWaitForNextBackup") ? "Fairness Algorithm" : (key.contains("canAdminChangeUserPassword") ? "Allow Admin To Change User Password" : (key.contains("canUserChangePassword") ? "Allow User To Change Password" : (key.contains("passwordChangeEnforce") ? "Enforce Password Rules" : (key.contains("isAdminDeleteBackupFile") ? "Allow Admin To Delete Backup File" : ""))))))))))))))))))))))))))))))));
            if (!StringUtils.isEmpty((Object)key)) {
                fieldChanges.get(field);
                changedFields.append(" (");
                changedFields.append(key);
                changedFields.append(" values ");
                changedFields.append((String)fieldChanges.get(field));
                changedFields.append(")");
                if (key.length() > 1) {
                    changedFields.append(", ");
                }
                logger.debug("changed fields *************** " + changedFields.toString());
                continue;
            }
            logger.debug("Key is empty *******************");
        }
        if (changedFields.length() > 0) {
            changedFields.replace(changedFields.length() - 1, changedFields.length(), " ");
        }
        logger.debug("the changed fields are " + changedFields.toString());
        return changedFields.toString();
    }

    @Override
    public CloudPropertyElement getCloudPropertyElement(int cloudId) {
        CloudProperties cloudProperties = this.cloudDao.getCloudProperties(cloudId);
        CloudPropertyElement cloudPropertyElement = null;
        if (cloudProperties != null) {
            cloudPropertyElement = new CloudPropertyElement();
            BeanUtils.copyProperties((Object)cloudProperties, (Object)cloudPropertyElement);
        }
        return cloudPropertyElement;
    }

    @Override
    public SmtpElement getSmtpElement(int cloudId) {
        SmtpCredentials smtpCred = this.cloudDao.getSmtpCredentials(cloudId);
        SmtpElement smtpElement = null;
        if (smtpCred != null) {
            smtpElement = new SmtpElement();
            BeanUtils.copyProperties((Object)smtpCred, (Object)smtpElement);
            smtpElement.setSmtpAuth(Boolean.parseBoolean(smtpCred.getSmtpAuth()));
        }
        return smtpElement;
    }

    private void initiateCloudProperties(int cloudId) {
        logger.debug("Starting up ... !");
        CloudProperties cloudProperties = this.cloudDao.getCloudProperties(cloudId);
        if (cloudProperties == null) {
            return;
        }
        CloudPropertyElement cloudPropertyElement = new CloudPropertyElement();
        BeanUtils.copyProperties((Object)cloudProperties, (Object)cloudPropertyElement);
        logger.debug("cloud property element is not null inside initate cloud properties>>>");
        PCHelperConstant.setPropertyFileValueAdfsUrl((String)cloudPropertyElement.getAdfsUrl());
        PCHelperConstant.setPropertyFileValueAllowAdminToRestoreAll((String)String.valueOf(cloudPropertyElement.getCanAdminRestoreAll()));
        PCHelperConstant.setPropertyFileValueBkpEmailGroupName((String)cloudPropertyElement.getEmailBkpGroupName());
        PCHelperConstant.setPropertyFileValueBkpSupportEmail((String)cloudPropertyElement.getBkpGroupEmail());
        PCHelperConstant.setPropertyFileValueBkpSyncEmailGroupName((String)cloudPropertyElement.getEmailSyncGroupName());
        PCHelperConstant.setPropertyFileValueBkpSyncSupportEmail((String)cloudPropertyElement.getSyncGroupEmail());
        PCHelperConstant.setPropertyFileValueClientDownloadPath((String)cloudPropertyElement.getBlusyncDownloadPath());
        PCHelperConstant.setPropertyFileValueClientMailName((String)cloudPropertyElement.getClientMailName());
        PCHelperConstant.setPropertyFileValueClientSupportMailName((String)cloudPropertyElement.getClientSupportMailName());
        PCHelperConstant.setPropertyFileValueDefaultBkpPolicy((String)cloudPropertyElement.getDefaultBkpPolicyName());
        PCHelperConstant.setPropertyFileValueDefaultSyncPolicy((String)cloudPropertyElement.getDefaultSyncPolicyName());
        PCHelperConstant.setPropertyFileValueEmailDomainCheck((String)String.valueOf(cloudPropertyElement.getIsDomainCheckEnabled()));
        PCHelperConstant.setPropertyFileValueEmailsToadminsOnly((String)String.valueOf(cloudPropertyElement.getEmailToAdminOnly()));
        PCHelperConstant.setPropertyFileValueIsCrawlEnabled((String)String.valueOf(cloudPropertyElement.getIsCrawlEnabled()));
        PCHelperConstant.setPropertyFileValueIsShareFileNameEnabled((String)String.valueOf(cloudPropertyElement.getIsShareFileNameEnabled()));
        PCHelperConstant.setPropertyFileValueMaxCrawlHit((String)String.valueOf(cloudPropertyElement.getMaxCrawlHit()));
        PCHelperConstant.setPropertyFileValueMaxRetryChunkUpdate((String)String.valueOf(cloudPropertyElement.getChunkUpdateMaxRetry()));
        PCHelperConstant.setPropertyFileValueMigrationOu((String)cloudPropertyElement.getAdGroupName());
        PCHelperConstant.setPropertyFileValueParacloudCloudnameFile((String)cloudPropertyElement.getCloudFileName());
        PCHelperConstant.setPropertyFileValueParacloudMountPoint((String)cloudPropertyElement.getMntParacloudPath());
        PCHelperConstant.setPropertyFileValueParacloudType((String)cloudPropertyElement.getCloudType());
        PCHelperConstant.setPropertyFileValuePgWriteDelayLimit((String)String.valueOf(cloudPropertyElement.getEbmsWriteDelayLimit()));
        PCHelperConstant.setPropertyFileValueReadPreference((String)String.valueOf(cloudPropertyElement.getMongoReadPreference()));
        PCHelperConstant.setPropertyFileValueReplicaSafeLimit((String)String.valueOf(cloudPropertyElement.getWriteConcernLimit()));
        PCHelperConstant.setPropertyFileValueReportDisplayRecords((String)String.valueOf(cloudPropertyElement.getReportRows()));
        PCHelperConstant.setPropertyFileValueScriptsBinDir((String)cloudPropertyElement.getScriptsBinDir());
        PCHelperConstant.setPropertyFileValueSolrBaseUrl((String)cloudPropertyElement.getSolrUrl());
        PCHelperConstant.setSolrServerUrl((String)cloudPropertyElement.getSolrServerUrl());
        PCHelperConstant.setPropertyFileValueSslAuthEnabled((String)String.valueOf(cloudPropertyElement.getSslAuthEnabled()));
        PCHelperConstant.setPropertyFileValueSupportMail((String)cloudPropertyElement.getSupportMail());
        PCHelperConstant.setPropertyFileValueSyncEmailGroupName((String)cloudPropertyElement.getEmailSyncGroupName());
        PCHelperConstant.setPropertyFileValueVideoThumbnailScript((String)cloudPropertyElement.getScriptsVideoThumbnail());
        PCHelperConstant.setBulkEmailDelay((int)cloudPropertyElement.getBulkEmailDelay());
        PCHelperConstant.setDaysToWaitForNextBackup((int)cloudPropertyElement.getDaysToWaitForNextBackup());
        PCHelperConstant.setCanUserChangePassword((boolean)cloudPropertyElement.isCanUserChangePassword());
        PCHelperConstant.setCanAdminChangeUserPassword((boolean)cloudPropertyElement.isCanAdminChangeUserPassword());
        PCHelperConstant.setPasswordChangeEnforce((boolean)cloudPropertyElement.isPasswordChangeEnforce());
        PCHelperConstant.setHideStorageSizeInCloud((boolean)cloudPropertyElement.isHideStorageSizeInCloud());
        logger.debug("end of initiating properties... !");
    }

    @Override
    public boolean createCloudCredentials(int cloudId, CloudCredentials cloudCredentials) {
        return this.cloudDao.createCloudCredentials(cloudId, cloudCredentials);
    }

    @Override
    public boolean editCloudCredentials(int cloudId, CloudCredentials cloudCredentials) {
        return this.cloudDao.editCloudCredentials(cloudId, cloudCredentials);
    }
}

