/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.udc.service.impl;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.aad.adal4j.AuthenticationContext;
import com.microsoft.aad.adal4j.AuthenticationResult;
import com.parablu.bluvault.udc.service.AADManagementService;
import com.parablu.cloud.security.service.impl.UserValidateService;
import com.parablu.helper.exceptions.BaseException;
import com.parablu.paracloud.constant.PCActionTypes;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.AADAuthorizationTokenElement;
import com.parablu.paracloud.element.AADCredentialsElement;
import com.parablu.paracloud.element.AADUserElement;
import com.parablu.paracloud.element.AADUserNamesList;
import com.parablu.paracloud.element.GraphGroupDeltaItemTO;
import com.parablu.paracloud.element.GraphGroupDeltaPageTO;
import com.parablu.paracloud.element.GraphResponseForMemberOf;
import com.parablu.paracloud.element.UserElement;
import com.parablu.pcbd.dao.AADDao;
import com.parablu.pcbd.dao.AuditHistoryDao;
import com.parablu.pcbd.dao.AuthorizationDao;
import com.parablu.pcbd.dao.BackupPolicyDao;
import com.parablu.pcbd.dao.DeviceDao;
import com.parablu.pcbd.dao.MigrationStatusDao;
import com.parablu.pcbd.dao.SettingsDao;
import com.parablu.pcbd.dao.UserDao;
import com.parablu.pcbd.domain.AADAuthorizationToken;
import com.parablu.pcbd.domain.AADCredentials;
import com.parablu.pcbd.domain.AuditHistory;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.MigrationStatus;
import com.parablu.pcbd.domain.Proxy;
import com.parablu.pcbd.domain.User;
import com.parablu.pcsd.dao.SyncPolicyDao;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class AADManagementServiceImpl
extends UserValidateService
implements AADManagementService {
    private static Logger logger = LoggerFactory.getLogger(AADManagementServiceImpl.class);
    public static final String AUTHORITY = "https://login.microsoftonline.com/common/";
    public static final String GRAPH_VERSION = "v1.0/";
    public static final String GRAPH_VERSION_BETA = "beta/";
    public static final String GRAPH_ME = "me";
    public static final String GRAPH_HOME = "https://graph.microsoft.com/";
    public static final String GRAPH_MEMBER_OF = "me/memberOf";
    public static final String GRAPH_USER_MEMBER_OF = "/memberOf";
    public static final String GRAPH_USERS = "/users/";
    public static final String GRAPH_GROUP_DELTA = "groups/delta";
    private static final String TOKEN_URL = "https://login.windows.net/";
    private static final String OAUTH2_TOKEN_URL = "/oauth2/token";
    private static final String UTF_8 = "UTF-8";
    private static final String REFRESH_TOKEN = "refresh_token";
    public static final String CONTENT_TYPE = "Content-Type";
    private static final String EXCEPTION = " Exception  :";
    private static final String BACK_UP_ENABLED = "Backup Enabled";
    private static final String SYNC_ENABLED = "Sync Enabled";
    private static final String AUTHORIZATION_CODE = "authorization_code";
    private static final String LOGIN_URL = "https://login.microsoftonline.com/";
    private AADDao aadDao;
    private UserDao userDao;
    private BackupPolicyDao backupPolicyDao;
    private SyncPolicyDao syncPolicyDao;
    private MigrationStatusDao migrationStatusDao;
    private SettingsDao settingsDao;
    @Resource
    private DeviceDao deviceDao;
    @Resource
    private AuditHistoryDao auditHistoryDao;
    @Resource
    private AuthorizationDao authorizationDao;

    public DeviceDao getDeviceDao() {
        return this.deviceDao;
    }

    public void setDeviceDao(DeviceDao deviceDao) {
        this.deviceDao = deviceDao;
    }

    public AuthorizationDao getAuthorizationDao() {
        return this.authorizationDao;
    }

    public void setAuthorizationDao(AuthorizationDao authorizationDao) {
        this.authorizationDao = authorizationDao;
    }

    public AuditHistoryDao getAuditHistoryDao() {
        return this.auditHistoryDao;
    }

    public void setAuditHistoryDao(AuditHistoryDao auditHistoryDao) {
        this.auditHistoryDao = auditHistoryDao;
    }

    public AADDao getAadDao() {
        return this.aadDao;
    }

    public void setAadDao(AADDao aadDao) {
        this.aadDao = aadDao;
    }

    @Override
    public AADCredentialsElement getAADCredentials(int cloudId) {
        logger.debug("......Inside getAADCredentials....");
        AADCredentialsElement aadCredentialsElement = null;
        AADCredentials aadCredentials = this.aadDao.getAADCredentials(cloudId);
        if (aadCredentials != null) {
            aadCredentialsElement = new AADCredentialsElement();
            BeanUtils.copyProperties((Object)aadCredentials, (Object)aadCredentialsElement);
            AADAuthorizationToken token = this.aadDao.getAADAuthorizationtoken(cloudId);
            if (token == null) {
                aadCredentialsElement.setAuthRequired(true);
            }
        }
        return aadCredentialsElement;
    }

    @Override
    public void saveAADCredentials(int cloudId, AADCredentialsElement aadCredentials) {
        logger.debug("......Inside saveAADCredentials....");
        if (aadCredentials != null) {
            this.aadDao.removeAADCredentials(cloudId);
            AADCredentials credentials = new AADCredentials();
            BeanUtils.copyProperties((Object)aadCredentials, (Object)credentials);
            this.aadDao.saveAADCredentials(cloudId, credentials);
        }
    }

    @Override
    public void saveAADAuthorizationtoken(int cloudId, AADAuthorizationTokenElement aadAuthorizationTokenElement) {
        logger.debug("......Inside saveAADAuthorizationtoken...." + aadAuthorizationTokenElement.toString());
        if (aadAuthorizationTokenElement != null) {
            AADAuthorizationToken authorizationToken = this.aadDao.getAADAuthorizationtoken(cloudId);
            if (authorizationToken == null) {
                authorizationToken = new AADAuthorizationToken();
            }
            BeanUtils.copyProperties((Object)aadAuthorizationTokenElement, (Object)authorizationToken);
            logger.debug("......Inside saveAADAuthorizationtoken...." + authorizationToken.toString());
            this.aadDao.saveAADAuthorizationtoken(cloudId, authorizationToken);
        }
    }

    public UserDao getUserDao() {
        return this.userDao;
    }

    public void setUserDao(UserDao userDao) {
        this.userDao = userDao;
    }

    public BackupPolicyDao getBackupPolicyDao() {
        return this.backupPolicyDao;
    }

    public void setBackupPolicyDao(BackupPolicyDao backupPolicyDao) {
        this.backupPolicyDao = backupPolicyDao;
    }

    public SyncPolicyDao getSyncPolicyDao() {
        return this.syncPolicyDao;
    }

    public void setSyncPolicyDao(SyncPolicyDao syncPolicyDao) {
        this.syncPolicyDao = syncPolicyDao;
    }

    public MigrationStatusDao getMigrationStatusDao() {
        return this.migrationStatusDao;
    }

    public void setMigrationStatusDao(MigrationStatusDao migrationStatusDao) {
        this.migrationStatusDao = migrationStatusDao;
    }

    public Object getAccessTokenFromUserCredentials(String username, String password, String clientID) {
        logger.debug("...clientID...." + clientID);
        AuthenticationResult result = null;
        ExecutorService service = Executors.newSingleThreadExecutor();
        try (Closeable close = service::shutdown;){
            AuthenticationContext context = new AuthenticationContext(AUTHORITY, false, service);
            if (this.getProxy(1) != null) {
                context.setProxy(this.getProxy(1));
            }
            Future future = context.acquireToken(GRAPH_HOME, clientID, username, password, null);
            result = (AuthenticationResult)future.get();
        }
        catch (Exception exp) {
            logger.error("Exception while getting AccessToken From UserCredentials................." + exp);
            logger.trace("Exception while getting AccessToken From UserCredentials................." + exp.getMessage());
        }
        return result;
    }

    @Override
    public Object getAADUser(Cloud cloud, String userName, String password) {
        AADUserElement user = null;
        try {
            String userString;
            ObjectMapper mapper = new ObjectMapper();
            mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
            AADCredentials aadCredentials = this.aadDao.getAADCredentials(cloud.getCloudId());
            if (aadCredentials == null) {
                logger.debug("AAD crediential is empty so return");
                return user;
            }
            AuthenticationResult authenticationResult = (AuthenticationResult)this.getAccessTokenFromUserCredentials(userName, password, aadCredentials.getClientIdForLogin());
            if (authenticationResult != null && !StringUtils.isEmpty((Object)authenticationResult.getAccessToken()) && (user = (AADUserElement)mapper.readValue(userString = this.getUserInfoFromGraph(authenticationResult.getAccessToken()), AADUserElement.class)) != null) {
                String userGroupInfo;
                boolean bkpEnabled = false;
                boolean syncEnabled = false;
                if (!CollectionUtils.isEmpty((Map)aadCredentials.getGroupConfig()) && !StringUtils.isEmpty((Object)(userGroupInfo = this.getUserGroupsFromUserToken(authenticationResult.getAccessToken())))) {
                    GraphResponseForMemberOf forMemberOf = (GraphResponseForMemberOf)mapper.readValue(userGroupInfo, GraphResponseForMemberOf.class);
                    if (!CollectionUtils.isEmpty((Collection)aadCredentials.getGroupConfig().keySet().stream().filter(line -> !StringUtils.isEmpty((Object)line)).collect(Collectors.toSet()))) {
                        List groupInfo = forMemberOf.getGroupInfo();
                        List groupNames = groupInfo.stream().map(group -> group.getDisplayName()).collect(Collectors.toList());
                        for (String groupName : aadCredentials.getGroupConfig().keySet()) {
                            if (StringUtils.isEmpty((Object)groupName)) {
                                if ("BACKUP".equals(aadCredentials.getGroupConfig().get(groupName))) {
                                    bkpEnabled = true;
                                }
                                if ("SYNC".equals(aadCredentials.getGroupConfig().get(groupName))) {
                                    syncEnabled = true;
                                    continue;
                                }
                                bkpEnabled = true;
                                syncEnabled = true;
                                continue;
                            }
                            if (CollectionUtils.isEmpty(groupNames) || !groupNames.contains(groupName)) continue;
                            if ("BACKUP".equals(aadCredentials.getGroupConfig().get(groupName))) {
                                bkpEnabled = true;
                                continue;
                            }
                            if ("SYNC".equals(aadCredentials.getGroupConfig().get(groupName))) {
                                syncEnabled = true;
                                continue;
                            }
                            bkpEnabled = true;
                            syncEnabled = true;
                        }
                    }
                }
                if (!StringUtils.isEmpty(aadCredentials.getGroupConfig().get(""))) {
                    if (((String)aadCredentials.getGroupConfig().get("")).equals("BACKUP")) {
                        bkpEnabled = true;
                    } else if (((String)aadCredentials.getGroupConfig().get("")).equals("SYNC")) {
                        syncEnabled = true;
                    } else {
                        bkpEnabled = true;
                        syncEnabled = true;
                    }
                }
                if (bkpEnabled && syncEnabled) {
                    user.setProductType("BOTH");
                } else if (bkpEnabled) {
                    user.setProductType("BACKUP");
                } else if (syncEnabled) {
                    user.setProductType("SYNC");
                }
            }
        }
        catch (Exception e) {
            logger.error("Exception while getting userInfo from UserName and Password................." + e);
            logger.trace("Exception while getting userInfo from UserName and Password................." + e.getMessage());
        }
        return user;
    }

    public String getUserInfoFromGraph(String accessToken) {
        StringBuilder response;
        block15: {
            response = new StringBuilder();
            try {
                URL url = new URL("https://graph.microsoft.com/beta/me");
                HttpURLConnection conn = this.getProxy(1) != null ? (HttpURLConnection)url.openConnection(this.getProxy(1)) : (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                conn.setRequestProperty("Authorization", "Bearer " + accessToken);
                conn.setRequestProperty("Accept", "application/json");
                int httpResponseCode = conn.getResponseCode();
                logger.debug("Status code ..." + httpResponseCode);
                if (httpResponseCode != 200) break block15;
                try (BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));){
                    String inputLine;
                    while ((inputLine = in.readLine()) != null) {
                        response.append(inputLine);
                    }
                }
            }
            catch (Exception e) {
                logger.error("Exception while getting userInfo ................." + e);
                logger.trace("Exception while getting userInfo ................." + e.getMessage());
            }
        }
        return response.toString();
    }

    public String getUserGroupsFromUserToken(String accessToken) {
        StringBuilder response = new StringBuilder();
        try {
            URL url = new URL("https://graph.microsoft.com/v1.0/me/memberOf");
            HttpURLConnection conn = this.getProxy(1) != null ? (HttpURLConnection)url.openConnection(this.getProxy(1)) : (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Authorization", "Bearer " + accessToken);
            conn.setRequestProperty("Accept", "application/json");
            int httpResponseCode = conn.getResponseCode();
            logger.debug("getUserGroupsFromGraph ........response code ......... " + httpResponseCode);
            try (BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));){
                String inputLine;
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
            }
        }
        catch (Exception e) {
            throw new BaseException("Exception while getting groups " + e.getMessage(), 500);
        }
        logger.debug("getUserGroupsFromGraph ........... body..........." + response.toString());
        return response.toString();
    }

    public String getAllGroupInfo(String accessToken) {
        StringBuilder response = new StringBuilder();
        try {
            URL url = new URL("https://graph.microsoft.com/v1.0/me/memberOf");
            HttpURLConnection conn = this.getProxy(1) != null ? (HttpURLConnection)url.openConnection(this.getProxy(1)) : (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Authorization", "Bearer " + accessToken);
            conn.setRequestProperty("Accept", "application/json");
            int httpResponseCode = conn.getResponseCode();
            logger.debug("getUserGroupsFromGraph ........response code ......... " + httpResponseCode);
            try (BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));){
                String inputLine;
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
            }
        }
        catch (Exception e) {
            throw new BaseException("Exception while getting groups " + e.getMessage(), 500);
        }
        logger.debug("getUserGroupsFromGraph ........... body..........." + response.toString());
        return response.toString();
    }

    @Override
    public List<AADUserElement> getAADUsersFromUserNames(int cloudId, AADUserNamesList aadUserNameList) {
        AADAuthorizationToken aadToken = this.aadDao.getAADAuthorizationtoken(cloudId);
        if (aadToken == null || StringUtils.isEmpty((Object)aadToken.getAccess_token())) {
            logger.debug("aadAuthToken or accessToken is empty so return....");
            return null;
        }
        ArrayList<AADUserElement> aadUsersList = new ArrayList<AADUserElement>();
        for (String userName : aadUserNameList.getAadUserNames()) {
            User user = this.userDao.getUserByUserNameOrAADLoginId(cloudId, userName);
            if (user == null) {
                AADUserElement aadUser = this.getAADUserFromUserName(cloudId, userName);
                if (aadUser != null) {
                    if (StringUtils.isEmpty((Object)aadUser.getProductType())) {
                        logger.debug("user is not part any group " + aadUser.getUserPrincipalName());
                        continue;
                    }
                    aadUser.setUserName(userName);
                    aadUsersList.add(aadUser);
                    continue;
                }
                logger.debug("...........User " + userName + " .........  Not found in AAD Or token expired.........");
                continue;
            }
            logger.debug("$##############################" + userName + " ........present in our db....");
        }
        logger.debug("...........aadUsersList size... " + aadUsersList.size());
        return aadUsersList;
    }

    @Override
    public AADUserElement getAADUserFromUserName(int cloudId, String userName) {
        AADAuthorizationToken aadToken = this.aadDao.getAADAuthorizationtoken(cloudId);
        if (aadToken == null || StringUtils.isEmpty((Object)aadToken.getAccess_token())) {
            logger.debug("aadAuthToken or accessToken is empty so return....");
            return null;
        }
        AADUserElement aadUser = null;
        User user = this.userDao.getUserByUserNameOrAADLoginId(cloudId, userName);
        if (user == null) {
            aadUser = this.getAADUserFromUserName(userName, aadToken);
            if (aadUser != null) {
                logger.debug("...........User " + aadUser.getUserName() + " .........found in AAD");
                String productType = "";
                AADCredentials aadCredentials = this.aadDao.getAADCredentials(cloudId);
                logger.debug(".................." + aadCredentials.toString());
                if (!CollectionUtils.isEmpty((Map)aadCredentials.getGroupConfig())) {
                    boolean bkpEnabled = false;
                    boolean syncEnabled = false;
                    boolean o365Enabled = false;
                    if (!CollectionUtils.isEmpty((Collection)aadCredentials.getGroupConfig().keySet().stream().filter(line -> !StringUtils.isEmpty((Object)line)).collect(Collectors.toSet()))) {
                        List<String> userMemberOf = this.getAADUserGroupInfo(userName, aadToken);
                        if (!CollectionUtils.isEmpty(userMemberOf)) {
                            for (String group : userMemberOf) {
                                logger.debug("User is memeber of ............" + group);
                                if (StringUtils.isEmpty(aadCredentials.getGroupConfig().get(group))) continue;
                                if (((String)aadCredentials.getGroupConfig().get(group)).equals("BACKUP")) {
                                    bkpEnabled = true;
                                    continue;
                                }
                                if (((String)aadCredentials.getGroupConfig().get(group)).equals("SYNC")) {
                                    syncEnabled = true;
                                    continue;
                                }
                                if (((String)aadCredentials.getGroupConfig().get(group)).equals("O365")) {
                                    o365Enabled = true;
                                    continue;
                                }
                                bkpEnabled = true;
                                syncEnabled = true;
                            }
                        }
                    } else {
                        productType = (String)aadCredentials.getGroupConfig().values().iterator().next();
                    }
                    logger.debug("............................" + (String)aadCredentials.getGroupConfig().get("") + "........" + !StringUtils.isEmpty(aadCredentials.getGroupConfig().get("")));
                    if (!StringUtils.isEmpty(aadCredentials.getGroupConfig().get(""))) {
                        if (((String)aadCredentials.getGroupConfig().get("")).equals("BACKUP")) {
                            bkpEnabled = true;
                        } else if (((String)aadCredentials.getGroupConfig().get("")).equals("SYNC")) {
                            syncEnabled = true;
                        } else if (((String)aadCredentials.getGroupConfig().get("")).equals("O365")) {
                            o365Enabled = true;
                        } else {
                            bkpEnabled = true;
                            syncEnabled = true;
                        }
                    }
                    if (bkpEnabled && syncEnabled && o365Enabled) {
                        productType = "BOTH";
                    } else if (bkpEnabled) {
                        productType = "BACKUP";
                    } else if (syncEnabled) {
                        productType = "SYNC";
                    } else if (o365Enabled) {
                        productType = "O365";
                    }
                }
                aadUser.setProductType(productType);
            } else {
                logger.debug("...........User " + userName + " .........  Not found in AAD");
            }
        } else {
            logger.debug("$##############################" + userName + " ........present in our db....");
        }
        if (aadUser != null) {
            logger.debug("AAD User Element ...." + aadUser.toString());
        }
        return aadUser;
    }

    @Override
    public AADUserElement getAADUserFromUserNameToSync(int cloudId, String userName) {
        AADAuthorizationToken aadToken = this.aadDao.getAADAuthorizationtoken(cloudId);
        if (aadToken == null || StringUtils.isEmpty((Object)aadToken.getAccess_token())) {
            logger.debug("aadAuthToken or accessToken is empty so return....");
            return null;
        }
        AADUserElement aadUser = null;
        aadUser = this.getAADUserFromUserName(userName, aadToken);
        if (aadUser != null) {
            logger.debug("...........User " + aadUser.getUserName() + " .........found in AAD");
            String productType = "";
            AADCredentials aadCredentials = this.aadDao.getAADCredentials(cloudId);
            logger.debug(".................." + aadCredentials.toString());
            if (!CollectionUtils.isEmpty((Map)aadCredentials.getGroupConfig())) {
                boolean bkpEnabled = false;
                boolean syncEnabled = false;
                if (!CollectionUtils.isEmpty((Collection)aadCredentials.getGroupConfig().keySet().stream().map(line -> line).filter(line -> !StringUtils.isEmpty((Object)line)).collect(Collectors.toSet()))) {
                    List<String> userMemberOf = this.getAADUserGroupInfo(userName, aadToken);
                    if (!CollectionUtils.isEmpty(userMemberOf)) {
                        for (String group : userMemberOf) {
                            logger.debug("User is memeber of ............" + group);
                            if (StringUtils.isEmpty(aadCredentials.getGroupConfig().get(group))) continue;
                            if (((String)aadCredentials.getGroupConfig().get(group)).equals("BACKUP")) {
                                bkpEnabled = true;
                                continue;
                            }
                            if (((String)aadCredentials.getGroupConfig().get(group)).equals("SYNC")) {
                                syncEnabled = true;
                                continue;
                            }
                            bkpEnabled = true;
                            syncEnabled = true;
                        }
                    }
                } else {
                    productType = (String)aadCredentials.getGroupConfig().values().iterator().next();
                }
                logger.debug("............................" + (String)aadCredentials.getGroupConfig().get("") + "........" + !StringUtils.isEmpty(aadCredentials.getGroupConfig().get("")));
                if (!StringUtils.isEmpty(aadCredentials.getGroupConfig().get(""))) {
                    if (((String)aadCredentials.getGroupConfig().get("")).equals("BACKUP")) {
                        bkpEnabled = true;
                    } else if (((String)aadCredentials.getGroupConfig().get("")).equals("SYNC")) {
                        syncEnabled = true;
                    } else {
                        bkpEnabled = true;
                        syncEnabled = true;
                    }
                }
                if (bkpEnabled && syncEnabled) {
                    productType = "BOTH";
                    aadUser.setDefaultPolicy(PCHelperConstant.getPropertyFileValueDefaultBkpPolicy());
                    aadUser.setDefaultSyncPolicy(PCHelperConstant.getPropertyFileValueDefaultSyncPolicy());
                } else if (bkpEnabled) {
                    productType = "BACKUP";
                    aadUser.setDefaultPolicy(PCHelperConstant.getPropertyFileValueDefaultBkpPolicy());
                } else if (syncEnabled) {
                    productType = "SYNC";
                    aadUser.setDefaultSyncPolicy(PCHelperConstant.getPropertyFileValueDefaultSyncPolicy());
                }
            }
            aadUser.setProductType(productType);
        } else {
            logger.debug("...........User " + userName + " .........  Not found in AAD");
        }
        return aadUser;
    }

    @Override
    public void synUserAttributes(Cloud cloud) {
        AADCredentials aadCredentials = this.aadDao.getAADCredentials(cloud.getCloudId());
        AADAuthorizationToken authToken = this.aadDao.getAADAuthorizationtoken(cloud.getCloudId());
        if (aadCredentials != null && authToken != null && !StringUtils.isEmpty((Object)authToken.getAccess_token())) {
            this.syncGroupChanges(cloud, aadCredentials, authToken);
        } else {
            logger.debug("Either aadCredentials or authToken or accessToken is Empty so no Sync");
        }
    }

    private void syncGroupChanges(Cloud cloud, AADCredentials aadCredentials, AADAuthorizationToken authToken) {
        try {
            Set<String> groupsInDB = aadCredentials.getGroupConfig().keySet().stream().filter(group -> !StringUtils.isEmpty((Object)group)).collect(Collectors.toSet());
            if (CollectionUtils.isEmpty(groupsInDB)) {
                logger.debug("Group name is empty so retun..");
                return;
            }
            String nextLink = "";
            if (!StringUtils.isEmpty((Object)aadCredentials.getGroupDeltaNextLink())) {
                nextLink = aadCredentials.getGroupDeltaNextLink();
            }
            int loopCount = 0;
            boolean isNextLinkExist = true;
            do {
                logger.debug("loopCount :" + ++loopCount);
                GraphGroupDeltaPageTO groupDelta = this.getGroupDelta(authToken, nextLink);
                if (groupDelta != null && !CollectionUtils.isEmpty((Collection)groupDelta.getItemList())) {
                    this.processGroupItems(cloud, groupsInDB, groupDelta);
                }
                if (groupDelta == null || StringUtils.isEmpty((Object)groupDelta.getNextLink())) {
                    isNextLinkExist = false;
                }
                if (!StringUtils.isEmpty((Object)groupDelta.getNextLink())) {
                    nextLink = groupDelta.getNextLink();
                    this.aadDao.updateGroupDeltaNextLink(cloud.getCloudId(), groupDelta.getNextLink());
                }
                if (StringUtils.isEmpty((Object)groupDelta.getDeltaLink())) continue;
                this.aadDao.updateGroupDeltaNextLink(cloud.getCloudId(), groupDelta.getDeltaLink());
                break;
            } while (isNextLinkExist);
        }
        catch (Exception e) {
            logger.error(" Exception  :..........." + e);
            logger.debug(" Exception  :..........." + e.getMessage());
        }
    }

    private void processGroupItems(Cloud cloud, Set<String> groupsInDB, GraphGroupDeltaPageTO groupDelta) {
        List<GraphGroupDeltaItemTO> groupdeltaUserItemTOs = groupDelta.getItemList();
        if (CollectionUtils.isEmpty(groupdeltaUserItemTOs = groupdeltaUserItemTOs.stream().filter(p -> groupsInDB.contains(p.displayName)).collect(Collectors.toList()))) {
            logger.debug("groupdeltaUserItemTOs is empty");
        }
        groupdeltaUserItemTOs.forEach(groupDeltaItems -> {
            logger.debug("Inside........" + groupDeltaItems.getDisplayName());
            List members = groupDeltaItems.getMembers();
            members.forEach(member -> {
                logger.debug("Inside.....member..." + member);
                AADUserElement aadUser = this.getAADUserFromUserNameToSync(cloud.getCloudId(), member.getId());
                if (member.isRemoved() && aadUser != null) {
                    if (aadUser.getProductType().equalsIgnoreCase("")) {
                        this.changeAADUserStatus(cloud, aadUser.getUserPrincipalName(), false, false, false);
                    } else if (aadUser.getProductType().equalsIgnoreCase("BACKUP")) {
                        this.changeAADUserStatus(cloud, aadUser.getUserPrincipalName(), true, false, false);
                    } else if (aadUser.getProductType().equalsIgnoreCase("SYNC")) {
                        this.changeAADUserStatus(cloud, aadUser.getUserPrincipalName(), false, true, false);
                    } else if (aadUser.getProductType().equalsIgnoreCase("O365")) {
                        this.changeAADUserStatus(cloud, aadUser.getUserPrincipalName(), false, false, true);
                    } else if (aadUser.getProductType().equalsIgnoreCase("BOTH")) {
                        this.changeAADUserStatus(cloud, aadUser.getUserPrincipalName(), true, true, true);
                    }
                } else if (aadUser != null) {
                    this.updateOrCreateAADUserInfo(cloud, aadUser);
                }
            });
        });
    }

    @Override
    public AADUserElement getAADUsersFromUserName(int cloudId, String userName) {
        AADUserElement aadUser = null;
        AADAuthorizationToken aadToken = this.aadDao.getAADAuthorizationtoken(cloudId);
        if (aadToken == null || StringUtils.isEmpty((Object)aadToken.getAccess_token())) {
            logger.debug("aadAuthToken or accessToken is empty so return....");
            return null;
        }
        User user = this.userDao.getUserByUserNameOrAADLoginId(cloudId, userName);
        if (user == null) {
            aadUser = this.getAADUserFromUserName(userName, aadToken);
            if (aadUser != null) {
                logger.debug("...........User " + aadUser.getUserName() + " .........found in AAD");
            } else {
                logger.debug("...........User " + userName + " .........  Not found in AAD");
            }
        } else {
            logger.debug("$##############################" + userName + " ........present in our db....");
        }
        return aadUser;
    }

    @Override
    public boolean checkTokenExpired(int cloudId) {
        boolean isTokenExpired = false;
        AADAuthorizationToken aadToken = this.aadDao.getAADAuthorizationtoken(cloudId);
        if (aadToken == null || StringUtils.isEmpty((Object)aadToken.getAccess_token())) {
            logger.debug("aadAuthToken or accessToken is empty so return....");
            return isTokenExpired;
        }
        AADAuthorizationToken accessTokenAndUpdateInDB = this.getAccessTokenAndUpdateInDB(aadToken);
        if (accessTokenAndUpdateInDB == null) {
            logger.debug("..token is expred so send the mail");
            isTokenExpired = true;
        }
        return isTokenExpired;
    }

    private AADUserElement getAADUserFromUserName(String userName, AADAuthorizationToken authToken) {
        StringBuilder response = new StringBuilder();
        AADUserElement aadUser = null;
        boolean retry = false;
        int retryCount = 0;
        ObjectMapper mapper = new ObjectMapper();
        do {
            try {
                mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
                URL url = new URL("https://graph.microsoft.com/beta//users/" + userName);
                HttpURLConnection conn = this.getProxy(1) != null ? (HttpURLConnection)url.openConnection(this.getProxy(1)) : (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                conn.setRequestProperty("Authorization", "Bearer " + authToken.getAccess_token());
                conn.setRequestProperty("Accept", "application/json");
                int httpResponseCode = conn.getResponseCode();
                logger.debug("getAADUserFromUserName ........response code ......... " + httpResponseCode);
                if (httpResponseCode == 401) {
                    retry = true;
                    ++retryCount;
                    if ((authToken = this.getAccessTokenAndUpdateInDB(authToken)) == null) {
                        logger.debug("..token is expred ....");
                        return null;
                    }
                    this.getAADUserFromUserName(userName, authToken);
                    continue;
                }
                if (httpResponseCode != 200) continue;
                try (BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));){
                    String inputLine;
                    while ((inputLine = in.readLine()) != null) {
                        response.append(inputLine);
                    }
                }
                aadUser = (AADUserElement)mapper.readValue(response.toString(), AADUserElement.class);
                break;
            }
            catch (Exception e) {
                logger.trace("" + e);
                logger.error(" ERROR trying to get AADUser From UserName " + e.getMessage());
                retry = true;
                ++retryCount;
            }
        } while (retry && retryCount < 2);
        return aadUser;
    }

    private GraphGroupDeltaPageTO getGroupDelta(AADAuthorizationToken authToken, String nextLink) {
        StringBuilder response = new StringBuilder();
        GraphGroupDeltaPageTO graphGroupDeltaPageTO = null;
        boolean retry = false;
        int retryCount = 0;
        ObjectMapper mapper = new ObjectMapper();
        do {
            try {
                mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
                URL url = null;
                url = !StringUtils.isEmpty((Object)nextLink) ? new URL(nextLink) : new URL("https://graph.microsoft.com/v1.0/groups/delta");
                HttpURLConnection conn = this.getProxy(1) != null ? (HttpURLConnection)url.openConnection(this.getProxy(1)) : (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                conn.setRequestProperty("Authorization", "Bearer " + authToken.getAccess_token());
                conn.setRequestProperty("Accept", "application/json");
                int httpResponseCode = conn.getResponseCode();
                logger.debug("..getAADUserFromUserName ........response code ......... " + httpResponseCode);
                if (httpResponseCode == 401) {
                    retry = true;
                    ++retryCount;
                    AADAuthorizationToken accessTokenAndUpdateInDB = this.getAccessTokenAndUpdateInDB(authToken);
                    if (accessTokenAndUpdateInDB == null) {
                        logger.debug("token is expired so return");
                        return null;
                    }
                    this.getGroupDelta(authToken, nextLink);
                    continue;
                }
                if (httpResponseCode != 200) continue;
                try (BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));){
                    String inputLine;
                    while ((inputLine = in.readLine()) != null) {
                        response.append(inputLine);
                    }
                }
                graphGroupDeltaPageTO = (GraphGroupDeltaPageTO)mapper.readValue(response.toString(), GraphGroupDeltaPageTO.class);
                break;
            }
            catch (Exception e) {
                logger.trace("" + e);
                logger.error(" ERROR trying to get AADUser From UserName " + e.getMessage());
                retry = true;
                ++retryCount;
            }
        } while (retry && retryCount < 2);
        return graphGroupDeltaPageTO;
    }

    private List<String> getAADUserGroupInfo(String userName, AADAuthorizationToken authToken) {
        StringBuilder response = new StringBuilder();
        List userMemeberOf = null;
        boolean retry = false;
        int retryCount = 0;
        ObjectMapper mapper = new ObjectMapper();
        do {
            try {
                mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
                URL url = new URL("https://graph.microsoft.com/v1.0//users/" + userName + GRAPH_USER_MEMBER_OF);
                HttpURLConnection conn = this.getProxy(1) != null ? (HttpURLConnection)url.openConnection(this.getProxy(1)) : (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                conn.setRequestProperty("Authorization", "Bearer " + authToken.getAccess_token());
                conn.setRequestProperty("Accept", "application/json");
                int httpResponseCode = conn.getResponseCode();
                logger.debug("getAADUserFromUserName ........response code ......... " + httpResponseCode);
                if (httpResponseCode == 401) {
                    retry = true;
                    ++retryCount;
                    AADAuthorizationToken accessTokenAndUpdateInDB = this.getAccessTokenAndUpdateInDB(authToken);
                    if (accessTokenAndUpdateInDB == null) {
                        logger.debug("token is expired so return");
                        return null;
                    }
                    this.getAADUserGroupInfo(userName, authToken);
                    continue;
                }
                if (httpResponseCode != 200) continue;
                try (BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));){
                    String inputLine;
                    while ((inputLine = in.readLine()) != null) {
                        response.append(inputLine);
                    }
                }
                GraphResponseForMemberOf forMemberOf = (GraphResponseForMemberOf)mapper.readValue(response.toString(), GraphResponseForMemberOf.class);
                if (forMemberOf == null || CollectionUtils.isEmpty((Collection)forMemberOf.getGroupInfo())) break;
                List groupInfo = forMemberOf.getGroupInfo();
                userMemeberOf = groupInfo.stream().map(group -> group.getDisplayName()).collect(Collectors.toList());
                break;
            }
            catch (Exception e) {
                logger.trace("" + e);
                logger.error(" ERROR trying to get getAADUserGroupInfo " + e.getMessage());
                retry = true;
                ++retryCount;
            }
        } while (retry && retryCount < 2);
        return userMemeberOf;
    }

    @Override
    public AADAuthorizationToken getAccessTokenAndUpdateInDB(AADAuthorizationToken aadAuthToken) {
        AADCredentials aadCredentials = this.aadDao.getAADCredentials(1);
        String accessToken = "";
        String refreshToken = "";
        URL url = null;
        URLConnection conn = null;
        String data = null;
        logger.debug("  getAccessToken............HttpURLConnection.............................");
        try {
            String line;
            data = URLEncoder.encode("grant_type", UTF_8) + "=" + URLEncoder.encode(REFRESH_TOKEN, UTF_8);
            data = data + "&" + URLEncoder.encode(REFRESH_TOKEN, UTF_8) + "=" + URLEncoder.encode(aadAuthToken.getRefresh_token(), UTF_8);
            data = data + "&" + URLEncoder.encode("client_id", UTF_8) + "=" + URLEncoder.encode(aadCredentials.getClientId(), UTF_8);
            data = data + "&" + URLEncoder.encode("client_secret", UTF_8) + "=" + URLEncoder.encode(aadCredentials.getSecretKey(), UTF_8);
            url = new URL(TOKEN_URL + aadCredentials.getTenentId() + OAUTH2_TOKEN_URL);
            conn = this.getProxy(1) != null ? url.openConnection(this.getProxy(1)) : url.openConnection();
            conn.setDoOutput(true);
            conn.setConnectTimeout(1800000);
            OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
            wr.write(data);
            wr.flush();
            HttpURLConnection connection = (HttpURLConnection)conn;
            if (connection.getResponseCode() == 400) {
                logger.error("TOKEN has expired so remap the token...... ");
                return null;
            }
            BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            StringBuilder response = new StringBuilder("");
            while ((line = rd.readLine()) != null) {
                response.append(line);
            }
            wr.close();
            rd.close();
            JSONObject jsonObject = new JSONObject(response.toString());
            accessToken = jsonObject.optString("access_token");
            refreshToken = jsonObject.optString(REFRESH_TOKEN);
            this.aadDao.updateRefreshToken(1, refreshToken, accessToken);
            aadAuthToken.setAccess_token(accessToken);
            aadAuthToken.setRefresh_token(refreshToken);
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error(" ERROR trying to get access token ...HttpURLConnection " + e.getMessage());
        }
        return aadAuthToken;
    }

    private void updateOrCreateAADUserInfo(Cloud cloud, AADUserElement aadUserElement) {
        try {
            User existingUser;
            boolean isBackupEnabled;
            boolean isSyncEnabled;
            block20: {
                logger.debug(aadUserElement.getProductType() + "...................................." + aadUserElement.getUserPrincipalName());
                isSyncEnabled = false;
                isBackupEnabled = false;
                boolean isO365Enabled = false;
                List list = cloud.getCloudCustomisableDetails();
                for (CloudCustomisableDetails customisableDetails : list) {
                    if (customisableDetails.getName().equalsIgnoreCase(SYNC_ENABLED)) {
                        isSyncEnabled = true;
                    }
                    if (customisableDetails.getName().equalsIgnoreCase(BACK_UP_ENABLED)) {
                        isBackupEnabled = true;
                    }
                    if (!"OneDrive Backup Enabled".equalsIgnoreCase(customisableDetails.getName())) continue;
                    isO365Enabled = true;
                }
                if (StringUtils.isEmpty((Object)aadUserElement.getProductType())) {
                    logger.debug("User not part of any product");
                    return;
                }
                if ("SYNC".equalsIgnoreCase(aadUserElement.getProductType())) {
                    isBackupEnabled = false;
                    isO365Enabled = false;
                }
                if ("BACKUP".equalsIgnoreCase(aadUserElement.getProductType())) {
                    isSyncEnabled = false;
                    isO365Enabled = false;
                }
                if ("O365".equalsIgnoreCase(aadUserElement.getProductType())) {
                    isSyncEnabled = false;
                    isBackupEnabled = false;
                }
                User user = new User();
                UUID uuid = UUID.randomUUID();
                String recoveryKey = String.valueOf(uuid);
                user.setSecurityRecoveryKey(recoveryKey);
                user.setActive(true);
                user.setAdmin(false);
                user.setBackupEnabled(isBackupEnabled);
                user.setSyncEnabled(isSyncEnabled);
                user.setFirstLogin(true);
                user.setShareEnabled(true);
                user.setUserName(aadUserElement.getUserPrincipalName());
                if (StringUtils.isEmpty((Object)aadUserElement.getMail())) {
                    user.setEmailId(aadUserElement.getUserPrincipalName());
                } else {
                    user.setEmailId(aadUserElement.getMail());
                }
                user.setCreatedTimestamp(String.valueOf(System.currentTimeMillis()));
                user.setDisplayName(aadUserElement.getDisplayName());
                user.setMigratedBy("AUTO");
                user.setlocalUser(false);
                user.setLocation(aadUserElement.getOfficeLocation());
                user.setDepartment(aadUserElement.getDepartment());
                user.setAccountStatus(true);
                user.setUserNameLowerCase(aadUserElement.getUserPrincipalName().toLowerCase());
                user.setPolicyName(aadUserElement.getDefaultPolicy());
                user.setSyncPolicyName(aadUserElement.getDefaultSyncPolicy());
                user.setOnedriveBkpEnabled(isO365Enabled);
                user.setOdbPolicyName(aadUserElement.getDefaultOdbPolicy());
                if (StringUtils.isEmpty((Object)aadUserElement.getDefaultOdbPolicy())) {
                    user.setOdbPolicyName(PCHelperConstant.getPropertyFileValueDefaultO365PolicyName());
                }
                UserElement userElement = new UserElement();
                BeanUtils.copyProperties((Object)user, (Object)userElement);
                existingUser = null;
                try {
                    long countOfPresentUsers = this.userDao.countOfPresentUsers(cloud.getCloudId(), cloud.getCloudName(), true);
                    int noOfUsersAllowed = cloud.getNoOfUsersAllowed();
                    if ((long)noOfUsersAllowed <= countOfPresentUsers) {
                        logger.debug(noOfUsersAllowed + "..User limit reached........." + countOfPresentUsers);
                        throw new Exception("User limit reached....");
                    }
                    UserElement createduserElement = this.createUser(cloud.getCloudId(), cloud.getCloudName(), userElement, true, this.userDao);
                    if (createduserElement != null) {
                        MigrationStatus migrationStatus = new MigrationStatus();
                        migrationStatus.setMigratedBy("AUTO");
                        migrationStatus.setMigratededTimestamp(System.currentTimeMillis());
                        migrationStatus.setMigrated(true);
                        migrationStatus.setUserName(user.getUserName());
                        migrationStatus.setEmailId(user.getEmailId());
                        this.migrationStatusDao.saveMigrationStatus(cloud.getCloudId(), migrationStatus);
                        this.saveStatisticToDatabase(cloud.getCloudId(), cloud.getCloudName(), "MIGRATION", "AUTO", aadUserElement.getUserPrincipalName(), "AAD", System.currentTimeMillis(), PCActionTypes.ADD_USER_MIGRATION.getActionTypeValue());
                    }
                }
                catch (BaseException e) {
                    logger.debug("...error message " + e.getMessage());
                    if (e.getErrorStatus() != 1200) break block20;
                    logger.debug("User already exists......");
                    existingUser = this.userDao.getUserByUserNameOrAADLoginId(cloud.getCloudId(), aadUserElement.getUserPrincipalName());
                }
            }
            if (existingUser != null) {
                boolean previStatus = existingUser.isActive();
                existingUser.setBackupEnabled(isBackupEnabled);
                existingUser.setSyncEnabled(isSyncEnabled);
                if (!isBackupEnabled && !isSyncEnabled) {
                    existingUser.setActive(false);
                } else {
                    existingUser.setActive(true);
                }
                this.userDao.saveUser(cloud.getCloudId(), cloud.getCloudName(), existingUser);
                this.deviceDao.updateUserInfoInDeviceBkpOverview(cloud.getCloudId(), existingUser);
                this.setAuditForAADBlockedOrUnblocked(cloud.getCloudId(), cloud.getCloudName(), existingUser.getUserName(), existingUser.isActive(), previStatus);
                if (!existingUser.isActive()) {
                    this.changeDeviceStatusAndAduit(cloud, existingUser);
                }
            }
        }
        catch (Exception e) {
            logger.error(EXCEPTION + e);
            logger.debug(EXCEPTION + e.getMessage());
        }
    }

    private void changeDeviceStatusAndAduit(Cloud cloud, User user) {
        List<Device> blockedDevices = this.blockUnblockDevicebyUserName(cloud.getCloudId(), cloud.getCloudName(), user.getUserName(), true);
        if (blockedDevices != null) {
            for (Device device : blockedDevices) {
                this.saveStatisticToDatabase(cloud, "Blocked device", "AUTO", device.getDeviceName(), "AAD Sync", System.currentTimeMillis(), PCActionTypes.ADD_USER_MIGRATION.getActionTypeValue());
            }
        }
    }

    private List<Device> blockUnblockDevicebyUserName(int cloudId, String cloudName, String userName, boolean toBlock) {
        List devices = new ArrayList();
        ArrayList<Device> blockedDevice = new ArrayList<Device>();
        devices = this.deviceDao.getDeviceByUserName(cloudId, userName);
        if (!CollectionUtils.isEmpty(devices)) {
            for (Device device : devices) {
                if (device.isBlocked()) continue;
                this.deviceDao.blockUnblockDevice(cloudId, cloudName, device, toBlock);
                this.deviceDao.updateDeviceStatusInOverview(cloudId, device.getDeviceUUID(), toBlock);
                if (toBlock) {
                    User user = this.userDao.getUserByName(cloudId, device.getUserName());
                    this.authorizationDao.deleteAuthTokenByUserAndUniqueID(cloudId, user, device.getDeviceUUID());
                }
                blockedDevice.add(device);
            }
        }
        return blockedDevice;
    }

    private void saveStatisticToDatabase(Cloud cloud, String action, String actionByUser, String actionOnUser, String actionUsingObject, long timeStamp, int actionType) {
        AuditHistory audit = new AuditHistory();
        audit.setAction(action);
        audit.setActionByUserName(actionByUser);
        audit.setActionOnObject(actionOnUser);
        audit.setTimestamp(timeStamp);
        audit.setActionUsingObject(actionUsingObject);
        audit.setActionType(actionType);
        this.auditHistoryDao.saveAudit(cloud.getCloudId(), cloud.getCloudName(), audit);
    }

    public void saveStatisticToDatabase(int cloudId, String cloudName, String action, String actionByUser, String actionOnUser, String actionUsingObject, long timeStamp, int actionType) {
        AuditHistory audit = new AuditHistory();
        audit.setAction(action);
        audit.setActionByUserName(actionByUser);
        audit.setActionOnObject(actionOnUser);
        audit.setTimestamp(timeStamp);
        audit.setActionUsingObject(actionUsingObject);
        audit.setActionType(actionType);
        this.userDao.saveAudit(cloudId, cloudName, audit);
    }

    private void changeAADUserStatus(Cloud cloud, String userName, boolean isBackupEnabled, boolean isSyncEnabled, boolean isO365Enabled) {
        try {
            User existingUser = this.userDao.getUserByUserNameOrAADLoginId(cloud.getCloudId(), userName);
            if (existingUser != null) {
                boolean previStatus = existingUser.isActive();
                existingUser.setBackupEnabled(isBackupEnabled);
                if (!isBackupEnabled) {
                    existingUser.setActive(false);
                }
                existingUser.setOnedriveBkpEnabled(isO365Enabled);
                if (isO365Enabled) {
                    existingUser.setOdbPolicyName(PCHelperConstant.getPropertyFileValueDefaultO365PolicyName());
                }
                this.userDao.saveUser(cloud.getCloudId(), cloud.getCloudName(), existingUser);
                this.deviceDao.updateUserInfoInDeviceBkpOverview(cloud.getCloudId(), existingUser);
                this.setAuditForAADBlockedOrUnblocked(cloud.getCloudId(), cloud.getCloudName(), userName, existingUser.isActive(), previStatus);
                this.changeDeviceStatusAndAduit(cloud, existingUser);
            }
        }
        catch (Exception e) {
            logger.error(EXCEPTION + e);
            logger.debug(EXCEPTION + e.getMessage());
        }
    }

    private void setAuditForAADBlockedOrUnblocked(int cloudId, String cloudName, String userName, boolean isActive, boolean previStatus) {
        if (!isActive && previStatus) {
            this.saveStatisticToDatabase(cloudId, cloudName, "BLOCKED", "AUTO", userName, "AAD", System.currentTimeMillis(), PCActionTypes.AAD_USER_BLOCKED.getActionTypeValue());
        } else if (isActive && !previStatus) {
            this.saveStatisticToDatabase(cloudId, cloudName, "UNBLOCKED", "AUTO", userName, "AAD", System.currentTimeMillis(), PCActionTypes.AAD_USER_UNBLOCKED.getActionTypeValue());
        }
    }

    private void getUserProductType(AADUserElement user, ObjectMapper mapper, AADCredentials aadCredentials, String accessToken) throws IOException, JsonParseException, JsonMappingException {
        String userGroupInfo;
        boolean bkpEnabled = false;
        boolean syncEnabled = false;
        if (!CollectionUtils.isEmpty((Map)aadCredentials.getGroupConfig()) && !StringUtils.isEmpty((Object)(userGroupInfo = this.getUserGroupsFromUserToken(accessToken)))) {
            GraphResponseForMemberOf forMemberOf = (GraphResponseForMemberOf)mapper.readValue(userGroupInfo, GraphResponseForMemberOf.class);
            if (!CollectionUtils.isEmpty((Collection)aadCredentials.getGroupConfig().keySet().stream().filter(line -> !StringUtils.isEmpty((Object)line)).collect(Collectors.toSet()))) {
                List groupInfo = forMemberOf.getGroupInfo();
                List groupNames = groupInfo.stream().map(group -> group.getDisplayName()).collect(Collectors.toList());
                for (String groupName : aadCredentials.getGroupConfig().keySet()) {
                    if (StringUtils.isEmpty((Object)groupName)) {
                        if ("BACKUP".equals(aadCredentials.getGroupConfig().get(groupName))) {
                            bkpEnabled = true;
                        }
                        if ("SYNC".equals(aadCredentials.getGroupConfig().get(groupName))) {
                            syncEnabled = true;
                            continue;
                        }
                        bkpEnabled = true;
                        syncEnabled = true;
                        continue;
                    }
                    if (CollectionUtils.isEmpty(groupNames) || !groupNames.contains(groupName)) continue;
                    if ("BACKUP".equals(aadCredentials.getGroupConfig().get(groupName))) {
                        bkpEnabled = true;
                        continue;
                    }
                    if ("SYNC".equals(aadCredentials.getGroupConfig().get(groupName))) {
                        syncEnabled = true;
                        continue;
                    }
                    bkpEnabled = true;
                    syncEnabled = true;
                }
            }
        }
        if (!StringUtils.isEmpty(aadCredentials.getGroupConfig().get(""))) {
            if (((String)aadCredentials.getGroupConfig().get("")).equals("BACKUP")) {
                bkpEnabled = true;
            } else if (((String)aadCredentials.getGroupConfig().get("")).equals("SYNC")) {
                syncEnabled = true;
            } else {
                bkpEnabled = true;
                syncEnabled = true;
            }
        }
        if (bkpEnabled && syncEnabled) {
            user.setProductType("BOTH");
        } else if (bkpEnabled) {
            user.setProductType("BACKUP");
        } else if (syncEnabled) {
            user.setProductType("SYNC");
        }
    }

    @Override
    public AADUserElement getAADUserByCode(String code, Cloud cloud, boolean callFromPortal, String redirectUrlFromHeader) {
        AADUserElement aadUserElement;
        block33: {
            aadUserElement = null;
            AADCredentials aadCredentials = this.aadDao.getAADCredentials(cloud.getCloudId());
            if (aadCredentials == null || StringUtils.isEmpty((Object)aadCredentials.getTenentId())) {
                logger.debug("AAD credentials is empty....");
                return aadUserElement;
            }
            String grantType = AUTHORIZATION_CODE;
            String applicationID = aadCredentials.getClientId();
            String redirectURI = aadCredentials.getEndpointRedirectURI();
            if (callFromPortal) {
                redirectURI = StringUtils.isEmpty((Object)redirectUrlFromHeader) ? aadCredentials.getPortalRedirectURI() : redirectUrlFromHeader;
            }
            try {
                logger.debug("Redirect URL :" + redirectURI);
                CloseableHttpClient httpclient = null;
                Proxy proxy = this.settingsDao.getProxy(1);
                if (proxy != null || !StringUtils.isEmpty((Object)PCHelperConstant.getProxyHost()) && !StringUtils.isEmpty((Object)PCHelperConstant.getProxyPort())) {
                    logger.debug("host :" + PCHelperConstant.getProxyHost());
                    logger.debug("port :" + PCHelperConstant.getProxyPort());
                    HttpHost proxyval = new HttpHost(PCHelperConstant.getProxyHost(), PCHelperConstant.getProxyPort(), "http");
                    DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxyval);
                    httpclient = HttpClients.custom().setRoutePlanner((HttpRoutePlanner)routePlanner).build();
                } else {
                    httpclient = HttpClients.custom().build();
                }
                HttpPost httppost = new HttpPost(LOGIN_URL + aadCredentials.getTenentId() + OAUTH2_TOKEN_URL);
                ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
                params.add(new BasicNameValuePair("grant_type", grantType));
                params.add(new BasicNameValuePair("client_id", applicationID));
                params.add(new BasicNameValuePair("code", code));
                params.add(new BasicNameValuePair("redirect_uri", redirectURI));
                params.add(new BasicNameValuePair("client_secret", aadCredentials.getSecretKey()));
                httppost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, UTF_8));
                httppost.setHeader(CONTENT_TYPE, "application/x-www-form-urlencoded");
                HttpResponse response = httpclient.execute((HttpUriRequest)httppost);
                HttpEntity entity = response.getEntity();
                logger.debug("Status code " + response.getStatusLine().getStatusCode());
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode == 200) {
                    if (entity == null) break block33;
                    try (InputStream instream = entity.getContent();){
                        JSONObject json = new JSONObject(IOUtils.toString((InputStream)instream, (String)UTF_8));
                        String accessToken = json.getString("access_token");
                        ObjectMapper mapper = new ObjectMapper();
                        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
                        logger.debug("accessToken......." + accessToken);
                        String userString = this.getUserInfoFromGraph(accessToken);
                        logger.debug("userString......." + userString);
                        aadUserElement = (AADUserElement)mapper.readValue(userString, AADUserElement.class);
                        if (aadUserElement != null) {
                            this.getUserProductType(aadUserElement, mapper, aadCredentials, accessToken);
                        } else {
                            logger.debug("AAD element is empty");
                        }
                        break block33;
                    }
                }
                try (InputStream instream = entity.getContent();){
                    logger.debug(IOUtils.toString((InputStream)instream, (String)UTF_8));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error(EXCEPTION + e);
                logger.debug(EXCEPTION + e.getMessage());
            }
        }
        return aadUserElement;
    }

    private java.net.Proxy getProxy(int cloudId) {
        int port;
        String host;
        String passwordVal;
        String userNameVal;
        Proxy proxy = this.settingsDao.getProxy(cloudId);
        if (proxy != null) {
            userNameVal = proxy.getUserName();
            passwordVal = proxy.getPassword();
            host = proxy.getHost();
            port = Integer.parseInt(proxy.getPort());
        } else {
            userNameVal = PCHelperConstant.getProxyUserName();
            passwordVal = PCHelperConstant.getProxyPassword();
            host = PCHelperConstant.getProxyHost();
            port = PCHelperConstant.getProxyPort();
        }
        String userName = userNameVal;
        String password = passwordVal;
        if (StringUtils.isEmpty((Object)host) || port <= 0) {
            return null;
        }
        return new java.net.Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, port));
    }

    public SettingsDao getSettingsDao() {
        return this.settingsDao;
    }

    public void setSettingsDao(SettingsDao settingsDao) {
        this.settingsDao = settingsDao;
    }
}

