/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.udc.controller;

import com.parablu.bluvault.ah.service.AuditHistoryService;
import com.parablu.bluvault.udc.controller.BaseController;
import com.parablu.bluvault.udc.service.AADManagementService;
import com.parablu.bluvault.udc.service.DeviceManagementService;
import com.parablu.bluvault.udc.service.LiteVersionManagementService;
import com.parablu.bluvault.udc.service.MiniCloudAccessControlService;
import com.parablu.bluvault.udc.service.PciAuthorizationTokensService;
import com.parablu.bluvault.udc.service.UserManagementService;
import com.parablu.cloud.security.service.AuthorizationService;
import com.parablu.cloud.security.service.DeviceAndUserSecurityService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.cloud.security.to.CloudLicenseTo;
import com.parablu.cloud.security.to.DeviceStatusTo;
import com.parablu.helper.element.ErrorElement;
import com.parablu.helper.exceptions.BaseException;
import com.parablu.mail.service.CloudMailService;
import com.parablu.mt.service.LdapService;
import com.parablu.paracloud.constant.PCActionTypes;
import com.parablu.paracloud.constant.PCClientTypes;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.AADCredentialsElement;
import com.parablu.paracloud.element.AADUserElement;
import com.parablu.paracloud.element.CloudPropertyElement;
import com.parablu.paracloud.element.DeviceElement;
import com.parablu.paracloud.element.EmailProps;
import com.parablu.paracloud.element.EmailRecipent;
import com.parablu.paracloud.element.LdapUserElement;
import com.parablu.paracloud.element.LdapUserListElement;
import com.parablu.paracloud.element.MiniCloudElementList;
import com.parablu.paracloud.element.ResponseElement;
import com.parablu.paracloud.element.SearchUserElement;
import com.parablu.paracloud.element.StringElement;
import com.parablu.paracloud.element.UserElement;
import com.parablu.paracloud.element.UserGroupElement;
import com.parablu.paracloud.element.UserListElement;
import com.parablu.paracloud.element.response.UserElementResponse;
import com.parablu.paracloud.element.response.UserErrorReponse;
import com.parablu.paracloud.util.CacheHelper;
import com.parablu.paracloud.util.DateUtil;
import com.parablu.paracloud.util.EmailCacher;
import com.parablu.paracloud.util.TokenGenerator;
import com.parablu.pcbd.domain.AuthorizationTokens;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.DeletedUser;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.Group;
import com.parablu.pcbd.domain.LiteVersion;
import com.parablu.pcbd.domain.MigrationStatus;
import com.parablu.pcbd.domain.PciAuthorizationTokens;
import com.parablu.pcbd.domain.Person;
import com.parablu.pcbd.domain.ReportQueryElement;
import com.parablu.pcbd.domain.User;
import com.parablu.pcbd.domain.UserGroup;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class UserManagementController
extends BaseController {
    private static final String SYNC = "Sync";
    private static final String BKP = "Bkp";
    private static final String BKP_SYNC = "Bkp-Sync";
    private static final String BROWSER = "browser";
    private static final String OS_TYPE = "osType";
    private static final String BACKUP = "backup";
    private static final String SECRET_KEY = "a9985ebcae81";
    private static Logger logger = LoggerFactory.getLogger(UserManagementController.class);
    @Autowired
    private UserManagementService managementService;
    @Autowired
    private LiteVersionManagementService liteVersionManagementService;
    @Autowired
    private LicenseService licenseService;
    @Autowired
    private AADManagementService aadManagementService;
    @Autowired
    private DeviceAndUserSecurityService deviceAndUserSecurityService;
    @Autowired
    private MiniCloudAccessControlService miniCloudAccessControlService;
    @Autowired
    private AuthorizationService authorizationService1;
    @Autowired
    private CloudMailService cloudMailService;
    @Autowired
    private DeviceManagementService deviceManagementService;
    @Autowired
    private LdapService ldapService;
    @Autowired
    private AuditHistoryService auditHistoryService;
    @Autowired
    private PciAuthorizationTokensService pciAuthorizationTokensService;
    private static final String DATA_ACCESS_EXCEPTION = " DataAccessException  :";
    private static final String BASE_EXCEPTION = " BaseException  :";
    private static final String USER_NAME = "userName";
    private static final String EXCEPTION = " Exception  :";
    private static final String INVALID_REQUEST = "Invalid Request.";
    private static final String GET_USER_INFO_BACKUP_ENABLED = "get user info Backup Enabled....";
    private static final String USER_NOT_FOUND = "User not found.";
    private static final String EMPTY_RESULT_DATA_ACCESS_EXCEPTION = " EmptyResultDataAccessException  :";
    private static final String BACK_UP_ENABLED = "Backup Enabled";
    private static final String SYNC_ENABLED = "Sync Enabled";
    private static final String ODB_ENABLED = "ODB Enabled";
    private static final String GD_ENABLED = "Google Drive Enabled";
    private static final String GD_SERVICE_ENABLED = "GD Service Account Enabled";
    private static final String USER_NAME_NOT_FOUND = "User name not found.";
    private static final String USER_ALREADY_EXISTS = "User already exists.";
    private static final String DATA_INSTEGRITY_VIOLATION_EXCEPTION = " DataIntegrityViolationException  :";
    private static final String CALLING_UPDATE_USER_INFO = "calling /updateUserInfo ...";
    private static final String ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    private static final String POST_GET_OPTIONS_DELETE = "POST, GET, OPTIONS, DELETE";
    private static final String ACCESS_CONTROL_ALLOW_METHODS = "Access-Control-Allow-Methods";
    private static final String ACCESS_CONTROL_MAX_AGE = "Access-Control-Max-Age";
    private static final String ACCESS_CONTROL_ALLOW_HEADERS = "Access-Control-Allow-Headers";
    private static final String X_REQUESTED_WITH_FIRST_LOGIN_TOKEN = "x-requested-with, firstLogin, token";
    private static final String PASSWORD = "password";
    private static final String DEVICE_NAME = "deviceName";
    private static final String CLIENT_TYPE = "clientType";
    private static final String PORTAL = "portal";
    private static final String LOGGED_INTO = "logged into ";
    private static final String FALSE = "false";
    private static final String CLOUD_NAME = "cloudName";
    private static final String INSIDE_AUTHENTICATE_DATA_INTEGRITY_VIOLATON_EXCEPTION = "@@@ Inside authenticate DataIntegrityViolationException...";
    private static final String CALLING_VERIFY_RECOVERY_KEY = "calling /verifyRecoveryKey ...";
    private static final String RESET_PASSWORD_KEY = "reset-password-key";
    private static final String IO_EXCEPTION = " IOException  :";
    private static final String INSIDE_AZURE_AUTHENTICATION = "@@@@@@@@@@@@@@ Inside Azure authentication  ...............";
    private static final String RESET_PASSWORD = "-reset-password";
    private static final String LDAP_ENABLED = "isLdapEnabled";
    private static final String AAD_ENABLED = "isAADEnabled";

    @RequestMapping(value={"cloud/{cloudName}/user/all"}, method={RequestMethod.GET})
    public ModelAndView getAllUsers(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        ModelAndView modelAndView = new ModelAndView();
        UserElementResponse ue = new UserElementResponse();
        modelAndView.setViewName("xmlview");
        String cloudName = cloudName1;
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), response)) {
                return null;
            }
            int skipValue = request.getIntHeader("skipValue");
            logger.debug(" Skip values .... " + skipValue);
            List<UserElement> userList = this.managementService.getAllUsers(cloudId, skipValue);
            userList.removeAll(Collections.singleton(null));
            Collections.sort(userList, new Comparator<UserElement>(){

                @Override
                public int compare(UserElement u1, UserElement u2) {
                    if (u1 == null || u2 == null || u1.getUserName() == null || u2.getUserName() == null) {
                        return -1;
                    }
                    return new CompareToBuilder().append((Object)UserManagementController.getStatus(u1.isActive()), (Object)UserManagementController.getStatus(u2.isActive())).append((Object)u1.getUserName().toLowerCase(), (Object)u2.getUserName().toLowerCase()).toComparison();
                }
            });
            ue.setUsers(userList);
            modelAndView.addObject((Object)ue);
            response.setStatus(200);
        }
        catch (DataAccessException e) {
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
            logger.trace(DATA_ACCESS_EXCEPTION + (Object)((Object)e));
            logger.error(DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (BaseException e) {
            ErrorElement err = this.createErrorElement(e.getErrorCode(), null);
            modelAndView.addObject((Object)err);
            response.setStatus(400);
            logger.trace(BASE_EXCEPTION + (Object)((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
        }
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/search/users/"}, method={RequestMethod.GET})
    public ModelAndView searchUsers(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        UserElementResponse ue = new UserElementResponse();
        modelAndView.setViewName("xmlview");
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), response)) {
                return null;
            }
            String userName = request.getHeader(USER_NAME);
            List<UserElement> userList = this.managementService.searchUsers(cloudId, userName);
            Collections.sort(userList, new Comparator<UserElement>(){

                @Override
                public int compare(UserElement u1, UserElement u2) {
                    return new CompareToBuilder().append((Object)UserManagementController.getStatus(u1.isActive()), (Object)UserManagementController.getStatus(u2.isActive())).append((Object)u1.getUserName().toLowerCase(), (Object)u2.getUserName().toLowerCase()).toComparison();
                }
            });
            ue.setUsers(userList);
            modelAndView.addObject((Object)ue);
            response.setStatus(200);
        }
        catch (Exception e) {
            ErrorElement err = this.createErrorElement(null, e.getMessage());
            modelAndView.addObject((Object)err);
            response.setStatus(400);
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
        return modelAndView;
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/search/users/"}, method={RequestMethod.GET})
    public ModelAndView searchUserbyUsernameOrDisplaynameOrEmailId(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        UserElementResponse ue = new UserElementResponse();
        modelAndView.setViewName("xmlview");
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), response)) {
                return null;
            }
            String userName = request.getHeader(USER_NAME);
            List<UserElement> userList = this.managementService.searchUserbyUsernameOrDisplaynameOrEmailId(cloudId, userName);
            Collections.sort(userList, new Comparator<UserElement>(){

                @Override
                public int compare(UserElement u1, UserElement u2) {
                    return new CompareToBuilder().append((Object)UserManagementController.getStatus(u1.isActive()), (Object)UserManagementController.getStatus(u2.isActive())).append((Object)u1.getUserName().toLowerCase(), (Object)u2.getUserName().toLowerCase()).toComparison();
                }
            });
            ue.setUsers(userList);
            modelAndView.addObject((Object)ue);
            response.setStatus(200);
        }
        catch (Exception e) {
            ErrorElement err = this.createErrorElement(null, e.getMessage());
            modelAndView.addObject((Object)err);
            response.setStatus(400);
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/user/{userName}/"}, method={RequestMethod.GET})
    public ModelAndView getUserInformation(@PathVariable(value="cloudName") String cloudName1, @PathVariable(value="userName") String userName, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling getUserInformation...:" + userName);
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        try {
            String token;
            if (!org.springframework.util.StringUtils.hasText((String)userName)) {
                throw new BaseException(INVALID_REQUEST);
            }
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            Cloud cloud = cl.getCloud();
            int cloudId = cloud.getCloudId();
            if (!this.performAuthorization(cloudId, cloudName = cloud.getCloudName(), token = request.getHeader("token"), response)) {
                return null;
            }
            UserElement ue = this.getUserElement(userName, cloud);
            logger.debug(GET_USER_INFO_BACKUP_ENABLED + ue.isBackupEnabled());
            modelAndView.addObject((Object)ue);
            response.setStatus(200);
        }
        catch (EmptyResultDataAccessException e) {
            ErrorElement err = this.createErrorElement(null, USER_NOT_FOUND);
            modelAndView.addObject((Object)err);
            response.setStatus(409);
            logger.trace(EMPTY_RESULT_DATA_ACCESS_EXCEPTION + (Object)((Object)e));
            logger.error(EMPTY_RESULT_DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (DataAccessException e) {
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
            logger.trace(DATA_ACCESS_EXCEPTION + (Object)((Object)e));
            logger.error(DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (BaseException e) {
            ErrorElement err = this.createErrorElement(e.getErrorCode(), null);
            modelAndView.addObject((Object)err);
            response.setStatus(400);
            logger.trace(BASE_EXCEPTION + (Object)((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
        }
        return modelAndView;
    }

    private UserElement getUserElement(String userName, Cloud cloud) {
        String cloudName = cloud.getCloudName();
        int cloudId = cloud.getCloudId();
        logger.debug("....userName..." + userName);
        UserElement ue = this.managementService.getUserByUserNameOrEmail(cloud, userName);
        if (ue == null && this.isAADEnabled(cloud.getCloudCustomisableDetails())) {
            logger.debug("....userName..." + userName);
            ue = this.managementService.getUserByAADLoginId(cloud, userName);
        }
        List list = cloud.getCloudCustomisableDetails();
        if (cloud.getContentSearchEnabled() == 1) {
            ue.setSearchEnabled(true);
        }
        boolean isODBUserLevelAcctEnabled = this.isODBUserLevelAcctEnabled(list);
        boolean isGDServiceAcctEnabled = this.isGDServiceAcctEnabled(list);
        logger.debug(" customizable details ............... " + list.size());
        list.removeAll(Collections.singleton(null));
        for (CloudCustomisableDetails customisableDetails : list) {
            List<PciAuthorizationTokens> authorizationTokens;
            PciAuthorizationTokens pciAuthorizationTokens;
            if ("PMS Enabled".equalsIgnoreCase(customisableDetails.getName())) {
                ue.setPmsEnabled(true);
            }
            if ("Report Enabled".equalsIgnoreCase(customisableDetails.getName())) {
                ue.setReportEnabled(true);
            }
            if ("Migrationtool Enabled".equalsIgnoreCase(customisableDetails.getName())) {
                ue.setMigrationToolEnabled(true);
            }
            if ("Support Enabled".equalsIgnoreCase(customisableDetails.getName())) {
                ue.setSupportEnabled(true);
            }
            if ("Shared Enabled".equalsIgnoreCase(customisableDetails.getName())) {
                ue.setShareEnabled(true);
            }
            if ("LDAP Enabled".equalsIgnoreCase(customisableDetails.getName())) {
                ue.setLdapEnabled(true);
            }
            if (BACK_UP_ENABLED.equalsIgnoreCase(customisableDetails.getName()) && ue.isBackupEnabled()) {
                ue.setBackupEnabled(true);
            }
            if (BACK_UP_ENABLED.equalsIgnoreCase(customisableDetails.getName())) {
                ue.setBackupWebAccessEnabled(true);
            }
            if (SYNC_ENABLED.equalsIgnoreCase(customisableDetails.getName()) && ue.isSyncEnabled()) {
                ue.setSyncEnabled(true);
            }
            if (SYNC_ENABLED.equalsIgnoreCase(customisableDetails.getName())) {
                ue.setSyncWebAccessEnabled(true);
            }
            if ("AzureBlob Enabled".equalsIgnoreCase(customisableDetails.getName())) {
                ue.setAzureBlobEnabled(true);
            }
            if ("Server Backup Enabled".equalsIgnoreCase(customisableDetails.getName())) {
                ue.setServerBackupEnabled(true);
            }
            if ("OneDrive Backup Enabled".equalsIgnoreCase(customisableDetails.getName()) && ue.isOnedriveBkpEnabled()) {
                ue.setOnedriveBkpEnabled(true);
            }
            if (ODB_ENABLED.equals(customisableDetails.getName())) {
                pciAuthorizationTokens = null;
                if (isODBUserLevelAcctEnabled) {
                    pciAuthorizationTokens = this.pciAuthorizationTokensService.getPciAuthorizationTokensForUserId(cloudId, cloudName, ue.getUserId());
                } else {
                    authorizationTokens = this.pciAuthorizationTokensService.getAllPciAuthorizationTokens(cloudId, cloudName);
                    if (!CollectionUtils.isEmpty(authorizationTokens)) {
                        pciAuthorizationTokens = authorizationTokens.get(0);
                    }
                }
                if (pciAuthorizationTokens != null) {
                    ue.setExternalStorageAuthorized(false);
                } else {
                    ue.setExternalStorageAuthorized(true);
                }
            }
            if (GD_ENABLED.equals(customisableDetails.getName())) {
                pciAuthorizationTokens = null;
                if (isGDServiceAcctEnabled) {
                    authorizationTokens = this.pciAuthorizationTokensService.getAllPciAuthorizationTokens(cloudId, cloudName);
                    if (!CollectionUtils.isEmpty(authorizationTokens)) {
                        pciAuthorizationTokens = authorizationTokens.get(0);
                    }
                } else {
                    pciAuthorizationTokens = this.pciAuthorizationTokensService.getPciAuthorizationTokensForUserId(cloudId, cloudName, ue.getUserId());
                }
                if (pciAuthorizationTokens != null) {
                    ue.setExternalStorageAuthorized(false);
                } else {
                    ue.setExternalStorageAuthorized(true);
                }
            }
            if (!"OneDrive Backup Enabled".equals(customisableDetails.getName())) continue;
            String accessToken = this.pciAuthorizationTokensService.getAccessTokenForODBBackup(cloudId);
            if (!org.springframework.util.StringUtils.isEmpty((Object)accessToken)) {
                ue.setOffice365BkpEnabled(false);
                continue;
            }
            ue.setOffice365BkpEnabled(true);
        }
        logger.debug(" after license........ " + ue.isExternalStorageAuthorized());
        return ue;
    }

    private boolean isODBUserLevelAcctEnabled(List<CloudCustomisableDetails> list) {
        boolean isODBUserLevelAcctEnabled = false;
        for (CloudCustomisableDetails customisableDetails : list) {
            if (!"ODB User Level Enabled".equals(customisableDetails.getName())) continue;
            isODBUserLevelAcctEnabled = true;
            break;
        }
        return isODBUserLevelAcctEnabled;
    }

    private boolean isGDServiceAcctEnabled(List<CloudCustomisableDetails> list) {
        boolean isGDServiceAcctEnabled = false;
        for (CloudCustomisableDetails customisableDetails : list) {
            if (!GD_SERVICE_ENABLED.equals(customisableDetails.getName())) continue;
            isGDServiceAcctEnabled = true;
            break;
        }
        return isGDServiceAcctEnabled;
    }

    @RequestMapping(value={"cloud/{cloudName}/user/admin/{userName}/"}, method={RequestMethod.POST})
    public ModelAndView createFirstTimeAdminUser(@PathVariable(value="cloudName") String cloudName1, @RequestBody UserElement userElement, @PathVariable(value="userName") String userName, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        logger.debug("calling /createFirstTimeAdminUser ...");
        UserElement ue = null;
        try {
            if (!org.springframework.util.StringUtils.hasText((String)userElement.getUserName()) || !org.springframework.util.StringUtils.hasText((String)userName)) {
                throw new BaseException(USER_NAME_NOT_FOUND);
            }
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            userElement.setAdmin(true);
            userElement.setUserNameLowerCase(userElement.getUserName().toLowerCase());
            List<UserElement> userList = this.managementService.getAllUsers(cloudId, cloudName);
            if (userList != null && !userList.isEmpty()) {
                modelAndView.addObject(null);
                response.setStatus(401);
                return null;
            }
            logger.debug(userElement.getOdbPolicyName() + " CREATE USER IS SHARE ENABLED .. " + userElement.isShareEnabled());
            ue = this.managementService.createUser(cloudId, cloudName, userElement, "");
            List list = cl.getCloud().getCloudCustomisableDetails();
            for (CloudCustomisableDetails customisableDetails : list) {
                ue.setExternalStorageAuthorized(false);
                if (!customisableDetails.getName().equals(ODB_ENABLED)) continue;
                PciAuthorizationTokens pciAuthorizationTokens = this.pciAuthorizationTokensService.getPciAuthorizationTokensForUserId(cloudId, cloudName, ue.getUserId());
                if (pciAuthorizationTokens != null) {
                    ue.setExternalStorageAuthorized(false);
                    continue;
                }
                ue.setExternalStorageAuthorized(true);
            }
            modelAndView.addObject((Object)ue);
            response.setStatus(201);
            this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "created  a new user", userName, userElement.getUserName(), "ParaBlu", System.currentTimeMillis(), PCActionTypes.USER_CREATE.getActionTypeValue());
        }
        catch (DataIntegrityViolationException e) {
            ErrorElement err = this.createErrorElement(null, USER_ALREADY_EXISTS);
            modelAndView.addObject((Object)err);
            response.setStatus(409);
            logger.trace(DATA_INSTEGRITY_VIOLATION_EXCEPTION + (Object)((Object)e));
            logger.error(DATA_INSTEGRITY_VIOLATION_EXCEPTION + e.getMessage());
        }
        catch (DataAccessException e) {
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
            logger.trace(DATA_ACCESS_EXCEPTION + (Object)((Object)e));
            logger.error(DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (BaseException e) {
            ErrorElement err = this.createErrorElement(e.getErrorCode(), null);
            modelAndView.addObject((Object)err);
            response.setStatus(400);
            logger.trace(BASE_EXCEPTION + (Object)((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
        }
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/user/{userName}/"}, method={RequestMethod.POST})
    public ModelAndView createUser(@PathVariable(value="cloudName") String cloudName1, @RequestBody UserElement userElement, @PathVariable(value="userName") String userName, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        logger.debug(userElement.getOdbPolicyName() + "..calling /createUser ..." + userElement.isOnedriveBkpEnabled());
        UserElement ue = null;
        User currentUser = new User();
        try {
            String token;
            if (!org.springframework.util.StringUtils.hasText((String)userElement.getUserName()) || !org.springframework.util.StringUtils.hasText((String)userName)) {
                throw new BaseException(USER_NAME_NOT_FOUND);
            }
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), currentUser, response)) {
                return null;
            }
            if (!currentUser.isAdmin()) {
                response.setStatus(401);
                return null;
            }
            int code = this.deviceAndUserSecurityService.validateUserRestrictions(cloudId, cloudName, cl.getCloud());
            if (!this.checkLicense(code, response)) {
                return null;
            }
            if (userElement.isSyncEnabled() && !this.checkLicense(code = this.deviceAndUserSecurityService.validateSyncUserRestrictions(cloudId, cloudName, cl.getCloud()), response)) {
                return null;
            }
            if ((userElement.isBackupEnabled() || userElement.isServerBackupEnabled()) && !this.checkLicense(code = this.deviceAndUserSecurityService.validateBackupUserRestrictions(cloudId, cloudName, cl.getCloud()), response)) {
                return null;
            }
            List<UserElement> elements = this.managementService.getAllUsers(cloudId, cloudName);
            List<DeletedUser> deletedUsers = this.managementService.getAllDeletedUsers(cloudId, cloudName);
            ArrayList<ObjectId> userIds = new ArrayList<ObjectId>();
            for (DeletedUser deletedUser : deletedUsers) {
                userIds.add(deletedUser.getUserId());
            }
            List<UserElement> deletedUserElements = this.managementService.getAllDeletedUsersById(cloudId, cloudName, userIds);
            elements.addAll(deletedUserElements);
            for (UserElement element : deletedUserElements) {
                if (!element.getUserName().equalsIgnoreCase(userElement.getUserName())) continue;
                response.setStatus(409);
                response.setHeader("deleted-user", "true");
                return null;
            }
            for (UserElement u : elements) {
                if (u == null || org.springframework.util.StringUtils.isEmpty((Object)u.getEmailId()) || org.springframework.util.StringUtils.isEmpty((Object)userElement.getEmailId())) continue;
                if (u.getEmailId().equalsIgnoreCase(userElement.getEmailId())) {
                    response.setStatus(412);
                    return null;
                }
                if (!u.getUserName().equalsIgnoreCase(userElement.getUserName()) && !u.getEmailId().equalsIgnoreCase(userElement.getUserName())) continue;
                response.setStatus(409);
                return null;
            }
            logger.debug(" CREATE USER IS SHARE ENABLED .. " + userElement.isShareEnabled());
            ue = this.managementService.createUser(cloudId, cloudName, userElement, currentUser.getUserName());
            MiniCloudElementList miniCloudElementList = userElement.getMiniCloudElementList();
            List miniCloudElements = miniCloudElementList.getMiniClouds();
            this.miniCloudAccessControlService.createAccessControlMapping(cloudId, cloudName, userElement.getUserName(), miniCloudElements);
            ue.setMiniCloudElementList(miniCloudElementList);
            List list = cl.getCloud().getCloudCustomisableDetails();
            for (CloudCustomisableDetails customisableDetails : list) {
                ue.setExternalStorageAuthorized(false);
                if (!customisableDetails.getName().equals(ODB_ENABLED)) continue;
                PciAuthorizationTokens pciAuthorizationTokens = this.pciAuthorizationTokensService.getPciAuthorizationTokensForUserId(cloudId, cloudName, ue.getUserId());
                if (pciAuthorizationTokens != null) {
                    ue.setExternalStorageAuthorized(false);
                    continue;
                }
                ue.setExternalStorageAuthorized(true);
            }
            modelAndView.addObject((Object)ue);
            response.setStatus(201);
            this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "created  a new user", userName, userElement.getUserName(), "Portal", System.currentTimeMillis(), PCActionTypes.USER_CREATE.getActionTypeValue());
        }
        catch (DataIntegrityViolationException e) {
            ErrorElement err = this.createErrorElement(null, USER_ALREADY_EXISTS);
            modelAndView.addObject((Object)err);
            response.setStatus(409);
            logger.trace("calling /createUser  DataIntegrityViolationException access ..." + (Object)((Object)e));
        }
        catch (DataAccessException e) {
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
            logger.trace("calling /createUser  data access ..." + (Object)((Object)e));
        }
        catch (BaseException e) {
            ErrorElement err = this.createErrorElement(e.getErrorCode(), null);
            modelAndView.addObject((Object)err);
            response.setStatus(400);
            logger.trace("calling /createUser  BaseException access ..." + (Object)((Object)e));
        }
        return modelAndView;
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/users/create/"}, method={RequestMethod.POST})
    public ModelAndView createMultipleUser(@PathVariable(value="cloudName") String cloudName1, @RequestBody UserListElement userElementList, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        logger.debug("/users/create/ ...");
        User currentUser = new User();
        int totalUsersCount = userElementList.getUserList().size();
        int totalUsersCreated = 0;
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), currentUser, response)) {
                return null;
            }
            long noOfUsersAllowed = (long)cl.getCloud().getNoOfUsersAllowed() - this.managementService.countOfPresentUsers(cloudId);
            if (noOfUsersAllowed < (long)totalUsersCount) {
                response.setHeader("no-of-possible-users", Long.toString(noOfUsersAllowed));
                response.setStatus(417);
                return null;
            }
            List<UserErrorReponse> responseUserElement = this.managementService.createMultipleUsers(cl.getCloud(), userElementList, currentUser.getUserName());
            for (UserErrorReponse ueErrorReponse : responseUserElement) {
                if (!ueErrorReponse.getErrorMessage().equalsIgnoreCase("User created")) continue;
                ++totalUsersCreated;
            }
            if (totalUsersCount == totalUsersCreated) {
                response.setStatus(201);
            } else if (totalUsersCreated == 0) {
                response.setStatus(400);
            } else {
                response.setHeader("totalUsersCount", String.valueOf(totalUsersCount));
                response.setHeader("totalUsersCreated", String.valueOf(totalUsersCreated));
                response.setStatus(206);
            }
            modelAndView.addObject(responseUserElement);
        }
        catch (Exception e) {
            e.printStackTrace();
            ErrorElement err = this.createErrorElement(EXCEPTION, null);
            modelAndView.addObject((Object)err);
            response.setStatus(417);
            logger.debug("calling /createUser Exception ..." + e);
        }
        return modelAndView;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(value={"cloud/{cloudName}/user/update/{userName}/"}, method={RequestMethod.PUT})
    public ModelAndView updateUserInformation(@PathVariable(value="cloudName") String cloudName1, @RequestBody UserElement userElement, @PathVariable(value="userName") String userName, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        User currentUser = new User();
        logger.debug(userElement.getOdbLoginId() + "...calling /user/update/  ..." + userName + " update user sync enabled ..:" + userElement.isSyncEnabled() + "user sync web access enabled.." + userElement.isSyncWebAccessEnabled());
        try {
            boolean userUnderLegalHold;
            int code;
            String token;
            if (userElement == null) throw new BaseException(INVALID_REQUEST);
            if (!org.springframework.util.StringUtils.hasText((String)(userElement.getUserId() + ""))) throw new BaseException(INVALID_REQUEST);
            if (!org.springframework.util.StringUtils.hasText((String)userElement.getUserName())) throw new BaseException(INVALID_REQUEST);
            if (!org.springframework.util.StringUtils.hasText((String)userName)) {
                throw new BaseException(INVALID_REQUEST);
            }
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), currentUser, response)) {
                return null;
            }
            User user = this.managementService.getUserDetails(cloudId, cloudName, userElement.getUserName());
            boolean emailAlreadyExists = false;
            boolean adEmailAlreadyExists = false;
            if (org.springframework.util.StringUtils.isEmpty((Object)user.getEmailId()) || !user.getEmailId().equalsIgnoreCase(userElement.getEmailId())) {
                if (!user.getlocalUser() && org.springframework.util.StringUtils.isEmpty((Object)userElement.getEmailId())) {
                    Person person = this.ldapService.getUserByEmail(userElement.getUserName());
                    if (person == null) {
                        logger.debug("Email Id is empty .............");
                        response.setStatus(206);
                        return null;
                    }
                    logger.error(" userName is not part of domain........................");
                    adEmailAlreadyExists = this.managementService.checkIfEmailAlreadyExists(cloudId, person.getEmailId());
                    if (adEmailAlreadyExists) {
                        logger.debug("Email Id is empty ..........");
                        response.setStatus(206);
                        return null;
                    }
                    userElement.setEmailId(person.getEmailId());
                }
                emailAlreadyExists = this.managementService.checkIfEmailAlreadyExists(cloudId, userElement.getEmailId());
            }
            if (emailAlreadyExists) {
                logger.error(" Email already exists ...... " + userElement.getEmailId());
                response.setStatus(412);
                return null;
            }
            if (!user.isSyncEnabled() && userElement.isSyncEnabled() && !this.checkLicense(code = this.deviceAndUserSecurityService.validateSyncUserRestrictions(cloudId, cloudName, cl.getCloud()), response)) {
                return null;
            }
            if (!user.isBackupEnabled() && userElement.isBackupEnabled() && !this.checkLicense(code = this.deviceAndUserSecurityService.validateBackupUserRestrictions(cloudId, cloudName, cl.getCloud()), response)) {
                response.setStatus(403);
                return null;
            }
            if (!user.isOnedriveBkpEnabled() && userElement.isOnedriveBkpEnabled() && !this.checkLicense(code = this.deviceAndUserSecurityService.validateO365BackupUserRestrictions(cloudId, cloudName, cl.getCloud()), response)) {
                response.setStatus(428);
                return null;
            }
            code = this.deviceAndUserSecurityService.validateUserRestrictions(cloudId, cloudName, cl.getCloud());
            if (!user.isActive() && code == 1503) {
                response.setStatus(417);
                return null;
            }
            if ((userElement.isAdmin() || userElement.isReadOnlyAdmin()) && (userUnderLegalHold = this.managementService.isUserUnderLegalHoldForUserName(cloudId, userElement.getUserName()))) {
                response.setStatus(447);
                return null;
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)user.getCreatedTimestamp())) {
                userElement.setCreatedTimestamp(user.getCreatedTimestamp());
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)user.getLastLoggedInTime())) {
                userElement.setLastLoggedInTime(user.getLastLoggedInTime());
            }
            logger.debug("userElement backup policy name:" + userElement.getPolicyName());
            logger.debug("userElement sync policy name:" + userElement.getSyncPolicyName());
            UserElement ue = this.managementService.updateUserInfo(cloudId, cloudName, userElement);
            if (!userElement.isBackupEnabled() && !userElement.isSyncEnabled()) {
                this.authorizationService1.deleteAllDeviceTokens(cloudId, cloudName, user);
            } else {
                List<DeviceElement> list = this.deviceManagementService.getDevicesForUser(cloudId, cloudName, userElement.getUserName());
                if (!CollectionUtils.isEmpty(list)) {
                    for (DeviceElement deviceElement : list) {
                        String deviceUUID = deviceElement.getDeviceUUID();
                        AuthorizationTokens authorizationTokens = this.authorizationService1.getAuthorizationTokenForDeviceUUID(cloudId, cloudName, deviceUUID);
                        if (authorizationTokens != null) continue;
                        this.createNewAuthorizationToken(cloudId, cloudName, user, deviceUUID);
                    }
                }
            }
            modelAndView.addObject((Object)ue);
            response.setStatus(200);
            this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "edited the details of user", userName, userElement.getUserName(), "Portal", System.currentTimeMillis(), PCActionTypes.USER_UPDATE.getActionTypeValue());
            logger.debug("end of calling /user/update/  ...");
            return modelAndView;
        }
        catch (EmptyResultDataAccessException e) {
            logger.trace(EMPTY_RESULT_DATA_ACCESS_EXCEPTION + (Object)((Object)e));
            logger.error(EMPTY_RESULT_DATA_ACCESS_EXCEPTION + e.getMessage());
            ErrorElement err = this.createErrorElement(null, USER_NOT_FOUND);
            modelAndView.addObject((Object)err);
            response.setStatus(409);
            return modelAndView;
        }
        catch (DataAccessException e) {
            logger.trace(DATA_ACCESS_EXCEPTION + (Object)((Object)e));
            logger.error(DATA_ACCESS_EXCEPTION + e.getMessage());
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
            return modelAndView;
        }
        catch (BaseException e) {
            logger.trace(BASE_EXCEPTION + (Object)((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
            ErrorElement err = this.createErrorElement(e.getErrorCode(), null);
            modelAndView.addObject((Object)err);
            response.setStatus(400);
            return modelAndView;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
        }
        return modelAndView;
    }

    private void createNewAuthorizationToken(int cloudId, String cloudName, User user, String deviceUUID) {
        AuthorizationTokens newAuthorizationTokens = new AuthorizationTokens();
        newAuthorizationTokens.setValiditoryPeriod(-10L);
        newAuthorizationTokens.setUniqueId(deviceUUID);
        newAuthorizationTokens.setModifiedTime(System.currentTimeMillis());
        newAuthorizationTokens.setToken(TokenGenerator.generateToken());
        newAuthorizationTokens.setUser(user);
        newAuthorizationTokens.setClientType(1);
        this.authorizationService1.addTokenOrUpdate(cloudId, cloudName, newAuthorizationTokens);
    }

    @RequestMapping(value={"cloud/{cloudName}/user/block/{userName}/"}, method={RequestMethod.POST})
    public ModelAndView blockUser(@PathVariable(value="cloudName") String cloudName1, @PathVariable(value="userName") String userName, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        logger.debug(CALLING_UPDATE_USER_INFO + userName);
        String blockedBy = request.getHeader(USER_NAME);
        try {
            int code;
            if (!org.springframework.util.StringUtils.hasText((String)userName)) {
                throw new BaseException(INVALID_REQUEST);
            }
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            boolean active = Boolean.parseBoolean(request.getHeader("blocked"));
            if (!this.performAuthorization(cloudId, cloudName, token, response)) {
                return null;
            }
            UserElement userElement = this.managementService.getUserInfo(cloudId, cloudName, userName);
            boolean isUserActive = userElement.isActive();
            if (active && !this.checkLicense(code = this.deviceAndUserSecurityService.validateUserRestrictions(cloudId, cloudName, cl.getCloud()), response)) {
                return null;
            }
            userElement.setActive(active);
            UserElement ue = this.managementService.updateUserInfo(cloudId, cloudName, userElement);
            modelAndView.addObject((Object)ue);
            response.setStatus(200);
            List<User> users = this.managementService.getAllAdmins(cloudId, cloudName);
            logger.debug("sending email: " + this.cloudMailService);
            HashMap<String, String> recipents = new HashMap<String, String>();
            recipents.put(ue.getUserName(), ue.getEmailId());
            for (User u : users) {
                recipents.put(u.getUserName(), u.getEmailId());
            }
            if (active && !isUserActive) {
                this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "unblocked user", blockedBy, userElement.getUserName(), "Portal", System.currentTimeMillis(), PCActionTypes.USER_UNBLOCK.getActionTypeValue());
            } else if (isUserActive) {
                List<Device> blockedDevices = this.managementService.blockUnblockDevicebyUserName(cloudId, cloudName, userName, true);
                this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "blocked user", blockedBy, userElement.getUserName(), "Portal", System.currentTimeMillis(), PCActionTypes.USER_BLOCK.getActionTypeValue());
                if (blockedDevices != null) {
                    for (Device device : blockedDevices) {
                        this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "blocked Device:" + device.getDeviceName() + " of User:", blockedBy, userElement.getUserName(), "Portal", System.currentTimeMillis(), PCActionTypes.DEVICE_BLOCK.getActionTypeValue());
                    }
                }
            }
        }
        catch (EmptyResultDataAccessException e) {
            ErrorElement err = this.createErrorElement(null, USER_NOT_FOUND);
            modelAndView.addObject((Object)err);
            response.setStatus(409);
            logger.trace(EMPTY_RESULT_DATA_ACCESS_EXCEPTION + (Object)((Object)e));
            logger.error(EMPTY_RESULT_DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (DataAccessException e) {
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
            logger.trace(DATA_ACCESS_EXCEPTION + (Object)((Object)e));
            logger.error(DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (BaseException e) {
            ErrorElement err = this.createErrorElement(e.getErrorCode(), null);
            modelAndView.addObject((Object)err);
            response.setStatus(400);
            logger.trace(BASE_EXCEPTION + (Object)((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
        }
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/users/block/"}, method={RequestMethod.POST})
    public void blockMultipleUser(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        String userNames = request.getHeader("userNames");
        logger.debug(CALLING_UPDATE_USER_INFO + userNames);
        String blockedBy = request.getHeader("blockedBy");
        try {
            int code;
            if (!org.springframework.util.StringUtils.hasText((String)userNames)) {
                throw new BaseException(INVALID_REQUEST);
            }
            ArrayList<String> userNameList = new ArrayList<String>(Arrays.asList(userNames.split(",")));
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            boolean active = Boolean.parseBoolean(request.getHeader("active"));
            if (!this.performAuthorization(cloudId, cloudName, token, response)) {
                return;
            }
            if (active && !this.checkLicense(code = this.deviceAndUserSecurityService.validateUserRestrictions(cloudId, cloudName, cl.getCloud()), response)) {
                return;
            }
            if (userNameList.contains(blockedBy)) {
                userNameList.remove(blockedBy);
            }
            for (String userName : userNameList) {
                this.blockOrUnblockUser(cloudName, userName, response, modelAndView, blockedBy, cloudId, active);
            }
        }
        catch (EmptyResultDataAccessException e) {
            ErrorElement err = this.createErrorElement(null, USER_NOT_FOUND);
            modelAndView.addObject((Object)err);
            response.setStatus(409);
            logger.trace(EMPTY_RESULT_DATA_ACCESS_EXCEPTION + (Object)((Object)e));
            logger.error(EMPTY_RESULT_DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (DataAccessException e) {
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
            logger.trace(DATA_ACCESS_EXCEPTION + (Object)((Object)e));
            logger.error(DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (BaseException e) {
            ErrorElement err = this.createErrorElement(e.getErrorCode(), null);
            modelAndView.addObject((Object)err);
            response.setStatus(400);
            logger.trace(BASE_EXCEPTION + (Object)((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
        }
    }

    private UserElement blockOrUnblockUser(String cloudName, String userName, HttpServletResponse response, ModelAndView modelAndView, String blockedBy, int cloudId, boolean active) {
        UserElement userElement = this.managementService.getUserInfo(cloudId, cloudName, userName);
        if (userElement != null) {
            boolean isUserActive = userElement.isActive();
            userElement.setActive(active);
            this.managementService.updateUserInfo(cloudId, cloudName, userElement);
            response.setStatus(200);
            if (active && !isUserActive) {
                this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "unblocked user", blockedBy, userElement.getUserName(), "Portal", System.currentTimeMillis(), PCActionTypes.USER_UNBLOCK.getActionTypeValue());
            } else if (isUserActive) {
                List<Device> blockedDevices = this.managementService.blockUnblockDevicebyUserName(cloudId, cloudName, userName, true);
                this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "blocked user", blockedBy, userElement.getUserName(), "Portal", System.currentTimeMillis(), PCActionTypes.USER_BLOCK.getActionTypeValue());
                if (blockedDevices != null) {
                    for (Device device : blockedDevices) {
                        this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "blocked Device:" + device.getDeviceName() + " of User:", blockedBy, userElement.getUserName(), "Portal", System.currentTimeMillis(), PCActionTypes.DEVICE_BLOCK.getActionTypeValue());
                    }
                }
                return userElement;
            }
        }
        return null;
    }

    @RequestMapping(value={"cloud/{cloudName}/user/{userId}/{userName}/"}, method={RequestMethod.DELETE})
    public ModelAndView deleteUser(@PathVariable(value="cloudName") String cloudName1, @PathVariable(value="userId") String userId, @PathVariable(value="userName") String userName, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        logger.debug("calling /deleteUser ...");
        try {
            String token;
            if (!org.springframework.util.StringUtils.hasText((String)userId) || !org.springframework.util.StringUtils.hasText((String)userName)) {
                throw new BaseException(INVALID_REQUEST);
            }
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName = cl.getCloud().getCloudName(), token = request.getHeader("token"), response)) {
                return null;
            }
            boolean userUnderLegalHold = this.managementService.isUserUnderLegalHoldForUserName(cloudId, userName);
            if (userUnderLegalHold) {
                response.setStatus(447);
                return null;
            }
            UserElement userElement = this.managementService.deleteUser(cloudId, cloudName, userId);
            this.setSuccessResponseFields(response);
            this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "deleted user", userName, userElement.getUserName(), "Portal", System.currentTimeMillis(), PCActionTypes.USER_DELETE.getActionTypeValue());
            return null;
        }
        catch (EmptyResultDataAccessException e) {
            ErrorElement err = this.createErrorElement(null, USER_NOT_FOUND);
            modelAndView.addObject((Object)err);
            response.setStatus(409);
            logger.trace(EMPTY_RESULT_DATA_ACCESS_EXCEPTION + (Object)((Object)e));
            logger.error(EMPTY_RESULT_DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (DataAccessException e) {
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
            logger.trace(DATA_ACCESS_EXCEPTION + (Object)((Object)e));
            logger.error(DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (BaseException e) {
            ErrorElement err = this.createErrorElement(e.getErrorCode(), e.getMessage());
            modelAndView.addObject((Object)err);
            response.setStatus(400);
            logger.trace(BASE_EXCEPTION + (Object)((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
        }
        return modelAndView;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(value={"cloud/{cloudName}/authenthicate"}, method={RequestMethod.GET})
    public ModelAndView authenticate(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        UserElement userElement = new UserElement();
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        logger.debug("calling /authenticate ...");
        response.setHeader(ACCESS_CONTROL_ALLOW_ORIGIN, "*");
        response.setHeader(ACCESS_CONTROL_ALLOW_METHODS, POST_GET_OPTIONS_DELETE);
        response.setHeader(ACCESS_CONTROL_MAX_AGE, "3600");
        response.setHeader(ACCESS_CONTROL_ALLOW_HEADERS, X_REQUESTED_WITH_FIRST_LOGIN_TOKEN);
        String client = "";
        int cloudId = 0;
        String ip = request.getHeader("ip");
        String osType = request.getHeader(OS_TYPE);
        String browser = request.getHeader(BROWSER);
        String hostIPDomain = "";
        logger.debug(" ip ostype, browser ................... " + ip + ".. " + osType + "...." + browser);
        if (!(org.springframework.util.StringUtils.isEmpty((Object)ip) && org.springframework.util.StringUtils.isEmpty((Object)osType) && org.springframework.util.StringUtils.isEmpty((Object)browser))) {
            hostIPDomain = " from the  ip address " + ip + " using the domain Name " + browser + " and the OS Type was  " + osType;
        }
        try {
            String decryptedPwd;
            String token;
            AADUserElement aadUserByCode;
            int clientType;
            Cloud cloud;
            CloudLicenseTo cl;
            String deviceName;
            String password;
            block37: {
                password = request.getHeader(PASSWORD);
                deviceName = request.getHeader(DEVICE_NAME);
                client = request.getHeader(CLIENT_TYPE);
                String username = request.getHeader(USER_NAME);
                cl = this.licenseService.validateLicense(cloudName);
                if (!this.checkLicense(cl, response)) {
                    logger.debug("@@@ Inside authenticated invalid license ...");
                    return null;
                }
                cloud = cl.getCloud();
                cloudName = cloud.getCloudName();
                if (client != null) {
                    logger.debug("@@@ Inside client selection ...." + client);
                    clientType = PCClientTypes.getClientType((String)client);
                } else {
                    client = PORTAL;
                    clientType = PCClientTypes.getClientType((String)client);
                }
                cloudId = cloud.getCloudId();
                aadUserByCode = null;
                if (this.isAADEnabled(cl.getCloud().getCloudCustomisableDetails()) && org.springframework.util.StringUtils.isEmpty((Object)password)) {
                    String aadAuthCode = request.getHeader("aadAuthCode");
                    if (org.springframework.util.StringUtils.isEmpty((Object)aadAuthCode)) {
                        logger.debug("Password and auth code is empty...");
                        response.setStatus(400);
                        return null;
                    }
                    String redirectUrlFromHeader = request.getHeader("redirectHost");
                    aadUserByCode = this.aadManagementService.getAADUserByCode(aadAuthCode, cl.getCloud(), true, redirectUrlFromHeader);
                    if (aadUserByCode == null) {
                        logger.debug("Failed to get aad user using aadAuthCode :" + aadAuthCode);
                        response.setStatus(440);
                        return null;
                    }
                    logger.debug("Got AAD user form aadAuthCode " + aadUserByCode.getUserPrincipalName());
                    username = aadUserByCode.getUserPrincipalName();
                }
                token = null;
                if (org.springframework.util.StringUtils.isEmpty((Object)username)) {
                    response.setStatus(400);
                    return null;
                }
                try {
                    decryptedPwd = this.getDecryptePassword(password);
                    logger.debug("checking for user info>>>>>>>>>>if not migrate from AD..........");
                    userElement = this.managementService.getUserByUserName(cloud, username);
                    if (this.isAADEnabled(cloud.getCloudCustomisableDetails()) && userElement == null) {
                        logger.debug("AAD enable and user is null for userName " + username + " so check with field aadLoginId");
                        userElement = this.managementService.getUserByAADLoginId(cloud, username);
                    }
                    if (userElement != null) {
                        logger.debug("user exists ........ " + userElement.getUserName());
                        if (userElement.isSuspended()) {
                            logger.debug("User is suspended.....");
                            response.setStatus(451);
                            return null;
                        }
                        break block37;
                    }
                    if (this.isAADEnabled(cloud.getCloudCustomisableDetails())) {
                        try {
                            boolean success = false;
                            success = aadUserByCode == null ? this.migrateUserFromAAD(username, decryptedPwd, cl, cloud, cloudName, response) : this.migrateUserFromAAD(aadUserByCode, cl, cl.getCloud(), cloudName, response);
                            if (!success) {
                                logger.error(" Authentication failed form AAD for user " + username + "............");
                                response.setStatus(440);
                                return null;
                            }
                            userElement = this.managementService.getUserByUserNameOrEmail(cloud, username);
                            break block37;
                        }
                        catch (BaseException e) {
                            logger.debug("Exception :" + e.getMessage());
                            response.setStatus(417);
                            return null;
                        }
                    }
                    if (!this.isLdapEnabledForCloud(cl)) break block37;
                    try {
                        boolean success = this.checkWithADandMigrateUser(cl, cloudId, cloudName, username, response);
                        if (!success) {
                            logger.error(" Authentication failed  for user " + username + "............");
                            return null;
                        }
                        userElement = this.managementService.getUserByUserName(cloud, username);
                    }
                    catch (BaseException e) {
                        logger.debug("Exception :" + e.getMessage());
                        response.setStatus(417);
                        return null;
                    }
                }
                catch (Exception exception) {
                    logger.trace(BASE_EXCEPTION + exception);
                    logger.error("@@@ Inside authentication BaseException..." + exception.getMessage());
                    response.setStatus(400);
                    return null;
                }
            }
            decryptedPwd = this.getDecryptePassword(password);
            if (org.springframework.util.StringUtils.isEmpty((Object)userElement.getPasswdHash())) {
                boolean isAuthenticated = false;
                if (this.isAADEnabled(cloud.getCloudCustomisableDetails())) {
                    if (aadUserByCode == null) {
                        isAuthenticated = this.authenticateAADUser(cl.getCloud(), userElement, decryptedPwd);
                    } else {
                        logger.debug("Since AAD login happen using code no need to authenticate...");
                        isAuthenticated = true;
                    }
                } else if (this.isLdapEnabledForCloud(cl)) {
                    Object[] objArr = this.ldapService.authenticate(userElement.getUserName(), decryptedPwd);
                    isAuthenticated = (Boolean)objArr[0];
                }
                if (!isAuthenticated) {
                    response.setStatus(400);
                    this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, " login failed from " + client + hostIPDomain, userElement.getUserName(), "", "", System.currentTimeMillis(), PCActionTypes.LOGIN.getActionTypeValue());
                    return null;
                }
                UserElement ue = this.getUserElement(userElement.getUserName(), cloud);
                logger.debug(" USer authenticated .... " + userElement.getUserName() + ".... is active ...." + ue.isActive());
                if (!ue.isActive()) {
                    throw new BaseException("User is not active", 403);
                }
                client = org.springframework.util.StringUtils.isEmpty((Object)client) || client.equalsIgnoreCase(PORTAL) ? PORTAL : client.toLowerCase();
                UUID uuid = UUID.randomUUID();
                token = String.valueOf(uuid);
                logger.debug(token + " addTokenByUser  .... " + client);
                this.authorizationService1.addTokenByUser(cloudId, cloudName, token, userElement.getUserName(), clientType);
                this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, LOGGED_INTO + client + hostIPDomain, userElement.getUserName(), "", deviceName, System.currentTimeMillis(), PCActionTypes.LOGIN.getActionTypeValue());
                logger.debug(GET_USER_INFO_BACKUP_ENABLED + ue.isBackupEnabled());
                modelAndView.addObject((Object)ue);
                this.managementService.updateUserLoggedInTime(cloudId, userElement.getUserName());
            } else {
                String passwordHash = this.generatePassWordhash(decryptedPwd);
                User u = this.managementService.authenticate(cloudId, cloudName, userElement.getUserName(), passwordHash);
                client = org.springframework.util.StringUtils.isEmpty((Object)client) || client.equalsIgnoreCase(PORTAL) ? PORTAL : client.toLowerCase();
                this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, LOGGED_INTO + client + hostIPDomain, userElement.getUserName(), "", deviceName, System.currentTimeMillis(), PCActionTypes.LOGIN.getActionTypeValue());
                UUID uuid = UUID.randomUUID();
                token = String.valueOf(uuid);
                this.authorizationService1.addTokenByUser(cloudId, cloudName, token, userElement.getUserName(), clientType);
                if (u.isFirstLogin()) {
                    response.setHeader("firstLogin", "true");
                    u.setFirstLogin(false);
                    this.managementService.updateUserInfo(cloudId, cloudName, u);
                } else {
                    response.setHeader("firstLogin", FALSE);
                }
                UserElement ue = this.getUserElement(userElement.getUserName(), cloud);
                logger.debug(ue.isOnedriveBkpEnabled() + GET_USER_INFO_BACKUP_ENABLED + ue.isBackupEnabled());
                modelAndView.addObject((Object)ue);
                this.managementService.updateUserLoggedInTime(cloudId, userElement.getUserName());
            }
            boolean isLDAPEnabled = this.isLdapEnabledForCloud(cl);
            boolean isAADEnabled = this.isAADEnabled(cloud.getCloudCustomisableDetails());
            response.setHeader(LDAP_ENABLED, Boolean.toString(isLDAPEnabled));
            response.setHeader(AAD_ENABLED, Boolean.toString(isAADEnabled));
            response.setHeader("token", token);
            response.setHeader(CLOUD_NAME, cloud.getCloudName());
            response.setStatus(202);
            response.setHeader("Access-Control-Expose-Headers", "token, firstLogin, cloudName, connectedClients");
            return modelAndView;
        }
        catch (DataIntegrityViolationException e) {
            logger.trace(INSIDE_AUTHENTICATE_DATA_INTEGRITY_VIOLATON_EXCEPTION + (Object)((Object)e));
            response.setStatus(401);
            logger.error(INSIDE_AUTHENTICATE_DATA_INTEGRITY_VIOLATON_EXCEPTION + e.getMessage());
            return modelAndView;
        }
        catch (DataAccessException e) {
            logger.trace(DATA_ACCESS_EXCEPTION + (Object)((Object)e));
            logger.error("@@@ Inside authenticate DataAccessException ..." + e.getMessage());
            response.setStatus(401);
            return modelAndView;
        }
        catch (BaseException e) {
            logger.trace(BASE_EXCEPTION + (Object)((Object)e));
            logger.error("@@@ Inside authentication BaseException..." + e.getMessage());
            if ("Bad Credentials.".equalsIgnoreCase(e.getMessage())) {
                this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, " login failed from " + client + hostIPDomain, userElement.getUserName(), "", "", System.currentTimeMillis(), PCActionTypes.LOGIN.getActionTypeValue());
            }
            response.setStatus(e.getErrorStatus());
            return modelAndView;
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error("@@@ Exception..." + e.getMessage());
        }
        return modelAndView;
    }

    private String generatePassWordhash(String passHash) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        byte[] digesta = null;
        try {
            MessageDigest mda = MessageDigest.getInstance("SHA-512", "BC");
            digesta = mda.digest(passHash.getBytes());
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            logger.trace("getSHA512hash : " + e);
            logger.trace(e.getMessage());
        }
        return Hex.encodeHexString((byte[])digesta);
    }

    private String getDecryptePassword(String ldapPwdEnc) {
        String decryptedPwd = null;
        if (!org.springframework.util.StringUtils.isEmpty((Object)ldapPwdEnc)) {
            try {
                decryptedPwd = this.decrypt(ldapPwdEnc, SECRET_KEY);
            }
            catch (Exception e) {
                logger.trace(EXCEPTION + e);
                logger.error("ERROR in decryption ... " + e.getMessage());
            }
        }
        return decryptedPwd;
    }

    private boolean checkWithADandMigrateUser(CloudLicenseTo cl, int cloudId, String cloudName, String userName, HttpServletResponse response) {
        boolean success = false;
        boolean isSyncEnabled = false;
        boolean isBackupEnabled = false;
        boolean isO365Enabled = false;
        List list = cl.getCloud().getCloudCustomisableDetails();
        try {
            Person person = this.ldapService.getPerson(userName);
            if (person != null) {
                int code;
                if (org.springframework.util.StringUtils.isEmpty((Object)person.getEmailId()) || !person.isAccountStatus()) {
                    return false;
                }
                UserElement user = this.managementService.getUserByUserNameOrEmail(cl.getCloud(), userName);
                if (user != null && user.getEmailId().equalsIgnoreCase(person.getEmailId())) {
                    logger.error(" .........username or email id already exists.......");
                    return false;
                }
                if (org.springframework.util.StringUtils.isEmpty((Object)person.getEmailId())) {
                    logger.debug(" .....no emailId configured in AD.........." + person.getFullName());
                    return false;
                }
                for (CloudCustomisableDetails customisableDetails : list) {
                    if (customisableDetails.getName().equalsIgnoreCase(SYNC_ENABLED)) {
                        isSyncEnabled = true;
                    }
                    if (customisableDetails.getName().equalsIgnoreCase(BACK_UP_ENABLED)) {
                        isBackupEnabled = true;
                    }
                    if (!"OneDrive Backup Enabled".equalsIgnoreCase(customisableDetails.getName())) continue;
                    isO365Enabled = true;
                }
                if (isBackupEnabled && "sync".equalsIgnoreCase(person.getAdGroupType())) {
                    isBackupEnabled = false;
                }
                if (isSyncEnabled && BACKUP.equalsIgnoreCase(person.getAdGroupType())) {
                    isSyncEnabled = false;
                }
                if (!this.checkLicense(code = this.deviceAndUserSecurityService.validateUserRestrictions(cloudId, cloudName, cl.getCloud()), response)) {
                    logger.debug("USER LIMIT REACHED........");
                    this.sendEmailForUserDeviceLimitExceeded(cloudId, cloudName, person.getFullName(), "User");
                    return success;
                }
                if (isSyncEnabled && !this.checkLicense(code = this.deviceAndUserSecurityService.validateSyncUserRestrictions(cloudId, cloudName, cl.getCloud()), response)) {
                    logger.debug(" SYNC USER LIMIT REACHED........");
                    this.sendEmailForUserDeviceLimitExceeded(cloudId, cloudName, person.getFullName(), "Sync User");
                    return success;
                }
                if (isBackupEnabled && !this.checkLicense(code = this.deviceAndUserSecurityService.validateBackupUserRestrictions(cloudId, cloudName, cl.getCloud()), response)) {
                    logger.debug("BACKUP USER LIMIT REACHED........");
                    this.sendEmailForUserDeviceLimitExceeded(cloudId, cloudName, person.getFullName(), "Backup User");
                    return success;
                }
                if (isO365Enabled && !this.checkLicense(code = this.deviceAndUserSecurityService.validateO365BackupUserRestrictions(cloudId, cloudName, cl.getCloud()), response)) {
                    logger.debug("O365 BACKUP USER LIMIT REACHED........");
                    this.sendEmailForUserDeviceLimitExceeded(cloudId, cloudName, person.getFullName(), "O365 Backup User");
                    return success;
                }
                LdapUserElement ldapUserElement = new LdapUserElement();
                ldapUserElement.setUserName(person.getFullName());
                ldapUserElement.setEmailId(person.getEmailId());
                ldapUserElement.setOrganizationUnit(person.getOrganizationalUnit());
                ldapUserElement.setDisplayName(person.getDisplayName());
                ldapUserElement.setDefaultPolicy(PCHelperConstant.getPropertyFileValueDefaultBkpPolicy());
                ldapUserElement.setDefaultSyncPolicy(PCHelperConstant.getPropertyFileValueDefaultSyncPolicy());
                ldapUserElement.setLocation(person.getLocation());
                ldapUserElement.setDepartment(person.getDepartment());
                ldapUserElement.setAccountStatus(person.isAccountStatus());
                boolean userCreated = this.managementService.createUserFromLdap(cloudId, cloudName, ldapUserElement, "AUTO", isSyncEnabled, isBackupEnabled, isO365Enabled);
                if (userCreated) {
                    this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "migrated", "Auto", userName, "Portal", System.currentTimeMillis(), PCActionTypes.AD_USER_MIGRATION.getActionTypeValue());
                    success = true;
                }
            } else {
                response.setStatus(401);
                logger.debug(" PERSON NOT FOUND  ..... " + userName);
                success = false;
            }
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(401);
            success = false;
        }
        return success;
    }

    private boolean migrateUserBasedOnProductType(CloudLicenseTo cl, int cloudId, String cloudName, LdapUserElement ldapUser, HttpServletResponse response, boolean isSyncEnable, boolean isBackupEnable, boolean isO365Enable, String migratedBy) {
        boolean userMigrated = false;
        boolean isSyncEnabled = isSyncEnable;
        boolean isBackupEnabled = isBackupEnable;
        boolean isO365Enabled = isO365Enable;
        try {
            Person person = this.ldapService.getPersonByUserName(ldapUser.getUserName());
            if (person != null) {
                boolean userCreated;
                if (isBackupEnabled && "sync".equalsIgnoreCase(person.getAdGroupType())) {
                    isBackupEnabled = false;
                }
                if (isSyncEnabled && BACKUP.equalsIgnoreCase(person.getAdGroupType())) {
                    isSyncEnabled = false;
                }
                if (org.springframework.util.StringUtils.isEmpty((Object)person.getEmailId())) {
                    logger.debug(" .....no emailId configured in AD.........." + person.getFullName());
                    MigrationStatus migrationStatus = new MigrationStatus();
                    migrationStatus.setMigratedBy(migratedBy);
                    migrationStatus.setMigratededTimestamp(System.currentTimeMillis());
                    migrationStatus.setMigrated(false);
                    migrationStatus.setReason("Email Id is empty");
                    migrationStatus.setUserName(person.getFullName());
                    this.managementService.saveMigrationStatus(cloudId, migrationStatus);
                    return userMigrated;
                }
                if (org.springframework.util.StringUtils.isEmpty((Object)ldapUser.getDefaultSyncPolicy())) {
                    ldapUser.setDefaultSyncPolicy(PCHelperConstant.getPropertyFileValueDefaultSyncPolicy());
                }
                if (isBackupEnabled && org.springframework.util.StringUtils.isEmpty((Object)ldapUser.getDefaultPolicy())) {
                    ldapUser.setDefaultPolicy(PCHelperConstant.getPropertyFileValueDefaultBkpPolicy());
                }
                if (isO365Enabled && org.springframework.util.StringUtils.isEmpty((Object)ldapUser.getDefaultO365Policy())) {
                    ldapUser.setDefaultPolicy(PCHelperConstant.getPropertyFileValueDefaultO365PolicyName());
                }
                if (userCreated = this.managementService.createUserFromLdap(cloudId, cloudName, ldapUser, migratedBy, isSyncEnabled, isBackupEnabled, isO365Enabled)) {
                    this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "migrated", migratedBy, ldapUser.getUserName(), "Portal", System.currentTimeMillis(), PCActionTypes.AD_USER_MIGRATION.getActionTypeValue());
                    userMigrated = true;
                }
            }
        }
        catch (Exception e) {
            MigrationStatus migrationStatus = new MigrationStatus();
            migrationStatus.setMigratedBy(migratedBy);
            migrationStatus.setMigratededTimestamp(System.currentTimeMillis());
            migrationStatus.setMigrated(false);
            migrationStatus.setReason("Failed to get user form AD");
            migrationStatus.setUserName(ldapUser.getUserName());
            migrationStatus.setEmailId(ldapUser.getEmailId());
            this.managementService.saveMigrationStatus(cloudId, migrationStatus);
            logger.trace(EXCEPTION + e);
            logger.error(" Exception  :----------" + e.getMessage());
        }
        return userMigrated;
    }

    @RequestMapping(value={"cloud/{cloudName}/adauthenticate"}, method={RequestMethod.GET})
    public ModelAndView adAuthenticate(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = null;
        logger.debug("calling /adauthenticate ...");
        response.setHeader(ACCESS_CONTROL_ALLOW_ORIGIN, "*");
        response.setHeader(ACCESS_CONTROL_ALLOW_METHODS, POST_GET_OPTIONS_DELETE);
        response.setHeader(ACCESS_CONTROL_MAX_AGE, "3600");
        response.setHeader(ACCESS_CONTROL_ALLOW_HEADERS, X_REQUESTED_WITH_FIRST_LOGIN_TOKEN);
        try {
            Object[] objArr;
            boolean isAuthenticated;
            CloudLicenseTo cl;
            String userName = request.getHeader(USER_NAME);
            String deviceName = request.getHeader(DEVICE_NAME);
            String client = PORTAL;
            if (!org.springframework.util.StringUtils.isEmpty((Object)request.getHeader(CLIENT_TYPE))) {
                client = request.getHeader(CLIENT_TYPE).toLowerCase();
            }
            if (!this.checkLicense(cl = this.licenseService.validateLicense(cloudName), response)) {
                logger.debug("@@@ Inside authenticate invalid license ...");
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int clientType = 1;
            if (client != null) {
                logger.debug("@@@ Inside client selection ..." + client);
                clientType = PCClientTypes.getClientType((String)client);
            }
            int cloudId = cl.getCloud().getCloudId();
            String ldapPwdEnc = request.getHeader("ldapPwdEnc");
            String decryptedPwd = null;
            if (!StringUtils.isEmpty((String)ldapPwdEnc)) {
                try {
                    decryptedPwd = this.decrypt(ldapPwdEnc, SECRET_KEY);
                }
                catch (Exception e) {
                    logger.debug("ERROR in decryption ... " + e.getMessage());
                    logger.error(EXCEPTION + e);
                }
            }
            if (!(isAuthenticated = ((Boolean)(objArr = this.ldapService.authenticate(userName, decryptedPwd))[0]).booleanValue())) {
                logger.debug("NOTINSIDEAUTHENTICATE LDAP ENABLED .............." + decryptedPwd);
                response.setStatus(400);
                return null;
            }
            User u = this.managementService.getUserDetails(cloudId, cloudName, userName);
            this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, LOGGED_INTO + client, userName, "", deviceName, System.currentTimeMillis(), PCActionTypes.LOGIN.getActionTypeValue());
            UUID uuid = UUID.randomUUID();
            String token = String.valueOf(uuid);
            this.authorizationService1.addTokenByUser(cloudId, cloudName, token, userName, clientType);
            if (u.isSyncEnabled() || u.isBackupEnabled() || u.isServerBackupEnabled()) {
                List<DeviceElement> devices = this.deviceManagementService.getDevicesForUser(cloudId, cloudName, u.getUserName());
                if (devices != null && !devices.isEmpty()) {
                    response.setHeader("has-connected-clients", "true");
                } else {
                    response.setHeader("has-connected-clients", FALSE);
                }
            }
            if (u.isFirstLogin()) {
                response.setHeader("firstLogin", "true");
                u.setFirstLogin(false);
                this.managementService.updateUserInfo(cloudId, cloudName, u);
            } else {
                response.setHeader("firstLogin", FALSE);
            }
            response.setHeader("token", token);
            response.setStatus(202);
        }
        catch (DataIntegrityViolationException e) {
            logger.trace(INSIDE_AUTHENTICATE_DATA_INTEGRITY_VIOLATON_EXCEPTION + (Object)((Object)e));
            logger.error(DATA_INSTEGRITY_VIOLATION_EXCEPTION + e.getMessage());
            response.setStatus(401);
        }
        catch (DataAccessException e) {
            logger.trace("@@@ Inside authenticate DataAccessException...." + (Object)((Object)e));
            logger.error(DATA_ACCESS_EXCEPTION + e.getMessage());
            response.setStatus(401);
        }
        catch (BaseException e) {
            logger.trace("@@@ Inside authenticate BaseException..." + (Object)((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
            response.setStatus(e.getErrorStatus());
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/auth/gen"}, method={RequestMethod.GET})
    public void generateProxyToken(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("calling /generateProxyToken ...");
        String cloudName = cloudName1;
        try {
            String username = request.getHeader(USER_NAME);
            String token = request.getHeader("token");
            if (!org.springframework.util.StringUtils.hasText((String)username)) {
                throw new BaseException(USER_NAME_NOT_FOUND);
            }
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            int cloudId = cl.getCloud().getCloudId();
            DeviceStatusTo code = this.deviceAndUserSecurityService.validateDevice(cloudId, cloudName = cl.getCloud().getCloudName(), token, cl.getCloud());
            if (!this.checkLicense(code.getStatus(), response)) {
                return;
            }
            String newtoken = TokenGenerator.generateToken();
            int clientType = 2;
            UserElement userElement = this.managementService.getUserByUserName(cl.getCloud(), username);
            if (userElement != null && !userElement.isSuspended()) {
                User user = new User();
                BeanUtils.copyProperties((Object)user, (Object)userElement);
                this.authorizationService1.addTokenByUser(cloudId, cloudName, newtoken, user, clientType);
                response.setHeader("token", newtoken);
                response.setHeader(CLOUD_NAME, cloudName);
                response.setStatus(200);
            } else {
                logger.debug("User is null or suspended for userName " + username);
                response.setStatus(200);
            }
        }
        catch (DataIntegrityViolationException e) {
            response.setStatus(401);
            logger.trace(DATA_INSTEGRITY_VIOLATION_EXCEPTION + (Object)((Object)e));
            logger.error(DATA_INSTEGRITY_VIOLATION_EXCEPTION + e.getMessage());
        }
        catch (DataAccessException e) {
            response.setStatus(401);
            logger.trace(DATA_ACCESS_EXCEPTION + (Object)((Object)e));
            logger.error(DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (BaseException e) {
            response.setStatus(401);
            logger.trace(BASE_EXCEPTION + (Object)((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
        }
        catch (Exception e) {
            response.setStatus(500);
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/auth/validate"}, method={RequestMethod.GET})
    public void validateProxyToken(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("calling /validateProxyToken ...");
        String cloudName = cloudName1;
        try {
            String username = request.getHeader(USER_NAME);
            String proxyToken = request.getHeader("token");
            if (!org.springframework.util.StringUtils.hasText((String)username)) {
                throw new BaseException(USER_NAME_NOT_FOUND);
            }
            logger.debug("@@@ Inside validateProxyToken before validateLicense ...");
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                logger.debug("@@@ Inside validateProxyToken invalid license ...");
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            logger.debug("@@@ Inside validating token from DB");
            AuthorizationTokens authorizationTokens = this.authorizationService1.getTokenDetailsForToken(cloudId, cloudName, proxyToken);
            if (authorizationTokens == null) {
                response.setStatus(421);
                return;
            }
            if (!authorizationTokens.getUser().getUserName().equals(username)) {
                response.setStatus(401);
                logger.debug("@@@ Inside validateProxyToken after splitting value ...");
                return;
            }
            this.authorizationService1.deleteToken(cloudId, cloudName, authorizationTokens);
            int clientType = 2;
            User u = this.managementService.getUserDetails(cloudId, cloudName, username);
            this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "logged into portal", username, "", "", System.currentTimeMillis(), PCActionTypes.LOGIN.getActionTypeValue());
            UUID uuid = UUID.randomUUID();
            String newToken1 = String.valueOf(uuid);
            this.authorizationService1.addTokenByUser(cloudId, cloudName, newToken1, username, clientType);
            if (u.isFirstLogin()) {
                response.setHeader("firstLogin", "true");
                u.setFirstLogin(false);
                this.managementService.updateUserInfo(cloudId, cloudName, u);
            } else {
                response.setHeader("firstLogin", FALSE);
            }
            response.setHeader("token", newToken1);
            response.setStatus(202);
            logger.debug("@@@ end of validateProxyToken ");
        }
        catch (DataIntegrityViolationException e) {
            response.setStatus(401);
            logger.trace(DATA_INSTEGRITY_VIOLATION_EXCEPTION + (Object)((Object)e));
            logger.error(DATA_INSTEGRITY_VIOLATION_EXCEPTION + e.getMessage());
        }
        catch (DataAccessException e) {
            response.setStatus(401);
            logger.trace(DATA_ACCESS_EXCEPTION + (Object)((Object)e));
            logger.error(DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (BaseException e) {
            response.setStatus(401);
            logger.trace(BASE_EXCEPTION + (Object)((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
        }
        catch (Exception e) {
            response.setStatus(500);
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/password/reset"}, method={RequestMethod.GET})
    public void resetPassword(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        block13: {
            logger.debug(CALLING_VERIFY_RECOVERY_KEY);
            String cloudName = cloudName1;
            try {
                String username = request.getHeader(USER_NAME);
                CacheHelper cacheHelper = new CacheHelper();
                if (!org.springframework.util.StringUtils.hasText((String)username)) {
                    response.setStatus(400);
                    return;
                }
                CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
                if (!this.checkLicense(cl, response)) {
                    return;
                }
                cloudName = cl.getCloud().getCloudName();
                int cloudId = cl.getCloud().getCloudId();
                UUID uuid = UUID.randomUUID();
                String recoveryKey = String.valueOf(uuid);
                UserElement element = this.managementService.getUserByUserNameOrEmail(cl.getCloud(), username);
                if (element == null) {
                    response.setStatus(403);
                    return;
                }
                if (org.springframework.util.StringUtils.isEmpty((Object)element.getPasswdHash())) {
                    response.setHeader("ldapuser", "true");
                    response.setStatus(400);
                    return;
                }
                username = element.getUserName();
                username = username.replaceAll(" ", "_");
                cacheHelper.addValueToCache(username + RESET_PASSWORD, recoveryKey, 1800);
                response.setHeader("email", element.getEmailId());
                response.setHeader(USER_NAME, username);
                response.setHeader(RESET_PASSWORD_KEY, recoveryKey);
                if (!element.isAdmin()) {
                    if (PCHelperConstant.isPasswordChangeEnforce()) {
                        if (!PCHelperConstant.isCanUserChangePassword()) {
                            response.setHeader("changepassword", FALSE);
                            response.setStatus(622);
                            return;
                        }
                        break block13;
                    }
                    if (element.getBackupPolicyElement() != null && !org.springframework.util.StringUtils.isEmpty((Object)element.getBackupPolicyElement().isCanUserChangePassword()) && !element.getBackupPolicyElement().isCanUserChangePassword() || element.getSyncPolicyElement() != null && !org.springframework.util.StringUtils.isEmpty((Object)element.getSyncPolicyElement().isCanUserChangePassword()) && !element.getSyncPolicyElement().isCanUserChangePassword()) {
                        response.setHeader("changepassword", FALSE);
                        response.setStatus(622);
                        return;
                    }
                    response.setStatus(200);
                    return;
                }
                response.setStatus(200);
                return;
            }
            catch (IOException e) {
                response.setStatus(500);
                logger.trace(IO_EXCEPTION + e);
                logger.error(IO_EXCEPTION + e.getMessage());
                return;
            }
            catch (DataIntegrityViolationException e) {
                response.setStatus(401);
                logger.trace(DATA_INSTEGRITY_VIOLATION_EXCEPTION + (Object)((Object)e));
                logger.error(DATA_INSTEGRITY_VIOLATION_EXCEPTION + e.getMessage());
            }
            catch (DataAccessException e) {
                response.setStatus(401);
                logger.trace(DATA_ACCESS_EXCEPTION + (Object)((Object)e));
                logger.error(DATA_ACCESS_EXCEPTION + e.getMessage());
            }
            catch (BaseException e) {
                response.setStatus(401);
                logger.trace(BASE_EXCEPTION + (Object)((Object)e));
                logger.error(BASE_EXCEPTION + e.getMessage());
            }
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/verify/password/key"}, method={RequestMethod.GET})
    public void verifyResetPasswordKey(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("calling /verifyResetPasswordKey ...");
        try {
            String username = request.getHeader(USER_NAME);
            String key = request.getHeader(RESET_PASSWORD_KEY);
            if (!org.springframework.util.StringUtils.hasText((String)username) || !org.springframework.util.StringUtils.hasText((String)key)) {
                throw new BaseException(USER_NAME_NOT_FOUND);
            }
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            CacheHelper cacheHelper = new CacheHelper();
            String key2 = cacheHelper.getValueFromCache((username = username.replaceAll(" ", "_")) + RESET_PASSWORD);
            if (key2 != null && key2.equalsIgnoreCase(key)) {
                response.setStatus(200);
                return;
            }
            response.setStatus(403);
            return;
        }
        catch (IOException e) {
            response.setStatus(500);
            logger.trace(IO_EXCEPTION + e);
            logger.error(IO_EXCEPTION + e.getMessage());
            return;
        }
        catch (DataIntegrityViolationException e) {
            response.setStatus(401);
            logger.trace(DATA_INSTEGRITY_VIOLATION_EXCEPTION + (Object)((Object)e));
            logger.error(DATA_INSTEGRITY_VIOLATION_EXCEPTION + e.getMessage());
        }
        catch (DataAccessException e) {
            response.setStatus(401);
            logger.trace(DATA_ACCESS_EXCEPTION + (Object)((Object)e));
            logger.error(DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (BaseException e) {
            response.setStatus(401);
            logger.trace(BASE_EXCEPTION + (Object)((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/verifyRecoveryKey"}, method={RequestMethod.GET})
    public void verifyRecoveryKey(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        logger.debug(CALLING_VERIFY_RECOVERY_KEY);
        String cloudName = cloudName1;
        try {
            String token;
            String username = request.getHeader(USER_NAME);
            String key = request.getHeader("recoveryKey");
            if (!org.springframework.util.StringUtils.hasText((String)username) || !org.springframework.util.StringUtils.hasText((String)key)) {
                throw new BaseException(USER_NAME_NOT_FOUND);
            }
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), response)) {
                return;
            }
            this.managementService.verifyRecoveryKey(cloudId, cloudName, username, key);
            response.setStatus(202);
        }
        catch (DataIntegrityViolationException e) {
            response.setStatus(401);
            logger.trace(DATA_INSTEGRITY_VIOLATION_EXCEPTION + (Object)((Object)e));
            logger.error(DATA_INSTEGRITY_VIOLATION_EXCEPTION + e.getMessage());
        }
        catch (DataAccessException e) {
            response.setStatus(401);
            logger.trace(DATA_ACCESS_EXCEPTION + (Object)((Object)e));
            logger.error(DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (BaseException e) {
            response.setStatus(401);
            logger.trace(BASE_EXCEPTION + (Object)((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/user/update/password"}, method={RequestMethod.PUT})
    public ModelAndView updateUserPassword(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        try {
            String username = request.getHeader(USER_NAME);
            String key = request.getHeader(RESET_PASSWORD_KEY);
            String password = request.getHeader(PASSWORD);
            String setPassword = request.getHeader("setpassword");
            logger.debug("calling /updateUserPassword ..." + username);
            if (!(org.springframework.util.StringUtils.hasText((String)username) && org.springframework.util.StringUtils.hasText((String)key) && org.springframework.util.StringUtils.hasText((String)password))) {
                throw new BaseException(INVALID_REQUEST);
            }
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            CacheHelper cacheHelper = new CacheHelper();
            String userName = username.replaceAll(" ", "_");
            UserElement element = this.managementService.getUserByUserNameOrEmail(cl.getCloud(), username);
            if (org.springframework.util.StringUtils.isEmpty((Object)element)) {
                response.setStatus(400);
                return null;
            }
            if (org.springframework.util.StringUtils.isEmpty((Object)element.getPasswdHash())) {
                response.setHeader("ldapuser", "true");
                response.setStatus(400);
                return null;
            }
            String key2 = !org.springframework.util.StringUtils.isEmpty((Object)setPassword) && "true".equalsIgnoreCase(setPassword) ? element.getSecurityRecoveryKey() : cacheHelper.getValueFromCache(userName + RESET_PASSWORD);
            if (key2 != null && key2.equalsIgnoreCase(key)) {
                element.setPasswdHash(password);
                this.managementService.updateUserInfo(cloudId, cloudName, element);
                cacheHelper.removeKeyFromCache(userName + RESET_PASSWORD);
                if (key.equals(element.getSecurityRecoveryKey())) {
                    this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, " set the password ", username, "", "Portal", System.currentTimeMillis(), PCActionTypes.SET_PASSWORD.getActionTypeValue());
                } else {
                    this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, " reset the password ", username, "", "Portal", System.currentTimeMillis(), PCActionTypes.RESET_PASSWORD.getActionTypeValue());
                }
                response.setStatus(200);
                return null;
            }
            response.setStatus(403);
            return null;
        }
        catch (IOException e) {
            response.setStatus(500);
            logger.trace(IO_EXCEPTION + e);
            logger.error(IO_EXCEPTION + e.getMessage());
            return null;
        }
        catch (EmptyResultDataAccessException e) {
            ErrorElement err = this.createErrorElement(null, USER_NOT_FOUND);
            modelAndView.addObject((Object)err);
            response.setStatus(409);
            logger.trace(EMPTY_RESULT_DATA_ACCESS_EXCEPTION + (Object)((Object)e));
            logger.error(EMPTY_RESULT_DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (DataAccessException e) {
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
            logger.trace(DATA_ACCESS_EXCEPTION + (Object)((Object)e));
            logger.error(DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (BaseException e) {
            ErrorElement err = this.createErrorElement(e.getErrorCode(), null);
            modelAndView.addObject((Object)err);
            response.setStatus(400);
            logger.trace(BASE_EXCEPTION + (Object)((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
        }
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/mail"}, method={RequestMethod.POST})
    public void sendMail(@PathVariable(value="cloudName") String cloudName1, @RequestBody EmailProps email, HttpServletRequest request, HttpServletResponse response) {
        logger.debug(CALLING_VERIFY_RECOVERY_KEY);
        String cloudName = cloudName1;
        try {
            if (email == null || StringUtils.isBlank((String)email.getAction())) {
                throw new BaseException("Bad Email props");
            }
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            int cloudId = cl.getCloud().getCloudId();
            cloudName = cl.getCloud().getCloudName();
            String token = request.getHeader("token");
            if (!Boolean.parseBoolean(request.getHeader("isInternalCall")) && !this.performAuthorization(cloudId, cloudName, token, response)) {
                return;
            }
            ArrayList<EmailRecipent> notifyRecipents = new ArrayList<EmailRecipent>();
            if (email.isToAllMinicloudUsers() && (email.getMiniCloudName() != null || !email.getMiniCloudName().isEmpty())) {
                List cloudList = email.getMiniCloudName();
                for (String miniCloudName : cloudList) {
                    List<User> users = this.miniCloudAccessControlService.getAllUserForMiniCloud(cloudId, cloudName, miniCloudName);
                    if (users == null) continue;
                    for (User u : users) {
                        if (!u.isActive()) continue;
                        EmailRecipent emailRecipent = new EmailRecipent();
                        emailRecipent.setUserName(u.getUserName());
                        emailRecipent.setEmail(u.getEmailId());
                        notifyRecipents.add(emailRecipent);
                    }
                }
            }
            if (CollectionUtils.isEmpty((Collection)email.getRecipents())) {
                ArrayList<EmailRecipent> recipents = new ArrayList<EmailRecipent>();
                EmailRecipent emailRecipent = new EmailRecipent();
                emailRecipent.setUserName(email.getActionBy());
                emailRecipent.setEmail(this.managementService.getUserInfo(cl.getCloud().getCloudId(), cloudName, email.getActionBy()).getEmailId());
                recipents.add(emailRecipent);
                email.setRecipents(recipents);
            }
            email.setNotifyRecipents(notifyRecipents);
            logger.debug("calling email..");
            if (!org.springframework.util.StringUtils.isEmpty((Object)request.getHeader("bkupsDone"))) {
                logger.debug("..... bkupsdone not empty... " + request.getHeader("bkupsDone"));
            }
            logger.debug("calling email.." + email.getBackupsDone());
            email.setBackupsDone(request.getHeader("bkupsDone"));
            this.cloudMailService.sendMail(email);
            response.setStatus(200);
        }
        catch (DataIntegrityViolationException e) {
            response.setStatus(401);
            logger.trace(DATA_INSTEGRITY_VIOLATION_EXCEPTION + (Object)((Object)e));
            logger.error(DATA_INSTEGRITY_VIOLATION_EXCEPTION + e.getMessage());
        }
        catch (DataAccessException e) {
            response.setStatus(401);
            logger.trace(DATA_ACCESS_EXCEPTION + (Object)((Object)e));
            logger.error(DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (BaseException e) {
            response.setStatus(401);
            logger.trace(BASE_EXCEPTION + (Object)((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/mail/reset/password"}, method={RequestMethod.POST})
    public void sendMailForPasswordReset(@PathVariable(value="cloudName") String cloudName1, @RequestBody EmailProps email, HttpServletRequest request, HttpServletResponse response) {
        logger.debug(CALLING_VERIFY_RECOVERY_KEY);
        String cloudName = cloudName1;
        try {
            if (email == null || StringUtils.isBlank((String)email.getAction())) {
                throw new BaseException("Bad Email props");
            }
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            int cloudId = cl.getCloud().getCloudId();
            cloudName = cl.getCloud().getCloudName();
            ArrayList<EmailRecipent> notifyRecipents = new ArrayList<EmailRecipent>();
            String emailId = ((EmailRecipent)email.getRecipents().get(0)).getEmail();
            if (!org.springframework.util.StringUtils.isEmpty((Object)emailId)) {
                UserElement userElement = this.managementService.getUserByUserNameOrEmail(cl.getCloud(), emailId);
                email.setActionOn(userElement.getUserName());
            }
            if (email.isToAllMinicloudUsers() && (email.getMiniCloudName() != null || !email.getMiniCloudName().isEmpty())) {
                List cloudList = email.getMiniCloudName();
                for (String miniCloudName : cloudList) {
                    List<User> users = this.miniCloudAccessControlService.getAllUserForMiniCloud(cloudId, cloudName, miniCloudName);
                    if (users == null) continue;
                    for (User u : users) {
                        if (!u.isActive()) continue;
                        EmailRecipent emailRecipent = new EmailRecipent();
                        emailRecipent.setUserName(u.getUserName());
                        emailRecipent.setEmail(u.getEmailId());
                        notifyRecipents.add(emailRecipent);
                    }
                }
            }
            email.setNotifyRecipents(notifyRecipents);
            logger.debug("calling email..");
            this.cloudMailService.sendMail(email);
            response.setStatus(200);
        }
        catch (DataIntegrityViolationException e) {
            response.setStatus(401);
            logger.trace(DATA_INSTEGRITY_VIOLATION_EXCEPTION + (Object)((Object)e));
            logger.error(DATA_INSTEGRITY_VIOLATION_EXCEPTION + e.getMessage());
        }
        catch (DataAccessException e) {
            response.setStatus(401);
            logger.trace(DATA_ACCESS_EXCEPTION + (Object)((Object)e));
            logger.error(DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (BaseException e) {
            response.setStatus(401);
            logger.trace(BASE_EXCEPTION + (Object)((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
        }
    }

    @RequestMapping(value={"mail/reload"}, method={RequestMethod.GET})
    public void reloadEmailTemplates(HttpServletRequest request, HttpServletResponse response) {
        logger.debug("calling /reloadEmailTemplates ...");
        try {
            EmailCacher.reloadTemplates();
        }
        catch (Exception e) {
            response.setStatus(500);
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/mobile/authenthicate"}, method={RequestMethod.GET})
    public ModelAndView authenticateMobile(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        logger.debug("calling /authenticateMobile ...");
        response.setHeader(ACCESS_CONTROL_ALLOW_ORIGIN, "*");
        response.setHeader(ACCESS_CONTROL_ALLOW_METHODS, POST_GET_OPTIONS_DELETE);
        response.setHeader(ACCESS_CONTROL_MAX_AGE, "3600");
        response.setHeader(ACCESS_CONTROL_ALLOW_HEADERS, X_REQUESTED_WITH_FIRST_LOGIN_TOKEN);
        ResponseElement responseElement = new ResponseElement();
        try {
            String username = request.getHeader(USER_NAME);
            String password = request.getHeader(PASSWORD);
            String deviceName = request.getHeader(DEVICE_NAME);
            String client = request.getHeader(CLIENT_TYPE);
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int clientType = 1;
            if (client != null) {
                clientType = PCClientTypes.getClientType((String)client);
            }
            int cloudId = cl.getCloud().getCloudId();
            User u = this.managementService.authenticate(cloudId, cloudName, username, password);
            this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "logged in using Mobile", username, "", deviceName, System.currentTimeMillis(), PCActionTypes.LOGIN.getActionTypeValue());
            UUID uuid = UUID.randomUUID();
            String token = String.valueOf(uuid);
            this.authorizationService1.addTokenByUser(cloudId, cloudName, token, username, clientType);
            if (u.isSyncEnabled() || u.isBackupEnabled() || u.isServerBackupEnabled()) {
                List<DeviceElement> devices = this.deviceManagementService.getDevicesForUser(cloudId, cloudName, u.getUserName());
                if (devices != null && !devices.isEmpty()) {
                    response.setHeader("has-connected-clients", "true");
                } else {
                    response.setHeader("has-connected-clients", FALSE);
                }
            }
            if (u.isFirstLogin()) {
                response.setHeader("firstLogin", "true");
                u.setFirstLogin(false);
                this.managementService.updateUserInfo(cloudId, cloudName, u);
            } else {
                response.setHeader("firstLogin", FALSE);
            }
            response.setHeader("token", token);
            responseElement.setStatus(String.valueOf(202));
            responseElement.setToken(token);
        }
        catch (DataIntegrityViolationException e) {
            responseElement.setStatus(String.valueOf(401));
            logger.trace(DATA_INSTEGRITY_VIOLATION_EXCEPTION + (Object)((Object)e));
            logger.error(DATA_INSTEGRITY_VIOLATION_EXCEPTION + e.getMessage());
        }
        catch (DataAccessException e) {
            responseElement.setStatus(String.valueOf(401));
            logger.trace(DATA_ACCESS_EXCEPTION + (Object)((Object)e));
            logger.error(DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (BaseException e) {
            responseElement.setStatus(String.valueOf(e.getErrorStatus()));
            logger.trace(BASE_EXCEPTION + (Object)((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
        }
        response.setHeader(CLOUD_NAME, cloudName);
        responseElement.setCloudName(cloudName);
        modelAndView.addObject((Object)responseElement);
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/create/amazonuser/{userName}/"}, method={RequestMethod.POST})
    public ModelAndView createFirstTimeAmazonUser(@PathVariable(value="cloudName") String cloudName1, @RequestBody UserElement userElement, @PathVariable(value="userName") String userName, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        logger.debug("calling /createFirstTimeAdminUser for AMAZON AMI ...");
        UserElement ue = null;
        try {
            if (!org.springframework.util.StringUtils.hasText((String)userElement.getUserName()) || !org.springframework.util.StringUtils.hasText((String)userName)) {
                throw new BaseException(USER_NAME_NOT_FOUND);
            }
            CloudLicenseTo cl = this.licenseService.validateAmazonLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            userElement.setAdmin(true);
            userElement.setBackupEnabled(true);
            userElement.setSyncEnabled(false);
            userElement.setShareEnabled(false);
            userElement.setActive(true);
            userElement.setFirstLogin(true);
            List<UserElement> userList = this.managementService.getAllUsers(cloudId, cloudName);
            if (userList != null && !userList.isEmpty()) {
                modelAndView.addObject(null);
                response.setStatus(401);
                return null;
            }
            logger.debug(" CREATE USER IS BACKUP ENABLED .. " + userElement.isBackupEnabled());
            ue = this.managementService.createUser(cloudId, cloudName, userElement, "");
            modelAndView.addObject((Object)ue);
            response.setStatus(201);
            this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "created  a new user", userName, userElement.getUserName(), "ParaBlu", System.currentTimeMillis(), PCActionTypes.USER_CREATE.getActionTypeValue());
        }
        catch (DataIntegrityViolationException e) {
            ErrorElement err = this.createErrorElement(null, USER_ALREADY_EXISTS);
            modelAndView.addObject((Object)err);
            response.setStatus(409);
            logger.trace(DATA_INSTEGRITY_VIOLATION_EXCEPTION + (Object)((Object)e));
            logger.error(DATA_INSTEGRITY_VIOLATION_EXCEPTION + e.getMessage());
        }
        catch (DataAccessException e) {
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
            logger.trace(DATA_ACCESS_EXCEPTION + (Object)((Object)e));
            logger.error(DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (BaseException e) {
            ErrorElement err = this.createErrorElement(e.getErrorCode(), null);
            modelAndView.addObject((Object)err);
            response.setStatus(400);
            logger.trace(BASE_EXCEPTION + (Object)((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
        }
        return modelAndView;
    }

    private boolean isLdapEnabledForCloud(CloudLicenseTo cl) {
        boolean isLdapEnabled = false;
        List list = cl.getCloud().getCloudCustomisableDetails();
        list.removeAll(Collections.singleton(null));
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (CloudCustomisableDetails cloudPluginDetails : list) {
                if (!"LDAP Enabled".equalsIgnoreCase(cloudPluginDetails.getName())) continue;
                isLdapEnabled = true;
                break;
            }
        }
        return isLdapEnabled;
    }

    private static String getStatus(boolean val) {
        if (val) {
            return "Active";
        }
        return "Blocked";
    }

    public static String md5(String input) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("MD5");
        byte[] messageDigest = md.digest(input.getBytes());
        BigInteger number = new BigInteger(1, messageDigest);
        return number.toString(16);
    }

    public String decrypt(String encryptedPassword, String key) throws Exception {
        int ivSize = 16;
        int keySize = 16;
        logger.info(" encrypted password is " + encryptedPassword);
        byte[] payload = Base64.getDecoder().decode(encryptedPassword);
        byte[] iv = new byte[ivSize];
        System.arraycopy(payload, 0, iv, 0, iv.length);
        IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
        int encryptedSize = payload.length - ivSize;
        byte[] encryptedBytes = new byte[encryptedSize];
        System.arraycopy(payload, ivSize, encryptedBytes, 0, encryptedSize);
        byte[] keyBytes = new byte[keySize];
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(key.getBytes());
        System.arraycopy(md.digest(), 0, keyBytes, 0, keyBytes.length);
        SecretKeySpec secretKeySpec = new SecretKeySpec(keyBytes, "AES");
        Cipher cipherDecrypt = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipherDecrypt.init(2, (Key)secretKeySpec, ivParameterSpec);
        byte[] decrypted = cipherDecrypt.doFinal(encryptedBytes);
        return new String(decrypted);
    }

    @RequestMapping(value={"cloud/{cloudName}/ldap/users/migrate"}, method={RequestMethod.POST})
    public ModelAndView ldapconnectivityUser(@PathVariable(value="cloudName") String cloudName1, @RequestBody LdapUserListElement ldapUserListElement, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug(" Inside migrate users ........ sync enabled>>" + request.getHeader("syncEnabled"));
        int totalUsersCount = ldapUserListElement.getLdapUserElements().size();
        int totalUsersMigrated = 0;
        logger.debug(" Inside migrate users ........ backup enabled>>" + request.getHeader("backupEnabled"));
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String adminName = request.getHeader("adminName");
            boolean isSyncEnabled = Boolean.parseBoolean(request.getHeader("syncEnabled"));
            boolean isBackupEnabled = Boolean.parseBoolean(request.getHeader("backupEnabled"));
            boolean isO365BackupEnabled = Boolean.parseBoolean(request.getHeader("o365BkpEnabled"));
            ArrayList<String> users = new ArrayList<String>();
            String groupName = request.getHeader("groupName");
            logger.debug(" group added .................. " + groupName);
            long noOfUsersAllowed = (long)cl.getCloud().getNoOfUsersAllowed() - this.managementService.countOfPresentUsers(cloudId);
            if (noOfUsersAllowed < (long)totalUsersCount) {
                response.setHeader("userLimit", Long.toString(noOfUsersAllowed));
                response.setStatus(417);
                return null;
            }
            for (LdapUserElement ldapUserElement : ldapUserListElement.getLdapUserElements()) {
                try {
                    int code = this.deviceAndUserSecurityService.validateUserRestrictions(cloudId, cloudName, cl.getCloud());
                    if (!this.checkLicense(code, response)) {
                        return null;
                    }
                    boolean userMigrated = this.migrateUserBasedOnProductType(cl, cloudId, cloudName, ldapUserElement, response, isSyncEnabled, isBackupEnabled, isO365BackupEnabled, adminName);
                    if (userMigrated) {
                        ++totalUsersMigrated;
                    }
                }
                catch (Exception e) {
                    logger.error(" USERS CANNOT BE MIGRATED ................." + e);
                    logger.debug("USERS CANNOT BE MIGRATED ................." + e.getMessage());
                }
                logger.debug("#####   " + ldapUserElement.getEmailId());
                users.add(ldapUserElement.getUserName());
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)groupName)) {
                this.managementService.saveGroup(cloudId, users, groupName);
            }
            if (totalUsersMigrated != totalUsersCount) {
                modelAndView.addObject("totalUsersMigrated", (Object)totalUsersMigrated);
                modelAndView.addObject("totalUsersCount", (Object)totalUsersCount);
                response.setStatus(206);
            } else {
                response.setStatus(200);
            }
        }
        catch (Exception e) {
            logger.trace("error trying to load elements  ..........." + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
        }
        logger.debug("End of Inside migrate users ........ ");
        return modelAndView;
    }

    @RequestMapping(value={"/cloud/azure/authenticate"}, method={RequestMethod.POST})
    public void azureAuthentication(HttpServletRequest request, HttpServletResponse response) {
        logger.debug(INSIDE_AZURE_AUTHENTICATION);
        String userName = request.getParameter(USER_NAME);
        String password = request.getParameter(PASSWORD);
        if (org.springframework.util.StringUtils.isEmpty((Object)userName) && org.springframework.util.StringUtils.isEmpty((Object)password)) {
            userName = request.getHeader(USER_NAME);
            password = request.getHeader(PASSWORD);
        }
        try {
            logger.debug(userName + INSIDE_AZURE_AUTHENTICATION);
            Object[] objArr = this.ldapService.authenticate(userName, password);
            response.setStatus(200);
            boolean isUserAuthenticated = (Boolean)objArr[0];
            String licenseEnabled = (String)objArr[1];
            response.setHeader("userAuthenticated", Boolean.toString(isUserAuthenticated));
            response.setHeader("licenseEnabled", licenseEnabled);
            logger.debug(INSIDE_AZURE_AUTHENTICATION + isUserAuthenticated);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setHeader("errorMessage", e.getMessage());
            response.setStatus(500);
            response.setHeader("userAuthenticated", Boolean.FALSE.toString());
        }
    }

    @RequestMapping(value={"/cloud/{cloudName}/createMultiUsers/"}, method={RequestMethod.POST})
    public void azureAuthentication(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        logger.debug(INSIDE_AZURE_AUTHENTICATION);
        String userName = request.getHeader(USER_NAME);
        String cloudName = cloudName1;
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            for (int i = 0; i <= 100; ++i) {
                User user = new User();
                String userNameObj = userName + i;
                user.setUserName(userNameObj);
                user.setPasswdHash("4c09d7197a7ae0d55ebc4b91113014c3");
                user.setEmailId(userNameObj + "@dummy.com");
                user.setBackupEnabled(true);
                user.setSyncEnabled(true);
                this.managementService.createUser(cloudId, cloudName, user);
            }
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setHeader("errorMessage", e.getMessage());
            response.setStatus(500);
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/user/delete/{userName}/"}, method={RequestMethod.POST})
    public void markUserAsDelete(@PathVariable(value="cloudName") String cloudName1, @PathVariable(value="userName") String userName, HttpServletRequest request, HttpServletResponse response) {
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        logger.debug("calling /user/delete/ ..." + userName);
        String blockedBy = request.getHeader(USER_NAME);
        String cloudName = cloudName1;
        try {
            User currentUser;
            String token;
            if (!org.springframework.util.StringUtils.hasText((String)userName)) {
                throw new BaseException(INVALID_REQUEST);
            }
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), currentUser = new User(), response)) {
                response.setStatus(400);
                return;
            }
            boolean userUnderLegalHold = this.managementService.isUserUnderLegalHoldForUserName(cloudId, userName);
            if (userUnderLegalHold) {
                response.setStatus(447);
                return;
            }
            boolean isUserOwnerOfAnyMiniCloud = this.managementService.isUserOwnerOfAnyMiniCloud(cloudId, userName);
            if (isUserOwnerOfAnyMiniCloud) {
                response.setStatus(448);
                return;
            }
            this.managementService.markUserAsDelete(cloudId, cloudName, userName, currentUser.getUserName());
            response.setStatus(200);
            this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "deleted user", blockedBy, userName, "Portal", System.currentTimeMillis(), PCActionTypes.USER_DELETE.getActionTypeValue());
        }
        catch (EmptyResultDataAccessException e) {
            ErrorElement err = this.createErrorElement(null, USER_NOT_FOUND);
            modelAndView.addObject((Object)err);
            response.setStatus(409);
            logger.trace("EmptyResultDataAccessException " + (Object)((Object)e));
            logger.error(" EmptyResultDataAccessException " + e.getMessage());
        }
        catch (DataAccessException e) {
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
            logger.trace("DataAccessException " + (Object)((Object)e));
            logger.error(" DataAccessException " + e.getMessage());
        }
        catch (BaseException e) {
            ErrorElement err = this.createErrorElement(e.getErrorCode(), null);
            modelAndView.addObject((Object)err);
            response.setStatus(400);
            logger.trace(BASE_EXCEPTION + (Object)((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/users/delete/"}, method={RequestMethod.POST})
    public void markMultipleUserAsDelete(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        String cloudName = cloudName1;
        String deletedBy = request.getHeader("deletedBy");
        String userNames = request.getHeader("userNames");
        logger.debug(CALLING_UPDATE_USER_INFO + userNames);
        try {
            String token;
            if (!org.springframework.util.StringUtils.hasText((String)userNames)) {
                throw new BaseException(INVALID_REQUEST);
            }
            ArrayList<String> userNameList = new ArrayList<String>(Arrays.asList(userNames.split(",")));
            String failedUsersList = "";
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), response)) {
                response.setStatus(400);
                return;
            }
            for (String userName : userNameList) {
                this.markUserAsDelete(cloudName, response, userName, deletedBy, cloudId, failedUsersList);
            }
        }
        catch (EmptyResultDataAccessException e) {
            ErrorElement err = this.createErrorElement(null, USER_NOT_FOUND);
            modelAndView.addObject((Object)err);
            response.setStatus(409);
            logger.trace("EmptyResultDataAccessException " + (Object)((Object)e));
            logger.error(" EmptyResultDataAccessException " + e.getMessage());
        }
        catch (DataAccessException e) {
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
            logger.trace("DataAccessException " + (Object)((Object)e));
            logger.error(" DataAccessException " + e.getMessage());
        }
        catch (BaseException e) {
            ErrorElement err = this.createErrorElement(e.getErrorCode(), null);
            modelAndView.addObject((Object)err);
            response.setStatus(400);
            logger.trace(BASE_EXCEPTION + (Object)((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
        }
    }

    private UserElement markUserAsDelete(String cloudName, HttpServletResponse response, String userName, String deletedBy, int cloudId, String failedUsersList1) {
        String failedUsersList = failedUsersList1;
        boolean userUnderLegalHold = this.managementService.isUserUnderLegalHoldForUserName(cloudId, userName);
        UserElement userElement = this.managementService.getUserInfo(cloudId, cloudName, userName);
        if (userElement != null) {
            if (userUnderLegalHold) {
                response.setStatus(447);
                failedUsersList = org.springframework.util.StringUtils.isEmpty((Object)failedUsersList) ? failedUsersList + userName : failedUsersList + "," + userName;
                response.setHeader("failed-users", failedUsersList);
            }
            try {
                this.managementService.markUserAsDelete(cloudId, cloudName, userName, deletedBy);
            }
            catch (BaseException e) {
                failedUsersList = org.springframework.util.StringUtils.isEmpty((Object)failedUsersList) ? failedUsersList + userName : failedUsersList + "," + userName;
                response.setHeader("failed-users", failedUsersList);
                logger.trace(BASE_EXCEPTION + (Object)((Object)e));
                logger.error(BASE_EXCEPTION + e.getMessage());
            }
            response.setStatus(200);
            this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "deleted user", deletedBy, userName, "Portal", System.currentTimeMillis(), PCActionTypes.USER_DELETE.getActionTypeValue());
        }
        return userElement;
    }

    @RequestMapping(value={"cloud/{cloudName}/userNames/all"}, method={RequestMethod.GET})
    public ModelAndView getAllUserNames(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), response)) {
                return null;
            }
            List<User> userList = this.managementService.getAllActiveUsers(cloudId);
            Collections.sort(userList, new Comparator<User>(){

                @Override
                public int compare(User u1, User u2) {
                    return new CompareToBuilder().append((Object)UserManagementController.getStatus(u1.isActive()), (Object)UserManagementController.getStatus(u2.isActive())).append((Object)u1.getUserName().toLowerCase(), (Object)u2.getUserName().toLowerCase()).toComparison();
                }
            });
            ArrayList<StringElement> userNameElements = new ArrayList<StringElement>();
            for (User user : userList) {
                StringElement stringElement = new StringElement();
                stringElement.setName(user.getUserName());
                userNameElements.add(stringElement);
            }
            modelAndView.addObject(userNameElements);
            response.setStatus(200);
        }
        catch (Exception e) {
            ErrorElement err = this.createErrorElement();
            modelAndView.addObject((Object)err);
            response.setStatus(500);
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/save/group/"}, method={RequestMethod.POST})
    public void saveGroup(@PathVariable(value="cloudName") String cloudName1, @RequestBody UserGroupElement userGroupElement, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling  /save/group/...:");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        User user = new User();
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), user, response)) {
                return;
            }
            String userNames = userGroupElement.getAssignedUsers();
            String groupName = userGroupElement.getGroupName();
            Group group = this.managementService.getGroupByName(cloudId, groupName);
            logger.debug(user.getUserName() + " user names .....................  " + userNames);
            ArrayList<String> list = new ArrayList<String>(Arrays.asList(userNames.split(",")));
            HashSet<String> removeSet = new HashSet<String>();
            removeSet.addAll(list);
            list.clear();
            list.addAll(removeSet);
            logger.debug(" total size .... " + list.size());
            ArrayList<String> list1 = new ArrayList<String>();
            list1.addAll(list);
            if (group != null) {
                List<UserGroup> existingGroups = this.managementService.getAllUsersForGroup(cloudId, null, group.getId().toString());
                for (UserGroup userGroup : existingGroups) {
                    if (userGroup == null) continue;
                    list1.remove(userGroup.getUser().getUserName());
                }
                logger.debug(" removed user size .... " + list1.size());
            }
            this.managementService.saveGroup(cloudId, list, groupName);
            for (String userName : list1) {
                this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "saved group", user.getUserName(), groupName + " to " + userName, "Portal", System.currentTimeMillis(), PCActionTypes.USER_GROUP_SAVE.getActionTypeValue());
            }
            response.setStatus(200);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
        }
        logger.debug(" end of calling /save/group/.. ");
    }

    @RequestMapping(value={"cloud/{cloudName}/groups/all"}, method={RequestMethod.GET})
    public ModelAndView getAllUserGroups(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), response)) {
                return null;
            }
            List<Group> groupList = this.managementService.getAllGroups(cloudId);
            Collections.sort(groupList, new Comparator<Group>(){

                @Override
                public int compare(Group u1, Group u2) {
                    return new CompareToBuilder().append((Object)u1.getGroupName().toLowerCase(), (Object)u2.getGroupName().toLowerCase()).toComparison();
                }
            });
            ArrayList<StringElement> groupElements = new ArrayList<StringElement>();
            for (Group group : groupList) {
                StringElement stringElement = new StringElement();
                stringElement.setName(group.getGroupName());
                groupElements.add(stringElement);
            }
            modelAndView.addObject(groupElements);
            response.setStatus(200);
        }
        catch (Exception e) {
            ErrorElement err = this.createErrorElement();
            modelAndView.addObject((Object)err);
            response.setStatus(500);
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/group/{groupName}/"}, method={RequestMethod.GET})
    public ModelAndView getGroupInformation(@PathVariable(value="cloudName") String cloudName1, @PathVariable(value="groupName") String groupName, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("calling ./group/{groupName}/..:" + groupName);
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        String cloudName = cloudName1;
        try {
            String token;
            if (!org.springframework.util.StringUtils.hasText((String)groupName)) {
                throw new BaseException(INVALID_REQUEST);
            }
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            Cloud cloud = cl.getCloud();
            int cloudId = cloud.getCloudId();
            if (!this.performAuthorization(cloudId, cloudName = cloud.getCloudName(), token = request.getHeader("token"), response)) {
                return null;
            }
            UserGroupElement groupElement = this.managementService.getGroupElement(cloudId, groupName);
            modelAndView.addObject((Object)groupElement);
            response.setStatus(200);
        }
        catch (Exception e) {
            ErrorElement err = this.createErrorElement(null, "Group not found.");
            modelAndView.addObject((Object)err);
            response.setStatus(500);
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/group/delete/{groupName}/"}, method={RequestMethod.POST})
    public void deleteGroup(@PathVariable(value="cloudName") String cloudName1, @PathVariable(value="groupName") String groupName, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        logger.debug("calling /group/delete/{groupName}/ ..." + groupName);
        String blockedBy = request.getHeader(USER_NAME);
        try {
            User user;
            String token;
            if (!org.springframework.util.StringUtils.hasText((String)groupName)) {
                throw new BaseException(INVALID_REQUEST);
            }
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), user = new User(), response)) {
                return;
            }
            Group group = this.managementService.getGroupByName(cloudId, groupName);
            this.managementService.deleteGroup(cloudId, group);
            response.setStatus(200);
            this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "delete group", blockedBy, user.getUserName(), "Portal", System.currentTimeMillis(), PCActionTypes.USER_GROUP_DELETE.getActionTypeValue());
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/user/group/all"}, method={RequestMethod.GET})
    public ModelAndView getAllUsersAndGroup(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        try {
            StringElement stringElement;
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), response)) {
                return null;
            }
            int skipValue = request.getIntHeader("skipValue");
            logger.debug(" Skip values .... " + skipValue);
            List<UserElement> userList = this.managementService.getAllUsers(cloudId, skipValue);
            List<Group> groups = this.managementService.getAllGroups(cloudId, skipValue);
            userList.removeAll(Collections.singleton(null));
            groups.removeAll(Collections.singleton(null));
            Collections.sort(userList, new Comparator<UserElement>(){

                @Override
                public int compare(UserElement u1, UserElement u2) {
                    if (u1 == null || u2 == null || u1.getUserName() == null || u2.getUserName() == null) {
                        return -1;
                    }
                    return new CompareToBuilder().append((Object)UserManagementController.getStatus(u1.isActive()), (Object)UserManagementController.getStatus(u2.isActive())).append((Object)u1.getUserName().toLowerCase(), (Object)u2.getUserName().toLowerCase()).toComparison();
                }
            });
            ArrayList<StringElement> userGroupNameElements = new ArrayList<StringElement>();
            for (UserElement user : userList) {
                stringElement = new StringElement();
                stringElement.setName(user.getUserName());
                userGroupNameElements.add(stringElement);
            }
            for (Group group : groups) {
                stringElement = new StringElement();
                stringElement.setName(group.getGroupName());
                userGroupNameElements.add(stringElement);
            }
            modelAndView.addObject(userGroupNameElements);
            response.setStatus(200);
        }
        catch (Exception e) {
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/search/users/group/"}, method={RequestMethod.GET})
    public ModelAndView searchUsersAndGroup(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("calling search/user/group.....");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        String cloudName = cloudName1;
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), response)) {
                return null;
            }
            String userName = request.getHeader(USER_NAME);
            logger.debug("header username:" + userName);
            List<UserElement> userList = this.managementService.searchUsers(cloudId, userName);
            Collections.sort(userList, new Comparator<UserElement>(){

                @Override
                public int compare(UserElement u1, UserElement u2) {
                    return new CompareToBuilder().append((Object)UserManagementController.getStatus(u1.isActive()), (Object)UserManagementController.getStatus(u2.isActive())).append((Object)u1.getUserName().toLowerCase(), (Object)u2.getUserName().toLowerCase()).toComparison();
                }
            });
            ArrayList<StringElement> userGroupNameElements = new ArrayList<StringElement>();
            for (UserElement user : userList) {
                StringElement stringElement = new StringElement();
                stringElement.setName(user.getUserName());
                userGroupNameElements.add(stringElement);
            }
            List<Group> groups = this.managementService.searchGroups(cloudId, userName);
            if (!CollectionUtils.isEmpty(groups)) {
                for (Group group : groups) {
                    StringElement stringElement = new StringElement();
                    stringElement.setName(group.getGroupName());
                    userGroupNameElements.add(stringElement);
                }
            }
            modelAndView.addObject(userGroupNameElements);
            response.setStatus(200);
        }
        catch (Exception e) {
            ErrorElement err = this.createErrorElement(null, e.getMessage());
            modelAndView.addObject((Object)err);
            response.setStatus(400);
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
        return modelAndView;
    }

    @RequestMapping(value={"cloud/azure/searchEmail"}, method={RequestMethod.GET})
    public ResponseEntity<List<Person>> searchEmail(HttpServletRequest request, HttpServletResponse response) {
        logger.debug("@@@@@@@@@@@@@@ Inside Azure cloud/azure/searchEmail  ...............");
        String searchBy = request.getParameter("searchBy");
        List persons = new ArrayList();
        if (org.springframework.util.StringUtils.isEmpty((Object)searchBy)) {
            searchBy = request.getHeader("searchBy");
        }
        try {
            logger.debug(searchBy + "@@@@@@@@@@@@@@ Inside Azure searchEmail  ...............");
            persons = this.ldapService.searchUsersByEmail(searchBy);
            response.setStatus(200);
            logger.debug(persons.size() + "@@@@@@@@@@@@@@ Inside Azure searchEmail  ..............." + searchBy);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setHeader("errorMessage", e.getMessage());
            response.setStatus(500);
        }
        return new ResponseEntity(persons, HttpStatus.OK);
    }

    @RequestMapping(value={"cloud/azure/getPerson/ad/"}, method={RequestMethod.GET})
    public ResponseEntity<Person> searchUserFromAD(HttpServletRequest request, HttpServletResponse response) {
        logger.debug("@@@@@@@@@@@@@@ Inside Azure cloud/azure/getPerson/ad/  ...............");
        String userName = request.getParameter(USER_NAME);
        Person person = null;
        if (org.springframework.util.StringUtils.isEmpty((Object)userName)) {
            userName = request.getHeader(USER_NAME);
        }
        try {
            logger.debug(userName + "@@@@@@@@@@@@@@ Inside Azure cloud/azure/getPerson/ad/  ...............");
            person = this.ldapService.getPerson(userName);
            response.setStatus(200);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setHeader("errorMessage", e.getMessage());
            response.setStatus(500);
        }
        return new ResponseEntity((Object)person, HttpStatus.OK);
    }

    @RequestMapping(value={"/ldap/"}, method={RequestMethod.GET})
    public void uploadFileLatest1(HttpServletRequest request, HttpServletResponse httpResponse) {
        logger.debug("Inside file ldap ....  ");
        String userName = request.getHeader(USER_NAME);
        String decryptedPwd = request.getHeader("pwd");
        Object[] objArr = this.ldapService.authenticate(userName, decryptedPwd);
        boolean isAuthenticated = (Boolean)objArr[0];
        logger.debug(userName + " isAD authenticated ... " + isAuthenticated);
    }

    @RequestMapping(value={"cloud/{cloudName}/search/user/device"}, method={RequestMethod.GET})
    public ModelAndView searchUsersWithDevices(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), response)) {
                return null;
            }
            String userName = request.getHeader(USER_NAME);
            if (userName.isEmpty()) {
                response.setStatus(400);
                return null;
            }
            AuthorizationTokens authorizationTokens = this.authorizationService.getTokenDetailsForToken(cloudId, cloudName, token);
            User currentUser = authorizationTokens.getUser();
            List<SearchUserElement> userList = this.managementService.searchUsersWithDevices(cloudId, userName, currentUser);
            Collections.sort(userList, new Comparator<SearchUserElement>(){

                @Override
                public int compare(SearchUserElement u1, SearchUserElement u2) {
                    return new CompareToBuilder().append((Object)UserManagementController.getStatus(u1.isActive()), (Object)UserManagementController.getStatus(u2.isActive())).append((Object)u1.getUserName().toLowerCase(), (Object)u2.getUserName().toLowerCase()).toComparison();
                }
            });
            modelAndView.addObject(userList);
            response.setStatus(200);
        }
        catch (Exception e) {
            ErrorElement err = this.createErrorElement(null, e.getMessage());
            modelAndView.addObject((Object)err);
            response.setStatus(400);
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
        return modelAndView;
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/users/"}, method={RequestMethod.POST})
    public ModelAndView getUsersBasedOnNames(@PathVariable(value="cloudName") String cloudName1, @RequestBody List<String> userNames, @PathVariable(value="versionNumber") String versionNumber, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("calling /users/ ....");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        String cloudName = cloudName1;
        try {
            User currentUser;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            List<String> userNames1 = userNames;
            String token = request.getHeader("token");
            if (!this.performAuthorization(cloudId, cloudName, token, currentUser = new User(), response)) {
                return null;
            }
            List<UserElement> userList = this.managementService.getUserListByNames(cloudId, userNames1, currentUser.getUserName());
            modelAndView.addObject(userList);
            response.setStatus(200);
        }
        catch (EmptyResultDataAccessException e) {
            ErrorElement err = this.createErrorElement(null, USER_NOT_FOUND);
            modelAndView.addObject((Object)err);
            response.setStatus(409);
            logger.trace(EMPTY_RESULT_DATA_ACCESS_EXCEPTION + (Object)((Object)e));
            logger.error(EMPTY_RESULT_DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (BaseException e) {
            ErrorElement err = this.createErrorElement(e.getErrorCode(), null);
            modelAndView.addObject((Object)err);
            response.setStatus(400);
            logger.trace(BASE_EXCEPTION + (Object)((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
        }
        catch (Exception e) {
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
        return modelAndView;
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/users/block/"}, method={RequestMethod.POST})
    public void blockMultipleUsers(@PathVariable(value="cloudName") String cloudName1, @RequestBody List<String> userNames, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        List<String> userNames1 = userNames;
        UserElement emailUser = null;
        logger.debug("calling /users/block/ .........");
        String blockedBy = request.getHeader("blockedBy");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            boolean active = Boolean.parseBoolean(request.getHeader("active"));
            if (!this.performAuthorization(cloudId, cloudName, token, response)) {
                return;
            }
            if (active) {
                long totalUsersCount;
                long noOfUsersAllowed = (long)cl.getCloud().getNoOfUsersAllowed() - this.managementService.countOfPresentUsers(cloudId);
                if (noOfUsersAllowed < (totalUsersCount = (long)userNames1.size())) {
                    response.setHeader("no-of-possible-users", Long.toString(noOfUsersAllowed));
                    response.setStatus(417);
                    return;
                }
                int code = this.deviceAndUserSecurityService.validateUserRestrictions(cl.getCloud().getCloudId(), cloudName, cl.getCloud());
                if (!this.checkLicense(code, response)) {
                    return;
                }
            }
            if (userNames1.contains(blockedBy)) {
                userNames1.remove(blockedBy);
            }
            for (String userName : userNames1) {
                emailUser = this.blockOrUnblockUser(cloudName, userName, response, modelAndView, blockedBy, cloudId, active);
                if (emailUser == null) continue;
                this.managementService.multipleUserBlockOrDeleteMail(cloudName, cloudId, blockedBy, emailUser.getUserName(), emailUser.getEmailId(), "user-blocked");
            }
        }
        catch (EmptyResultDataAccessException e) {
            ErrorElement err = this.createErrorElement(null, USER_NOT_FOUND);
            modelAndView.addObject((Object)err);
            response.setStatus(409);
            logger.trace(EMPTY_RESULT_DATA_ACCESS_EXCEPTION + (Object)((Object)e));
            logger.error(EMPTY_RESULT_DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (DataAccessException e) {
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
            logger.trace(DATA_ACCESS_EXCEPTION + (Object)((Object)e));
            logger.error(DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (BaseException e) {
            ErrorElement err = this.createErrorElement(e.getErrorCode(), null);
            modelAndView.addObject((Object)err);
            response.setStatus(400);
            logger.trace(BASE_EXCEPTION + (Object)((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
        }
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/users/delete/"}, method={RequestMethod.POST})
    public void markMultipleUsersAsDelete(@PathVariable(value="cloudName") String cloudName1, @RequestBody List<String> userNames, HttpServletRequest request, HttpServletResponse response) {
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        UserElement emailUser = null;
        String cloudName = cloudName1;
        String deletedBy = request.getHeader("deletedBy");
        logger.debug("calling /users/delete/ ........" + userNames);
        try {
            String token;
            String failedUsersList = "";
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), response)) {
                response.setStatus(400);
                return;
            }
            for (String userName : userNames) {
                emailUser = this.markUserAsDelete(cloudName, response, userName, deletedBy, cloudId, failedUsersList);
                if (emailUser == null) continue;
                this.managementService.multipleUserBlockOrDeleteMail(cloudName, cloudId, deletedBy, emailUser.getUserName(), emailUser.getEmailId(), "user-delete");
            }
        }
        catch (EmptyResultDataAccessException e) {
            ErrorElement err = this.createErrorElement(null, USER_NOT_FOUND);
            modelAndView.addObject((Object)err);
            response.setStatus(409);
            logger.trace(EMPTY_RESULT_DATA_ACCESS_EXCEPTION + (Object)((Object)e));
            logger.error(EMPTY_RESULT_DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (DataAccessException e) {
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
            logger.trace(DATA_ACCESS_EXCEPTION + (Object)((Object)e));
            logger.error(DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (BaseException e) {
            ErrorElement err = this.createErrorElement(e.getErrorCode(), null);
            modelAndView.addObject((Object)err);
            response.setStatus(400);
            logger.trace(BASE_EXCEPTION + (Object)((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/users/authenticate"}, method={RequestMethod.POST})
    public ModelAndView authenticateNew(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        logger.debug("calling /authenticate ...");
        response.setHeader(ACCESS_CONTROL_ALLOW_ORIGIN, "*");
        response.setHeader(ACCESS_CONTROL_ALLOW_METHODS, POST_GET_OPTIONS_DELETE);
        response.setHeader(ACCESS_CONTROL_MAX_AGE, "3600");
        response.setHeader(ACCESS_CONTROL_ALLOW_HEADERS, X_REQUESTED_WITH_FIRST_LOGIN_TOKEN);
        String username = "";
        String client = "";
        String password = "";
        String deviceName = "";
        int cloudId = 0;
        try {
            String token;
            Cloud cloud;
            block29: {
                int clientType;
                block28: {
                    password = request.getHeader(PASSWORD);
                    deviceName = request.getHeader(DEVICE_NAME);
                    client = request.getHeader(CLIENT_TYPE);
                    username = request.getHeader(USER_NAME);
                    CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
                    if (!this.checkLicense(cl, response)) {
                        logger.debug("@@@ Inside authenticate invalid license ...");
                        return null;
                    }
                    cloud = cl.getCloud();
                    cloudName = cloud.getCloudName();
                    clientType = 1;
                    if (client != null) {
                        logger.debug("@@@ Inside client selection ..." + client);
                        clientType = PCClientTypes.getClientType((String)client);
                    }
                    cloudId = cloud.getCloudId();
                    boolean isLdapEnabledForCloud = this.isLdapEnabledForCloud(cl);
                    logger.debug(" LDAPENABLED ............  " + isLdapEnabledForCloud);
                    String parabluSuperUserName = "NEED TO CLEAN API";
                    if (!isLdapEnabledForCloud || username.equalsIgnoreCase(parabluSuperUserName)) break block28;
                    String ldapPwdEnc = request.getHeader("ldapPwdEnc");
                    String decryptedPwd = this.getDecryptePassword(ldapPwdEnc);
                    Object[] objArr = this.ldapService.authenticate(username, decryptedPwd);
                    boolean isAuthenticated = (Boolean)objArr[0];
                    String licenseEnabled = (String)objArr[1];
                    if (isAuthenticated) {
                        block27: {
                            try {
                                logger.debug("checking for user info>>>>>>>>>>if not migrate from AD..........");
                                UserElement userElement = this.managementService.getUserInfo(cloudId, cloudName, username);
                                if (userElement != null) {
                                    logger.debug("user exists ........ " + userElement.getUserName());
                                }
                            }
                            catch (EmptyResultDataAccessException accessException) {
                                logger.debug("user is null so migrate from AD..........");
                                boolean success = this.checkWithADandMigrateUser(cl, cloudId, cloudName, username, response);
                                if (success) break block27;
                                logger.error(" Authentication failed  for user " + username + "............");
                                logger.error(EMPTY_RESULT_DATA_ACCESS_EXCEPTION + (Object)((Object)accessException));
                                logger.debug(EMPTY_RESULT_DATA_ACCESS_EXCEPTION + accessException.getMessage());
                                return null;
                            }
                        }
                        UserElement ue = this.getUserElement(username, cloud);
                        if (!org.springframework.util.StringUtils.isEmpty((Object)licenseEnabled)) {
                            if (licenseEnabled.equalsIgnoreCase(BKP_SYNC)) {
                                ue.setBackupEnabled(true);
                                ue.setSyncEnabled(true);
                            } else if (licenseEnabled.equalsIgnoreCase(BKP)) {
                                ue.setBackupEnabled(true);
                                ue.setSyncEnabled(false);
                                ue.setSyncWebAccessEnabled(false);
                            } else if (licenseEnabled.equalsIgnoreCase(SYNC)) {
                                ue.setBackupEnabled(false);
                                ue.setSyncEnabled(true);
                            }
                        }
                        logger.debug(" USer authenticated .... " + username + ".... is active ...." + ue.isActive());
                        if (!ue.isActive()) {
                            throw new BaseException("User is not active", 403);
                        }
                        client = StringUtils.isEmpty((String)client) || client.equalsIgnoreCase(PORTAL) ? PORTAL : client.toLowerCase();
                        UUID uuid = UUID.randomUUID();
                        token = String.valueOf(uuid);
                        logger.debug(token + " addTokenByUser  .... " + client);
                        this.authorizationService1.addTokenByUser(cloudId, cloudName, token, username, clientType);
                        this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, LOGGED_INTO + client, username, "", deviceName, System.currentTimeMillis(), PCActionTypes.LOGIN.getActionTypeValue());
                        logger.debug(GET_USER_INFO_BACKUP_ENABLED + ue.isBackupEnabled());
                        modelAndView.addObject((Object)ue);
                        this.managementService.updateUserLoggedInTime(cloudId, username);
                        break block29;
                    } else {
                        response.setStatus(400);
                        String ip = request.getHeader("ip");
                        String osType = request.getHeader(OS_TYPE);
                        String browser = request.getHeader(BROWSER);
                        String hostIPDomain = "";
                        logger.debug(" ip ostype,  browser .................. " + ip + ".. " + osType + "...." + browser);
                        if (!(org.springframework.util.StringUtils.isEmpty((Object)ip) && org.springframework.util.StringUtils.isEmpty((Object)osType) && org.springframework.util.StringUtils.isEmpty((Object)browser))) {
                            hostIPDomain = " from the ip address " + ip + " using  the domain Name " + browser + " and the OS Type was " + osType;
                        }
                        this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, " login  failed from " + client + hostIPDomain, username, "", "", System.currentTimeMillis(), PCActionTypes.LOGIN.getActionTypeValue());
                        return null;
                    }
                }
                User u = this.managementService.authenticate(cloudId, cloudName, username, password);
                client = StringUtils.isEmpty((String)client) || client.equalsIgnoreCase(PORTAL) ? PORTAL : client.toLowerCase();
                this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, LOGGED_INTO + client, username, "", deviceName, System.currentTimeMillis(), PCActionTypes.LOGIN.getActionTypeValue());
                UUID uuid = UUID.randomUUID();
                token = String.valueOf(uuid);
                this.authorizationService1.addTokenByUser(cloudId, cloudName, token, username, clientType);
                if (u.isSyncEnabled() || u.isBackupEnabled() || u.isServerBackupEnabled()) {
                    List<DeviceElement> devices = this.deviceManagementService.getDevicesForUser(cloudId, cloudName, u.getUserName());
                    if (devices != null && !devices.isEmpty()) {
                        response.setHeader("has-connected-clients", "true");
                    } else {
                        response.setHeader("has-connected-clients", FALSE);
                    }
                }
                if (u.isFirstLogin()) {
                    response.setHeader("firstLogin", "true");
                    u.setFirstLogin(false);
                    this.managementService.updateUserInfo(cloudId, cloudName, u);
                } else {
                    response.setHeader("firstLogin", FALSE);
                }
                UserElement ue = this.getUserElement(username, cloud);
                logger.debug(GET_USER_INFO_BACKUP_ENABLED + ue.isBackupEnabled());
                this.managementService.updateUserLoggedInTime(cloudId, username);
            }
            response.setHeader("token", token);
            response.setHeader(CLOUD_NAME, cloud.getCloudName());
            response.setStatus(202);
            response.setHeader("Access-Control-Expose-Headers", "token, firstLogin, cloudName, connectedClients");
            return modelAndView;
        }
        catch (DataIntegrityViolationException e) {
            logger.trace(INSIDE_AUTHENTICATE_DATA_INTEGRITY_VIOLATON_EXCEPTION + (Object)((Object)e));
            response.setStatus(401);
            logger.error(INSIDE_AUTHENTICATE_DATA_INTEGRITY_VIOLATON_EXCEPTION + e.getMessage());
            return modelAndView;
        }
        catch (DataAccessException e) {
            logger.trace(DATA_ACCESS_EXCEPTION + (Object)((Object)e));
            logger.error("@@@ Inside authenticate DataAccessException..." + e.getMessage());
            response.setStatus(401);
            return modelAndView;
        }
        catch (BaseException e) {
            logger.trace(BASE_EXCEPTION + (Object)((Object)e));
            logger.error("@@@ Inside authenticate BaseException..." + e.getMessage());
            if ("Bad Credentials.".equalsIgnoreCase(e.getMessage())) {
                String ip = request.getHeader("ip");
                String osType = request.getHeader(OS_TYPE);
                String browser = request.getHeader(BROWSER);
                String hostIPDomain = "";
                logger.debug(username + " ..... " + password + " ..........ip ostype, browser .................. " + ip + ".. " + osType + "...." + browser);
                if (!(org.springframework.util.StringUtils.isEmpty((Object)ip) && org.springframework.util.StringUtils.isEmpty((Object)osType) && org.springframework.util.StringUtils.isEmpty((Object)browser))) {
                    hostIPDomain = " from the ip address " + ip + " using the domain Name " + browser + " and the OS Type was " + osType;
                }
                this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, " login  failed from " + client + hostIPDomain, username, "", "", System.currentTimeMillis(), PCActionTypes.LOGIN.getActionTypeValue());
            }
            response.setStatus(e.getErrorStatus());
            return modelAndView;
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error("@@@ Exception..." + e.getMessage());
        }
        return modelAndView;
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/liteVersion"}, method={RequestMethod.GET})
    public ModelAndView getLiteVersioProperties(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        logger.debug("calling /liteVersion ...");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            Cloud cloud = cl.getCloud();
            int cloudId = cloud.getCloudId();
            LiteVersion liteVersion = this.liteVersionManagementService.getLiteVersionProperties(cloudId);
            if (liteVersion == null) {
                logger.debug("lite version properties are empty");
                response.setStatus(204);
                return null;
            }
            modelAndView.addObject((Object)liteVersion);
            response.setStatus(200);
        }
        catch (Exception e) {
            response.setStatus(500);
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
        return modelAndView;
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/checkAdConnection"}, method={RequestMethod.GET})
    public void checkADConnection(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("calling check Ad connection ");
        String cloudName = cloudName1;
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return;
            }
            int cloudId = cl.getCloud().getCloudId();
            this.ldapService.checkAdConnection(cloudId, response);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace(EXCEPTION + (Object)((Object)e));
            logger.error(EXCEPTION + e.getMessage());
        }
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/users/createExcel/"}, method={RequestMethod.POST})
    public void createExcel(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, @RequestBody ReportQueryElement userQueryElement, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("Cloud name :" + cloudName);
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        if (!this.checkLicense(cl, response)) {
            logger.debug("Invalid Cloud Name.....");
            return;
        }
        try {
            int cloudId = cl.getCloud().getCloudId();
            String userName = userQueryElement.getUserName();
            boolean isExcelCreated = this.managementService.createExcelForUsers(cl, cloudId, userName);
            if (isExcelCreated) {
                response.setStatus(200);
            } else {
                response.setStatus(403);
            }
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
        }
    }

    private boolean authenticateAADUser(Cloud cloud, UserElement userElement, String password) {
        boolean success = false;
        AADUserElement aaDUserRequestElement = new AADUserElement();
        String userPrincipleName = userElement.getUserName();
        if (!org.springframework.util.StringUtils.isEmpty((Object)userElement.getAadLoginId())) {
            userPrincipleName = userElement.getAadLoginId();
        }
        aaDUserRequestElement.setPassword(password);
        aaDUserRequestElement.setUserName(userPrincipleName);
        logger.debug("...userPrincipleName..." + userPrincipleName);
        AADUserElement aadUser = null;
        try {
            aadUser = (AADUserElement)this.aadManagementService.getAADUser(cloud, userPrincipleName, password);
        }
        catch (Exception e) {
            logger.debug("Fail to login for " + userPrincipleName);
            return false;
        }
        if (aadUser != null) {
            logger.debug("login sucees in aad for " + userPrincipleName);
            return true;
        }
        return success;
    }

    private boolean migrateUserFromAAD(String userPrincipleName, String password, CloudLicenseTo cl, Cloud cloud, String cloudName, HttpServletResponse response) {
        int code;
        boolean success = false;
        AADUserElement aaDUserRequestElement = new AADUserElement();
        aaDUserRequestElement.setPassword(password);
        aaDUserRequestElement.setUserName(userPrincipleName);
        AADUserElement aadUser = (AADUserElement)this.aadManagementService.getAADUser(cloud, userPrincipleName, password);
        if (aadUser == null) {
            logger.debug("Fail to login for " + userPrincipleName);
            return success;
        }
        if (org.springframework.util.StringUtils.isEmpty((Object)aadUser.getProductType())) {
            logger.debug("User not part of any product");
            return success;
        }
        boolean isSyncEnabled = false;
        boolean isBackupEnabled = false;
        boolean isO365BkpEnabled = false;
        List list = cl.getCloud().getCloudCustomisableDetails();
        for (CloudCustomisableDetails customisableDetails : list) {
            if (customisableDetails.getName().equalsIgnoreCase(SYNC_ENABLED)) {
                isSyncEnabled = true;
            }
            if (customisableDetails.getName().equalsIgnoreCase(BACK_UP_ENABLED)) {
                isBackupEnabled = true;
            }
            if (!"OneDrive Backup Enabled".equalsIgnoreCase(customisableDetails.getName())) continue;
            isO365BkpEnabled = true;
        }
        if ("SYNC".equalsIgnoreCase(aadUser.getProductType())) {
            isBackupEnabled = false;
        }
        if (BACKUP.equalsIgnoreCase(aadUser.getProductType())) {
            isSyncEnabled = false;
        }
        if (!this.checkLicense(code = this.deviceAndUserSecurityService.validateUserRestrictions(cloud.getCloudId(), cloudName, cl.getCloud()), response)) {
            logger.debug("USER LIMIT REACHED........");
            this.sendEmailForUserDeviceLimitExceeded(cloud.getCloudId(), cloudName, aadUser.getUserPrincipalName(), "User");
            throw new BaseException("User limit reached");
        }
        if (isSyncEnabled && !this.checkLicense(code = this.deviceAndUserSecurityService.validateSyncUserRestrictions(cloud.getCloudId(), cloudName, cl.getCloud()), response)) {
            logger.debug(" SYNC USER LIMIT REACHED........");
            this.sendEmailForUserDeviceLimitExceeded(cloud.getCloudId(), cloudName, aadUser.getUserPrincipalName(), "Sync User");
            return success;
        }
        if (isBackupEnabled && !this.checkLicense(code = this.deviceAndUserSecurityService.validateBackupUserRestrictions(cloud.getCloudId(), cloudName, cl.getCloud()), response)) {
            logger.debug("BACKUP USER LIMIT REACHED........");
            this.sendEmailForUserDeviceLimitExceeded(cloud.getCloudId(), cloudName, aadUser.getUserPrincipalName(), "Backup User");
            return success;
        }
        if (isO365BkpEnabled && !this.checkLicense(code = this.deviceAndUserSecurityService.validateO365BackupUserRestrictions(cloud.getCloudId(), cloudName, cl.getCloud()), response)) {
            logger.debug("O365 BACKUP USER LIMIT REACHED........");
            this.sendEmailForUserDeviceLimitExceeded(cloud.getCloudId(), cloudName, aadUser.getUserPrincipalName(), "O365 User");
            return success;
        }
        LdapUserElement ldapUserElement = new LdapUserElement();
        ldapUserElement.setUserName(aadUser.getUserPrincipalName());
        if (org.springframework.util.StringUtils.isEmpty((Object)aadUser.getMail())) {
            ldapUserElement.setEmailId(aadUser.getUserPrincipalName());
        } else {
            ldapUserElement.setEmailId(aadUser.getMail());
        }
        ldapUserElement.setDisplayName(aadUser.getDisplayName());
        ldapUserElement.setDefaultPolicy(PCHelperConstant.getPropertyFileValueDefaultBkpPolicy());
        ldapUserElement.setDefaultSyncPolicy(PCHelperConstant.getPropertyFileValueDefaultSyncPolicy());
        ldapUserElement.setDefaultO365Policy(PCHelperConstant.getPropertyFileValueDefaultO365PolicyName());
        ldapUserElement.setLocation(aadUser.getOfficeLocation());
        ldapUserElement.setDepartment(aadUser.getDepartment());
        ldapUserElement.setAccountStatus(true);
        boolean userCreated = false;
        try {
            userCreated = this.managementService.createUserFromLdap(cloud.getCloudId(), cloudName, ldapUserElement, "AUTO", isSyncEnabled, isBackupEnabled, isO365BkpEnabled);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(401);
            success = false;
        }
        if (userCreated) {
            this.auditHistoryService.saveStatisticToDatabase(cloud.getCloudId(), cloudName, "migrated", "Auto", ldapUserElement.getUserName(), "Portal", System.currentTimeMillis(), PCActionTypes.AAD_USER_MIGRATION.getActionTypeValue());
            success = true;
        }
        return success;
    }

    private boolean isAADEnabled(List<CloudCustomisableDetails> list) {
        boolean isAADEnabled = false;
        for (CloudCustomisableDetails customisableDetails : list) {
            if (!"AAD Enabled".equals(customisableDetails.getName())) continue;
            isAADEnabled = true;
            break;
        }
        return isAADEnabled;
    }

    @RequestMapping(value={"cloud/{cloudName}/users/createExcelForBlackListAndMappedUser"}, method={RequestMethod.GET})
    public void createBlackListAndODBUsers(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("Cloud name :" + cloudName);
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            logger.debug(request.getHeader("secAdmin") + "....secAdmin");
            logger.debug(request.getHeader("is-all-user") + "....");
            boolean isAllUser = Boolean.parseBoolean(request.getHeader("is-all-user"));
            boolean secAdmin = Boolean.parseBoolean(request.getHeader("secAdmin"));
            if (!this.checkLicense(cl, response)) {
                logger.debug("Invalid Cloud Name.....");
                return;
            }
            if (!secAdmin && !this.isODBEnabled(cl.getCloud().getCloudCustomisableDetails())) {
                response.setStatus(450);
                return;
            }
            boolean isTextCreated = this.managementService.createTextForBlackListAndMappedUser(cl.getCloud().getCloudId(), cloudName, isAllUser, secAdmin);
            logger.debug("..isTextCreated.." + isTextCreated);
            if (isTextCreated) {
                response.setStatus(200);
                FileInputStream inputStream = new FileInputStream(new File("/var/www/odbInfo/BlackList_And_Active_User.txt"));
                FileCopyUtils.copy((InputStream)inputStream, (OutputStream)response.getOutputStream());
                logger.debug("....new changes ");
            } else {
                response.setStatus(204);
            }
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/users/mapODBId"}, method={RequestMethod.POST})
    public void mapODBId(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response, @RequestBody UserListElement userList) {
        String cloudName = cloudName1;
        logger.debug("Cloud name :" + cloudName);
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                logger.debug("Invalid Cloud Name.....");
                return;
            }
            if (!this.isODBEnabled(cl.getCloud().getCloudCustomisableDetails())) {
                response.setStatus(450);
                return;
            }
            logger.debug("...");
            this.managementService.mapODBIdsByFilePath(userList);
            response.setStatus(200);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/users/mapODBIdAndErrorCode"}, method={RequestMethod.POST})
    public void mapODBIdAndErrorCode(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response, @RequestBody UserListElement userList) {
        String cloudName = cloudName1;
        logger.debug("Cloud name :" + cloudName);
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                logger.debug("Invalid Cloud Name.....");
                return;
            }
            if (!this.isODBEnabled(cl.getCloud().getCloudCustomisableDetails())) {
                response.setStatus(450);
                return;
            }
            logger.debug("...");
            this.managementService.mapODBIdAndErrorCode(userList);
            response.setStatus(200);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
        }
    }

    private boolean isODBEnabled(List<CloudCustomisableDetails> licenseDetails) {
        boolean isODBEnabled = false;
        for (CloudCustomisableDetails license : licenseDetails) {
            if (license == null || !ODB_ENABLED.equalsIgnoreCase(license.getName())) continue;
            isODBEnabled = true;
            break;
        }
        return isODBEnabled;
    }

    private void sendEmailForUserDeviceLimitExceeded(int cloudId, String cloudName, String userName, String userLicense) {
        EmailProps email = new EmailProps();
        ArrayList<EmailRecipent> emailRecipents = new ArrayList<EmailRecipent>();
        email.setAction("user-limit-reached");
        EmailRecipent emailRecipent = new EmailRecipent();
        try {
            List<User> allAdmins = this.managementService.getAllAdmins(cloudId, cloudName);
            for (User adminUser : allAdmins) {
                emailRecipent = new EmailRecipent();
                emailRecipent.setUserName(adminUser.getUserName());
                emailRecipent.setEmail(adminUser.getEmailId());
                emailRecipents.add(emailRecipent);
            }
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
        logger.debug("Toatal email recipents count...:" + emailRecipents.size());
        email.setActionBy("");
        email.setStartDate(DateUtil.getDateInddMMMyyyy((long)System.currentTimeMillis()));
        email.setDeviceName(userName);
        email.setRecipents(emailRecipents);
        email.setToUser(true);
        email.setBodyData("Portal");
        email.setSupportDescription(userLicense);
        email.setUserName(userName);
        email.setActionOn(userName);
        email.setUserName(userName);
        this.cloudMailService.sendMail(email);
    }

    private boolean migrateUserFromAAD(AADUserElement aadUser, CloudLicenseTo cl, Cloud cloud, String cloudName, HttpServletResponse response) {
        int code;
        boolean success = false;
        if (aadUser == null) {
            logger.debug("aadUser user is null ");
            return success;
        }
        if (org.springframework.util.StringUtils.isEmpty((Object)aadUser.getProductType())) {
            logger.debug("User not part of any product");
            return success;
        }
        boolean isSyncEnabled = false;
        boolean isBackupEnabled = false;
        boolean isO365BkpEnabled = false;
        List list = cl.getCloud().getCloudCustomisableDetails();
        for (CloudCustomisableDetails customisableDetails : list) {
            if (customisableDetails.getName().equalsIgnoreCase(SYNC_ENABLED)) {
                isSyncEnabled = true;
            }
            if (customisableDetails.getName().equalsIgnoreCase(BACK_UP_ENABLED)) {
                isBackupEnabled = true;
            }
            if (!"OneDrive Backup Enabled".equalsIgnoreCase(customisableDetails.getName())) continue;
            isO365BkpEnabled = true;
        }
        if ("SYNC".equalsIgnoreCase(aadUser.getProductType())) {
            isBackupEnabled = false;
        }
        if ("BACKUP".equalsIgnoreCase(aadUser.getProductType())) {
            isSyncEnabled = false;
        }
        if (!this.checkLicense(code = this.deviceAndUserSecurityService.validateUserRestrictions(cloud.getCloudId(), cloudName, cl.getCloud()), response)) {
            logger.debug("USER LIMIT REACHED........");
            return success;
        }
        if (isSyncEnabled && !this.checkLicense(code = this.deviceAndUserSecurityService.validateSyncUserRestrictions(cloud.getCloudId(), cloudName, cl.getCloud()), response)) {
            logger.debug(" SYNC USER LIMIT REACHED........");
            return success;
        }
        if (isBackupEnabled && !this.checkLicense(code = this.deviceAndUserSecurityService.validateBackupUserRestrictions(cloud.getCloudId(), cloudName, cl.getCloud()), response)) {
            logger.debug("BACKUP USER LIMIT REACHED........");
            return success;
        }
        if (isO365BkpEnabled && !this.checkLicense(code = this.deviceAndUserSecurityService.validateO365BackupUserRestrictions(cloud.getCloudId(), cloudName, cl.getCloud()), response)) {
            logger.debug("O365 BACKUP USER LIMIT REACHED........");
            this.sendEmailForUserDeviceLimitExceeded(cloud.getCloudId(), cloudName, aadUser.getUserPrincipalName(), "O365 User");
            return success;
        }
        LdapUserElement ldapUserElement = new LdapUserElement();
        ldapUserElement.setUserName(aadUser.getUserPrincipalName());
        if (org.springframework.util.StringUtils.isEmpty((Object)aadUser.getMail())) {
            ldapUserElement.setEmailId(aadUser.getUserPrincipalName());
        } else {
            ldapUserElement.setEmailId(aadUser.getMail());
        }
        ldapUserElement.setDisplayName(aadUser.getDisplayName());
        ldapUserElement.setDefaultPolicy(PCHelperConstant.getPropertyFileValueDefaultBkpPolicy());
        ldapUserElement.setDefaultSyncPolicy(PCHelperConstant.getPropertyFileValueDefaultSyncPolicy());
        ldapUserElement.setDefaultO365Policy(PCHelperConstant.getPropertyFileValueDefaultO365PolicyName());
        ldapUserElement.setLocation(aadUser.getOfficeLocation());
        ldapUserElement.setDepartment(aadUser.getDepartment());
        ldapUserElement.setAccountStatus(true);
        boolean userCreated = false;
        try {
            userCreated = this.managementService.createUserFromLdap(cloud.getCloudId(), cloudName, ldapUserElement, "AUTO", isSyncEnabled, isBackupEnabled, isO365BkpEnabled);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(401);
            success = false;
        }
        if (userCreated) {
            this.auditHistoryService.saveStatisticToDatabase(cloud.getCloudId(), cloudName, "migrated", "Auto", ldapUserElement.getUserName(), "Portal", System.currentTimeMillis(), PCActionTypes.AAD_USER_MIGRATION.getActionTypeValue());
            success = true;
        }
        return success;
    }

    @RequestMapping(value={"cloud/{cloudName}/envDetails/"}, method={RequestMethod.GET})
    public ModelAndView getEnvDetails(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        logger.debug("cloud/{cloudName}/envDetails/....");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            if (this.isAADEnabled(cl.getCloud().getCloudCustomisableDetails())) {
                response.setHeader("aadEnabled", "true");
                AADCredentialsElement aadCredentialsElement = this.aadManagementService.getAADCredentials(cl.getCloud().getCloudId());
                if (aadCredentialsElement != null) {
                    CloudPropertyElement cloudPropertyElement = this.licenseService.getCloudPropertyElement(cl.getCloud().getCloudId());
                    if (cloudPropertyElement != null && !cloudPropertyElement.isPortalSSOEnable()) {
                        response.setStatus(434);
                        return null;
                    }
                    modelAndView.addObject((Object)aadCredentialsElement);
                    response.setStatus(435);
                    return modelAndView;
                }
                response.setStatus(450);
                return null;
            }
            if (this.isLdapEnabledForCloud(cl)) {
                response.setHeader("adEnabled", "true");
            }
            response.setStatus(200);
            return modelAndView;
        }
        catch (Exception e) {
            response.setStatus(500);
            logger.trace(BASE_EXCEPTION + e);
            logger.error(BASE_EXCEPTION + e.getMessage());
            return modelAndView;
        }
    }
}

