/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.udc.controller;

import com.parablu.bluvault.ah.service.AuditHistoryService;
import com.parablu.bluvault.mem.MemoryStore;
import com.parablu.bluvault.udc.controller.BaseController;
import com.parablu.bluvault.udc.controller.DeviceManagementController;
import com.parablu.bluvault.udc.service.DeviceManagementService;
import com.parablu.bluvault.udc.service.EventHubManagementService;
import com.parablu.cloud.security.service.AuthorizationService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.cloud.security.to.CloudLicenseTo;
import com.parablu.paracloud.constant.PCActionTypes;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.DeviceElement;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.DeviceBackupOverView;
import com.parablu.pcbd.domain.EventHub;
import com.parablu.pcbd.domain.EventHubElement;
import com.parablu.pcbd.domain.User;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class EventHubContoller
extends BaseController {
    private static Logger logger = LoggerFactory.getLogger(DeviceManagementController.class);
    private static final String EXCEPTION = " Exception  :";
    protected static final String JSONVIEW = "jsonview";
    private static final String CLIENT_TYPE = "clientType";
    private static final String CRAWL_LIMIT = "crawlLimit";
    @Autowired
    private EventHubManagementService eventHubManagementService;
    @Autowired
    private LicenseService licenseService;
    @Autowired
    private DeviceManagementService deviceManagementService;
    @Autowired
    private AuthorizationService authorizationService1;
    @Autowired
    private AuditHistoryService auditHistoryService;
    private static final String STOP_BACKUP_ERROR_CODE = "1207";
    private static final String PAUSE_BACKUP_ERROR_CODE = "1992";

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/eventHub/events/"}, method={RequestMethod.POST})
    public void editAction(@PathVariable(value="cloudName") String cloudName1, @RequestBody EventHubElement eventHubElement, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling versions/{versionNumber}/clouds/{cloudName}/eventHub/events/...  to edit action");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            User currentUser = new User();
            String token = request.getHeader("token");
            if (!this.performAuthorization(cloudId, cloudName, token, currentUser, response)) {
                return;
            }
            if (eventHubElement.getActionToDeviceUUID() == null) {
                logger.debug("deviceUUID is null ");
                response.setStatus(406);
                return;
            }
            String actionByUserName = this.authorizationService1.getTokenDetailsForToken(cloudId, cloudName, token).getUser().getUserName();
            DeviceElement deviceElement = this.deviceManagementService.getDeviceInfo(cloudId, cloudName, eventHubElement.getActionToDeviceUUID());
            String acctionToUserName = deviceElement.getUserName();
            logger.debug("..... device type..... " + deviceElement.getDeviceType());
            logger.debug(request.getHeader("isStopBackup") + "..... device type..... " + request.getHeader("isPauseBackup"));
            if (Boolean.parseBoolean(request.getHeader("isPauseBackup"))) {
                logger.debug("..entering pause event...");
                String errorCode = PAUSE_BACKUP_ERROR_CODE;
                this.eventHubManagementService.updateBackupBatchForStopAndPauseBkp(cloudId, eventHubElement.getActionToDeviceUUID(), errorCode);
                this.addAuditHistory(cloudName1, cl, currentUser, deviceElement, PCHelperConstant.EVENTHUB_ACTION.PAUSE_BACKUP.toString(), false);
                response.setStatus(200);
                logger.debug("...pause backup... " + eventHubElement.getActionToDeviceUUID());
                return;
            }
            if (Boolean.parseBoolean(request.getHeader("isStopBackup"))) {
                String errorCode = STOP_BACKUP_ERROR_CODE;
                logger.debug("..entering StopBackup event...");
                this.eventHubManagementService.updateBackupBatchForStopAndPauseBkp(cloudId, eventHubElement.getActionToDeviceUUID(), errorCode);
                this.addAuditHistory(cloudName1, cl, currentUser, deviceElement, PCHelperConstant.EVENTHUB_ACTION.STOP_BACKUP.toString(), false);
                response.setStatus(200);
                logger.debug("...stopped backup... " + eventHubElement.getActionToDeviceUUID());
                return;
            }
            logger.debug("... creating event hub....");
            EventHub eventHub = new EventHub();
            eventHub.setActionBy(actionByUserName);
            eventHub.setActionStatus(PCHelperConstant.EVENTHUB_ACTION_STATUS.CREATED.toString());
            eventHub.setActionToUserName(acctionToUserName);
            eventHub.setActionToDeviceUUID(eventHubElement.getActionToDeviceUUID());
            if (Device.TYPE.ONEDRIVE.toString().equals(deviceElement.getDeviceType())) {
                eventHub.setOdStatus(EventHub.ODSTATUS.STARTED.toString());
            }
            List<String> actionsFromDb = this.eventHubManagementService.getActionsByUserNameAndAction(cloudId, cloudName1, eventHub);
            logger.debug("actions From Db" + actionsFromDb);
            ArrayList<String> actionsFromDb1 = new ArrayList<String>();
            actionsFromDb1.addAll(actionsFromDb);
            List actionsFormReqst = eventHubElement.getActions();
            if (!CollectionUtils.isEmpty((Collection)eventHubElement.getActions())) {
                actionsFromDb1.removeAll(actionsFormReqst);
                actionsFormReqst.removeAll(actionsFromDb);
                actionsFormReqst.forEach(action -> {
                    EventHub eventHubObj = new EventHub();
                    BeanUtils.copyProperties((Object)eventHub, (Object)eventHubObj);
                    logger.debug("actions Form Reqst" + actionsFormReqst);
                    logger.debug("action:" + action);
                    eventHubObj.setAction(action);
                    this.eventHubManagementService.saveAction(cloudId, cloudName1, eventHubObj);
                    this.addAuditHistory(cloudName1, cl, currentUser, deviceElement, (String)action, false);
                });
                actionsFromDb1.forEach(action -> {
                    logger.debug("actions From Db1" + actionsFromDb1);
                    eventHub.setAction(action);
                    this.eventHubManagementService.deleteAction(cloudId, cloudName1, eventHub);
                    if (action.contains(PCHelperConstant.EVENTHUB_ACTION.PULL_AGENTLOGS.toString()) || action.contains(PCHelperConstant.EVENTHUB_ACTION.PULL_HISTORICAL_LOGS.toString())) {
                        this.addAuditHistory(cloudName1, cl, currentUser, deviceElement, (String)action, true);
                    }
                });
            } else {
                this.eventHubManagementService.deleteAllActionByDeviceUUID(cloudId, eventHub);
                if (actionsFromDb.contains(PCHelperConstant.EVENTHUB_ACTION.PULL_AGENTLOGS.toString())) {
                    this.addAuditHistory(cloudName1, cl, currentUser, deviceElement, "PULL_AGENTLOGS", true);
                }
                if (actionsFromDb.contains(PCHelperConstant.EVENTHUB_ACTION.PULL_HISTORICAL_LOGS.toString())) {
                    this.addAuditHistory(cloudName1, cl, currentUser, deviceElement, "PULL_HISTORICAL_LOGS", true);
                }
                if (actionsFromDb.contains(PCHelperConstant.EVENTHUB_ACTION.STOP_BACKUP_WHILE_RESTORE.toString())) {
                    this.addAuditHistory(cloudName1, cl, currentUser, deviceElement, "STOP_BACKUP_WHILE_RESTORE", true);
                }
            }
            response.setStatus(200);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
        }
    }

    private void addAuditHistory(String cloudName, CloudLicenseTo cl, User currentUser, DeviceElement deviceElement, String actionFormPortal, boolean isDeletedSupportAction) {
        String Actionname = null;
        int actionType = 0;
        if (actionFormPortal.equals(PCHelperConstant.EVENTHUB_ACTION.PULL_AGENTLOGS.toString())) {
            if (!isDeletedSupportAction) {
                Actionname = "support logs for";
                actionType = PCActionTypes.PULL_AGENTLOGS_ENABLE.getActionTypeValue();
            } else {
                Actionname = "Disable support logs for";
                actionType = PCActionTypes.PULL_AGENTLOGS_DISABLE.getActionTypeValue();
            }
        }
        if (actionFormPortal.equals(PCHelperConstant.EVENTHUB_ACTION.PULL_HISTORICAL_LOGS.toString())) {
            if (!isDeletedSupportAction) {
                Actionname = "requested Historical logs for";
                actionType = PCActionTypes.PULL_HISTORICAL_LOGS_ENABLE.getActionTypeValue();
            } else {
                Actionname = "requested Disable Historical logs for";
                actionType = PCActionTypes.PULL_HISTORICAL_LOGS_DISABLE.getActionTypeValue();
            }
        }
        if (actionFormPortal.equals(PCHelperConstant.EVENTHUB_ACTION.STOP_BACKUP_WHILE_RESTORE.toString())) {
            if (!isDeletedSupportAction) {
                Actionname = "has Disabled backup  of ";
                actionType = PCActionTypes.STOP_BACKUP_WHILE_RESTORE.getActionTypeValue();
            } else {
                Actionname = "has Enabled backup of ";
                actionType = PCActionTypes.STOP_BACKUP_WHILE_RESTORE.getActionTypeValue();
            }
        }
        if (actionFormPortal.equals(PCHelperConstant.EVENTHUB_ACTION.FULL_BACKUP.toString()) && !isDeletedSupportAction) {
            Actionname = "requested Full backup of";
            actionType = PCActionTypes.START_BACKUP.getActionTypeValue();
        }
        if (actionFormPortal.equals(PCHelperConstant.EVENTHUB_ACTION.START_BACKUP.toString()) && !isDeletedSupportAction) {
            Actionname = "requested Start backup of";
            actionType = PCActionTypes.START_BACKUP.getActionTypeValue();
        }
        if (actionFormPortal.equals(PCHelperConstant.EVENTHUB_ACTION.STOP_BACKUP.toString()) && !isDeletedSupportAction) {
            Actionname = "requested Stop backup of";
            actionType = PCActionTypes.STOP_BACKUP.getActionTypeValue();
        }
        if (actionFormPortal.equals(PCHelperConstant.EVENTHUB_ACTION.PAUSE_BACKUP.toString()) && !isDeletedSupportAction) {
            Actionname = "requested Pause backup of";
            actionType = PCActionTypes.PAUSE_BACKUP.getActionTypeValue();
        }
        this.auditHistoryService.saveStatisticToDatabase(cl.getCloud().getCloudId(), cloudName, Actionname, currentUser.getUserName(), "device name:" + deviceElement.getDeviceName() + ", user Name:" + deviceElement.getUserName(), "Portal", System.currentTimeMillis(), actionType);
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/eventHub/events/"}, method={RequestMethod.GET})
    public ModelAndView getEvents(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String deviceUUID = request.getParameter("deviceUUID");
        logger.debug("...old api method versions/{versionNumber}/clouds/{cloudName}/eventHub/events/ ...." + deviceUUID);
        return this.getEvents(cloudName1, deviceUUID, request, response);
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/eventHub/events/{deviceUUID}"}, method={RequestMethod.GET})
    public ModelAndView editActions(@PathVariable(value="cloudName") String cloudName1, @PathVariable(value="deviceUUID") String deviceUUID, HttpServletRequest request, HttpServletResponse response) {
        return this.getEvents(cloudName1, deviceUUID, request, response);
    }

    private ModelAndView getEvents(String cloudName1, String deviceUUID, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName(JSONVIEW);
        String client = request.getHeader(CLIENT_TYPE);
        logger.debug("calling versions/{versionNumber}/clouds/{cloudName}/eventHub/events/...  to get action of " + deviceUUID);
        try {
            User user;
            String token;
            if (this.getCurrentCrawlLimit() > PCHelperConstant.getMaxCrawlHitCount()) {
                logger.debug("@@@CRAWL_COUNT has exceeded  /eventHub/events/{deviceUUID} the max limit of>>>:" + PCHelperConstant.getMaxCrawlHitCount() + "..sleep for 20 secs...");
                response.setStatus(500);
                return null;
            }
            this.incrementCrawlLimit();
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                this.decrementCrawlLimit();
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), user = new User(), response)) {
                this.decrementCrawlLimit();
                return null;
            }
            if (user != null && user.isSuspended()) {
                logger.debug("User is suspended.....");
                response.setStatus(400);
                return null;
            }
            Device device = this.deviceManagementService.getDeviceProperties(cloudId, cloudName, deviceUUID);
            if (device == null) {
                response.setStatus(406);
                this.decrementCrawlLimit();
                logger.error("...invalid device.....");
                return null;
            }
            long currentmillis = System.currentTimeMillis();
            DeviceBackupOverView overView = this.deviceManagementService.getDeviceBkpOverviewForDeviceUUID(cloudId, deviceUUID);
            if (overView != null) {
                String actionByUserName = user.getUserName();
                if (StringUtils.isEmpty((String)client)) {
                    this.deviceManagementService.updateLastHeardTime(cloudId, overView.getId());
                    logger.debug("[agentHeardTimeStamp][" + actionByUserName + "][" + deviceUUID + "][" + currentmillis + "]");
                }
                EventHub eventHub = new EventHub();
                eventHub.setActionBy(actionByUserName);
                eventHub.setActionToDeviceUUID(deviceUUID);
                String actionToUserName = overView.getUserName();
                eventHub.setActionToUserName(actionToUserName);
                long devicePolicyUpdatedTime = overView.getPolicyUpdatedTime();
                long timeStampOfPolicyModified = user.getPolicyModifiedTime();
                List<String> actions = this.eventHubManagementService.getActionForDevice(cloudId, cloudName, eventHub, timeStampOfPolicyModified, devicePolicyUpdatedTime);
                EventHubElement eventHubElement = new EventHubElement();
                eventHubElement.setActions(actions);
                eventHubElement.setActionToDeviceUUID(deviceUUID);
                eventHubElement.setActionToUserName(eventHub.getActionToUserName());
                modelAndView.addObject((Object)eventHubElement);
                response.setStatus(200);
                this.decrementCrawlLimit();
            }
            return modelAndView;
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
            this.decrementCrawlLimit();
            return null;
        }
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/eventHub/events/"}, method={RequestMethod.DELETE})
    public void deleteAction(@PathVariable(value="cloudName") String cloudName1, @RequestParam(value="deviceUUID") String deviceUUID, @RequestParam(value="action") String action, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName(JSONVIEW);
        logger.debug("calling versions/{versionNumber}/clouds/{cloudName}/eventHub/events/...  TO DELETE  ");
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), response)) {
                return;
            }
            String actionByUserName = this.authorizationService1.getTokenDetailsForToken(cloudId, cloudName, token).getUser().getUserName();
            DeviceElement deviceElement = this.deviceManagementService.getDeviceInfo(cloudId, cloudName, deviceUUID);
            String acctionToUserName = deviceElement.getUserName();
            EventHub eventHub = new EventHub();
            eventHub.setActionToDeviceUUID(deviceUUID);
            eventHub.setActionToUserName(acctionToUserName);
            eventHub.setActionBy(actionByUserName);
            eventHub.setAction(action);
            logger.debug("Deleteing action for user " + acctionToUserName + " for device " + deviceUUID + " action is " + action);
            this.eventHubManagementService.deleteAllLogEvents(cloudId, cloudName, eventHub);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
            return;
        }
    }

    private synchronized int getCurrentCrawlLimit() {
        int crawlLimit = 0;
        if (MemoryStore.get((String)CRAWL_LIMIT) != null) {
            crawlLimit = (Integer)MemoryStore.get((String)CRAWL_LIMIT);
        }
        logger.debug("@@@CURRENT-Crawl count ............. " + crawlLimit);
        return crawlLimit;
    }

    private synchronized void incrementCrawlLimit() {
        int crawlLimit = this.getCurrentCrawlLimit();
        MemoryStore.delete((String)CRAWL_LIMIT);
        MemoryStore.add((String)CRAWL_LIMIT, (Object)(++crawlLimit));
        logger.debug("@@@INCREMENT Crawl count ............. " + crawlLimit);
    }

    private synchronized void decrementCrawlLimit() {
        int crawlLimit = this.getCurrentCrawlLimit();
        if (crawlLimit > 0) {
            --crawlLimit;
        }
        MemoryStore.delete((String)CRAWL_LIMIT);
        MemoryStore.add((String)CRAWL_LIMIT, (Object)crawlLimit);
        logger.debug("@@@DECREMENT Crawl count ............. " + crawlLimit);
    }
}

