/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.udc.controller;

import com.parablu.bluvault.ah.service.AuditHistoryService;
import com.parablu.bluvault.udc.controller.BaseController;
import com.parablu.bluvault.udc.dto.AuthorizationDeviceTo;
import com.parablu.bluvault.udc.service.AADManagementService;
import com.parablu.bluvault.udc.service.AlertHistoryService;
import com.parablu.bluvault.udc.service.DeviceManagementService;
import com.parablu.bluvault.udc.service.UserManagementService;
import com.parablu.cloud.security.service.AuthorizationService;
import com.parablu.cloud.security.service.DeviceAndUserSecurityService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.cloud.security.to.CloudLicenseTo;
import com.parablu.helper.element.ErrorElement;
import com.parablu.helper.exceptions.BaseException;
import com.parablu.helper.utils.MD5Generator;
import com.parablu.mail.service.CloudMailService;
import com.parablu.mt.service.LdapService;
import com.parablu.paracloud.constant.PCActionTypes;
import com.parablu.paracloud.constant.PCClientTypes;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.AADCredentialsElement;
import com.parablu.paracloud.element.AADUserElement;
import com.parablu.paracloud.element.BluSyncGroupBackupPolicyElement;
import com.parablu.paracloud.element.BluSyncGroupSyncPolicyElement;
import com.parablu.paracloud.element.DeviceContainerElement;
import com.parablu.paracloud.element.DeviceContainerListElement;
import com.parablu.paracloud.element.DeviceElement;
import com.parablu.paracloud.element.DeviceListElement;
import com.parablu.paracloud.element.DeviceRegistrationElement;
import com.parablu.paracloud.element.EditDeviceContainerElement;
import com.parablu.paracloud.element.EmailProps;
import com.parablu.paracloud.element.EmailRecipent;
import com.parablu.paracloud.element.EndpointUiPreferencesElement;
import com.parablu.paracloud.element.LdapUserElement;
import com.parablu.paracloud.element.UserAnouncement;
import com.parablu.paracloud.element.UserElement;
import com.parablu.paracloud.element.response.DeviceElementResponse;
import com.parablu.paracloud.util.DateUtil;
import com.parablu.pcbd.domain.AlertHistory;
import com.parablu.pcbd.domain.AuthorizationTokens;
import com.parablu.pcbd.domain.BackupPolicy;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.DeviceBackupOverView;
import com.parablu.pcbd.domain.Group;
import com.parablu.pcbd.domain.Person;
import com.parablu.pcbd.domain.ReportQueryElement;
import com.parablu.pcbd.domain.User;
import com.parablu.pcsd.domain.SyncPolicy;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Scanner;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class DeviceManagementController
extends BaseController {
    private static final String SYNC = "Sync";
    private static final String BKP = "Bkp";
    private static final String BKP_SYNC = "Bkp-Sync";
    private static Logger logger = LoggerFactory.getLogger(DeviceManagementController.class);
    private static final String DATA_INTEGRITY_VIOLATION_EXCEPTION = " DataIntegrityViolationException  :";
    private static final String DATA_ACCESS_EXCEPTION = " DataAccessException  :";
    private static final String BASE_EXCEPTION = " BaseException  :";
    private static final String EXCEPTION = " Exception  :";
    private static final String APPLICATION_JSON = "application/json";
    private static final String DEVICE_NOT_FOUND = "Device not found.";
    private static final String EMPTY_RESULT_DATA_ACCESS_EXCEPTION = " EmptyResultDataAccessException  :";
    private static final String DEVICE_UUID = "deviceUUID";
    private static final String USER_NAME = "userName";
    private static final String INVALID_REQUEST = "Invalid Request.";
    private static final String AUTHENTICATION_FAILED = " Authentication failed  for user ";
    private static final String BACKUP_ENABLED = "Backup Enabled";
    private static final String SYNC_ENABLED = "Sync Enabled";
    private static final String BACK_UP_ENABLED = "Backup Enabled";
    @Autowired
    private DeviceManagementService deviceManagementService;
    @Autowired
    private UserManagementService managementService;
    @Autowired
    private LicenseService licenseService;
    @Autowired
    private AuthorizationService authorizationService1;
    @Autowired
    private CloudMailService cloudMailService;
    @Autowired
    private AlertHistoryService alertHistoryService;
    @Autowired
    private AuditHistoryService auditHistoryService;
    @Autowired
    private AADManagementService aadManagementService;
    @Autowired
    private LdapService ldapService;
    @Autowired
    private DeviceAndUserSecurityService deviceAndUserSecurityService;

    @Deprecated
    @RequestMapping(value={"cloud/{cloudName}/device/uuid/{uuid}"}, method={RequestMethod.POST})
    public ModelAndView registerDeviceUUID(@PathVariable(value="cloudName") String cloudName1, @PathVariable(value="uuid") String uuid, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        logger.debug("calling /registerDeviceUUID ...");
        try {
            String token;
            if (!org.springframework.util.StringUtils.hasText((String)uuid)) {
                throw new BaseException("UUID not found.");
            }
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), response)) {
                return null;
            }
            this.deviceManagementService.registerUUID(cloudId, cloudName, uuid);
            response.setStatus(201);
            return null;
        }
        catch (DataIntegrityViolationException e) {
            ErrorElement err = this.createErrorElement(null, "Device UUID already exists.");
            modelAndView.addObject((Object)err);
            response.setStatus(409);
            logger.trace(DATA_INTEGRITY_VIOLATION_EXCEPTION + (Object)((Object)e));
            logger.error(DATA_INTEGRITY_VIOLATION_EXCEPTION + e.getMessage());
        }
        catch (DataAccessException e) {
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
            logger.trace(DATA_ACCESS_EXCEPTION + (Object)((Object)e));
            logger.error(DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (BaseException e) {
            ErrorElement err = this.createErrorElement(e.getErrorCode(), e.getMessage());
            modelAndView.addObject((Object)err);
            response.setStatus(400);
            logger.trace(BASE_EXCEPTION + (Object)((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
        }
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/device/all"}, method={RequestMethod.GET})
    public ModelAndView getAllRegisteredDevices(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        DeviceElementResponse devices = new DeviceElementResponse();
        modelAndView.setViewName("xmlview");
        logger.debug("calling /device/all...");
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), response)) {
                return null;
            }
            AuthorizationTokens authorizationTokens = this.authorizationService1.getTokenDetailsForToken(cloudId, cloudName, token);
            User user = authorizationTokens.getUser();
            if (user.isAdmin()) {
                int skipValue = request.getIntHeader("skipValue");
                logger.debug(" Skip value for all devices .... " + skipValue);
                List<DeviceElement> devList = this.deviceManagementService.getAllDevicesWithPagination(cloudId, skipValue);
                logger.debug("device list for admin user " + devList.size());
                devList = this.updateDeviceNameIfEmpty(cloudId, devList);
                Collections.sort(devList, new Comparator<DeviceElement>(){

                    @Override
                    public int compare(DeviceElement d1, DeviceElement d2) {
                        if (d1 == null || d2 == null || d1.getDeviceName() == null || d2.getDeviceName() == null || d1.getUserName() == null || d2.getUserName() == null) {
                            return -1;
                        }
                        return new CompareToBuilder().append((Object)DeviceManagementController.getStatus(d1.isBlocked()), (Object)DeviceManagementController.getStatus(d2.isBlocked())).append((Object)d1.getDeviceName().toLowerCase(), (Object)d2.getDeviceName().toLowerCase()).append((Object)d1.getUserName().toLowerCase(), (Object)d2.getUserName().toLowerCase()).toComparison();
                    }
                });
                devices.setDevices(devList);
            } else {
                List<DeviceElement> devList = this.deviceManagementService.getDevicesForUser(cloudId, cloudName, user.getUserName());
                logger.debug("device list for normal user " + devList.size());
                devList = this.updateDeviceNameIfEmpty(cloudId, devList);
                Collections.sort(devList, new Comparator<DeviceElement>(){

                    @Override
                    public int compare(DeviceElement d1, DeviceElement d2) {
                        if (d1 == null || d2 == null || d1.getDeviceName() == null || d2.getDeviceName() == null || d1.getUserName() == null || d2.getUserName() == null) {
                            return -1;
                        }
                        return new CompareToBuilder().append((Object)DeviceManagementController.getStatus(d1.isBlocked()), (Object)DeviceManagementController.getStatus(d2.isBlocked())).append((Object)d1.getDeviceName().toLowerCase(), (Object)d2.getDeviceName().toLowerCase()).append((Object)d1.getUserName().toLowerCase(), (Object)d2.getUserName().toLowerCase()).toComparison();
                    }
                });
                devices.setDevices(devList);
            }
            modelAndView.addObject((Object)devices);
            response.setStatus(200);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            ErrorElement err = this.createErrorElement();
            modelAndView.addObject((Object)err);
            response.setStatus(500);
        }
        return modelAndView;
    }

    private List<DeviceElement> updateDeviceNameIfEmpty(int cloudId, List<DeviceElement> devList) {
        ArrayList<DeviceElement> filteredDevList = new ArrayList<DeviceElement>();
        for (DeviceElement devElement : devList) {
            if (org.springframework.util.StringUtils.isEmpty((Object)devElement.getDeviceName())) {
                logger.debug("Device Name is empty for devceUUID :" + devElement.getDeviceUUID() + " so set device Name same as deviceUUID");
                this.deviceManagementService.updateDeviceName(cloudId, devElement.getDeviceUUID(), devElement.getDeviceUUID());
                devElement.setDeviceName(devElement.getDeviceUUID());
            }
            filteredDevList.add(devElement);
        }
        return filteredDevList;
    }

    @RequestMapping(value={"cloud/{cloudName}/search/device/"}, method={RequestMethod.GET})
    public ModelAndView searchDevices(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        DeviceElementResponse devices = new DeviceElementResponse();
        modelAndView.setViewName("xmlview");
        logger.debug("calling /device/all...");
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), response)) {
                return null;
            }
            String deviceNames = request.getHeader("deviceNames");
            logger.debug(" device names .....................  " + deviceNames);
            ArrayList<String> list = new ArrayList<String>(Arrays.asList(deviceNames.split(",")));
            HashSet<String> removeSet = new HashSet<String>();
            removeSet.addAll(list);
            list.clear();
            list.addAll(removeSet);
            AuthorizationTokens authorizationTokens = this.authorizationService1.getTokenDetailsForToken(cloudId, cloudName, token);
            User user = authorizationTokens.getUser();
            if (user.isAdmin()) {
                List<DeviceElement> devList = this.deviceManagementService.getAllDevices(cloudId, list);
                logger.debug("device list for admin user " + devList.size());
                Collections.sort(devList, new Comparator<DeviceElement>(){

                    @Override
                    public int compare(DeviceElement d1, DeviceElement d2) {
                        return new CompareToBuilder().append((Object)DeviceManagementController.getStatus(d1.isBlocked()), (Object)DeviceManagementController.getStatus(d2.isBlocked())).append((Object)d1.getDeviceName().toLowerCase(), (Object)d2.getDeviceName().toLowerCase()).append((Object)d1.getUserName().toLowerCase(), (Object)d2.getUserName().toLowerCase()).toComparison();
                    }
                });
                devices.setDevices(devList);
            } else {
                List<DeviceElement> devList = this.deviceManagementService.getDevicesForUser(cloudId, user.getUserName(), list);
                logger.debug("device list for normal user " + devList.size());
                Collections.sort(devList, new Comparator<DeviceElement>(){

                    @Override
                    public int compare(DeviceElement d1, DeviceElement d2) {
                        return new CompareToBuilder().append((Object)DeviceManagementController.getStatus(d1.isBlocked()), (Object)DeviceManagementController.getStatus(d2.isBlocked())).append((Object)d1.getDeviceName().toLowerCase(), (Object)d2.getDeviceName().toLowerCase()).append((Object)d1.getUserName().toLowerCase(), (Object)d2.getUserName().toLowerCase()).toComparison();
                    }
                });
                devices.setDevices(devList);
            }
            modelAndView.addObject((Object)devices);
            response.setStatus(200);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            ErrorElement err = this.createErrorElement();
            modelAndView.addObject((Object)err);
            response.setStatus(500);
        }
        return modelAndView;
    }

    @Deprecated
    @RequestMapping(value={"cloud/{cloudName}/device/user/{userName}/"}, method={RequestMethod.GET})
    public ModelAndView getAllRegisteredDevicesByUser(@PathVariable(value="cloudName") String cloudName1, @PathVariable(value="userName") String userName, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        DeviceElementResponse devices = new DeviceElementResponse();
        modelAndView.setViewName("xmlview");
        logger.debug("calling /getAllDeviceAllbyUser...");
        try {
            List<DeviceElement> devList;
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName = cl.getCloud().getCloudName(), token = request.getHeader("token"), response)) {
                return null;
            }
            User user = this.managementService.getUserDetails(cloudId, cloudName, userName);
            if (user == null) {
                logger.debug("user not exists");
                response.setStatus(204);
                return null;
            }
            if (user.isServerBackupEnabled()) {
                if (user.isAdmin()) {
                    devList = this.deviceManagementService.getAllDevices(cloudId, cloudName);
                } else {
                    Group group = this.managementService.getUserGroup(cloudId, user);
                    devList = this.deviceManagementService.getAllDevicesByGroup(cloudId, group);
                }
            } else {
                devList = this.deviceManagementService.getDevicesForUser(cloudId, cloudName, userName);
            }
            if (devList == null) {
                response.setStatus(204);
                return null;
            }
            logger.debug("device list >>>>>>>>>>>" + devList.size());
            devices.setDevices(devList);
            modelAndView.addObject((Object)devices);
            response.setStatus(200);
        }
        catch (DataAccessException e) {
            logger.trace(DATA_ACCESS_EXCEPTION + (Object)((Object)e));
            logger.error(DATA_ACCESS_EXCEPTION + e.getMessage());
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(204);
        }
        catch (BaseException e) {
            logger.trace(BASE_EXCEPTION + (Object)((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
            ErrorElement err = this.createErrorElement(e.getErrorCode(), null);
            modelAndView.addObject((Object)err);
            response.setStatus(400);
        }
        catch (Exception e) {
            logger.debug("...........&&&&&&&&&&&.......");
            logger.trace(BASE_EXCEPTION + e);
            logger.error(BASE_EXCEPTION + e.getMessage());
            response.setStatus(204);
        }
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/device/anouncement/user"}, method={RequestMethod.GET})
    public ModelAndView getUserClientDownloadDetails(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        ModelAndView modelAndView = new ModelAndView();
        String cloudName = cloudName1;
        logger.debug("calling getUserClientDownloadDetails...");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            String token = request.getHeader("token");
            User user = new User();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName = cl.getCloud().getCloudName(), token, user, response)) {
                return null;
            }
            UserAnouncement anouncement = this.deviceManagementService.getDeviceAndClientDetailsForUser(cloudId, cloudName, user.getUserName());
            response.setStatus(200);
            String applicationType = request.getContentType();
            if (applicationType == null) {
                applicationType = APPLICATION_JSON;
            }
            if ("application/xml".equalsIgnoreCase(applicationType)) {
                response.setContentType("application/xml");
                modelAndView.setViewName("xmlview");
            } else {
                response.setContentType(APPLICATION_JSON);
                modelAndView.setViewName("jsonview");
            }
            modelAndView.addObject((Object)anouncement);
        }
        catch (DataAccessException e) {
            logger.trace("DataAccessException", (Throwable)e);
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
        }
        catch (BaseException e) {
            logger.trace("BaseException", (Throwable)e);
            ErrorElement err = this.createErrorElement(e.getErrorCode(), null);
            modelAndView.addObject((Object)err);
            response.setStatus(e.getErrorStatus());
        }
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/getDeviceInfo/{deviceUUID}"}, method={RequestMethod.GET})
    public ModelAndView getDeviceInformation(@PathVariable(value="cloudName") String cloudName1, @PathVariable(value="deviceUUID") String deviceUUID, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        logger.debug("calling /getDeviceInfo ...");
        try {
            String token;
            if (!org.springframework.util.StringUtils.hasText((String)deviceUUID)) {
                throw new BaseException("Device registeration ID not found.");
            }
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), response)) {
                return null;
            }
            DeviceElement de = this.deviceManagementService.getDeviceInfo(cloudId, cloudName, deviceUUID);
            modelAndView.addObject((Object)de);
            response.setStatus(200);
        }
        catch (EmptyResultDataAccessException e) {
            ErrorElement err = this.createErrorElement(null, DEVICE_NOT_FOUND);
            modelAndView.addObject((Object)err);
            response.setStatus(409);
            logger.trace(EMPTY_RESULT_DATA_ACCESS_EXCEPTION + (Object)((Object)e));
            logger.error(EMPTY_RESULT_DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (DataAccessException e) {
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
            logger.trace(DATA_ACCESS_EXCEPTION + (Object)((Object)e));
            logger.error(DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (BaseException e) {
            ErrorElement err = this.createErrorElement(e.getErrorCode(), e.getMessage());
            modelAndView.addObject((Object)err);
            response.setStatus(400);
            logger.trace(BASE_EXCEPTION + (Object)((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
        }
        return modelAndView;
    }

    @Deprecated
    @RequestMapping(value={"cloud/{cloudName}/register/deviceold"}, method={RequestMethod.POST})
    public ModelAndView registerDeviceOld(@PathVariable(value="cloudName") String cloudName1, @RequestBody DeviceElement deviceElement, HttpServletRequest request, HttpServletResponse response) {
        Cloud cloud;
        User user;
        int cloudId;
        CloudLicenseTo cl;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        logger.debug("$%$%  calling /registerAsNewDevice ..." + deviceElement.getDeviceUUID());
        String cloudName = cloudName1;
        String username = request.getHeader(USER_NAME);
        String password = request.getHeader("password");
        String resgistration = request.getHeader("firstRegistration");
        String client = request.getHeader("clientType");
        int clientType = 1;
        if (client != null) {
            clientType = PCClientTypes.getClientType((String)client);
        }
        boolean forceReg = true;
        if (resgistration != null) {
            forceReg = Boolean.valueOf(resgistration);
        }
        DeviceRegistrationElement deviceRegistrationElement = new DeviceRegistrationElement();
        if (!org.springframework.util.StringUtils.hasText((String)username)) {
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(400);
            return modelAndView;
        }
        try {
            cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudId = cl.getCloud().getCloudId();
            cloudName = cl.getCloud().getCloudName();
            user = "09sep14".equalsIgnoreCase(cloudName) ? this.managementService.authenticateV2(cloudId, cloudName, username) : this.managementService.authenticate(cloudId, cloudName, username, password);
            if (!(user.isSyncEnabled() || user.isBackupEnabled() || user.isServerBackupEnabled())) {
                response.setStatus(425);
                return null;
            }
        }
        catch (BaseException e) {
            return this.errorMessage(response, modelAndView, e);
        }
        Device device = this.deviceManagementService.getDeviceProperties(cloudId, cloudName, deviceElement.getDeviceUUID());
        if (device != null && device.isBlocked()) {
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(420);
            return modelAndView;
        }
        List<DeviceElement> list = this.deviceManagementService.getDevicesForUser(cloudId, cloudName, username);
        int activeDevicesForUser = this.activeDevicesForUser(list, cloudId, cloudName, username, deviceElement.getDeviceUUID());
        if (activeDevicesForUser > (cloud = cl.getCloud()).getNoOfDevicesAllowed()) {
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(418);
            return modelAndView;
        }
        try {
            AuthorizationDeviceTo authorizationDeviceTo;
            if (deviceElement == null || !org.springframework.util.StringUtils.hasText((String)deviceElement.getDeviceName()) || !org.springframework.util.StringUtils.hasText((String)deviceElement.getDeviceUUID())) {
                throw new BaseException("Invalid input parameters.");
            }
            logger.debug(" check for old tokens ***************** ");
            AuthorizationTokens oldTokens = this.authorizationService1.getAuthorizationTokenForDeviceUUID(cloudId, cloudName, deviceElement.getDeviceUUID());
            List existingDeviceConnections = this.authorizationService1.getLatestTokensByUserAndClientTypeForRegisterdDevices(cloudId, cloudName, user, clientType, cl.getCloud());
            if (!forceReg && existingDeviceConnections != null) {
                boolean isConfilcted = true;
                for (AuthorizationTokens tokens : existingDeviceConnections) {
                    if (tokens.getUniqueId() == null || !tokens.getUniqueId().equals(deviceElement.getDeviceUUID())) continue;
                    isConfilcted = false;
                    break;
                }
                if (isConfilcted) {
                    response.setStatus(409);
                    return null;
                }
            }
            if ((authorizationDeviceTo = this.deviceManagementService.registerDevice(cloudId, cloudName, deviceElement, oldTokens, user, clientType)) == null) {
                ErrorElement err = this.createErrorElement(null, null);
                modelAndView.addObject((Object)err);
                response.setStatus(420);
                return modelAndView;
            }
            this.authorizationService1.addTokenOrUpdate(cloudId, cloudName, authorizationDeviceTo.getAuthorizationTokens());
            DeviceElement d = new DeviceElement();
            d.setDeviceName(authorizationDeviceTo.getDevice().getDeviceName());
            deviceRegistrationElement.setDeviceElement(d);
            modelAndView.addObject((Object)deviceRegistrationElement);
            response.setHeader("backup-enabled", String.valueOf(user.isBackupEnabled()));
            response.setHeader("sync-enabled", String.valueOf(user.isSyncEnabled()));
            boolean isRestoreEnabled = this.isRestoreEnabledForCloud(cl);
            response.setHeader("restore-enabled", String.valueOf(isRestoreEnabled));
            response.setHeader("token", authorizationDeviceTo.getAuthorizationTokens().getToken());
            response.setHeader("isLdapEnabled", "true");
            response.setStatus(201);
        }
        catch (DataIntegrityViolationException e) {
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
            logger.trace(DATA_INTEGRITY_VIOLATION_EXCEPTION + (Object)((Object)e));
            logger.error(DATA_INTEGRITY_VIOLATION_EXCEPTION + e.getMessage());
        }
        catch (DataAccessException e) {
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
            logger.trace(DATA_ACCESS_EXCEPTION + (Object)((Object)e));
            logger.error(DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (BaseException e) {
            ErrorElement err = this.createErrorElement(e.getErrorCode(), e.getMessage());
            modelAndView.addObject((Object)err);
            if (e.getErrorStatus() == 0) {
                response.setStatus(400);
            } else {
                response.setStatus(e.getErrorStatus());
            }
            logger.trace(BASE_EXCEPTION + (Object)((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
        }
        return modelAndView;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(value={"cloud/{cloudName}/register/device"}, method={RequestMethod.POST})
    public ModelAndView registerDevice(@PathVariable(value="cloudName") String cloudName1, @RequestBody DeviceElement deviceElement, HttpServletRequest request, HttpServletResponse response) {
        int statusCode;
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        String contentType = request.getHeader("Content-Type");
        if (contentType.equalsIgnoreCase(APPLICATION_JSON)) {
            logger.debug("@@@ calling register device JSON_VIEW /register/device ..." + contentType);
            modelAndView.setViewName("jsonview");
        } else {
            logger.debug("@@@ calling register device XML_VIEW  /register/device ..." + contentType);
            modelAndView.setViewName("xmlview");
        }
        String licenseEnabled = "";
        logger.debug("$%$%  calling /registerAsNewDevice ..." + deviceElement.getDeviceUUID());
        logger.debug(" ELEMENT .... " + deviceElement.toString());
        String username = request.getHeader(USER_NAME);
        String password = request.getHeader("password");
        logger.debug(username + " username  password.... " + password);
        String productVersion = request.getHeader("productVersion");
        logger.debug("THE PRODUCT VERSION OF AGENT IS>>>>>>" + productVersion);
        if (productVersion != null) {
            deviceElement.setClientVersion(productVersion);
        }
        String client = request.getHeader("clientType");
        int clientType = 1;
        if (client != null) {
            clientType = PCClientTypes.getClientType((String)client);
        }
        client = StringUtils.isEmpty((String)client) || "portal".equalsIgnoreCase(client) ? "portal" : client.toLowerCase();
        User user = new User();
        DeviceRegistrationElement deviceRegistrationElement = new DeviceRegistrationElement();
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        if (!this.checkLicense(cl, response)) {
            logger.error(" Invlaid cloud license ....");
            return null;
        }
        cloudName = cl.getCloud().getCloudName();
        if (!(org.springframework.util.StringUtils.hasText((String)username) && deviceElement != null && org.springframework.util.StringUtils.hasText((String)deviceElement.getDeviceName()) && org.springframework.util.StringUtils.hasText((String)deviceElement.getDeviceUUID()))) {
            response.setStatus(400);
            logger.error(" Invlaid UserName or devicename or deviceUUID ....");
            return null;
        }
        int cloudId = cl.getCloud().getCloudId();
        Device device = this.deviceManagementService.getDeviceProperties(cloudId, cloudName, deviceElement.getDeviceUUID());
        if (this.isFeatureEnabled(cl, "Server Backup Enabled")) {
            user = this.managementService.getAdminUserWithServerBackupEnabled(cloudId);
        } else {
            String encPwd;
            UserElement userElement;
            try {
                userElement = this.managementService.getUserByUserName(cl.getCloud(), username);
                if (this.isAADEnabled(cl.getCloud().getCloudCustomisableDetails()) && userElement == null) {
                    logger.debug("AAD enable and user is null for userName " + username + " so check with field aadLoginId");
                    userElement = this.managementService.getUserByAADLoginId(cl.getCloud(), username);
                }
                if (userElement != null) {
                    logger.debug("user exists ........ " + userElement.getUserName());
                    if (userElement.isSuspended()) {
                        logger.debug("User is suspended.....");
                        response.setStatus(451);
                        return null;
                    }
                }
                if (userElement == null) {
                    if (this.isAADEnabled(cl.getCloud().getCloudCustomisableDetails())) {
                        encPwd = request.getHeader("encPwd");
                        password = DeviceManagementController.decryptBS(encPwd, "26ac50996c66634c");
                        boolean success = this.migrateUserFromAAD(username, password, cl, cl.getCloud(), cloudName, response);
                        if (!success) {
                            logger.error(" Authentication failed form AAD for user " + username + "............");
                            return null;
                        }
                        userElement = this.managementService.getUserByUserNameOrEmail(cl.getCloud(), username);
                    } else if (this.isLdapEnabledForCloud(cl.getCloud())) {
                        logger.debug("User is not our database so check in AD");
                        boolean success = this.checkWithADandMigrateUser(cl, cloudId, cloudName, username, response);
                        if (!success) {
                            if (!org.springframework.util.StringUtils.isEmpty((Object)password)) return null;
                            logger.debug("User not in AD also");
                            return null;
                        }
                        logger.debug("User Present in AD and migrated success fully.");
                        userElement = this.managementService.getUserByUserNameOrEmail(cl.getCloud(), username);
                    }
                }
                BeanUtils.copyProperties((Object)userElement, (Object)user);
                username = userElement.getUserName();
            }
            catch (BaseException e) {
                ErrorElement err = this.createErrorElement(e.getErrorCode(), e.getMessage());
                modelAndView.addObject((Object)err);
                response.setStatus(400);
                logger.trace(BASE_EXCEPTION + (Object)((Object)e));
                logger.error(BASE_EXCEPTION + e.getMessage());
                return null;
            }
            try {
                if (org.springframework.util.StringUtils.isEmpty((Object)user.getPasswdHash())) {
                    encPwd = request.getHeader("encPwd");
                    password = DeviceManagementController.decryptBS(encPwd, "26ac50996c66634c");
                    boolean isAuthenticated = false;
                    if (this.isAADEnabled(cl.getCloud().getCloudCustomisableDetails())) {
                        isAuthenticated = this.authenticateAADUser(cl.getCloud(), userElement, password);
                    } else if (this.isLdapEnabledForCloud(cl.getCloud())) {
                        Object[] objArr = this.ldapService.authenticate(username, password);
                        isAuthenticated = (Boolean)objArr[0];
                        licenseEnabled = (String)objArr[1];
                    }
                    if (!isAuthenticated) {
                        logger.error(AUTHENTICATION_FAILED + username + "............");
                        response.setStatus(401);
                        if (3 != clientType) return null;
                        this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, AUTHENTICATION_FAILED + client, username, "", deviceElement.getDeviceName(), System.currentTimeMillis(), PCActionTypes.LOGIN.getActionTypeValue());
                        return null;
                    }
                    user = this.managementService.authenticateV2(cloudId, cloudName, username);
                    AuthorizationTokens authorizationTokens = this.authorizationService1.getAuthorizationTokenForUserName(cloudId, cloudName, username);
                    if (authorizationTokens == null) {
                        UUID uuid = UUID.randomUUID();
                        String token = String.valueOf(uuid);
                        this.authorizationService1.addTokenByUser(cloudId, cloudName, token, username, clientType);
                    }
                    user = this.managementService.getUserDetails(cloudId, cloudName, username);
                } else {
                    user = this.managementService.authenticate(cloudId, cloudName, username, password);
                }
            }
            catch (BaseException e) {
                if (3 == clientType) {
                    this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, AUTHENTICATION_FAILED + client, username, "", deviceElement.getDeviceName(), System.currentTimeMillis(), PCActionTypes.LOGIN.getActionTypeValue());
                }
                logger.trace("inside base exception status code:" + e.getErrorStatus());
                return this.errorMessage(response, modelAndView, e);
            }
        }
        boolean isDeviceBlocked = false;
        if (device != null && device.isBlocked()) {
            isDeviceBlocked = true;
        }
        if ((statusCode = this.validateDeviceAndUser(cloudId, cloudName, username, cl, deviceElement, user, deviceElement.getDeviceUUID(), isDeviceBlocked)) > 0) {
            response.setStatus(statusCode);
            logger.error(" validation failed ............");
            if (3 != clientType) return null;
            this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "validation failed " + client, username, "", deviceElement.getDeviceName(), System.currentTimeMillis(), PCActionTypes.VALIDATION_FAIL.getActionTypeValue());
            return null;
        }
        try {
            BluSyncGroupBackupPolicyElement groupPolicyElement;
            logger.debug("############################ BEFORE RGISTERING ");
            AuthorizationTokens oldTokens = this.authorizationService1.getAuthorizationTokenForDeviceUUID(cloudId, cloudName, deviceElement.getDeviceUUID());
            AuthorizationDeviceTo authorizationDeviceTo = this.deviceManagementService.registerDeviceV2(cloudId, cloudName, deviceElement, oldTokens, user, clientType);
            if (authorizationDeviceTo == null) {
                ErrorElement err = this.createErrorElement(null, null);
                modelAndView.addObject((Object)err);
                response.setStatus(420);
                if (3 != clientType) return modelAndView;
                this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "Device blocked " + client, username, "", deviceElement.getDeviceName(), System.currentTimeMillis(), PCActionTypes.DEVICE_BLOCK.getActionTypeValue());
                return modelAndView;
            }
            this.authorizationService1.addTokenOrUpdate(cloudId, cloudName, authorizationDeviceTo.getAuthorizationTokens());
            boolean isExternalStorageSelected = false;
            if (cl.getCloud().getExternalStorageAllowed() == 1) {
                isExternalStorageSelected = true;
            }
            Integer uiVersion = this.deviceManagementService.getUIVersion();
            response.addHeader("uiVersion", uiVersion.toString());
            response.addHeader("isExternalStorageSelected", Boolean.toString(isExternalStorageSelected));
            DeviceElement d = new DeviceElement();
            d.setDeviceName(authorizationDeviceTo.getDevice().getDeviceName());
            d.setDecoupled(authorizationDeviceTo.getDevice().isDecoupled());
            d.setDeviceId(authorizationDeviceTo.getDevice().getId().toString());
            d.setDeviceUUID(authorizationDeviceTo.getDevice().getDeviceUUID());
            d.setUserName(username);
            logger.debug("############################ device id::::: " + authorizationDeviceTo.getDevice().getId().toString());
            logger.debug("############################ device uuid::::: " + authorizationDeviceTo.getDevice().getDeviceUUID());
            boolean isPoliciesAvailable = false;
            if (!org.springframework.util.StringUtils.isEmpty((Object)licenseEnabled) && licenseEnabled.equalsIgnoreCase(BKP_SYNC) || user.isBackupEnabled() && user.isSyncEnabled()) {
                groupPolicyElement = this.deviceManagementService.getBluSyncGroupPolicyElement(cloudId, cloudName, user.getUserName(), d.getDeviceUUID());
                BluSyncGroupSyncPolicyElement groupSyncPolicyElement = this.deviceManagementService.getBluSyncGroupSyncPolicyElement(cloudId, cloudName, user.getUserName(), d.getDeviceUUID());
                logger.debug("Sync and backup Enabled ");
                if (groupPolicyElement != null && groupSyncPolicyElement != null) {
                    List endpointUiPreferencesElementList = groupPolicyElement.getEndpointUiPreferencesElementList();
                    if (!CollectionUtils.isEmpty((Collection)endpointUiPreferencesElementList)) {
                        ArrayList<EndpointUiPreferencesElement> responseValues = new ArrayList<EndpointUiPreferencesElement>();
                        for (EndpointUiPreferencesElement endpointUiPreferencesElement : endpointUiPreferencesElementList) {
                            logger.debug(".................." + endpointUiPreferencesElement.getEndpointsUiPreferences());
                            if (endpointUiPreferencesElement.getEndpointsUiPreferences().equals("PAUSE_BACKUP")) continue;
                            responseValues.add(endpointUiPreferencesElement);
                        }
                        groupPolicyElement.setEndpointUiPreferencesElementList(responseValues);
                    }
                    deviceRegistrationElement.setBackupPolicyElement(groupPolicyElement);
                    deviceRegistrationElement.setSyncPolicyElement(groupSyncPolicyElement);
                    isPoliciesAvailable = true;
                }
            } else if (!org.springframework.util.StringUtils.isEmpty((Object)licenseEnabled) && licenseEnabled.equalsIgnoreCase(BKP) || user.isBackupEnabled()) {
                groupPolicyElement = this.deviceManagementService.getBluSyncGroupPolicyElement(cloudId, cloudName, user.getUserName(), d.getDeviceUUID());
                logger.debug(user.getUserName() + "...." + d.getDeviceUUID() + "...Backup Enabled " + groupPolicyElement);
                if (groupPolicyElement != null) {
                    List endpointUiPreferencesElementList = groupPolicyElement.getEndpointUiPreferencesElementList();
                    if (!CollectionUtils.isEmpty((Collection)endpointUiPreferencesElementList)) {
                        ArrayList<EndpointUiPreferencesElement> responseValues = new ArrayList<EndpointUiPreferencesElement>();
                        for (EndpointUiPreferencesElement endpointUiPreferencesElement : endpointUiPreferencesElementList) {
                            logger.debug(".................." + endpointUiPreferencesElement.getEndpointsUiPreferences());
                            if (endpointUiPreferencesElement.getEndpointsUiPreferences().equals("PAUSE_BACKUP")) continue;
                            responseValues.add(endpointUiPreferencesElement);
                        }
                        groupPolicyElement.setEndpointUiPreferencesElementList(responseValues);
                    }
                    deviceRegistrationElement.setBackupPolicyElement(groupPolicyElement);
                    isPoliciesAvailable = true;
                }
            } else if (!org.springframework.util.StringUtils.isEmpty((Object)licenseEnabled) && licenseEnabled.equalsIgnoreCase(BKP) || user.isSyncEnabled()) {
                logger.debug("Sync Enabled ");
                BluSyncGroupSyncPolicyElement groupSyncPolicyElement = this.deviceManagementService.getBluSyncGroupSyncPolicyElement(cloudId, cloudName, user.getUserName(), d.getDeviceUUID());
                if (groupSyncPolicyElement != null) {
                    deviceRegistrationElement.setSyncPolicyElement(groupSyncPolicyElement);
                    isPoliciesAvailable = true;
                }
            }
            if (!isPoliciesAvailable) {
                ErrorElement err = this.createErrorElement(null, null);
                modelAndView.addObject((Object)err);
                response.setStatus(901);
                if (3 != clientType) return modelAndView;
                this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "No Policy Mapped" + client, username, "", deviceElement.getDeviceName(), System.currentTimeMillis(), PCActionTypes.NO_POLICY_MAP.getActionTypeValue());
                return modelAndView;
            }
            deviceRegistrationElement.setDeviceElement(d);
            DeviceBackupOverView overView = this.deviceManagementService.getDeviceBkpOverviewForDeviceUUID(cloudId, authorizationDeviceTo.getDevice().getDeviceUUID());
            if (overView == null) {
                logger.debug(" First time saving device backup ....");
                this.deviceManagementService.saveDeviceBackupOverView(cloudId, authorizationDeviceTo.getDevice());
            }
            if (3 == clientType) {
                // empty if block
            }
            modelAndView.addObject((Object)deviceRegistrationElement);
            if (!org.springframework.util.StringUtils.isEmpty((Object)licenseEnabled)) {
                if (licenseEnabled.equalsIgnoreCase(BKP_SYNC)) {
                    user.setBackupEnabled(true);
                    user.setSyncEnabled(true);
                } else if (licenseEnabled.equalsIgnoreCase(BKP)) {
                    user.setBackupEnabled(true);
                    user.setSyncEnabled(false);
                } else if (licenseEnabled.equalsIgnoreCase(SYNC)) {
                    user.setBackupEnabled(false);
                    user.setSyncEnabled(true);
                }
            }
            this.setValuesInResponseHeader(response, user, cl, authorizationDeviceTo);
            this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "registered a new device", user.getUserName(), authorizationDeviceTo.getDevice().getDeviceName(), "Endpoint", System.currentTimeMillis(), PCActionTypes.DEVICE_REGISTER.getActionTypeValue());
            response.addHeader("cloudName", cl.getCloud().getCloudName());
            response.setStatus(201);
            return modelAndView;
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
        }
        return modelAndView;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(value={"versions/{versionNumber}/cloud/{cloudName}/register/device"}, method={RequestMethod.POST})
    public ModelAndView registerDeviceNew(@PathVariable(value="cloudName") String cloudName1, @RequestBody DeviceElement deviceElement, HttpServletRequest request, HttpServletResponse response) {
        boolean isDeviceBlocked;
        int cloudId;
        CloudLicenseTo cl;
        DeviceRegistrationElement deviceRegistrationElement;
        User user;
        int clientType;
        String client;
        String username;
        String licenseEnabled;
        ModelAndView modelAndView;
        String cloudName;
        block68: {
            Device device;
            Optional<Device> deviceForDeviceName;
            cloudName = cloudName1;
            modelAndView = new ModelAndView();
            String contentType = request.getHeader("Content-Type");
            if (contentType.equalsIgnoreCase(APPLICATION_JSON)) {
                logger.debug("@@@ calling register device JSON_VIEW /register/device ..." + contentType);
                modelAndView.setViewName("jsonview");
            } else {
                logger.debug("@@@ calling register device XML_VIEW  /register/device ..." + contentType);
                modelAndView.setViewName("xmlview");
            }
            licenseEnabled = "";
            logger.debug("$%$%  calling /registerAsNewDevice ..." + deviceElement.getDeviceUUID());
            logger.debug(" ELEMENT .... " + deviceElement.toString());
            username = request.getHeader(USER_NAME);
            String password = request.getHeader("password");
            boolean checkForMultipleUserandDevice = false;
            String checkForMultipleUserandDevice1 = request.getHeader("checkForMultipleUserandDevice");
            if (!org.springframework.util.StringUtils.isEmpty((Object)checkForMultipleUserandDevice1)) {
                checkForMultipleUserandDevice = Boolean.parseBoolean(checkForMultipleUserandDevice1);
            }
            logger.debug(username + " username  password.... " + password);
            String productVersion = request.getHeader("productVersion");
            logger.debug("THE PRODUCT VERSION OF AGENT IS>>>>>>" + productVersion);
            if (productVersion != null) {
                deviceElement.setClientVersion(productVersion);
            }
            client = request.getHeader("clientType");
            clientType = 1;
            if (client != null) {
                clientType = PCClientTypes.getClientType((String)client);
            }
            client = StringUtils.isEmpty((String)client) || "portal".equalsIgnoreCase(client) ? "portal" : client.toLowerCase();
            user = new User();
            deviceRegistrationElement = new DeviceRegistrationElement();
            cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                logger.error(" Invlaid cloud license ....");
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            if (!(org.springframework.util.StringUtils.hasText((String)username) && deviceElement != null && org.springframework.util.StringUtils.hasText((String)deviceElement.getDeviceName()) && org.springframework.util.StringUtils.hasText((String)deviceElement.getDeviceUUID()))) {
                response.setStatus(400);
                logger.error(" Invlaid UserName or devicename or deviceUUID ....");
                return null;
            }
            cloudId = cl.getCloud().getCloudId();
            User userDetailsByUserName = this.managementService.getUserDetails(cloudId, cloudName, username);
            List<Device> devices = null;
            if (userDetailsByUserName != null) {
                devices = this.deviceManagementService.getDevicesByUserName(cloudId, userDetailsByUserName.getUserName());
                username = userDetailsByUserName.getUserName();
            }
            AADUserElement aadUserByCode = null;
            if (this.isAADEnabled(cl.getCloud().getCloudCustomisableDetails()) && org.springframework.util.StringUtils.isEmpty((Object)password) && org.springframework.util.StringUtils.isEmpty((Object)request.getHeader("encPwd"))) {
                String aadAuthCode = request.getHeader("aadAuthCode");
                if (org.springframework.util.StringUtils.isEmpty((Object)aadAuthCode)) {
                    logger.debug("AAD enabled and aadAuthCode in header aadAuthCode is empty so return..");
                    AADCredentialsElement aadCredentials = this.aadManagementService.getAADCredentials(cl.getCloud().getCloudId());
                    if (aadCredentials != null && !org.springframework.util.StringUtils.isEmpty((Object)aadCredentials.getTenentId()) && !org.springframework.util.StringUtils.isEmpty((Object)aadCredentials.getEndpointRedirectURI())) {
                        response.setStatus(444);
                        response.addHeader("clientId", aadCredentials.getClientId());
                        response.addHeader("endpointRedirectURI", aadCredentials.getEndpointRedirectURI());
                        response.addHeader("tenantName", aadCredentials.getTenentId());
                        return null;
                    }
                    logger.debug("AAD credentials or endpointredirect url or tenetId is empty is empty....");
                    response.setStatus(450);
                    return null;
                }
                aadUserByCode = this.aadManagementService.getAADUserByCode(aadAuthCode, cl.getCloud(), false, "");
                if (aadUserByCode == null) {
                    logger.debug("Failed to get aad user using aadAuthCode :" + aadAuthCode);
                    response.setStatus(440);
                    return null;
                }
                logger.debug("Got AAD user form aadAuthCode " + aadUserByCode.getUserPrincipalName());
                username = aadUserByCode.getUserPrincipalName();
            }
            isDeviceBlocked = false;
            if (!CollectionUtils.isEmpty(devices) && (deviceForDeviceName = devices.stream().filter(dev -> dev.getDeviceName().equalsIgnoreCase(deviceElement.getDeviceName())).findFirst()).isPresent() && (device = deviceForDeviceName.get()) != null && !org.springframework.util.StringUtils.isEmpty((Object)device.getDeviceUUID())) {
                deviceElement.setDeviceUUID(device.getDeviceUUID());
                deviceElement.setUserName(device.getUserName());
                if (device.isBlocked()) {
                    isDeviceBlocked = true;
                }
            }
            if (checkForMultipleUserandDevice) {
                List<DeviceElement> list = this.deviceManagementService.getDevicesByUser(cloudId, cloudName, userDetailsByUserName);
                int activeDevicesForUser = this.activeDevicesForUser(list, cloudId, cloudName, username, deviceElement.getDeviceUUID());
                logger.debug("active devices for the user " + username + "is : " + activeDevicesForUser);
                List<DeviceElement> listForUsersforDevice = this.deviceManagementService.getUsersForDevice(cloudId, cloudName, deviceElement.getDeviceName());
                int activeUsersForDevice = this.activeuserssForDevice(listForUsersforDevice, cloudId, cloudName, deviceElement.getDeviceUUID());
                logger.debug("active users for the Device " + deviceElement.getDeviceName() + "is : " + activeUsersForDevice);
                if (activeDevicesForUser > 0 && activeUsersForDevice > 0) {
                    response.setStatus(433);
                    return null;
                }
                if (activeDevicesForUser > 0) {
                    response.setStatus(432);
                    return null;
                }
                if (activeUsersForDevice > 0) {
                    response.setStatus(431);
                    return null;
                }
            }
            if (this.isFeatureEnabled(cl, "Server Backup Enabled")) {
                user = this.managementService.getAdminUserWithServerBackupEnabled(cloudId);
            } else {
                UserElement userElement;
                try {
                    userElement = this.managementService.getUserByUserName(cl.getCloud(), username);
                    if (this.isAADEnabled(cl.getCloud().getCloudCustomisableDetails()) && userElement == null) {
                        logger.debug("AAD enable and user is null for userName " + username + " so check with field aadLoginId");
                        userElement = this.managementService.getUserByAADLoginId(cl.getCloud(), username);
                    }
                    if (userElement != null) {
                        logger.debug("user exists ........ " + userElement.getUserName());
                        if (userElement.isSuspended()) {
                            logger.debug("User is suspended.....");
                            response.setStatus(451);
                            return null;
                        }
                    }
                    if (userElement == null) {
                        if (this.isAADEnabled(cl.getCloud().getCloudCustomisableDetails())) {
                            boolean success = false;
                            if (aadUserByCode == null) {
                                String encPwd = request.getHeader("encPwd");
                                password = DeviceManagementController.decryptBS(encPwd, "26ac50996c66634c");
                                success = this.migrateUserFromAAD(username, password, cl, cl.getCloud(), cloudName, response);
                            } else {
                                success = this.migrateUserFromAAD(aadUserByCode, cl, cl.getCloud(), cloudName, response);
                            }
                            logger.debug(".......success......" + success);
                            if (!success) {
                                logger.error(" Authentication failed form AAD for user " + username + "............");
                                return null;
                            }
                            userElement = this.managementService.getUserByUserNameOrEmail(cl.getCloud(), username);
                        } else if (this.isLdapEnabledForCloud(cl.getCloud())) {
                            logger.debug("User is not our database so check in AD");
                            boolean success = this.checkWithADandMigrateUser(cl, cloudId, cloudName, username, response);
                            if (!success) {
                                if (!org.springframework.util.StringUtils.isEmpty((Object)password)) return null;
                                logger.debug("User not in AD also");
                                response.setStatus(400);
                                return null;
                            }
                            logger.debug("User Present in AD and migrated success fully.");
                            userElement = this.managementService.getUserByUserNameOrEmail(cl.getCloud(), username);
                        }
                    }
                    logger.debug(".................userElement..........." + userElement.toString());
                    BeanUtils.copyProperties((Object)userElement, (Object)user);
                    username = userElement.getUserName();
                }
                catch (BaseException e) {
                    ErrorElement err = this.createErrorElement(e.getErrorCode(), e.getMessage());
                    modelAndView.addObject((Object)err);
                    response.setStatus(400);
                    logger.trace(BASE_EXCEPTION + (Object)((Object)e));
                    logger.error(BASE_EXCEPTION + e.getMessage());
                    return null;
                }
                try {
                    if (org.springframework.util.StringUtils.isEmpty((Object)user.getPasswdHash())) {
                        String encPwd = request.getHeader("encPwd");
                        password = DeviceManagementController.decryptBS(encPwd, "26ac50996c66634c");
                        boolean isAuthenticated = false;
                        if (this.isAADEnabled(cl.getCloud().getCloudCustomisableDetails())) {
                            if (aadUserByCode == null) {
                                isAuthenticated = this.authenticateAADUser(cl.getCloud(), userElement, password);
                            } else {
                                logger.debug("Since AAD login happen using code no need to authenticate...");
                                isAuthenticated = true;
                            }
                        } else if (this.isLdapEnabledForCloud(cl.getCloud())) {
                            Object[] objArr = this.ldapService.authenticate(username, password);
                            isAuthenticated = (Boolean)objArr[0];
                            licenseEnabled = (String)objArr[1];
                        }
                        if (!isAuthenticated) {
                            logger.error(AUTHENTICATION_FAILED + username + "............");
                            response.setStatus(401);
                            if (3 != clientType) return null;
                            this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, AUTHENTICATION_FAILED + client, username, "", deviceElement.getDeviceName(), System.currentTimeMillis(), PCActionTypes.LOGIN.getActionTypeValue());
                            return null;
                        }
                        user = this.managementService.authenticateV2(cloudId, cloudName, username);
                        AuthorizationTokens authorizationTokens = this.authorizationService1.getAuthorizationTokenForUserName(cloudId, cloudName, username);
                        if (authorizationTokens == null) {
                            UUID uuid = UUID.randomUUID();
                            String token = String.valueOf(uuid);
                            this.authorizationService1.addTokenByUser(cloudId, cloudName, token, username, clientType);
                        }
                        user = this.managementService.getUserDetails(cloudId, cloudName, username);
                        break block68;
                    }
                    user = this.managementService.authenticate(cloudId, cloudName, username, password);
                }
                catch (BaseException e) {
                    if (3 == clientType) {
                        this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, AUTHENTICATION_FAILED + client, username, "", deviceElement.getDeviceName(), System.currentTimeMillis(), PCActionTypes.LOGIN.getActionTypeValue());
                    }
                    logger.trace("inside base exception status code:" + e.getErrorStatus());
                    return this.errorMessage(response, modelAndView, e);
                }
            }
        }
        int statusCode = this.validateDeviceAndUser(cloudId, cloudName, username, cl, deviceElement, user, deviceElement.getDeviceUUID(), isDeviceBlocked);
        if (statusCode > 0) {
            response.setStatus(statusCode);
            logger.error(" validation failed ............");
            if (3 != clientType) return null;
            this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "validation failed " + client, username, "", deviceElement.getDeviceName(), System.currentTimeMillis(), PCActionTypes.VALIDATION_FAIL.getActionTypeValue());
            return null;
        }
        try {
            long count;
            BluSyncGroupBackupPolicyElement groupPolicyElement;
            logger.debug("############################ BEFORE RGISTERING ");
            AuthorizationTokens oldTokens = this.authorizationService1.getAuthorizationTokenForDeviceUUID(cloudId, cloudName, deviceElement.getDeviceUUID());
            AuthorizationDeviceTo authorizationDeviceTo = this.deviceManagementService.registerDeviceV2(cloudId, cloudName, deviceElement, oldTokens, user, clientType);
            if (authorizationDeviceTo == null) {
                ErrorElement err = this.createErrorElement(null, null);
                modelAndView.addObject((Object)err);
                response.setStatus(420);
                if (3 != clientType) return modelAndView;
                this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "Device blocked " + client, username, "", deviceElement.getDeviceName(), System.currentTimeMillis(), PCActionTypes.DEVICE_BLOCK.getActionTypeValue());
                return modelAndView;
            }
            this.authorizationService1.addTokenOrUpdate(cloudId, cloudName, authorizationDeviceTo.getAuthorizationTokens());
            boolean isExternalStorageSelected = false;
            if (cl.getCloud().getExternalStorageAllowed() == 1) {
                isExternalStorageSelected = true;
            }
            Integer uiVersion = this.deviceManagementService.getUIVersion();
            response.addHeader("uiVersion", uiVersion.toString());
            response.addHeader("isExternalStorageSelected", Boolean.toString(isExternalStorageSelected));
            DeviceElement d = new DeviceElement();
            d.setDeviceName(authorizationDeviceTo.getDevice().getDeviceName());
            d.setDecoupled(authorizationDeviceTo.getDevice().isDecoupled());
            d.setDeviceId(authorizationDeviceTo.getDevice().getId().toString());
            d.setDeviceUUID(authorizationDeviceTo.getDevice().getDeviceUUID());
            d.setUserName(username);
            logger.debug("############################ device id::::: " + authorizationDeviceTo.getDevice().getId().toString());
            logger.debug("############################ device uuid::::: " + authorizationDeviceTo.getDevice().getDeviceUUID());
            boolean isPoliciesAvailable = false;
            if (!org.springframework.util.StringUtils.isEmpty((Object)licenseEnabled) && licenseEnabled.equalsIgnoreCase(BKP_SYNC) || user.isBackupEnabled() && user.isSyncEnabled()) {
                groupPolicyElement = this.deviceManagementService.getBluSyncGroupPolicyElement(cloudId, cloudName, user.getUserName(), d.getDeviceUUID());
                BluSyncGroupSyncPolicyElement groupSyncPolicyElement = this.deviceManagementService.getBluSyncGroupSyncPolicyElement(cloudId, cloudName, user.getUserName(), d.getDeviceUUID());
                logger.debug("Sync and backup Enabled ");
                if (groupPolicyElement != null && groupSyncPolicyElement != null) {
                    deviceRegistrationElement.setBackupPolicyElement(groupPolicyElement);
                    deviceRegistrationElement.setSyncPolicyElement(groupSyncPolicyElement);
                    isPoliciesAvailable = true;
                }
            } else if (!org.springframework.util.StringUtils.isEmpty((Object)licenseEnabled) && licenseEnabled.equalsIgnoreCase(BKP) || user.isBackupEnabled()) {
                groupPolicyElement = this.deviceManagementService.getBluSyncGroupPolicyElement(cloudId, cloudName, user.getUserName(), d.getDeviceUUID());
                logger.debug(user.getUserName() + "...." + d.getDeviceUUID() + "...Backup Enabled " + groupPolicyElement);
                if (groupPolicyElement != null) {
                    deviceRegistrationElement.setBackupPolicyElement(groupPolicyElement);
                    isPoliciesAvailable = true;
                }
            } else if (!org.springframework.util.StringUtils.isEmpty((Object)licenseEnabled) && licenseEnabled.equalsIgnoreCase(BKP) || user.isSyncEnabled()) {
                logger.debug("Sync Enabled ");
                BluSyncGroupSyncPolicyElement groupSyncPolicyElement = this.deviceManagementService.getBluSyncGroupSyncPolicyElement(cloudId, cloudName, user.getUserName(), d.getDeviceUUID());
                if (groupSyncPolicyElement != null) {
                    deviceRegistrationElement.setSyncPolicyElement(groupSyncPolicyElement);
                    isPoliciesAvailable = true;
                }
            }
            if (!isPoliciesAvailable) {
                ErrorElement err = this.createErrorElement(null, null);
                modelAndView.addObject((Object)err);
                response.setStatus(901);
                if (3 != clientType) return modelAndView;
                this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "No Policy Mapped" + client, username, "", deviceElement.getDeviceName(), System.currentTimeMillis(), PCActionTypes.NO_POLICY_MAP.getActionTypeValue());
                return modelAndView;
            }
            deviceRegistrationElement.setDeviceElement(d);
            DeviceBackupOverView overView = this.deviceManagementService.getDeviceBkpOverviewForDeviceUUID(cloudId, authorizationDeviceTo.getDevice().getDeviceUUID());
            if (overView == null) {
                logger.debug(" First time saving device backup ....");
                this.deviceManagementService.saveDeviceBackupOverView(cloudId, authorizationDeviceTo.getDevice());
            }
            if ((count = this.deviceManagementService.getDeviceBackupOverviewCountByDeviceUUID(cloudId, authorizationDeviceTo.getDevice().getDeviceUUID())) >= 2L) {
                logger.debug("$%$%$%$%$%$%$%$%$%$%$% There are duplicates deviceBkp overview are present for deviceUUID :" + authorizationDeviceTo.getDevice().getDeviceUUID() + " count of bkpOverview :" + count);
                response.setStatus(500);
                return null;
            }
            if (3 == clientType) {
                // empty if block
            }
            modelAndView.addObject((Object)deviceRegistrationElement);
            if (!org.springframework.util.StringUtils.isEmpty((Object)licenseEnabled)) {
                if (licenseEnabled.equalsIgnoreCase(BKP_SYNC)) {
                    user.setBackupEnabled(true);
                    user.setSyncEnabled(true);
                } else if (licenseEnabled.equalsIgnoreCase(BKP)) {
                    user.setBackupEnabled(true);
                    user.setSyncEnabled(false);
                } else if (licenseEnabled.equalsIgnoreCase(SYNC)) {
                    user.setBackupEnabled(false);
                    user.setSyncEnabled(true);
                }
            }
            this.setValuesInResponseHeader(response, user, cl, authorizationDeviceTo);
            this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "registered a new device", user.getUserName(), authorizationDeviceTo.getDevice().getDeviceName(), "Endpoint", System.currentTimeMillis(), PCActionTypes.DEVICE_REGISTER.getActionTypeValue());
            response.addHeader("cloudName", cl.getCloud().getCloudName());
            response.setStatus(201);
            return modelAndView;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
        }
        return modelAndView;
    }

    private boolean isAADEnabled(List<CloudCustomisableDetails> list) {
        boolean isAADEnabled = false;
        for (CloudCustomisableDetails customisableDetails : list) {
            if (!"AAD Enabled".equals(customisableDetails.getName())) continue;
            isAADEnabled = true;
            break;
        }
        return isAADEnabled;
    }

    private boolean authenticateAADUser(Cloud cloud, UserElement userElement, String password) {
        boolean success = false;
        AADUserElement aaDUserRequestElement = new AADUserElement();
        String userPrincipleName = userElement.getUserName();
        if (!org.springframework.util.StringUtils.isEmpty((Object)userElement.getAadLoginId())) {
            userPrincipleName = userElement.getAadLoginId();
        }
        aaDUserRequestElement.setPassword(password);
        aaDUserRequestElement.setUserName(userPrincipleName);
        logger.debug("...userPrincipleName..." + userPrincipleName);
        AADUserElement aadUser = null;
        try {
            aadUser = (AADUserElement)this.aadManagementService.getAADUser(cloud, userPrincipleName, password);
        }
        catch (Exception e) {
            logger.debug("Fail to login for " + userPrincipleName);
            return false;
        }
        if (aadUser != null) {
            logger.debug("login sucees in aad for " + userPrincipleName);
            return true;
        }
        return success;
    }

    private boolean migrateUserFromAAD(String userPrincipleName, String password, CloudLicenseTo cl, Cloud cloud, String cloudName, HttpServletResponse response) {
        int code;
        boolean success = false;
        AADUserElement aaDUserRequestElement = new AADUserElement();
        aaDUserRequestElement.setPassword(password);
        aaDUserRequestElement.setUserName(userPrincipleName);
        AADUserElement aadUser = (AADUserElement)this.aadManagementService.getAADUser(cloud, userPrincipleName, password);
        if (aadUser == null) {
            logger.debug("Fail to login for " + userPrincipleName);
            return success;
        }
        if (org.springframework.util.StringUtils.isEmpty((Object)aadUser.getProductType())) {
            logger.debug("User not part of any product");
            return success;
        }
        boolean isSyncEnabled = false;
        boolean isBackupEnabled = false;
        List list = cl.getCloud().getCloudCustomisableDetails();
        for (CloudCustomisableDetails customisableDetails : list) {
            if (customisableDetails.getName().equalsIgnoreCase(SYNC_ENABLED)) {
                isSyncEnabled = true;
            }
            if (!customisableDetails.getName().equalsIgnoreCase("Backup Enabled")) continue;
            isBackupEnabled = true;
        }
        if ("SYNC".equalsIgnoreCase(aadUser.getProductType())) {
            isBackupEnabled = false;
        }
        if ("BACKUP".equalsIgnoreCase(aadUser.getProductType())) {
            isSyncEnabled = false;
        }
        if (!this.checkLicense(code = this.deviceAndUserSecurityService.validateUserRestrictions(cloud.getCloudId(), cloudName, cl.getCloud()), response)) {
            logger.debug("USER LIMIT REACHED........");
            this.sendEmailForUserLimitExceded(cloud.getCloudId(), cloudName, userPrincipleName, "User");
            return success;
        }
        if (isSyncEnabled && !this.checkLicense(code = this.deviceAndUserSecurityService.validateSyncUserRestrictions(cloud.getCloudId(), cloudName, cl.getCloud()), response)) {
            logger.debug(" SYNC USER LIMIT REACHED........");
            this.sendEmailForUserLimitExceded(cloud.getCloudId(), cloudName, userPrincipleName, "Sync User");
            return success;
        }
        if (isBackupEnabled && !this.checkLicense(code = this.deviceAndUserSecurityService.validateBackupUserRestrictions(cloud.getCloudId(), cloudName, cl.getCloud()), response)) {
            logger.debug("BACKUP USER LIMIT REACHED........");
            this.sendEmailForUserLimitExceded(cloud.getCloudId(), cloudName, userPrincipleName, "Backup User");
            return success;
        }
        LdapUserElement ldapUserElement = new LdapUserElement();
        ldapUserElement.setUserName(aadUser.getUserPrincipalName());
        if (org.springframework.util.StringUtils.isEmpty((Object)aadUser.getMail())) {
            ldapUserElement.setEmailId(aadUser.getUserPrincipalName());
        } else {
            ldapUserElement.setEmailId(aadUser.getMail());
        }
        ldapUserElement.setDisplayName(aadUser.getDisplayName());
        ldapUserElement.setDefaultPolicy(PCHelperConstant.getPropertyFileValueDefaultBkpPolicy());
        ldapUserElement.setDefaultSyncPolicy(PCHelperConstant.getPropertyFileValueDefaultSyncPolicy());
        ldapUserElement.setLocation(aadUser.getOfficeLocation());
        ldapUserElement.setDepartment(aadUser.getDepartment());
        ldapUserElement.setAccountStatus(true);
        boolean userCreated = false;
        try {
            userCreated = this.managementService.createUserFromLdap(cloud.getCloudId(), cloudName, ldapUserElement, "AUTO", isSyncEnabled, isBackupEnabled, false);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(401);
            success = false;
        }
        if (userCreated) {
            this.auditHistoryService.saveStatisticToDatabase(cloud.getCloudId(), cloudName, "migrated", "Auto", ldapUserElement.getUserName(), "Agent", System.currentTimeMillis());
            success = true;
        }
        return success;
    }

    private boolean checkWithADandMigrateUser(CloudLicenseTo cl, int cloudId, String cloudName, String userName, HttpServletResponse response) {
        boolean success = false;
        boolean isSyncEnabled = false;
        boolean isBackupEnabled = false;
        List list = cl.getCloud().getCloudCustomisableDetails();
        try {
            Person personWithADType = this.ldapService.getPersonByUserName(userName);
            if (personWithADType != null) {
                int code;
                if (org.springframework.util.StringUtils.isEmpty((Object)personWithADType.getEmailId()) || !personWithADType.isAccountStatus()) {
                    return false;
                }
                for (CloudCustomisableDetails customisableDetails : list) {
                    if (customisableDetails.getName().equalsIgnoreCase(SYNC_ENABLED)) {
                        isSyncEnabled = true;
                    }
                    if (!customisableDetails.getName().equalsIgnoreCase("Backup Enabled")) continue;
                    isBackupEnabled = true;
                }
                if (isBackupEnabled && "sync".equalsIgnoreCase(personWithADType.getAdGroupType())) {
                    isBackupEnabled = false;
                }
                if (isSyncEnabled && "backup".equalsIgnoreCase(personWithADType.getAdGroupType())) {
                    isSyncEnabled = false;
                }
                if (!this.checkLicense(code = this.deviceAndUserSecurityService.validateUserRestrictions(cloudId, cloudName, cl.getCloud()), response)) {
                    logger.debug("USER LIMIT REACHED........");
                    this.sendEmailForUserLimitExceded(cl.getCloud().getCloudId(), cloudName, userName, "User");
                    return success;
                }
                if (isSyncEnabled && !this.checkLicense(code = this.deviceAndUserSecurityService.validateSyncUserRestrictions(cloudId, cloudName, cl.getCloud()), response)) {
                    logger.debug(" SYNC USER LIMIT REACHED........");
                    this.sendEmailForUserLimitExceded(cl.getCloud().getCloudId(), cloudName, userName, "Sync User");
                    return success;
                }
                if (isBackupEnabled && !this.checkLicense(code = this.deviceAndUserSecurityService.validateBackupUserRestrictions(cloudId, cloudName, cl.getCloud()), response)) {
                    logger.debug("BACKUP USER LIMIT REACHED........");
                    this.sendEmailForUserLimitExceded(cl.getCloud().getCloudId(), cloudName, userName, "Backup User");
                    return success;
                }
                LdapUserElement ldapUserElement = new LdapUserElement();
                ldapUserElement.setUserName(personWithADType.getFullName());
                ldapUserElement.setEmailId(personWithADType.getEmailId());
                ldapUserElement.setOrganizationUnit(personWithADType.getOrganizationalUnit());
                ldapUserElement.setDisplayName(personWithADType.getDisplayName());
                ldapUserElement.setDefaultPolicy(PCHelperConstant.getPropertyFileValueDefaultBkpPolicy());
                ldapUserElement.setDefaultSyncPolicy(PCHelperConstant.getPropertyFileValueDefaultSyncPolicy());
                boolean userCreated = this.managementService.createUserFromLdap(cloudId, cloudName, ldapUserElement, "AUTO", isSyncEnabled, isBackupEnabled, false);
                if (userCreated) {
                    this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "migrated", "Auto", userName, "Agent", System.currentTimeMillis(), PCActionTypes.AD_USER_MIGRATION.getActionTypeValue());
                    success = true;
                }
            } else {
                response.setStatus(401);
                logger.debug(" PERSON NOT FOUND  ..... " + userName);
                success = false;
            }
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(401);
            success = false;
        }
        return success;
    }

    private void setValuesInResponseHeader(HttpServletResponse response, User user, CloudLicenseTo cl, AuthorizationDeviceTo authorizationDeviceTo) {
        boolean isRestoreEnabled = this.isRestoreEnabledForCloud(cl);
        response.setHeader("restore-enabled", String.valueOf(isRestoreEnabled));
        response.setHeader("backup-enabled", String.valueOf(user.isBackupEnabled()));
        response.setHeader("serverbackup-enabled", String.valueOf(user.isServerBackupEnabled()));
        response.setHeader("sync-enabled", String.valueOf(user.isSyncEnabled()));
        response.setHeader("token", authorizationDeviceTo.getAuthorizationTokens().getToken());
        response.setHeader("isLdapEnabled", "true");
        response.setHeader("admin", String.valueOf(user.isAdmin()));
        response.setHeader("readOnlyAdmin", String.valueOf(user.isReadOnlyAdmin()));
        response.setHeader("emailId", user.getEmailId());
    }

    private int validateDeviceAndUser(int cloudId, String cloudName, String username, CloudLicenseTo cl, DeviceElement deviceElement, User user, String deviceUUID, boolean isDeviceBlocked) {
        int statuCode = 0;
        if (isDeviceBlocked) {
            statuCode = 420;
            logger.error("Device Blocked for user ..... ");
        } else {
            List<DeviceElement> list = this.deviceManagementService.getDevicesForUser(cloudId, cloudName, username);
            int activeDevicesForUser = this.activeDevicesForUser(list, cloudId, cloudName, username, deviceUUID);
            int maxDeviceAllowed = this.getMaxDeviceAllowed(cl.getCloud(), user);
            logger.debug("maxDeviceAllowed.........." + maxDeviceAllowed);
            if (activeDevicesForUser >= maxDeviceAllowed) {
                statuCode = 418;
                logger.error("Device limit exceeded for user ..... " + activeDevicesForUser);
                if (deviceElement != null) {
                    logger.error("EMAIL Device limit exceeded for user ..... " + deviceElement.getDeviceName());
                    this.sendEmailForUserDeviceLimitExceeded(cloudId, cl.getCloud().getCloudName(), user, activeDevicesForUser, deviceElement.getDeviceName());
                    DeviceElement element = list.get(0);
                    Device device = this.deviceManagementService.getDeviceByName(cloudId, cloudName, element.getDeviceName());
                    AlertHistory alertHistory = new AlertHistory();
                    alertHistory.setUser(user);
                    alertHistory.setDevice(device);
                    alertHistory.setJobType("Device Limit Reached");
                    alertHistory.setBatchStartTimestamp(System.currentTimeMillis());
                    alertHistory.setBatchEndTimestamp(System.currentTimeMillis());
                    alertHistory.setAction(user.getUserName() + " already has " + activeDevicesForUser + " active devices. ");
                    this.alertHistoryService.saveAlertHistory(cloudId, cloudName, alertHistory);
                }
            }
        }
        if (!(user == null || user.isSyncEnabled() || user.isBackupEnabled() || user.isServerBackupEnabled())) {
            statuCode = 425;
            logger.error("User does not have backup/server-backup and Sync Enabled ...");
        }
        return statuCode;
    }

    private int getMaxDeviceAllowed(Cloud cloud, User user) {
        int maxDeviceAllowed = 0;
        if (user.isBackupEnabled()) {
            BackupPolicy bkpPolicy = this.managementService.getBackupPolicy(cloud.getCloudId(), user.getPolicyName());
            if (bkpPolicy != null) {
                maxDeviceAllowed = bkpPolicy.getNoOfDevicesAllowed();
            } else {
                logger.debug("Bkp policy not found for userName " + user.getUserName() + " and policyName :" + user.getPolicyName());
            }
        } else if (user.isSyncEnabled()) {
            SyncPolicy syncPolicy = this.managementService.getSyncPolicyByPolicyName(cloud.getCloudId(), user.getSyncPolicyName());
            if (syncPolicy != null) {
                maxDeviceAllowed = syncPolicy.getNoOfDevicesAllowed();
            } else {
                logger.debug("SyncPolicy not found for userName " + user.getUserName() + " and policyName :" + user.getSyncPolicyName());
            }
        }
        logger.debug("maxDeviceAllowedInPolicy..." + maxDeviceAllowed);
        return maxDeviceAllowed;
    }

    private int activeDevicesForUser(List<DeviceElement> list, int cloudId, String cloudName, String username, String deviceUUID) {
        int activeDevicesForUser = 0;
        for (DeviceElement element : list) {
            if (Device.TYPE.ONEDRIVE.toString().equalsIgnoreCase(element.getDeviceType()) || element.isBlocked() || element.getDeviceUUID().equals(deviceUUID)) continue;
            ++activeDevicesForUser;
        }
        return activeDevicesForUser;
    }

    private ModelAndView errorMessage(HttpServletResponse response, ModelAndView modelAndView, BaseException e) {
        ErrorElement err = this.createErrorElement(e.getErrorCode(), e.getMessage());
        modelAndView.addObject((Object)err);
        logger.debug("status message:" + e.getMessage());
        response.setStatus(e.getErrorStatus());
        return modelAndView;
    }

    private boolean isRestoreEnabledForCloud(CloudLicenseTo cl) {
        boolean isRestoreEnabled = false;
        List list = cl.getCloud().getCloudCustomisableDetails();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (CloudCustomisableDetails cloudPluginDetails : list) {
                if (!"Restore Enabled".equals(cloudPluginDetails.getName())) continue;
                isRestoreEnabled = true;
                break;
            }
        }
        return isRestoreEnabled;
    }

    private boolean isLdapEnabledForCloud(Cloud cl) {
        boolean isLdapEnabled = false;
        List list = cl.getCloudCustomisableDetails();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (CloudCustomisableDetails cloudPluginDetails : list) {
                if (!"LDAP Enabled".equalsIgnoreCase(cloudPluginDetails.getName())) continue;
                isLdapEnabled = true;
                break;
            }
        }
        return isLdapEnabled;
    }

    @RequestMapping(value={"cloud/{cloudName}/device/user/{userName}/"}, method={RequestMethod.PUT})
    public ModelAndView updateDeviceInformation(@PathVariable(value="cloudName") String cloudName1, @RequestBody DeviceElement deviceElement, @PathVariable(value="userName") String userName, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        logger.debug("calling /updateDevice..." + userName);
        try {
            String token;
            if (!(org.springframework.util.StringUtils.hasText((String)deviceElement.getDeviceUUID()) && org.springframework.util.StringUtils.hasText((String)deviceElement.getDeviceName()) && org.springframework.util.StringUtils.hasText((String)userName))) {
                throw new BaseException(INVALID_REQUEST);
            }
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), response)) {
                return null;
            }
            User user = this.managementService.getUserDetails(cloudId, cloudName, userName);
            int maxDeviceAllowed = this.getMaxDeviceAllowed(cl.getCloud(), user);
            long noOfDevicesConnectedForUser = 0L;
            List<Device> allDevicesForUser = this.deviceManagementService.getAllDevicesForUser(cloudId, cloudName, deviceElement.getUserName());
            for (Device device : allDevicesForUser) {
                if (device.isBlocked()) continue;
                ++noOfDevicesConnectedForUser;
            }
            logger.debug("no of devices connected for user>>>>>>>>>>>" + noOfDevicesConnectedForUser);
            logger.debug("max device allowed>>>>>>>>>>>" + maxDeviceAllowed);
            if (!deviceElement.isBlocked() && noOfDevicesConnectedForUser >= (long)maxDeviceAllowed) {
                response.setStatus(418);
                return null;
            }
            DeviceElement devElement = this.deviceManagementService.updateInfo(cloudId, cloudName, deviceElement, user);
            modelAndView.addObject((Object)devElement);
            response.setStatus(200);
            if (devElement.isBlocked()) {
                this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "blocked the device", userName, deviceElement.getDeviceName(), "Portal", System.currentTimeMillis(), PCActionTypes.DEVICE_BLOCK.getActionTypeValue());
            } else {
                this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "unblocked the device", userName, deviceElement.getDeviceName(), "Portal", System.currentTimeMillis(), PCActionTypes.DEVICE_UNBLOCK.getActionTypeValue());
            }
        }
        catch (EmptyResultDataAccessException e) {
            ErrorElement err = this.createErrorElement(null, DEVICE_NOT_FOUND);
            modelAndView.addObject((Object)err);
            response.setStatus(409);
            logger.trace(EMPTY_RESULT_DATA_ACCESS_EXCEPTION + (Object)((Object)e));
            logger.error(EMPTY_RESULT_DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (DataAccessException e) {
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
            logger.trace(DATA_ACCESS_EXCEPTION + (Object)((Object)e));
            logger.error(DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (BaseException e) {
            ErrorElement err = this.createErrorElement(e.getErrorCode(), null);
            modelAndView.addObject((Object)err);
            response.setStatus(400);
            logger.trace(BASE_EXCEPTION + (Object)((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
        }
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/device/update/{userName}/"}, method={RequestMethod.PUT})
    public void updateDeviceInformationInBulk(@PathVariable(value="cloudName") String cloudName1, @RequestBody List<DeviceElement> deviceElementList, @PathVariable(value="userName") String userName, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        logger.debug("calling /updateDevice..." + userName);
        String deviceUUIDs = request.getHeader("deviceUUIDs");
        try {
            String token;
            boolean blocked = Boolean.parseBoolean(request.getHeader("blocked"));
            if (!org.springframework.util.StringUtils.hasText((String)deviceUUIDs)) {
                throw new BaseException(INVALID_REQUEST);
            }
            ArrayList<String> deviceUUIDList = new ArrayList<String>(Arrays.asList(deviceUUIDs.split(",")));
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), response)) {
                return;
            }
            User user = this.managementService.getUserDetails(cloudId, cloudName, userName);
            for (String deviceUUID : deviceUUIDList) {
                this.updateDeviceInformationInBulk(cloudName, userName, response, modelAndView, cl, cloudId, user, deviceUUID, blocked);
            }
        }
        catch (EmptyResultDataAccessException e) {
            ErrorElement err = this.createErrorElement(null, DEVICE_NOT_FOUND);
            modelAndView.addObject((Object)err);
            response.setStatus(409);
            logger.trace(EMPTY_RESULT_DATA_ACCESS_EXCEPTION + (Object)((Object)e));
            logger.error(EMPTY_RESULT_DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (DataAccessException e) {
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
            logger.trace(DATA_ACCESS_EXCEPTION + (Object)((Object)e));
            logger.error(DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (BaseException e) {
            ErrorElement err = this.createErrorElement(e.getErrorCode(), null);
            modelAndView.addObject((Object)err);
            response.setStatus(400);
            logger.trace(BASE_EXCEPTION + (Object)((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
        }
    }

    private void updateDeviceInformationInBulk(String cloudName, String userName, HttpServletResponse response, ModelAndView modelAndView, CloudLicenseTo cl, int cloudId, User user, String deviceUUID, boolean blocked) {
        DeviceElement deviceElement = this.deviceManagementService.getDeviceInfo(cloudId, cloudName, deviceUUID);
        deviceElement.setBlocked(blocked);
        if (!(org.springframework.util.StringUtils.hasText((String)deviceElement.getDeviceUUID()) && org.springframework.util.StringUtils.hasText((String)deviceElement.getDeviceName()) && org.springframework.util.StringUtils.hasText((String)userName))) {
            return;
        }
        long maxDevicesAllowed = cl.getCloud().getNoOfDevicesAllowed();
        long noOfDevicesConnectedForUser = 0L;
        List<Device> allDevicesForUser = this.deviceManagementService.getAllDevicesForUser(cloudId, cloudName, deviceElement.getUserName());
        for (Device device : allDevicesForUser) {
            if (device.isBlocked()) continue;
            ++noOfDevicesConnectedForUser;
        }
        logger.debug("no of devices connected for user>>>>>>>>>>>" + noOfDevicesConnectedForUser);
        logger.debug("max device allowed>>>>>>>>>>>" + maxDevicesAllowed);
        if (!deviceElement.isBlocked() && noOfDevicesConnectedForUser >= maxDevicesAllowed) {
            response.setStatus(418);
            return;
        }
        DeviceElement devElement = this.deviceManagementService.updateInfo(cloudId, cloudName, deviceElement, user);
        modelAndView.addObject((Object)devElement);
        response.setStatus(200);
        this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "updated the device", userName, deviceElement.getDeviceName(), "Portal", System.currentTimeMillis(), PCActionTypes.DEVICE_UPDATE.getActionTypeValue());
    }

    @RequestMapping(value={"cloud/{cloudName}/device/{deviceUUID}/block/{toBlock}", "versions/{versionNumber}/clouds/{cloudName}/device/{deviceUUID}/block/{toBlock}/"}, method={RequestMethod.PUT})
    public ModelAndView blockDevice(@PathVariable(value="cloudName") String cloudName1, @PathVariable(value="deviceUUID") String deviceUUID, @PathVariable(value="toBlock") boolean toBlock, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        logger.debug("calling /blockDevice ...");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            String userName = request.getHeader("user-name");
            String deviceName = request.getHeader("device-name");
            User currentUser = new User();
            if (!this.performAuthorization(cloudId, cloudName, token, currentUser, response)) {
                return null;
            }
            Device device = this.deviceManagementService.getDeviceByDeviceUUID(cloudId, cloudName, deviceUUID);
            this.deviceManagementService.blockUnblockDevice(cloudId, cloudName, device, toBlock);
            if (toBlock) {
                this.sendEmail("device-blocked", currentUser.getUserName(), userName, deviceName);
                this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "blocked Device:" + deviceName + " of User:", currentUser.getUserName(), userName, "Portal", System.currentTimeMillis(), PCActionTypes.DEVICE_BLOCK.getActionTypeValue());
            } else {
                this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "unblocked Device:" + deviceName + " of User:", currentUser.getUserName(), userName, "Portal", System.currentTimeMillis(), PCActionTypes.DEVICE_UNBLOCK.getActionTypeValue());
            }
            response.setStatus(200);
            return null;
        }
        catch (EmptyResultDataAccessException e) {
            ErrorElement err = this.createErrorElement(null, DEVICE_NOT_FOUND);
            modelAndView.addObject((Object)err);
            response.setStatus(409);
            logger.trace(EMPTY_RESULT_DATA_ACCESS_EXCEPTION + (Object)((Object)e));
            logger.error(EMPTY_RESULT_DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (DataAccessException e) {
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
            logger.trace(DATA_ACCESS_EXCEPTION + (Object)((Object)e));
            logger.error(DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (BaseException e) {
            ErrorElement err = this.createErrorElement(e.getErrorCode(), e.getMessage());
            modelAndView.addObject((Object)err);
            response.setStatus(400);
            logger.trace(BASE_EXCEPTION + (Object)((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
        }
        return modelAndView;
    }

    @RequestMapping(value={"/devicecheck/{deviceId}"}, method={RequestMethod.GET})
    public void checkDeviceId(@PathVariable(value="deviceId") String deviceId, HttpServletRequest request, HttpServletResponse response) throws FileNotFoundException {
        logger.trace("Entering DeviceManagementController.checkDeviceId");
        try {
            File file = new File("/var/lib/parablusys/bin/devID.txt");
            try (Scanner scan = new Scanner(file);){
                logger.debug(" Inside checkDeviceId value for deviceID " + deviceId);
                String deviceIdFromDevIdTxt = "";
                while (scan.hasNextLine()) {
                    deviceIdFromDevIdTxt = scan.nextLine();
                }
                if (deviceId.equals(deviceIdFromDevIdTxt = MD5Generator.generateMD5OfString((String)(deviceIdFromDevIdTxt + "KikZ")))) {
                    response.setStatus(200);
                } else {
                    response.setStatus(400);
                }
            }
            catch (Exception e) {
                logger.trace(EXCEPTION + e);
                logger.error(EXCEPTION + e.getMessage());
            }
        }
        catch (Exception e) {
            response.setStatus(400);
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/device/{deviceUUID}/decoupled/"}, method={RequestMethod.POST})
    public void auditDeviceDecoupled(@PathVariable(value="cloudName") String cloudName1, @PathVariable(value="deviceUUID") String deviceUUID, HttpServletRequest request, HttpServletResponse response) throws FileNotFoundException {
        logger.debug("Entering DeviceManagementController.auditDeviceDecoupled ....  ");
        try {
            User userObj;
            String cloudName = cloudName1;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            int cloudId = cl.getCloud().getCloudId();
            Device device = this.deviceManagementService.getDeviceProperties(cloudId, cloudName = cl.getCloud().getCloudName(), deviceUUID);
            if (device == null) {
                response.setStatus(200);
                return;
            }
            AuthorizationTokens authorizationTokens = this.authorizationService1.getAuthorizationTokenForDeviceUUID(cloudId, cloudName, deviceUUID);
            User user = userObj = authorizationTokens.getUser();
            logger.debug(device + "*****************auditDeviceDecoupled*************************************" + user);
            this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "decoupled device", user.getUserName(), device.getDeviceName(), "EndPoint", System.currentTimeMillis(), PCActionTypes.DEVICE_DECOUPLE.getActionTypeValue());
            this.sendEmail("decoupled-device", user.getUserName(), user.getUserName(), device.getDeviceName());
            this.deviceManagementService.updateDeviceDecoupled(cloudId, cloudName, deviceUUID);
            this.createAlertHistory(cloudId, cloudName, device, userObj);
            response.setStatus(200);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
        }
        logger.debug("End of DeviceManagementController.auditDeviceDecoupled ....  ");
    }

    private void createAlertHistory(int cloudId, String cloudName, Device device, User userObj) {
        AlertHistory alertHistory = new AlertHistory();
        alertHistory.setUser(userObj);
        alertHistory.setDevice(device);
        alertHistory.setJobType("Decoupled");
        alertHistory.setBatchStartTimestamp(System.currentTimeMillis());
        alertHistory.setBatchEndTimestamp(System.currentTimeMillis());
        alertHistory.setAction("Device Decoupled on " + DateUtil.getDateInddMMMyyyy((long)System.currentTimeMillis()) + " by " + userObj.getUserName());
        this.alertHistoryService.saveAlertHistory(cloudId, cloudName, alertHistory);
    }

    private void sendEmail(String action, String currentUserName, String userName, String deviceName) {
        EmailProps email = new EmailProps();
        email.setAction(action);
        email.setActionBy(currentUserName);
        email.setActionOn(userName);
        email.setStartDate(DateUtil.getDateInddMMMyyyy((long)System.currentTimeMillis()));
        email.setDeviceName(deviceName);
        User user = this.managementService.getUserDetails(1, "", userName);
        ArrayList<EmailRecipent> emailRecipents = new ArrayList<EmailRecipent>();
        EmailRecipent emailRecipent = new EmailRecipent();
        emailRecipent.setUserName(user.getUserName());
        emailRecipent.setEmail(user.getEmailId());
        emailRecipents.add(emailRecipent);
        email.setRecipents(emailRecipents);
        this.cloudMailService.sendMail(email);
    }

    private void sendEmailForUserDeviceLimitExceeded(int cloudId, String cloudName, User userObj, int noOfDevices, String deviceName) {
        EmailProps email = new EmailProps();
        ArrayList<EmailRecipent> emailRecipents = new ArrayList<EmailRecipent>();
        email.setAction("device-limit-reached");
        EmailRecipent emailRecipent = new EmailRecipent();
        emailRecipent.setUserName(userObj.getUserName());
        emailRecipent.setEmail(userObj.getEmailId());
        if (PCHelperConstant.getPropertyFileValueEmailsToadminsOnly()) {
            if (userObj.isAdmin()) {
                emailRecipents.add(emailRecipent);
            }
        } else {
            emailRecipents.add(emailRecipent);
        }
        email.setActionBy(userObj.getUserName());
        email.setStartDate(DateUtil.getDateInddMMMyyyy((long)System.currentTimeMillis()));
        email.setDeviceName(deviceName);
        email.setNoOfDevices(Integer.valueOf(noOfDevices));
        email.setRecipents(emailRecipents);
        this.cloudMailService.sendMail(email);
    }

    private static String getStatus(boolean val) {
        if (val) {
            return "Blocked";
        }
        return "Active";
    }

    public static final String decryptBS(String encrypted, String key) {
        try {
            SecretKeySpec keySpecification = new SecretKeySpec(key.getBytes("UTF-8"), "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(2, keySpecification);
            byte[] plainBytes = cipher.doFinal(Base64.decodeBase64((String)encrypted));
            return new String(plainBytes);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            return "";
        }
    }

    @RequestMapping(value={"/cloud/{cloudName}/registerContainer/"}, method={RequestMethod.POST})
    public void createContainer(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response, @RequestBody DeviceContainerElement deviceContainerElement) {
        logger.trace("/cloud/{cloudName}/registerContainer/");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            int cloudId = cl.getCloud().getCloudId();
            if (this.deviceManagementService.isContainerUnique(cloudId, deviceContainerElement)) {
                this.deviceManagementService.registerDeviceContainer(deviceContainerElement, cloudId, cloudName);
                response.setStatus(200);
                this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "Created the container", "", deviceContainerElement.getContainerName(), "Portal", System.currentTimeMillis(), PCActionTypes.CREATE_CONTAINER.getActionTypeValue());
            } else {
                logger.debug("Container already exists in add container");
                response.setStatus(601);
            }
        }
        catch (Exception e) {
            response.setStatus(400);
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
    }

    @RequestMapping(value={"/cloud/{cloudName}/getContainer/"}, method={RequestMethod.POST})
    public ModelAndView getContainer(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        logger.trace("/cloud/{cloudName}/getContainer/");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        String deviceUUID = request.getHeader(DEVICE_UUID);
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            int cloudId = cl.getCloud().getCloudId();
            DeviceContainerListElement deviceContainerListElement = this.deviceManagementService.getDeviceContainerElements(cloudId, deviceUUID);
            modelAndView.addObject((Object)deviceContainerListElement);
            response.setStatus(200);
        }
        catch (Exception e) {
            response.setStatus(400);
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
        return modelAndView;
    }

    @RequestMapping(value={"/cloud/{cloudName}/getAllContainers/"}, method={RequestMethod.POST})
    public ModelAndView getAllContainer(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        logger.trace("/cloud/{cloudName}/getContainer/");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        String deviceUUID = request.getHeader(DEVICE_UUID);
        String userName = request.getHeader(USER_NAME);
        try {
            List<EditDeviceContainerElement> containers;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            int cloudId = cl.getCloud().getCloudId();
            User user = this.managementService.getUserDetails(cloudId, cloudName, userName);
            if (user.isAdmin()) {
                containers = this.deviceManagementService.getAllDeviceContainers(cloudId, deviceUUID);
            } else {
                Group group = this.managementService.getUserGroup(cloudId, user);
                containers = this.deviceManagementService.getAllDeviceContainersByGroup(cloudId, deviceUUID, group);
            }
            modelAndView.addObject(containers);
            response.setStatus(200);
        }
        catch (Exception e) {
            response.setStatus(400);
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
        return modelAndView;
    }

    @RequestMapping(value={"/cloud/{cloudName}/removeContainer/"}, method={RequestMethod.POST})
    public void removeContainer(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response, @RequestBody DeviceContainerElement deviceContainerElement) {
        logger.trace("/cloud/{cloudName}/removeContainer/");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            int cloudId = cl.getCloud().getCloudId();
            this.deviceManagementService.removeContainer(deviceContainerElement, cloudId, cloudName);
            this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "Removed the container", "", deviceContainerElement.getContainerName(), "Portal", System.currentTimeMillis(), PCActionTypes.DELETE_CONTAINER.getActionTypeValue());
            response.setStatus(200);
        }
        catch (Exception e) {
            response.setStatus(400);
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
    }

    @RequestMapping(value={"/cloud/{cloudName}/editContainer/"}, method={RequestMethod.POST})
    public void editContainer(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response, @RequestBody DeviceContainerElement deviceContainerElement) {
        logger.debug("/cloud/{cloudName}/editContainer/");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            int cloudId = cl.getCloud().getCloudId();
            if (this.deviceManagementService.isContainerUnique(cloudId, deviceContainerElement)) {
                this.deviceManagementService.registerDeviceContainer(deviceContainerElement, cloudId, cloudName);
                response.setStatus(200);
                this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "Edited the container", "", deviceContainerElement.getContainerName(), "Portal", System.currentTimeMillis(), PCActionTypes.UPDATE_CONTAINER.getActionTypeValue());
            } else {
                logger.debug("Container already exists");
                response.setStatus(601);
            }
        }
        catch (Exception e) {
            response.setStatus(400);
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/device/delete/user/{userName}/"}, method={RequestMethod.PUT})
    public void deleteDevice(@PathVariable(value="cloudName") String cloudName1, @RequestBody DeviceElement deviceElement, @PathVariable(value="userName") String userName, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling /delete Device..." + deviceElement.isBlocked());
        try {
            User currentUser;
            String token;
            if (!(org.springframework.util.StringUtils.hasText((String)deviceElement.getDeviceUUID()) && org.springframework.util.StringUtils.hasText((String)deviceElement.getDeviceName()) && org.springframework.util.StringUtils.hasText((String)userName))) {
                throw new BaseException(INVALID_REQUEST);
            }
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), currentUser = new User(), response)) {
                return;
            }
            if (!deviceElement.isBlocked()) {
                response.setStatus(403);
                return;
            }
            this.deviceManagementService.deleteDevice(cloudId, cloudName, deviceElement.getDeviceUUID(), response);
            if (response.getStatus() == 200) {
                this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "deleted Device:" + deviceElement.getDeviceName() + " of User:", currentUser.getUserName(), userName, "Portal", System.currentTimeMillis(), PCActionTypes.DEVICE_DELETE.getActionTypeValue());
            }
        }
        catch (EmptyResultDataAccessException e) {
            response.setStatus(409);
            logger.trace(EMPTY_RESULT_DATA_ACCESS_EXCEPTION + (Object)((Object)e));
            logger.error(EMPTY_RESULT_DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (DataAccessException e) {
            response.setStatus(500);
            logger.trace(DATA_ACCESS_EXCEPTION + (Object)((Object)e));
            logger.error(DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (BaseException e) {
            response.setStatus(400);
            logger.trace(BASE_EXCEPTION + (Object)((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
        }
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/device/delete/{deviceUUID}/"}, method={RequestMethod.DELETE})
    public void deleteDeviceByDevicUUID(@PathVariable(value="cloudName") String cloudName1, @PathVariable(value="deviceUUID") String deviceUUID, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        try {
            if (!org.springframework.util.StringUtils.hasText((String)deviceUUID)) {
                throw new BaseException(INVALID_REQUEST);
            }
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            String currentUserName = request.getHeader("deletedBy");
            String userName = request.getHeader("user-name");
            String deviceName = request.getHeader("device-name");
            User currentUser = new User();
            if (!this.performAuthorization(cloudId, cloudName, token, currentUser, response)) {
                return;
            }
            Device device = this.deviceManagementService.getDeviceByDeviceUUID(cloudId, cloudName, deviceUUID);
            if (!device.isBlocked()) {
                response.setStatus(403);
                return;
            }
            this.deviceManagementService.deleteDevice(cloudId, cloudName, device.getDeviceUUID(), response);
            if (response.getStatus() == 200) {
                this.sendEmail("device-deleted", currentUserName, userName, deviceName);
                this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "deleted Device:" + device.getDeviceName() + " of User:", currentUser.getUserName(), userName, "Portal", System.currentTimeMillis(), PCActionTypes.DEVICE_DELETE.getActionTypeValue());
            }
        }
        catch (EmptyResultDataAccessException e) {
            response.setStatus(409);
            logger.trace(EMPTY_RESULT_DATA_ACCESS_EXCEPTION + (Object)((Object)e));
            logger.error(EMPTY_RESULT_DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (DataAccessException e) {
            response.setStatus(500);
            logger.trace(DATA_ACCESS_EXCEPTION + (Object)((Object)e));
            logger.error(DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (BaseException e) {
            response.setStatus(400);
            logger.trace(BASE_EXCEPTION + (Object)((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/device/delete/bulk/user/{userName}/"}, method={RequestMethod.PUT})
    public void deleteDevicesInBulk(@PathVariable(value="cloudName") String cloudName1, @RequestBody List<DeviceElement> deviceElementList, @PathVariable(value="userName") String userName, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        logger.debug("calling /delete Device..." + userName);
        String deviceUUIDs = request.getHeader("deviceUUIDs");
        try {
            User currentUser;
            String token;
            if (!org.springframework.util.StringUtils.hasText((String)deviceUUIDs)) {
                throw new BaseException(INVALID_REQUEST);
            }
            ArrayList<String> deviceUUIDList = new ArrayList<String>(Arrays.asList(deviceUUIDs.split(",")));
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), currentUser = new User(), response)) {
                return;
            }
            for (String deviceUUID : deviceUUIDList) {
                this.deleteDeviceInformationInBulk(cloudName, userName, response, modelAndView, cl, cloudId, deviceUUID, currentUser.getUserName());
            }
        }
        catch (EmptyResultDataAccessException e) {
            ErrorElement err = this.createErrorElement(null, DEVICE_NOT_FOUND);
            modelAndView.addObject((Object)err);
            response.setStatus(409);
            logger.trace(EMPTY_RESULT_DATA_ACCESS_EXCEPTION + (Object)((Object)e));
            logger.error(EMPTY_RESULT_DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (DataAccessException e) {
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
            logger.trace(DATA_ACCESS_EXCEPTION + (Object)((Object)e));
            logger.error(DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (BaseException e) {
            ErrorElement err = this.createErrorElement(e.getErrorCode(), null);
            modelAndView.addObject((Object)err);
            response.setStatus(400);
            logger.trace(BASE_EXCEPTION + (Object)((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
        }
    }

    private void deleteDeviceInformationInBulk(String cloudName, String userName, HttpServletResponse response, ModelAndView modelAndView, CloudLicenseTo cl, int cloudId, String deviceUUID, String currentUserName) {
        DeviceElement deviceElement = this.deviceManagementService.getDeviceInfo(cloudId, cloudName, deviceUUID);
        if (!(org.springframework.util.StringUtils.hasText((String)deviceElement.getDeviceUUID()) && org.springframework.util.StringUtils.hasText((String)deviceElement.getDeviceName()) && org.springframework.util.StringUtils.hasText((String)userName))) {
            return;
        }
        if (!deviceElement.isBlocked()) {
            response.setStatus(403);
            return;
        }
        this.deviceManagementService.deleteDevice(cloudId, cloudName, deviceElement.getDeviceUUID(), response);
        if (response.getStatus() == 200) {
            this.sendEmail("device-deleted", currentUserName, deviceElement.getUserName(), deviceElement.getDeviceName());
            this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "deleted Device:" + deviceElement.getDeviceName() + " of User:", currentUserName, deviceElement.getUserName(), "Portal", System.currentTimeMillis(), PCActionTypes.DEVICE_DELETE.getActionTypeValue());
        }
    }

    private boolean isFeatureEnabled(CloudLicenseTo cl, String feature) {
        List list = cl.getCloud().getCloudCustomisableDetails();
        for (CloudCustomisableDetails customisableDetails : list) {
            if (!customisableDetails.getName().equalsIgnoreCase(feature)) continue;
            return true;
        }
        return false;
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/devices/"}, method={RequestMethod.POST})
    public ModelAndView getDeviceByDeviceNameAndUserName(@PathVariable(value="cloudName") String cloudName1, @RequestBody DeviceListElement userDevicesElementList, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        logger.debug("calling /devices/...");
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), response)) {
                return null;
            }
            List<DeviceElement> devList = this.deviceManagementService.getDeviceByDeviceNameAndUserName(cloudId, cloudName, userDevicesElementList.getDeviceList());
            logger.debug("device list " + devList.size());
            modelAndView.addObject(devList);
            response.setStatus(200);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            ErrorElement err = this.createErrorElement();
            modelAndView.addObject((Object)err);
            response.setStatus(500);
        }
        return modelAndView;
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/devices/block/"}, method={RequestMethod.PUT})
    public ModelAndView bulkDeviceBlock(@PathVariable(value="cloudName") String cloudName1, @RequestBody List<String> deviceUUIDList, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        logger.debug("calling /devices/block/ ...");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            boolean toBlock = Boolean.parseBoolean(request.getHeader("active"));
            User currentUser = new User();
            if (!this.performAuthorization(cloudId, cloudName, token, currentUser, response)) {
                return null;
            }
            for (String deviceUUID : deviceUUIDList) {
                Device device = this.deviceManagementService.getDeviceByDeviceUUID(cloudId, cloudName, deviceUUID);
                this.deviceManagementService.blockUnblockDevice(cloudId, cloudName, device, toBlock);
                if (toBlock) {
                    this.sendEmail("device-blocked", currentUser.getUserName(), device.getUserName(), device.getDeviceName());
                    this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "blocked Device:" + device.getDeviceName() + " of User:", currentUser.getUserName(), device.getUserName(), "Portal", System.currentTimeMillis(), PCActionTypes.DEVICE_BLOCK.getActionTypeValue());
                    continue;
                }
                this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "unblocked Device:" + device.getDeviceName() + " of User:", currentUser.getUserName(), device.getUserName(), "Portal", System.currentTimeMillis(), PCActionTypes.DEVICE_UNBLOCK.getActionTypeValue());
            }
            response.setStatus(200);
            return null;
        }
        catch (EmptyResultDataAccessException e) {
            ErrorElement err = this.createErrorElement(null, DEVICE_NOT_FOUND);
            modelAndView.addObject((Object)err);
            response.setStatus(409);
            logger.trace(EMPTY_RESULT_DATA_ACCESS_EXCEPTION + (Object)((Object)e));
            logger.error(EMPTY_RESULT_DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (DataAccessException e) {
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
            logger.trace(DATA_ACCESS_EXCEPTION + (Object)((Object)e));
            logger.error(DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (BaseException e) {
            ErrorElement err = this.createErrorElement(e.getErrorCode(), e.getMessage());
            modelAndView.addObject((Object)err);
            response.setStatus(400);
            logger.trace(BASE_EXCEPTION + (Object)((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
        }
        return modelAndView;
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/devices/delete/"}, method={RequestMethod.PUT})
    public void deleteDevicesBulk(@PathVariable(value="cloudName") String cloudName1, @RequestBody List<String> deviceUUIDList1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        String userName = request.getHeader("deletedBy");
        logger.debug("calling /devices/delete/ ....." + userName);
        try {
            User currentUser;
            String token;
            List<String> deviceUUIDList = deviceUUIDList1;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), currentUser = new User(), response)) {
                return;
            }
            for (String deviceUUID : deviceUUIDList) {
                this.deleteDeviceInformationInBulk(cloudName, userName, response, modelAndView, cl, cloudId, deviceUUID, currentUser.getUserName());
            }
        }
        catch (EmptyResultDataAccessException e) {
            ErrorElement err = this.createErrorElement(null, DEVICE_NOT_FOUND);
            modelAndView.addObject((Object)err);
            response.setStatus(409);
            logger.trace(EMPTY_RESULT_DATA_ACCESS_EXCEPTION + (Object)((Object)e));
            logger.error(EMPTY_RESULT_DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (DataAccessException e) {
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
            logger.trace(DATA_ACCESS_EXCEPTION + (Object)((Object)e));
            logger.error(DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (BaseException e) {
            ErrorElement err = this.createErrorElement(e.getErrorCode(), null);
            modelAndView.addObject((Object)err);
            response.setStatus(400);
            logger.trace(BASE_EXCEPTION + (Object)((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/update/agentProductVersion"}, method={RequestMethod.POST})
    public void updateAgentVersion(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling update/agentProductVersion ...");
        try {
            block13: {
                CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
                if (!this.checkLicense(cl, response)) {
                    response.setStatus(400);
                }
                cloudName = cl.getCloud().getCloudName();
                int cloudId = cl.getCloud().getCloudId();
                String deviceUUID = request.getHeader(DEVICE_UUID);
                String productVersion = request.getHeader("productVersion");
                String serviceVersion = request.getHeader("serviceVersion");
                try {
                    if (!(org.springframework.util.StringUtils.isEmpty((Object)productVersion) || org.springframework.util.StringUtils.isEmpty((Object)deviceUUID) || productVersion.equals("null"))) {
                        DeviceElement deviceElement = this.deviceManagementService.getDeviceInfo(cloudId, cloudName, deviceUUID);
                        if (deviceElement != null) {
                            String clientVersion = deviceElement.getClientVersion();
                            logger.debug("Device element product version..........." + clientVersion);
                            if (clientVersion != null) {
                                if (!clientVersion.contentEquals(productVersion)) {
                                    this.deviceManagementService.updateClientVersion(cloudId, productVersion, deviceUUID);
                                }
                            } else {
                                this.deviceManagementService.updateClientVersion(cloudId, productVersion, deviceUUID);
                            }
                            if (!org.springframework.util.StringUtils.isEmpty((Object)serviceVersion)) {
                                String clientServiceVersion = deviceElement.getClientServiceVersion();
                                logger.debug("Device element service version..........." + clientServiceVersion + "---- service version : " + serviceVersion);
                                if (org.springframework.util.StringUtils.isEmpty((Object)clientServiceVersion) || !clientServiceVersion.equalsIgnoreCase(serviceVersion)) {
                                    this.deviceManagementService.updateClientServiceVersion(cloudId, serviceVersion, deviceUUID);
                                }
                            }
                        } else {
                            logger.error("device element is nulll...........");
                        }
                        break block13;
                    }
                    logger.debug("product version or uuid is empty.....");
                    response.setStatus(406);
                    return;
                }
                catch (Exception e) {
                    logger.trace("check version and update is Failed..." + e);
                    logger.error("check version and update is Failed..." + e.getMessage());
                }
            }
            response.setStatus(200);
            return;
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace(BASE_EXCEPTION + (Object)((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
            return;
        }
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/devices/createExcel/"}, method={RequestMethod.POST})
    public void createExcel(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, @RequestBody ReportQueryElement deviceQueryElement, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("Cloud name :" + cloudName);
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        if (!this.checkLicense(cl, response)) {
            logger.debug("Invalid Cloud Name.....");
            return;
        }
        try {
            boolean isExcelCreated;
            int cloudId = cl.getCloud().getCloudId();
            String deviceNames = deviceQueryElement.getDeviceName();
            ArrayList<String> list = new ArrayList<String>();
            if (!org.springframework.util.StringUtils.isEmpty((Object)deviceNames)) {
                list = new ArrayList<String>(Arrays.asList(deviceNames.split(",")));
            }
            if (isExcelCreated = this.deviceManagementService.createExcelForDevices(cloudId, list)) {
                response.setStatus(200);
            } else {
                response.setStatus(403);
            }
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
        }
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/device/forceDelete/{deviceUUID}"}, method={RequestMethod.DELETE})
    public void deleteDeviceByAdmin(@PathVariable(value="cloudName") String cloudName, @PathVariable(value="deviceUUID") String deviceUUID, HttpServletRequest request, HttpServletResponse response) {
        String cloudName1 = cloudName;
        String token = request.getHeader("token");
        try {
            User user;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName1);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName1, token, user = new User(), response)) {
                return;
            }
            boolean isRemoteWipe = false;
            Device device = this.deviceManagementService.getDeviceByDeviceUUID(cloudId, cloudName1, deviceUUID);
            if (device != null) {
                isRemoteWipe = this.deviceManagementService.remoteWipe(cloudId, cloudName1, device);
                if (isRemoteWipe) {
                    this.saveStatisticToDatabase(cloudName, cloudId, user, device);
                    response.setStatus(200);
                } else {
                    response.setStatus(500);
                }
            }
        }
        catch (Exception e) {
            logger.trace("Exception" + e);
            logger.error("Exception" + e.getMessage());
        }
    }

    private void saveStatisticToDatabase(String cloudName, int cloudId, User user, Device device) {
        this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "deleted the device", user.getUserName(), device.getDeviceName(), "Portal", System.currentTimeMillis(), PCActionTypes.DEVICE_DELETE.getActionTypeValue());
    }

    private int activeuserssForDevice(List<DeviceElement> list, int cloudId, String cloudName, String deviceUUID) {
        int activeuserssForDevice = 0;
        for (DeviceElement element : list) {
            if (element.isBlocked() || element.getDeviceUUID().equals(deviceUUID)) continue;
            ++activeuserssForDevice;
        }
        return activeuserssForDevice;
    }

    private void sendEmailForUserLimitExceded(int cloudId, String cloudName, String userName, String userLicense) {
        EmailProps email = new EmailProps();
        ArrayList<EmailRecipent> emailRecipents = new ArrayList<EmailRecipent>();
        email.setAction("user-limit-reached");
        EmailRecipent emailRecipent = new EmailRecipent();
        try {
            List<User> allAdmins = this.managementService.getAllAdmins(cloudId, cloudName);
            for (User adminUser : allAdmins) {
                emailRecipent = new EmailRecipent();
                emailRecipent.setUserName(adminUser.getUserName());
                emailRecipent.setEmail(adminUser.getEmailId());
                emailRecipents.add(emailRecipent);
            }
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
        logger.debug("Toatal email recipents count...:" + emailRecipents.size());
        email.setActionBy("");
        email.setStartDate(DateUtil.getDateInddMMMyyyy((long)System.currentTimeMillis()));
        email.setDeviceName(userName);
        email.setRecipents(emailRecipents);
        email.setToUser(true);
        email.setBodyData("EndPoint");
        email.setSupportDescription(userLicense);
        email.setUserName(userName);
        email.setActionOn(userName);
        email.setUserName(userName);
        this.cloudMailService.sendMail(email);
    }

    private boolean migrateUserFromAAD(AADUserElement aadUser, CloudLicenseTo cl, Cloud cloud, String cloudName, HttpServletResponse response) {
        int code;
        boolean success = false;
        if (aadUser == null) {
            logger.debug("aadUser user is null ");
            return success;
        }
        logger.debug("aad user..." + aadUser.toString());
        if (org.springframework.util.StringUtils.isEmpty((Object)aadUser.getProductType())) {
            logger.debug("User not part of any product");
            return success;
        }
        boolean isSyncEnabled = false;
        boolean isBackupEnabled = false;
        List list = cl.getCloud().getCloudCustomisableDetails();
        for (CloudCustomisableDetails customisableDetails : list) {
            if (customisableDetails.getName().equalsIgnoreCase(SYNC_ENABLED)) {
                isSyncEnabled = true;
            }
            if (!customisableDetails.getName().equalsIgnoreCase("Backup Enabled")) continue;
            isBackupEnabled = true;
        }
        if ("SYNC".equalsIgnoreCase(aadUser.getProductType())) {
            isBackupEnabled = false;
        }
        if ("BACKUP".equalsIgnoreCase(aadUser.getProductType())) {
            isSyncEnabled = false;
        }
        if (!this.checkLicense(code = this.deviceAndUserSecurityService.validateUserRestrictions(cloud.getCloudId(), cloudName, cl.getCloud()), response)) {
            logger.debug("USER LIMIT REACHED........");
            return success;
        }
        if (isSyncEnabled && !this.checkLicense(code = this.deviceAndUserSecurityService.validateSyncUserRestrictions(cloud.getCloudId(), cloudName, cl.getCloud()), response)) {
            logger.debug(" SYNC USER LIMIT REACHED........");
            return success;
        }
        if (isBackupEnabled && !this.checkLicense(code = this.deviceAndUserSecurityService.validateBackupUserRestrictions(cloud.getCloudId(), cloudName, cl.getCloud()), response)) {
            logger.debug("BACKUP USER LIMIT REACHED........");
            return success;
        }
        LdapUserElement ldapUserElement = new LdapUserElement();
        ldapUserElement.setUserName(aadUser.getUserPrincipalName());
        if (org.springframework.util.StringUtils.isEmpty((Object)aadUser.getMail())) {
            ldapUserElement.setEmailId(aadUser.getUserPrincipalName());
        } else {
            ldapUserElement.setEmailId(aadUser.getMail());
        }
        ldapUserElement.setDisplayName(aadUser.getDisplayName());
        ldapUserElement.setDefaultPolicy(PCHelperConstant.getPropertyFileValueDefaultBkpPolicy());
        ldapUserElement.setDefaultSyncPolicy(PCHelperConstant.getPropertyFileValueDefaultSyncPolicy());
        ldapUserElement.setLocation(aadUser.getOfficeLocation());
        ldapUserElement.setDepartment(aadUser.getDepartment());
        ldapUserElement.setAccountStatus(true);
        boolean userCreated = false;
        try {
            userCreated = this.managementService.createUserFromLdap(cloud.getCloudId(), cloudName, ldapUserElement, "AUTO", isSyncEnabled, isBackupEnabled, false);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(401);
            success = false;
        }
        if (userCreated) {
            this.auditHistoryService.saveStatisticToDatabase(cloud.getCloudId(), cloudName, "migrated", "Auto", ldapUserElement.getUserName(), "Agent", System.currentTimeMillis());
            success = true;
        }
        return success;
    }
}

