/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.udc.controller;

import com.parablu.bluvault.udc.controller.BaseController;
import com.parablu.bluvault.udc.service.DeviceManagementService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.cloud.security.to.CloudLicenseTo;
import com.parablu.helper.exceptions.BaseException;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class DeviceCertificateManagementController
extends BaseController {
    private static Logger logger = LoggerFactory.getLogger(DeviceCertificateManagementController.class);
    @Autowired
    private LicenseService licenseService;
    @Autowired
    private DeviceManagementService deviceManagementService;

    @RequestMapping(value={"cloud/{cloudName}/validateCertificate/"}, method={RequestMethod.POST})
    public void validateDevice(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        try {
            logger.debug(" INSIDE Validate Device ....................... ");
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            int cloudId = cl.getCloud().getCloudId();
            ServletInputStream inputStream = request.getInputStream();
            byte[] keyBytes = IOUtils.toByteArray((InputStream)inputStream);
            if (keyBytes == null) {
                response.setStatus(400);
                return;
            }
            boolean isDeviceCertAllowed = this.deviceManagementService.checkDeviceCertAuth(cloudId, keyBytes);
            logger.debug("device cert allowed outside ...." + isDeviceCertAllowed);
            if (!isDeviceCertAllowed) {
                logger.debug("device cert allowed...." + isDeviceCertAllowed);
                response.setStatus(400);
                response.setHeader("certAuth", "false");
                return;
            }
            response.setStatus(200);
            response.setHeader("certAuth", "true");
        }
        catch (IOException e) {
            logger.trace(" IOException  :" + e);
            logger.error(" IOException  :" + e.getMessage());
            response.setStatus(400);
            return;
        }
        catch (DataAccessException e) {
            logger.trace(" DataAccessException  :" + (Object)((Object)e));
            logger.error(" DataAccessException  :" + e.getMessage());
            response.setStatus(500);
            return;
        }
        catch (BaseException e) {
            logger.trace(" BaseException  :" + (Object)((Object)e));
            logger.error(" BaseException  :" + e.getMessage());
            response.setStatus(400);
            return;
        }
    }
}

