/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.udc.controller;

import com.parablu.bluvault.ah.service.AuditHistoryService;
import com.parablu.bluvault.udc.controller.BaseController;
import com.parablu.bluvault.udc.service.CloudSettingsService;
import com.parablu.bluvault.udc.service.UserManagementService;
import com.parablu.cloud.security.service.AuthorizationService;
import com.parablu.cloud.security.service.CloudDiskUsageService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.cloud.security.service.UpgradeService;
import com.parablu.cloud.security.to.CloudLicenseTo;
import com.parablu.helper.element.ErrorElement;
import com.parablu.helper.exceptions.BaseException;
import com.parablu.paracloud.constant.PCActionTypes;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.CloudCredentialElement;
import com.parablu.paracloud.element.CloudCredentialListElement;
import com.parablu.paracloud.element.CloudPropertyElement;
import com.parablu.paracloud.element.CloudRegistrationElement;
import com.parablu.paracloud.element.LicenseElement;
import com.parablu.paracloud.element.SmtpElement;
import com.parablu.paracloud.element.UpgradeRequestElement;
import com.parablu.paracloud.util.DiskSpaceHelper;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCredentials;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.CloudPluginDetails;
import com.parablu.pcbd.domain.Release;
import com.parablu.pcbd.domain.User;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class CloudSettingsController
extends BaseController {
    private static Logger logger = LoggerFactory.getLogger(CloudSettingsController.class);
    private static final String HEADER_KEY = PCHelperConstant.getPropertyFileValueReloadKey();
    @Autowired
    private LicenseService licenseService;
    @Autowired
    private CloudSettingsService cloudSettingService;
    @Autowired
    private UserManagementService managementService;
    @Autowired
    CloudDiskUsageService cloudDiskUsageService;
    @Autowired
    UpgradeService upgradeService;
    @Autowired
    private AuthorizationService authorizationServices;
    @Autowired
    private AuditHistoryService auditHistoryService;
    private static final String EXCEPTION = " Exception  :";

    @RequestMapping(value={"/load/all/cloud/{cloud}"}, method={RequestMethod.POST})
    public void loadCloud(@PathVariable(value="cloud") String cloud, HttpServletRequest request, HttpServletResponse response) {
        logger.trace("Entering CloudSettingsController.loadCloud");
        String key = request.getHeader("key");
        if (!key.equals(HEADER_KEY)) {
            response.setStatus(400);
            return;
        }
        Cloud cloud2 = this.licenseService.getCloudDetails(cloud);
        if (cloud2 == null) {
            response.setStatus(400);
            return;
        }
        this.licenseService.reInitialiseCloudMappings();
        try {
            DiskSpaceHelper.forceReinitialiseDiskSpace((String)cloud2.getCloudName(), (long)this.cloudDiskUsageService.getTotalDiskSpaceUsedForCloud(cloud2.getCloudId(), cloud2.getCloudName()));
        }
        catch (Exception e) {
            logger.debug(" @@@@@ Exception inside loadcloud forceReinitialiseDiskSpace " + e);
        }
        response.setStatus(200);
    }

    @RequestMapping(value={"/cloud/clients/version"}, method={RequestMethod.POST})
    public void updateVersion(@RequestBody UpgradeRequestElement upgradeRequestElement, HttpServletRequest request, HttpServletResponse response) {
        logger.trace("Entering CloudSettingsController.updateVersion");
        logger.debug("calling updateVersion ...");
        if (StringUtils.isBlank((String)upgradeRequestElement.getCurrentVersion()) || StringUtils.isBlank((String)upgradeRequestElement.getProductMinorGroup())) {
            response.setStatus(400);
            return;
        }
        try {
            Release release = this.upgradeService.getReleaseVersionForClientMinorVersionType(upgradeRequestElement.getProductMinorGroup(), upgradeRequestElement.getCurrentVersion());
            if (release == null) {
                response.setStatus(204);
                return;
            }
            release.setProductVersion(upgradeRequestElement.getCurrentVersion());
            this.upgradeService.updateReleaseDetail(release);
            response.setStatus(200);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
        }
    }

    @RequestMapping(value={"/ping/"}, method={RequestMethod.GET})
    public void pingCloud(HttpServletRequest request, HttpServletResponse response) {
        logger.debug("Entering CloudSettingsController.pingCloud");
        try {
            String key = request.getHeader("key");
            if (StringUtils.isEmpty((String)key) || !key.equals(HEADER_KEY)) {
                response.setStatus(400);
                return;
            }
            response.setStatus(200);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(400);
        }
    }

    @RequestMapping(value={"/api/license/info/{cloudName}"}, method={RequestMethod.GET})
    public ModelAndView getLicenseDetailsForCloud(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        logger.trace("Inside getLicenseDetailsForCloud");
        ModelAndView modelAndView = null;
        LicenseElement licenseElement = null;
        try {
            if (StringUtils.isEmpty((String)cloudName)) {
                throw new BaseException("Invalid cloudname", 400);
            }
            licenseElement = this.licenseService.getLicenceElementForCloud(cloudName);
            if (licenseElement == null) {
                throw new BaseException("Invalid license element", 400);
            }
            response.setStatus(200);
            modelAndView = new ModelAndView();
            if ("application/xml".equalsIgnoreCase(request.getHeader("Content-Type"))) {
                logger.trace("since the Content-Type is application/xml so will return XML");
                modelAndView.setViewName("xmlview");
            } else {
                logger.trace("since the Content-Type is NOT application/xml so will return JSON");
                modelAndView.setViewName("jsonview");
            }
            response.setHeader("noOfUsersAllowedWithSync", String.valueOf(licenseElement.getNoOfUsersAllowedWithSync()));
            response.setHeader("noOfUsersAllowedWithBackup", String.valueOf(licenseElement.getNoOfUsersAllowedWithBackup()));
            response.setHeader("enableMedia", String.valueOf(licenseElement.getEnableMedia()));
            modelAndView.addObject((Object)licenseElement);
        }
        catch (BaseException baseException) {
            logger.trace(" BaseException  :" + (Object)((Object)baseException));
            logger.error("Inside getLicenseDetailsForCloud baseexception " + baseException.getMessage());
            response.setStatus(baseException.getErrorStatus());
        }
        catch (Exception e) {
            logger.trace("Inside getLicenseDetailsForCloud exception : " + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
        }
        return modelAndView;
    }

    @RequestMapping(value={"/register/cloud/{cloudName}"}, method={RequestMethod.POST})
    public synchronized void registerCloud(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        logger.trace("Entering CloudSettingsController.registerCloud ");
        CloudRegistrationElement cloudRegistrationElement = new CloudRegistrationElement();
        String userName = "inba";
        String password = "63a9f0ea7bb98050796b649e85481845";
        boolean syncEnabled = true;
        boolean backupEnabled = false;
        ArrayList<String> pluginDetails = new ArrayList<String>();
        pluginDetails.add("Backup Enabled");
        pluginDetails.add("Restore Enabled");
        Cloud cloud = this.convertElementToCloudAndAssociateDB(cloudRegistrationElement);
        cloud.setCloudName("dev");
        cloud.setNoOfBackupUsersAllowed(10);
        cloud.setCloudSizeAllowed(10240);
        cloud.setContentSearchEnabled(1);
        cloud.setNoOfDevicesAllowed(10);
        cloud.setNoOfSyncUsersAllowed(10);
        cloud.setNoOfUsersAllowed(10);
        cloud.setVersioningEnabled(10);
        cloud.setNoOfMiniCloudsAllowed(10);
        cloud.setValidityPeriod(1451586600000L);
        boolean shareEnabled = false;
        ArrayList<String> customisableDetails = new ArrayList<String>();
        customisableDetails.add("Backup Enabled");
        customisableDetails.add("Restore Enabled");
        customisableDetails.add("Sync Enabled");
        customisableDetails.add("Shared Enabled");
        customisableDetails.add("LDAP Enabled");
        if (!CollectionUtils.isEmpty(pluginDetails)) {
            this.addPluginDetails(pluginDetails, cloud);
        }
        if (!CollectionUtils.isEmpty(customisableDetails)) {
            this.addCustomisableDetails(customisableDetails, cloud);
        }
        User user = this.createFirstUser(userName, password, syncEnabled, backupEnabled, "test@test.com", shareEnabled);
        try {
            this.cloudSettingService.createNewCloud(cloud);
            this.managementService.createUser(1, cloudName, user);
            response.setStatus(200);
        }
        catch (Exception exception) {
            logger.trace("exception", (Throwable)exception);
            response.setStatus(500);
        }
    }

    private void addPluginDetails(List<String> pluginDetails, Cloud cloud2) {
        HashSet<CloudPluginDetails> cloudPluginDetailsSet = new HashSet<CloudPluginDetails>();
        for (String pluginName : pluginDetails) {
            CloudPluginDetails cloudPluginDetails = new CloudPluginDetails();
            cloudPluginDetails.setPluginName(pluginName);
            cloudPluginDetailsSet.add(cloudPluginDetails);
        }
        if (!cloudPluginDetailsSet.isEmpty()) {
            cloud2.setCloudPluginDetails(new ArrayList());
            cloud2.getCloudPluginDetails().addAll(cloudPluginDetailsSet);
        }
    }

    private void addCustomisableDetails(List<String> customisableDetails, Cloud cloud2) {
        HashSet<CloudCustomisableDetails> cloudPluginDetailsSet = new HashSet<CloudCustomisableDetails>();
        for (String customizableName : customisableDetails) {
            CloudCustomisableDetails cloudCustomisableDetails = new CloudCustomisableDetails();
            cloudCustomisableDetails.setName(customizableName);
            cloudPluginDetailsSet.add(cloudCustomisableDetails);
        }
        if (!cloudPluginDetailsSet.isEmpty()) {
            cloud2.setCloudCustomisableDetails(new ArrayList());
            cloud2.getCloudCustomisableDetails().addAll(cloudPluginDetailsSet);
        }
    }

    protected User createFirstUser(String userName, String password, boolean syncEnabled, boolean backupEnabled, String emailId, boolean shareEnabled) {
        User user = new User();
        user.setActive(true);
        user.setAdmin(true);
        user.setEmailId(emailId);
        user.setLastModifiedTimestamp(String.valueOf(System.currentTimeMillis()));
        user.setUserName(userName);
        user.setPasswdHash(password);
        user.setBackupEnabled(true);
        user.setSyncEnabled(true);
        user.setShareEnabled(true);
        return user;
    }

    private Cloud convertElementToCloudAndAssociateDB(CloudRegistrationElement cloudRegistrationElement) {
        Cloud cloud = new Cloud();
        cloud.setCloudName(cloudRegistrationElement.getCloudName());
        cloud.setCloudRegistrationUUId(cloudRegistrationElement.getCloudUUID());
        cloud.setCloudSizeAllowed(cloudRegistrationElement.getCloudSizeAllowed());
        cloud.setNoOfBackupUsersAllowed(cloudRegistrationElement.getNoOfUsersAllowedWithBackup());
        cloud.setNoOfSyncUsersAllowed(cloudRegistrationElement.getNoOfUsersAllowedWithSync());
        cloud.setVersioningEnabled(cloudRegistrationElement.getVersionsAllowed());
        cloud.setContentSearchEnabled(cloudRegistrationElement.getContentSearchAllowed());
        cloud.setNoOfMiniCloudsAllowed(cloudRegistrationElement.getNoOfMiniCloudsAllowed());
        cloud.setNoOfUsersAllowed(cloudRegistrationElement.getTotalNoOfUsers());
        cloud.setStatusCode("ACTIVE");
        try {
            cloud.setValidityPeriod(cloudRegistrationElement.getValidityPeriod());
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
        String devicesAllowed = "NEED TO CLEAN API";
        int devices = Integer.parseInt(devicesAllowed);
        cloud.setNoOfDevicesAllowed(devices);
        cloud.setExternalStorageAllowed(cloudRegistrationElement.getExternalStorageAllowed());
        cloud.setNoOfDevicesAllowed(cloudRegistrationElement.getMaxDevicePerUser());
        cloud.setEnableMedia(cloudRegistrationElement.getEnableMedia());
        cloud.setPci(cloudRegistrationElement.getPci());
        cloud.setIm1(cloudRegistrationElement.getIm1());
        cloud.setIm2(cloudRegistrationElement.getIm2());
        cloud.setIm3(cloudRegistrationElement.getIm3());
        return cloud;
    }

    @Deprecated
    @RequestMapping(value={"cloud/{cloudName}/save/cloudCredentials/"}, method={RequestMethod.POST})
    public void saveCloudCredentials(@PathVariable(value="cloudName") String cloudName, @RequestBody CloudCredentialElement cloudCredentialElement, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("calling savecloudCredentials ..." + cloudCredentialElement.getCloudName());
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            User currentUser = new User();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), currentUser, response)) {
                return;
            }
            CloudCredentials cloudCredentials = new CloudCredentials();
            BeanUtils.copyProperties((Object)cloudCredentialElement, (Object)cloudCredentials);
            String provider = this.getProvider(cloudCredentials.getCloudName());
            cloudCredentials.setProvider(provider);
            this.cloudSettingService.saveCloudCredentials(cloudId, cloudCredentials);
            this.auditHistoryService.saveStatisticToDatabase(cl.getCloud().getCloudId(), cloudName, "created cloud ", currentUser.getUserName(), cloudCredentials.getIdentity(), "Portal", System.currentTimeMillis(), PCActionTypes.CLOUD_CREATE.getActionTypeValue());
            response.setStatus(200);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error("Error failed to save external storage authentication ..." + e.getMessage());
            response.setStatus(500);
        }
        logger.debug("end of calling savecloudCredentials ");
    }

    @Deprecated
    @RequestMapping(value={"cloud/{cloudName}/cc/all"}, method={RequestMethod.GET})
    public ModelAndView getAllCloudCredentials(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        CloudCredentialListElement cc = new CloudCredentialListElement();
        modelAndView.setViewName("jsonview");
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), response)) {
                return null;
            }
            List<CloudCredentialElement> list = this.cloudSettingService.getAllCloudCredentials(cloudId);
            list.removeAll(Collections.singleton(null));
            Collections.sort(list, new Comparator<CloudCredentialElement>(){

                @Override
                public int compare(CloudCredentialElement u1, CloudCredentialElement u2) {
                    if (u1 == null || u2 == null || u1.getCloudName() == null || u2.getCloudName() == null) {
                        return -1;
                    }
                    return new CompareToBuilder().append((Object)u1.getCloudName().toLowerCase(), (Object)u2.getCloudName().toLowerCase()).toComparison();
                }
            });
            cc.setCloudCredentialElements(list);
            modelAndView.addObject((Object)cc);
            response.setStatus(200);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
        }
        return modelAndView;
    }

    private String getProvider(String cloudName) {
        String provider = "";
        if ("azureblob".equalsIgnoreCase(cloudName)) {
            provider = "azureblob";
        } else if ("amazon".equalsIgnoreCase(cloudName)) {
            provider = "aws-s3";
        } else if ("ibmCloud".equalsIgnoreCase(cloudName)) {
            provider = "swift";
        } else if ("s3".equalsIgnoreCase(cloudName)) {
            provider = "s3";
        } else if ("b2".equalsIgnoreCase(cloudName)) {
            provider = "b2";
        }
        return provider;
    }

    @Deprecated
    @RequestMapping(value={"cloud/{cloudName}/cc/delete/"}, method={RequestMethod.POST})
    public void deleteCloudCredentials(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("calling deletecloudCredentials test ...");
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            logger.debug("calling deletecloudCredentials test1 ...");
            String identity = request.getHeader("identity");
            if (StringUtils.isEmpty((String)identity)) {
                response.setStatus(400);
                return;
            }
            User currentUser = new User();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), currentUser, response)) {
                return;
            }
            logger.debug("befor deletecloudCredentials ..." + identity);
            this.cloudSettingService.deleteCloudCredentials(cl.getCloud().getCloudId(), identity);
            this.auditHistoryService.saveStatisticToDatabase(cl.getCloud().getCloudId(), cloudName, "deleted cloud ", currentUser.getUserName(), identity, "Portal", System.currentTimeMillis(), PCActionTypes.CLOUD_DELETE.getActionTypeValue());
            response.setStatus(200);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/save/cloudprops/"}, method={RequestMethod.POST})
    public void saveCloudProperties(@PathVariable(value="cloudName") String cloudName1, @RequestBody CloudPropertyElement cloudPropElement, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling cloudprop/save..." + cloudPropElement.getAzureVM());
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            cloudName = cl.getCloud().getCloudName();
            if (!this.performAuthorization(cloudId, cloudName, token, response)) {
                return;
            }
            this.cloudSettingService.saveCloudProperties(cloudId, cloudPropElement);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.error("Error failed to cloudprop/save ..." + (Object)((Object)e));
            logger.debug("Error failed to save cloud props ..." + e.getMessage());
        }
        logger.debug("end of calling save cloud props ...");
    }

    @RequestMapping(value={"cloud/{cloudName}/get/cloudprops/"}, method={RequestMethod.POST})
    public ModelAndView getCloudProperties(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling cloudprop/get...");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            cloudName = cl.getCloud().getCloudName();
            if (!this.performAuthorization(cloudId, cloudName, token, response)) {
                return null;
            }
            CloudPropertyElement cloudPropertyElement = this.cloudSettingService.getCloudPropertyElement(cloudId);
            if (cloudPropertyElement != null) {
                response.setStatus(200);
                modelAndView.addObject((Object)cloudPropertyElement);
            } else {
                response.setStatus(500);
            }
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.error("Error failed to getcloud props ..." + (Object)((Object)e));
            logger.debug("Error failed to /cloudprop/get ..." + e.getMessage());
        }
        logger.debug("end of calling save cloudprop ...");
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/save/smtp/"}, method={RequestMethod.POST})
    public void saveSmtpCredentials(@PathVariable(value="cloudName") String cloudName1, @RequestBody SmtpElement smtpElement, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling smtp/save..." + smtpElement.getFromEmail());
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            User currentUser = new User();
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            cloudName = cl.getCloud().getCloudName();
            if (!this.authorizationServices.getTokenDetailsForToken(cloudId, cloudName, token).getUser().isAdmin()) {
                logger.debug("not a  admin user so return");
                response.setStatus(403);
                return;
            }
            if (!this.performAuthorization(cloudId, cloudName, token, currentUser, response)) {
                return;
            }
            logger.debug(smtpElement.getSmtpAuth() + " currentUser >>>>>>>>>>>" + currentUser.getUserName());
            this.cloudSettingService.saveSmtpCredentials(cloudId, smtpElement);
            this.auditHistoryService.saveStatisticToDatabase(cl.getCloud().getCloudId(), cloudName, "created a new SMTP configuration ", currentUser.getUserName(), "", "Portal", System.currentTimeMillis(), PCActionTypes.SMTP_CREATE.getActionTypeValue());
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.error("Error failed to save smtp ..." + (Object)((Object)e));
            logger.debug("Error failed to /smtp/save ..." + e.getMessage());
        }
        logger.debug("end of calling /smtp/save ...");
    }

    @RequestMapping(value={"cloud/{cloudName}/get/smtp/"}, method={RequestMethod.POST})
    public ModelAndView getSmtpCredentials(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling smtp/get...");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            cloudName = cl.getCloud().getCloudName();
            if (!this.performAuthorization(cloudId, cloudName, token, response)) {
                return null;
            }
            SmtpElement smtpElement = this.cloudSettingService.getSmtpElement(cloudId);
            if (smtpElement != null) {
                response.setStatus(200);
                modelAndView.addObject((Object)smtpElement);
            } else {
                response.setStatus(500);
            }
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.error("Error failed to gettingsmtp ..." + (Object)((Object)e));
            logger.debug("Error failed to gettingSmtp ..." + e.getMessage());
        }
        logger.debug("end of calling gettin smtp ...");
        return modelAndView;
    }

    @RequestMapping(value={"{version}/cloud/{cloudName}/cloudCredentials/"}, method={RequestMethod.POST})
    public void createCloudCredentials(@PathVariable(value="version") String version, @PathVariable(value="cloudName") String cloudName1, @RequestBody CloudCredentialElement cloudCredentialElement, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("calling savecloudCredentials ..." + cloudCredentialElement.getCloudName());
        String cloudName = cloudName1;
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            User currentUser = new User();
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            cloudName = cl.getCloud().getCloudName();
            if (!this.performAuthorization(cloudId, cloudName, token, response)) {
                return;
            }
            CloudCredentials cloudCredentials = new CloudCredentials();
            BeanUtils.copyProperties((Object)cloudCredentialElement, (Object)cloudCredentials);
            String provider = this.getProvider(cloudCredentials.getCloudName());
            cloudCredentials.setProvider(provider);
            if (this.cloudSettingService.createCloudCredentials(cloudId, cloudCredentials)) {
                response.setStatus(200);
                this.auditHistoryService.saveStatisticToDatabase(cl.getCloud().getCloudId(), cloudName, "created cloud ", currentUser.getUserName(), cloudCredentials.getCloudName(), "Portal", System.currentTimeMillis(), PCActionTypes.CLOUD_CREATE.getActionTypeValue());
            } else {
                response.setStatus(406);
            }
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error("Error failed to save external storage authentication ..." + e.getMessage());
            response.setStatus(500);
        }
        logger.debug("end of calling savecloudCredentials ");
    }

    @RequestMapping(value={"{version}/cloud/{cloudName}/cloudCredentials/{identity}"}, method={RequestMethod.PUT})
    public void edditCloudCredentials(@PathVariable(value="version") String version, @PathVariable(value="identity") String identity, @PathVariable(value="cloudName") String cloudName1, @RequestBody CloudCredentialElement cloudCredentialElement, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("calling editcloudCredentials ..." + cloudCredentialElement.getCloudName());
        String cloudName = cloudName1;
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            User currentUser = new User();
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            cloudName = cl.getCloud().getCloudName();
            if (!this.performAuthorization(cloudId, cloudName, token, currentUser, response)) {
                return;
            }
            CloudCredentials cloudCredentials = new CloudCredentials();
            BeanUtils.copyProperties((Object)cloudCredentialElement, (Object)cloudCredentials);
            String provider = this.getProvider(cloudCredentials.getCloudName());
            cloudCredentials.setProvider(provider);
            if (this.cloudSettingService.editCloudCredentials(cloudId, cloudCredentials)) {
                response.setStatus(200);
                this.auditHistoryService.saveStatisticToDatabase(cl.getCloud().getCloudId(), cloudName, "edited cloud ", currentUser.getUserName(), cloudCredentials.getCloudName(), "Portal", System.currentTimeMillis(), PCActionTypes.CLOUD_UPDATE.getActionTypeValue());
            } else {
                response.setStatus(406);
            }
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error("Error failed to edit external storage authentication ..." + e.getMessage());
            response.setStatus(500);
        }
        logger.debug("end of calling editcloudCredentials ");
    }

    @RequestMapping(value={"{version}/cloud/{cloudName}/cloudCredentials/"}, method={RequestMethod.GET})
    public ModelAndView getAllCloudCredentialList(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        CloudCredentialListElement cc = new CloudCredentialListElement();
        modelAndView.setViewName("jsonview");
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), response)) {
                return null;
            }
            List<CloudCredentialElement> list = this.cloudSettingService.getAllCloudCredentials(cloudId);
            list.removeAll(Collections.singleton(null));
            if (!CollectionUtils.isEmpty(list)) {
                Collections.sort(list, new Comparator<CloudCredentialElement>(){

                    @Override
                    public int compare(CloudCredentialElement u1, CloudCredentialElement u2) {
                        if (u1 == null || u2 == null || u1.getCloudName() == null || u2.getCloudName() == null) {
                            return -1;
                        }
                        return new CompareToBuilder().append((Object)u1.getCloudName().toLowerCase(), (Object)u2.getCloudName().toLowerCase()).toComparison();
                    }
                });
                cc.setCloudCredentialElements(list);
                modelAndView.addObject((Object)cc);
                response.setStatus(200);
            } else {
                response.setStatus(406);
            }
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
        }
        return modelAndView;
    }

    @RequestMapping(value={"{version}/cloud/{cloudName}/cloudCredentials/{identity}"}, method={RequestMethod.DELETE})
    public void removeCloudCredentials(@PathVariable(value="cloudName") String cloudName, @PathVariable(value="identity") String identity, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("calling deletecloudCredentials test ...");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            logger.debug("calling deletecloudCredentials test1 ...");
            if (StringUtils.isEmpty((String)identity)) {
                response.setStatus(400);
                return;
            }
            User currentUser = new User();
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            String cloudName1 = cl.getCloud().getCloudName();
            if (!this.performAuthorization(cloudId, cloudName1, token, currentUser, response)) {
                return;
            }
            logger.debug("befor deletecloudCredentials ..." + identity);
            if (this.cloudSettingService.deleteCloudCredentials(cl.getCloud().getCloudId(), identity)) {
                response.setStatus(200);
                this.auditHistoryService.saveStatisticToDatabase(cl.getCloud().getCloudId(), cloudName1, "deleted cloud ", currentUser.getUserName(), identity, "Portal", System.currentTimeMillis(), PCActionTypes.CLOUD_DELETE.getActionTypeValue());
            } else {
                response.setStatus(404);
            }
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
        }
    }

    @RequestMapping(value={"{version}/cloud/{cloudName}/cloudProperties/"}, method={RequestMethod.PUT})
    public void editCloudProperties(@PathVariable(value="cloudName") String cloudName1, @RequestBody CloudPropertyElement cloudPropElement, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling cloudprop/save..." + cloudPropElement.getAzureVM());
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            cloudName = cl.getCloud().getCloudName();
            User currentUser = this.authorizationServices.getTokenDetailsForToken(cloudId, cloudName, token).getUser();
            if (!currentUser.isAdmin()) {
                logger.debug("not a admin user so return");
                response.setStatus(403);
                return;
            }
            if (!this.performAuthorization(cloudId, cloudName, token, response)) {
                return;
            }
            String fieldChanged = this.cloudSettingService.saveCloudProperties(cloudId, cloudPropElement);
            response.setStatus(200);
            if (!StringUtils.isEmpty((String)fieldChanged)) {
                this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, " modified cloud properties. The changed fields are " + fieldChanged, currentUser.getUserName(), "", "Portal", System.currentTimeMillis(), PCActionTypes.CLOUD_PROPERTIES_UPDATE.getActionTypeValue());
            }
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.error("Error failed to cloudprop/save ..." + (Object)((Object)e));
            logger.debug("Error failed to save cloud props ..." + e.getMessage());
        }
        logger.debug("end of calling save cloud props ...");
    }

    @RequestMapping(value={"{version}/cloud/{cloudName}/cloudProperties/"}, method={RequestMethod.GET})
    public ModelAndView getNewCloudProperties(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling cloudprop/get............");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            cloudName = cl.getCloud().getCloudName();
            if (StringUtils.isEmpty((String)request.getHeader("isInternalCall")) && !this.performAuthorization(cloudId, cloudName, token, response)) {
                return null;
            }
            CloudPropertyElement cloudPropertyElement = this.cloudSettingService.getCloudPropertyElement(cloudId);
            if (cloudPropertyElement != null) {
                cloudPropertyElement.setNoOfDevicesAllowed(cl.getCloud().getNoOfDevicesAllowed());
                response.setStatus(200);
                modelAndView.addObject((Object)cloudPropertyElement);
            } else {
                response.setStatus(500);
            }
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.error("Error failed to getcloud props ..." + (Object)((Object)e));
            logger.debug("Error failed to /cloudprop/get ..." + e.getMessage());
        }
        logger.debug("end of calling save cloudprop ...");
        return modelAndView;
    }
}

