/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Feature;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.Binder;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.CommonProperties;
import org.glassfish.jersey.ExtendedConfig;
import org.glassfish.jersey.client.ClientBinder;
import org.glassfish.jersey.client.ClientRuntime;
import org.glassfish.jersey.client.HttpUrlConnectorProvider;
import org.glassfish.jersey.client.JerseyClient;
import org.glassfish.jersey.client.internal.LocalizationMessages;
import org.glassfish.jersey.client.spi.Connector;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.glassfish.jersey.internal.ServiceFinder;
import org.glassfish.jersey.internal.inject.Injections;
import org.glassfish.jersey.internal.inject.ProviderBinder;
import org.glassfish.jersey.internal.util.collection.LazyValue;
import org.glassfish.jersey.internal.util.collection.Value;
import org.glassfish.jersey.internal.util.collection.Values;
import org.glassfish.jersey.model.internal.CommonConfig;
import org.glassfish.jersey.model.internal.ComponentBag;
import org.glassfish.jersey.process.internal.ExecutorProviders;

public class ClientConfig
implements Configurable<ClientConfig>,
ExtendedConfig {
    private State state;

    public ClientConfig() {
        this.state = new State(null);
    }

    public ClientConfig(Class<?> ... providerClasses) {
        this();
        for (Class<?> providerClass : providerClasses) {
            this.state.register((Class)providerClass);
        }
    }

    public ClientConfig(Object ... providers) {
        this();
        for (Object provider : providers) {
            this.state.register(provider);
        }
    }

    ClientConfig(JerseyClient parent) {
        this.state = new State(parent);
    }

    ClientConfig(JerseyClient parent, Configuration that) {
        if (that instanceof ClientConfig) {
            this.state = ((ClientConfig)that).state.copy(parent);
        } else {
            this.state = new State(parent);
            this.state.loadFrom(that);
        }
    }

    private ClientConfig(State state) {
        this.state = state;
    }

    ClientConfig snapshot() {
        this.state.markAsShared();
        return new ClientConfig(this.state);
    }

    public ClientConfig loadFrom(Configuration config) {
        if (config instanceof ClientConfig) {
            this.state = ((ClientConfig)config).state.copy();
        } else {
            this.state.loadFrom(config);
        }
        return this;
    }

    public ClientConfig register(Class<?> providerClass) {
        this.state = this.state.register((Class)providerClass);
        return this;
    }

    public ClientConfig register(Object provider) {
        this.state = this.state.register(provider);
        return this;
    }

    public ClientConfig register(Class<?> providerClass, int bindingPriority) {
        this.state = this.state.register((Class)providerClass, bindingPriority);
        return this;
    }

    public ClientConfig register(Class<?> providerClass, Class<?> ... contracts) {
        this.state = this.state.register((Class)providerClass, (Class[])contracts);
        return this;
    }

    public ClientConfig register(Class<?> providerClass, Map<Class<?>, Integer> contracts) {
        this.state = this.state.register((Class)providerClass, (Map)contracts);
        return this;
    }

    public ClientConfig register(Object provider, int bindingPriority) {
        this.state = this.state.register(provider, bindingPriority);
        return this;
    }

    public ClientConfig register(Object provider, Class<?> ... contracts) {
        this.state = this.state.register(provider, (Class[])contracts);
        return this;
    }

    public ClientConfig register(Object provider, Map<Class<?>, Integer> contracts) {
        this.state = this.state.register(provider, (Map)contracts);
        return this;
    }

    public ClientConfig property(String name, Object value) {
        this.state = this.state.property(name, value);
        return this;
    }

    public ClientConfig getConfiguration() {
        return this;
    }

    public RuntimeType getRuntimeType() {
        return this.state.getRuntimeType();
    }

    public Map<String, Object> getProperties() {
        return this.state.getProperties();
    }

    public Object getProperty(String name) {
        return this.state.getProperty(name);
    }

    public Collection<String> getPropertyNames() {
        return this.state.getPropertyNames();
    }

    public boolean isProperty(String name) {
        return this.state.isProperty(name);
    }

    public boolean isEnabled(Feature feature) {
        return this.state.isEnabled(feature);
    }

    public boolean isEnabled(Class<? extends Feature> featureClass) {
        return this.state.isEnabled(featureClass);
    }

    public boolean isRegistered(Object component) {
        return this.state.isRegistered(component);
    }

    public Map<Class<?>, Integer> getContracts(Class<?> componentClass) {
        return this.state.getContracts(componentClass);
    }

    public boolean isRegistered(Class<?> componentClass) {
        return this.state.isRegistered(componentClass);
    }

    public Set<Class<?>> getClasses() {
        return this.state.getClasses();
    }

    public Set<Object> getInstances() {
        return this.state.getInstances();
    }

    public ClientConfig connectorProvider(ConnectorProvider connectorProvider) {
        this.state = this.state.connectorProvider(connectorProvider);
        return this;
    }

    public Connector getConnector() {
        return this.state.getConnector();
    }

    public ConnectorProvider getConnectorProvider() {
        return this.state.getConnectorProvider();
    }

    ClientRuntime getRuntime() {
        return (ClientRuntime)this.state.runtime.get();
    }

    public JerseyClient getClient() {
        return this.state.getClient();
    }

    ClientConfig preInitialize() {
        this.state = this.state.preInitialize();
        return this;
    }

    void checkClient() throws IllegalStateException {
        if (this.getClient() == null) {
            throw new IllegalStateException("Client configuration does not contain a parent client instance.");
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClientConfig other = (ClientConfig)obj;
        return this.state == other.state || this.state != null && this.state.equals(other.state);
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + (this.state != null ? this.state.hashCode() : 0);
        return hash;
    }

    private static class State
    implements Configurable<State>,
    ExtendedConfig {
        private static final StateChangeStrategy IDENTITY = new StateChangeStrategy(){

            @Override
            public State onChange(State state) {
                return state;
            }
        };
        private static final StateChangeStrategy COPY_ON_CHANGE = new StateChangeStrategy(){

            @Override
            public State onChange(State state) {
                return state.copy();
            }
        };
        private volatile StateChangeStrategy strategy;
        private final CommonConfig commonConfig;
        private final JerseyClient client;
        private volatile ConnectorProvider connectorProvider;
        private final LazyValue<ClientRuntime> runtime = Values.lazy((Value)new Value<ClientRuntime>(this){
            final /* synthetic */ State this$0;
            {
                this.this$0 = this$0;
            }

            public ClientRuntime get() {
                return this.this$0.initRuntime();
            }
        });

        State(JerseyClient client) {
            this.strategy = IDENTITY;
            this.commonConfig = new CommonConfig(RuntimeType.CLIENT, ComponentBag.EXCLUDE_EMPTY);
            this.client = client;
            Iterator iterator = ServiceFinder.find(ConnectorProvider.class).iterator();
            this.connectorProvider = iterator.hasNext() ? (ConnectorProvider)iterator.next() : new HttpUrlConnectorProvider();
        }

        private State(JerseyClient client, State original) {
            this.strategy = IDENTITY;
            this.client = client;
            this.commonConfig = new CommonConfig(original.commonConfig);
            this.connectorProvider = original.connectorProvider;
        }

        State copy() {
            return new State(this.client, this);
        }

        State copy(JerseyClient client) {
            return new State(client, this);
        }

        void markAsShared() {
            this.strategy = COPY_ON_CHANGE;
        }

        State preInitialize() {
            State state = this.strategy.onChange(this);
            state.strategy = COPY_ON_CHANGE;
            ((ClientRuntime)state.runtime.get()).preInitialize();
            return state;
        }

        public State property(String name, Object value) {
            State state = this.strategy.onChange(this);
            state.commonConfig.property(name, value);
            return state;
        }

        public State loadFrom(Configuration config) {
            State state = this.strategy.onChange(this);
            state.commonConfig.loadFrom(config);
            return state;
        }

        public State register(Class<?> providerClass) {
            State state = this.strategy.onChange(this);
            state.commonConfig.register(providerClass);
            return state;
        }

        public State register(Object provider) {
            State state = this.strategy.onChange(this);
            state.commonConfig.register(provider);
            return state;
        }

        public State register(Class<?> providerClass, int bindingPriority) {
            State state = this.strategy.onChange(this);
            state.commonConfig.register(providerClass, bindingPriority);
            return state;
        }

        public State register(Class<?> providerClass, Class<?> ... contracts) {
            State state = this.strategy.onChange(this);
            state.commonConfig.register(providerClass, (Class[])contracts);
            return state;
        }

        public State register(Class<?> providerClass, Map<Class<?>, Integer> contracts) {
            State state = this.strategy.onChange(this);
            state.commonConfig.register(providerClass, contracts);
            return state;
        }

        public State register(Object provider, int bindingPriority) {
            State state = this.strategy.onChange(this);
            state.commonConfig.register(provider, bindingPriority);
            return state;
        }

        public State register(Object provider, Class<?> ... contracts) {
            State state = this.strategy.onChange(this);
            state.commonConfig.register(provider, (Class[])contracts);
            return state;
        }

        public State register(Object provider, Map<Class<?>, Integer> contracts) {
            State state = this.strategy.onChange(this);
            state.commonConfig.register(provider, contracts);
            return state;
        }

        State connectorProvider(ConnectorProvider provider) {
            if (provider == null) {
                throw new NullPointerException(LocalizationMessages.NULL_CONNECTOR_PROVIDER());
            }
            State state = this.strategy.onChange(this);
            state.connectorProvider = provider;
            return state;
        }

        Connector getConnector() {
            return this.runtime.isInitialized() ? ((ClientRuntime)this.runtime.get()).getConnector() : null;
        }

        ConnectorProvider getConnectorProvider() {
            return this.connectorProvider;
        }

        JerseyClient getClient() {
            return this.client;
        }

        public State getConfiguration() {
            return this;
        }

        public RuntimeType getRuntimeType() {
            return this.commonConfig.getConfiguration().getRuntimeType();
        }

        public Map<String, Object> getProperties() {
            return this.commonConfig.getConfiguration().getProperties();
        }

        public Object getProperty(String name) {
            return this.commonConfig.getConfiguration().getProperty(name);
        }

        public Collection<String> getPropertyNames() {
            return this.commonConfig.getConfiguration().getPropertyNames();
        }

        public boolean isProperty(String name) {
            return this.commonConfig.getConfiguration().isProperty(name);
        }

        public boolean isEnabled(Feature feature) {
            return this.commonConfig.getConfiguration().isEnabled(feature);
        }

        public boolean isEnabled(Class<? extends Feature> featureClass) {
            return this.commonConfig.getConfiguration().isEnabled(featureClass);
        }

        public boolean isRegistered(Object component) {
            return this.commonConfig.getConfiguration().isRegistered(component);
        }

        public boolean isRegistered(Class<?> componentClass) {
            return this.commonConfig.getConfiguration().isRegistered(componentClass);
        }

        public Map<Class<?>, Integer> getContracts(Class<?> componentClass) {
            return this.commonConfig.getConfiguration().getContracts(componentClass);
        }

        public Set<Class<?>> getClasses() {
            return this.commonConfig.getConfiguration().getClasses();
        }

        public Set<Object> getInstances() {
            return this.commonConfig.getConfiguration().getInstances();
        }

        public void configureAutoDiscoverableProviders(ServiceLocator locator) {
            this.commonConfig.configureAutoDiscoverableProviders(locator, false);
        }

        public void configureForcedAutoDiscoverableProviders(ServiceLocator locator) {
            this.commonConfig.configureAutoDiscoverableProviders(locator, true);
        }

        public void configureMetaProviders(ServiceLocator locator) {
            this.commonConfig.configureMetaProviders(locator);
        }

        public ComponentBag getComponentBag() {
            return this.commonConfig.getComponentBag();
        }

        private ClientRuntime initRuntime() {
            this.markAsShared();
            final State runtimeCfgState = this.copy();
            runtimeCfgState.markAsShared();
            ServiceLocator locator = Injections.createLocator((Binder[])new Binder[]{new ClientBinder(runtimeCfgState.getProperties())});
            locator.setDefaultClassAnalyzerName("JerseyClassAnalyzer");
            if (!((Boolean)CommonProperties.getValue(runtimeCfgState.getProperties(), (RuntimeType)RuntimeType.CLIENT, (String)"jersey.config.disableAutoDiscovery", (Object)Boolean.FALSE, Boolean.class)).booleanValue()) {
                runtimeCfgState.configureAutoDiscoverableProviders(locator);
            } else {
                runtimeCfgState.configureForcedAutoDiscoverableProviders(locator);
            }
            runtimeCfgState.configureMetaProviders(locator);
            AbstractBinder configBinder = new AbstractBinder(){

                protected void configure() {
                    this.bind(runtimeCfgState).to(Configuration.class);
                }
            };
            DynamicConfiguration dc = Injections.getConfiguration((ServiceLocator)locator);
            configBinder.bind(dc);
            dc.commit();
            ProviderBinder.bindProviders((ComponentBag)runtimeCfgState.getComponentBag(), (RuntimeType)RuntimeType.CLIENT, null, (ServiceLocator)locator);
            ExecutorProviders.createInjectionBindings((ServiceLocator)locator);
            ClientConfig configuration = new ClientConfig(runtimeCfgState);
            Connector connector = this.connectorProvider.getConnector(this.client, (Configuration)configuration);
            ClientRuntime crt = new ClientRuntime(configuration, connector, locator);
            this.client.registerShutdownHook(crt);
            return crt;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            State state = (State)o;
            if (this.client != null ? !this.client.equals(state.client) : state.client != null) {
                return false;
            }
            if (!this.commonConfig.equals((Object)state.commonConfig)) {
                return false;
            }
            return this.connectorProvider == null ? state.connectorProvider == null : this.connectorProvider.equals(state.connectorProvider);
        }

        public int hashCode() {
            int result = this.commonConfig.hashCode();
            result = 31 * result + (this.client != null ? this.client.hashCode() : 0);
            result = 31 * result + (this.connectorProvider != null ? this.connectorProvider.hashCode() : 0);
            return result;
        }

        private static interface StateChangeStrategy {
            public State onChange(State var1);
        }
    }
}

