/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.compute.options;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.net.InternetDomainName;
import java.util.List;
import java.util.Map;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.scriptbuilder.domain.Statement;

public class SoftLayerTemplateOptions
extends TemplateOptions
implements Cloneable {
    protected String domainName = "jclouds.org";
    protected List<Integer> blockDevices = ImmutableList.of();
    protected String diskType;
    protected Integer portSpeed;
    protected String userData;
    protected Integer primaryNetworkComponentNetworkVlanId;
    protected Integer primaryBackendNetworkComponentNetworkVlanId;
    protected Boolean hourlyBillingFlag;
    protected Boolean dedicatedAccountHostOnlyFlag;
    protected Boolean privateNetworkOnlyFlag;
    protected String postInstallScriptUri;
    protected List<Integer> sshKeys = ImmutableList.of();

    public SoftLayerTemplateOptions clone() {
        SoftLayerTemplateOptions options = new SoftLayerTemplateOptions();
        this.copyTo(options);
        return options;
    }

    public void copyTo(TemplateOptions to) {
        super.copyTo(to);
        if (to instanceof SoftLayerTemplateOptions) {
            SoftLayerTemplateOptions eTo = (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(to);
            eTo.domainName(this.domainName);
            if (!this.blockDevices.isEmpty()) {
                eTo.blockDevices(this.blockDevices);
            }
            eTo.diskType(this.diskType);
            eTo.portSpeed(this.portSpeed);
            eTo.userData(this.userData);
            eTo.primaryNetworkComponentNetworkVlanId(this.primaryNetworkComponentNetworkVlanId);
            eTo.primaryBackendNetworkComponentNetworkVlanId(this.primaryBackendNetworkComponentNetworkVlanId);
            eTo.hourlyBillingFlag(this.hourlyBillingFlag);
            eTo.dedicatedAccountHostOnlyFlag(this.dedicatedAccountHostOnlyFlag);
            eTo.privateNetworkOnlyFlag(this.privateNetworkOnlyFlag);
            if (!this.sshKeys.isEmpty()) {
                eTo.sshKeys(this.sshKeys);
            }
        }
    }

    public SoftLayerTemplateOptions domainName(String domainName) {
        Preconditions.checkNotNull((Object)domainName, (Object)"domainName was null");
        Preconditions.checkArgument((boolean)InternetDomainName.from((String)domainName).hasPublicSuffix(), (String)"domainName %s has no public suffix", (Object)domainName);
        this.domainName = domainName;
        return this;
    }

    public SoftLayerTemplateOptions blockDevices(Iterable<Integer> capacities) {
        for (Integer capacity : (Iterable)Preconditions.checkNotNull(capacities, (Object)"capacities")) {
            Preconditions.checkNotNull((Object)capacity, (Object)"all block devices must be non-empty");
        }
        this.blockDevices = ImmutableList.copyOf(capacities);
        return this;
    }

    public SoftLayerTemplateOptions blockDevices(Integer ... capacities) {
        return this.blockDevices((Iterable<Integer>)ImmutableList.copyOf((Object[])((Object[])Preconditions.checkNotNull((Object)capacities, (Object)"capacities"))));
    }

    public SoftLayerTemplateOptions diskType(@Nullable String diskType) {
        this.diskType = diskType;
        return this;
    }

    public SoftLayerTemplateOptions portSpeed(@Nullable Integer portSpeed) {
        this.portSpeed = portSpeed;
        return this;
    }

    public SoftLayerTemplateOptions userData(@Nullable String userData) {
        this.userData = userData;
        return this;
    }

    public SoftLayerTemplateOptions primaryNetworkComponentNetworkVlanId(@Nullable Integer primaryNetworkComponentNetworkVlanId) {
        this.primaryNetworkComponentNetworkVlanId = primaryNetworkComponentNetworkVlanId;
        return this;
    }

    public SoftLayerTemplateOptions primaryBackendNetworkComponentNetworkVlanId(@Nullable Integer primaryBackendNetworkComponentNetworkVlanId) {
        this.primaryBackendNetworkComponentNetworkVlanId = primaryBackendNetworkComponentNetworkVlanId;
        return this;
    }

    public SoftLayerTemplateOptions hourlyBillingFlag(@Nullable Boolean hourlyBillingFlag) {
        this.hourlyBillingFlag = hourlyBillingFlag;
        return this;
    }

    public SoftLayerTemplateOptions dedicatedAccountHostOnlyFlag(@Nullable Boolean dedicatedAccountHostOnlyFlag) {
        this.dedicatedAccountHostOnlyFlag = dedicatedAccountHostOnlyFlag;
        return this;
    }

    public SoftLayerTemplateOptions privateNetworkOnlyFlag(@Nullable Boolean privateNetworkOnlyFlag) {
        this.privateNetworkOnlyFlag = privateNetworkOnlyFlag;
        return this;
    }

    public SoftLayerTemplateOptions postInstallScriptUri(@Nullable String postInstallScriptUri) {
        this.postInstallScriptUri = postInstallScriptUri;
        return this;
    }

    public SoftLayerTemplateOptions sshKeys(Iterable<Integer> sshKeys) {
        for (Integer sshKey : (Iterable)Preconditions.checkNotNull(sshKeys, (Object)"sshKeys")) {
            Preconditions.checkNotNull((Object)sshKey, (Object)"sshKeys must be non-empty");
        }
        this.sshKeys = ImmutableList.copyOf(sshKeys);
        return this;
    }

    public SoftLayerTemplateOptions sshKeys(Integer ... sshKeys) {
        return this.sshKeys((Iterable<Integer>)ImmutableList.copyOf((Object[])((Object[])Preconditions.checkNotNull((Object)sshKeys, (Object)"sshKeys"))));
    }

    public String getDomainName() {
        return this.domainName;
    }

    public List<Integer> getBlockDevices() {
        return this.blockDevices;
    }

    public String getDiskType() {
        return this.diskType;
    }

    public Integer getPortSpeed() {
        return this.portSpeed;
    }

    public String getUserData() {
        return this.userData;
    }

    public Integer getPrimaryNetworkComponentNetworkVlanId() {
        return this.primaryNetworkComponentNetworkVlanId;
    }

    public Integer getPrimaryBackendNetworkComponentNetworkVlanId() {
        return this.primaryBackendNetworkComponentNetworkVlanId;
    }

    public Boolean isHourlyBillingFlag() {
        return this.hourlyBillingFlag;
    }

    public Boolean isDedicatedAccountHostOnlyFlag() {
        return this.dedicatedAccountHostOnlyFlag;
    }

    public Boolean isPrivateNetworkOnlyFlag() {
        return this.privateNetworkOnlyFlag;
    }

    public String getPostInstallScriptUri() {
        return this.postInstallScriptUri;
    }

    public List<Integer> getSshKeys() {
        return this.sshKeys;
    }

    public SoftLayerTemplateOptions blockOnPort(int port, int seconds) {
        return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(super.blockOnPort(port, seconds));
    }

    public SoftLayerTemplateOptions inboundPorts(int ... ports) {
        return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(super.inboundPorts(ports));
    }

    public SoftLayerTemplateOptions authorizePublicKey(String publicKey) {
        return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(super.authorizePublicKey(publicKey));
    }

    public SoftLayerTemplateOptions installPrivateKey(String privateKey) {
        return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(super.installPrivateKey(privateKey));
    }

    public SoftLayerTemplateOptions blockUntilRunning(boolean blockUntilRunning) {
        return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(super.blockUntilRunning(blockUntilRunning));
    }

    public SoftLayerTemplateOptions dontAuthorizePublicKey() {
        return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(super.dontAuthorizePublicKey());
    }

    public SoftLayerTemplateOptions nameTask(String name) {
        return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(super.nameTask(name));
    }

    public SoftLayerTemplateOptions runAsRoot(boolean runAsRoot) {
        return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(super.runAsRoot(runAsRoot));
    }

    public SoftLayerTemplateOptions runScript(Statement script) {
        return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(super.runScript(script));
    }

    public SoftLayerTemplateOptions overrideLoginCredentials(LoginCredentials overridingCredentials) {
        return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(super.overrideLoginCredentials(overridingCredentials));
    }

    public SoftLayerTemplateOptions overrideLoginPassword(String password) {
        return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(super.overrideLoginPassword(password));
    }

    public SoftLayerTemplateOptions overrideLoginPrivateKey(String privateKey) {
        return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(super.overrideLoginPrivateKey(privateKey));
    }

    public SoftLayerTemplateOptions overrideLoginUser(String loginUser) {
        return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(super.overrideLoginUser(loginUser));
    }

    public SoftLayerTemplateOptions overrideAuthenticateSudo(boolean authenticateSudo) {
        return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(super.overrideAuthenticateSudo(authenticateSudo));
    }

    public SoftLayerTemplateOptions userMetadata(Map<String, String> userMetadata) {
        return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(super.userMetadata(userMetadata));
    }

    public SoftLayerTemplateOptions userMetadata(String key, String value) {
        return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(super.userMetadata(key, value));
    }

    public SoftLayerTemplateOptions nodeNames(Iterable<String> nodeNames) {
        return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(super.nodeNames(nodeNames));
    }

    public SoftLayerTemplateOptions networks(Iterable<String> networks) {
        return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(super.networks(networks));
    }

    public static class Builder {
        public static SoftLayerTemplateOptions domainName(String domainName) {
            SoftLayerTemplateOptions options = new SoftLayerTemplateOptions();
            return options.domainName(domainName);
        }

        public static SoftLayerTemplateOptions blockDevices(Integer ... capacities) {
            SoftLayerTemplateOptions options = new SoftLayerTemplateOptions();
            return options.blockDevices(capacities);
        }

        public static SoftLayerTemplateOptions blockDevices(Iterable<Integer> capacities) {
            SoftLayerTemplateOptions options = new SoftLayerTemplateOptions();
            return options.blockDevices(capacities);
        }

        public static SoftLayerTemplateOptions diskType(String diskType) {
            SoftLayerTemplateOptions options = new SoftLayerTemplateOptions();
            return options.diskType(diskType);
        }

        public static SoftLayerTemplateOptions portSpeed(Integer portSpeed) {
            SoftLayerTemplateOptions options = new SoftLayerTemplateOptions();
            return options.portSpeed(portSpeed);
        }

        public static SoftLayerTemplateOptions userData(String userData) {
            SoftLayerTemplateOptions options = new SoftLayerTemplateOptions();
            return options.userData(userData);
        }

        public static SoftLayerTemplateOptions primaryNetworkComponentNetworkVlanId(Integer primaryNetworkComponentNetworkVlanId) {
            SoftLayerTemplateOptions options = new SoftLayerTemplateOptions();
            return options.primaryNetworkComponentNetworkVlanId(primaryNetworkComponentNetworkVlanId);
        }

        public static SoftLayerTemplateOptions primaryBackendNetworkComponentNetworkVlanId(Integer primaryBackendNetworkComponentNetworkVlanId) {
            SoftLayerTemplateOptions options = new SoftLayerTemplateOptions();
            return options.primaryBackendNetworkComponentNetworkVlanId(primaryBackendNetworkComponentNetworkVlanId);
        }

        public static SoftLayerTemplateOptions hourlyBillingFlag(boolean hourlyBillingFlag) {
            SoftLayerTemplateOptions options = new SoftLayerTemplateOptions();
            return options.hourlyBillingFlag(hourlyBillingFlag);
        }

        public static SoftLayerTemplateOptions dedicatedAccountHostOnlyFlag(boolean dedicatedAccountHostOnlyFlag) {
            SoftLayerTemplateOptions options = new SoftLayerTemplateOptions();
            return options.dedicatedAccountHostOnlyFlag(dedicatedAccountHostOnlyFlag);
        }

        public static SoftLayerTemplateOptions privateNetworkOnlyFlag(boolean privateNetworkOnlyFlag) {
            SoftLayerTemplateOptions options = new SoftLayerTemplateOptions();
            return options.privateNetworkOnlyFlag(privateNetworkOnlyFlag);
        }

        public static SoftLayerTemplateOptions postInstallScriptUri(String postInstallScriptUri) {
            SoftLayerTemplateOptions options = new SoftLayerTemplateOptions();
            return options.postInstallScriptUri(postInstallScriptUri);
        }

        public static SoftLayerTemplateOptions sshKeys(Integer ... sshKeys) {
            SoftLayerTemplateOptions options = new SoftLayerTemplateOptions();
            return options.sshKeys(sshKeys);
        }

        public static SoftLayerTemplateOptions sshKeys(Iterable<Integer> sshKeys) {
            SoftLayerTemplateOptions options = new SoftLayerTemplateOptions();
            return options.blockDevices(sshKeys);
        }

        public static SoftLayerTemplateOptions inboundPorts(int ... ports) {
            SoftLayerTemplateOptions options = new SoftLayerTemplateOptions();
            return options.inboundPorts(ports);
        }

        public static SoftLayerTemplateOptions blockOnPort(int port, int seconds) {
            SoftLayerTemplateOptions options = new SoftLayerTemplateOptions();
            return options.blockOnPort(port, seconds);
        }

        public static SoftLayerTemplateOptions installPrivateKey(String rsaKey) {
            SoftLayerTemplateOptions options = new SoftLayerTemplateOptions();
            return options.installPrivateKey(rsaKey);
        }

        public static SoftLayerTemplateOptions authorizePublicKey(String rsaKey) {
            SoftLayerTemplateOptions options = new SoftLayerTemplateOptions();
            return options.authorizePublicKey(rsaKey);
        }

        public static SoftLayerTemplateOptions userMetadata(Map<String, String> userMetadata) {
            SoftLayerTemplateOptions options = new SoftLayerTemplateOptions();
            return options.userMetadata((Map)userMetadata);
        }

        public static SoftLayerTemplateOptions nodeNames(Iterable<String> nodeNames) {
            SoftLayerTemplateOptions options = new SoftLayerTemplateOptions();
            return options.nodeNames((Iterable)nodeNames);
        }

        public static SoftLayerTemplateOptions networks(Iterable<String> networks) {
            SoftLayerTemplateOptions options = new SoftLayerTemplateOptions();
            return options.networks((Iterable)networks);
        }

        public static SoftLayerTemplateOptions overrideLoginUser(String user) {
            SoftLayerTemplateOptions options = new SoftLayerTemplateOptions();
            return options.overrideLoginUser(user);
        }

        public static SoftLayerTemplateOptions overrideLoginPassword(String password) {
            SoftLayerTemplateOptions options = new SoftLayerTemplateOptions();
            return options.overrideLoginPassword(password);
        }

        public static SoftLayerTemplateOptions overrideLoginPrivateKey(String privateKey) {
            SoftLayerTemplateOptions options = new SoftLayerTemplateOptions();
            return options.overrideLoginPrivateKey(privateKey);
        }

        public static SoftLayerTemplateOptions overrideAuthenticateSudo(boolean authenticateSudo) {
            SoftLayerTemplateOptions options = new SoftLayerTemplateOptions();
            return options.overrideAuthenticateSudo(authenticateSudo);
        }

        public static SoftLayerTemplateOptions overrideLoginCredentials(LoginCredentials credentials) {
            SoftLayerTemplateOptions options = new SoftLayerTemplateOptions();
            return options.overrideLoginCredentials(credentials);
        }

        public static SoftLayerTemplateOptions blockUntilRunning(boolean blockUntilRunning) {
            SoftLayerTemplateOptions options = new SoftLayerTemplateOptions();
            return options.blockUntilRunning(blockUntilRunning);
        }
    }
}

