/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Date;
import org.jclouds.ultradns.ws.domain.ResourceRecord;

public class ResourceRecordDetail {
    private final String zoneId;
    private final String guid;
    private final String zoneName;
    private final Date created;
    private final Date modified;
    private final ResourceRecord record;

    private ResourceRecordDetail(String zoneId, String guid, String zoneName, Date created, Date modified, ResourceRecord record) {
        this.zoneId = (String)Preconditions.checkNotNull((Object)zoneId, (Object)"zoneId");
        this.guid = (String)Preconditions.checkNotNull((Object)guid, (Object)"guid");
        this.zoneName = (String)Preconditions.checkNotNull((Object)zoneName, (String)"zoneName of %s/%s", (Object)zoneId, (Object)guid);
        this.created = (Date)Preconditions.checkNotNull((Object)created, (String)"created of %s/%s", (Object)zoneId, (Object)guid);
        this.modified = (Date)Preconditions.checkNotNull((Object)modified, (String)"modified of %s/%s", (Object)zoneId, (Object)guid);
        this.record = (ResourceRecord)Preconditions.checkNotNull((Object)record, (String)"record of %s/%s", (Object)zoneId, (Object)guid);
    }

    public String getZoneId() {
        return this.zoneId;
    }

    public String getGuid() {
        return this.guid;
    }

    public String getZoneName() {
        return this.zoneName;
    }

    public Date getCreated() {
        return this.created;
    }

    public Date getModified() {
        return this.modified;
    }

    public ResourceRecord getRecord() {
        return this.record;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.zoneId, this.guid});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceRecordDetail that = (ResourceRecordDetail)ResourceRecordDetail.class.cast(obj);
        return Objects.equal((Object)this.zoneId, (Object)that.zoneId) && Objects.equal((Object)this.guid, (Object)that.guid);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("zoneId", (Object)this.zoneId).add("guid", (Object)this.guid).add("zoneName", (Object)this.zoneName).add("created", (Object)this.created).add("modified", (Object)this.modified).add("record", (Object)this.record).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return ResourceRecordDetail.builder().from(this);
    }

    public static final class Builder {
        private String zoneId;
        private String guid;
        private String zoneName;
        private Date created;
        private Date modified;
        private ResourceRecord record;

        public Builder zoneName(String zoneName) {
            this.zoneName = zoneName;
            return this;
        }

        public Builder guid(String guid) {
            this.guid = guid;
            return this;
        }

        public Builder zoneId(String zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        public Builder created(Date created) {
            this.created = created;
            return this;
        }

        public Builder modified(Date modified) {
            this.modified = modified;
            return this;
        }

        public Builder record(ResourceRecord record) {
            this.record = record;
            return this;
        }

        public Builder record(ResourceRecord.Builder record) {
            this.record = record.build();
            return this;
        }

        public ResourceRecordDetail build() {
            return new ResourceRecordDetail(this.zoneId, this.guid, this.zoneName, this.created, this.modified, this.record);
        }

        public Builder from(ResourceRecordDetail in) {
            return this.zoneName(in.zoneName).guid(in.guid).zoneId(in.zoneId).created(in.created).modified(in.modified).record(in.record);
        }
    }
}

