/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.domain;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;

public final class IdAndName {
    private final String id;
    private final String name;

    public static IdAndName create(String id, String name) {
        return new IdAndName(id, name);
    }

    private IdAndName(String id, String name) {
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.name = (String)Preconditions.checkNotNull((Object)name, (String)"name for %s", (Object)id);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.name});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IdAndName that = (IdAndName)IdAndName.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.name, (Object)that.name);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"").add("id", (Object)this.id).add("name", (Object)this.name).toString();
    }

    public static Predicate<IdAndName> nameEqualTo(String name) {
        return Predicates.compose((Predicate)Predicates.equalTo((Object)name), (Function)ToName.INSTANCE);
    }

    private static enum ToName implements Function<IdAndName, String>
    {
        INSTANCE;


        public String apply(IdAndName input) {
            return input.getName();
        }
    }
}

