# Create log file with timestamp in a persistent location
LOG_DIR="/var/log/parablu"
LOG_FILE="$LOG_DIR/parablu_script_$(date +%Y%m%d_%H%M%S).log"

# Create log directory if it doesn't exist
mkdir -p "$LOG_DIR" 2>/dev/null || {
    # Fallback to /var/log if we can't create /var/log/parablu
    LOG_FILE="/var/log/parablu_script_$(date +%Y%m%d_%H%M%S).log"
}

echo "Script execution started. Detailed logs will be written to: $LOG_FILE"

# Function to log commands while keeping echo visible
log_exec() {
    echo "[$(/bin/date '+%Y-%m-%d %H:%M:%S')] $*" >> "$LOG_FILE" 2>&1
    "$@" >> "$LOG_FILE" 2>&1
}

PARABLU_COMPONENT_SCRIPT_PATH=../../config/parablu_component_config.sh
PARABLU_CONFIG_SCRIPT_PATH=../../config/parablu_config.sh

source $PARABLU_COMPONENT_SCRIPT_PATH
source $PARABLU_CONFIG_SCRIPT_PATH

if [ "$SERVER_TYPE" == "0" ] || [ "$SERVER_TYPE" == "1 2" ] || [ "$SERVER_TYPE" == "3 1" ]; then
        FILE2=Portal_V2.zip
        if [ -f "$FILE2" ]; then
                rm -rf /var/www/portal/*
                cp -r Portal_V2.zip /var/www/portal/
                cd /var/www/portal/
                        ##new portal extraction
                        unzip -oqq Portal_V2.zip
                        rm -rf Portal_V2.zip
                        chmod -R 755 *
                        chown -R www-data:www-data *
                cd -

                        ##newportal config.json changes
                        sed -i "s|devangular|$NG_IP|"  /var/www/portal/assets/config.json
                        sed -i "s|multicloud|$CLOUD_NAME|"  /var/www/portal/assets/config.json
                        sed -i "s|pbengg-redirect.parablu.com|$NG_RL|" /var/www/portal/assets/config.json
                        sed -i "s|mycloud.parablu.com|$BLUVAULT_IP|" /var/www/portal/assets/config.json

                        ##new portal index.html changes
                        sed -i '6s|<base href="/">|<base href="/devangular/portal/">|' /var/www/portal/index.html
                        sed -i "s|devangular|$NG_IP|" /var/www/portal/index.html

			##old .htacess
			sed -i "s|HOST|$NG_IP|"  indexnew.html
                	cp -rp  indexnew.html index.html
                	cp -rp index.html /var/www/

        fi
fi

if [ "$SERVER_TYPE" == "0" ] || [ "$SERVER_TYPE" == "1 2" ] || [ "$SERVER_TYPE" == "3 1" ]; then

         ##new portal .htaccess
                        cp -rp  htaccessnginix .htaccess
                        chown -R  www-data:www-data .htaccess
                        cp -rp .htaccess /var/www/portal/
fi

if [ "$SERVER_TYPE" == "0" ] || [ "$SERVER_TYPE" == "3" ] || [ "$SERVER_TYPE" == "3 1" ]; then

        chown -R tomcat:parablu Users.xlsx
        cp -rp Users.xlsx /parablu/bkpOverview/

        chown -R tomcat:parablu bulkCreateUsers.xlsx
        cp -rp bulkCreateUsers.xlsx /parablu/bkpOverview/

        chown -R tomcat:parablu  bulkBlockUnblockDeleteAssets.xlsx
        cp -rp bulkBlockUnblockDeleteAssets.xlsx /parablu/bkpOverview/

        chown -R tomcat:parablu bulkBlockUnblockDeleteUsers.xlsx
        cp -rp bulkBlockUnblockDeleteUsers.xlsx /parablu/bkpOverview/

        chown -R tomcat:parablu bulkBlockUnblockDeleteUsersAdvanced.xlsx
        cp -rp bulkBlockUnblockDeleteUsersAdvanced.xlsx /parablu/bkpOverview/

	chown -R tomcat:parablu  bulkBackupTargetMapping.xlsx
        cp -rp bulkBackupTargetMapping.xlsx /parablu/bkpOverview/

fi

if [ "$SERVER_TYPE" == "0" ] || [ "$SERVER_TYPE" == "1 2" ] || [ "$SERVER_TYPE" == "3 1" ]; then

        cp -r /var/lib/tomcat-pcb1/webapps/paracloud/WEB-INF/classes/pb-cloudproperty.properties /var/lib/tomcat-pcb1/webapps/paralite/WEB-INF/classes/
        cp -r /var/lib/tomcat-pcb1/webapps/paracloud/WEB-INF/classes/pb-credential.properties /var/lib/tomcat-pcb1/webapps/paralite/WEB-INF/classes/
        service tomcat-pcb1 stop && service tomcat-job1 stop
        sleep 2s
        cd /var/lib/tomcat-pcb1/webapps/
        rm -rf paralite.war
        sleep 1s
        cd -
        sleep 2s
        service tomcat-pcb1 restart && service tomcat-job1 restart
fi

if [ "$SERVER_TYPE" == "0" ] || [ "$SERVER_TYPE" == "3" ] || [ "$SERVER_TYPE" == "3 1" ]; then
    # Get MongoDB port in one step
    dbport=$(grep port: /etc/mongod.conf)
    MONGODB_PORT=$(echo $dbport | sed -e 's/port://' | sed 's/"//g' | tr -d ' ')

    echo "Applying MongoDB updates..."

    # Single heredoc for all updates
    mongo --quiet localhost:"$MONGODB_PORT" -u "neil" -p "parablu" --authenticationDatabase "admin" << 'EOF'
use parablu001
db.PRIVACY_GATEWAY.updateMany({}, { $set: { "componentsProperties.numOfThreadsToUseForContentChunkFile": "50" } })
db.JOB_CONFIG.updateMany({}, { $set: { "job.autoDeviceBlockerTimerTrigger": true } })

use parablu
db.CLOUD_PROPERTIES.updateMany({}, { $set: { "allowAgentUpdateWithoutDeviceUUID": true } })
EOF

    echo "All MongoDB updates applied successfully."
fi

# 05-09-2025: Delete the below .jar files
# List of JAR files to remove
JAR_FILES=(
    "google-api-client-1.22.0.jar"
    "google-http-client-1.22.0.jar"
    "google-oauth-client-1.22.0.jar"
    "google-http-client-jackson2-1.22.0.jar"
)

if [ "$SERVER_TYPE" == "0" ] || [ "$SERVER_TYPE" == "1 2" ] || [ "$SERVER_TYPE" == "3 1" ] || [ "$SERVER_TYPE" == "2" ]; then
    echo "Removing old JAR files..."
    echo "Stopping Tomcat services..."
    log_exec service tomcat-pcb1 stop
    log_exec service tomcat-job1 stop
    sleep 2s

    # Remove files from tomcat-pcb1 repo
    cd /var/lib/tomcat-pcb1/repo
    for jar_file in "${JAR_FILES[@]}"; do
        if [ -f "$jar_file" ]; then
            log_exec rm -f "$jar_file"
        fi
    done
    cd -

    sleep 1s

    # Remove files from tomcat-job1 repo
    cd /var/lib/tomcat-job1/repo
    for jar_file in "${JAR_FILES[@]}"; do
        if [ -f "$jar_file" ]; then
            log_exec rm -f "$jar_file"
        fi
    done
    cd -

    sleep 2s

    # 08-09-2025: Change all occurrences of MONGO PORT to 48765 in /var/lib/tomcat-pcb1/webapps/BluKryptBuilder/WEB-INF/classes/privacygateway.properties
    sed -i 's/=27017/=48765/g' /var/lib/tomcat-pcb1/webapps/BluKryptBuilder/WEB-INF/classes/privacygateway.properties

    echo "Starting Tomcat services..."
    log_exec service tomcat-pcb1 restart
    log_exec service tomcat-job1 restart
fi
