/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.geo;

import java.io.Closeable;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Locale;
import org.apache.lucene.analysis.MockAnalyzer;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.FilterCodec;
import org.apache.lucene.codecs.PointsFormat;
import org.apache.lucene.codecs.PointsReader;
import org.apache.lucene.codecs.PointsWriter;
import org.apache.lucene.codecs.lucene60.Lucene60PointsReader;
import org.apache.lucene.codecs.lucene60.Lucene60PointsWriter;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.geo.GeoTestUtil;
import org.apache.lucene.geo.Polygon;
import org.apache.lucene.geo.Rectangle;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.RandomIndexWriter;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.SerialMergeScheduler;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.SimpleCollector;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.store.BaseDirectoryWrapper;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.SloppyMath;
import org.apache.lucene.util.TestUtil;

public abstract class BaseGeoPointTestCase
extends LuceneTestCase {
    protected static final String FIELD_NAME = "point";

    protected double nextLongitude() {
        return GeoTestUtil.nextLongitude();
    }

    protected double nextLatitude() {
        return GeoTestUtil.nextLatitude();
    }

    protected Rectangle nextBox() {
        return GeoTestUtil.nextBox();
    }

    protected Polygon nextPolygon() {
        return GeoTestUtil.nextPolygon();
    }

    protected boolean supportsPolygons() {
        return true;
    }

    public void testIndexExtremeValues() {
        Document document = new Document();
        this.addPointToDoc("foo", document, 90.0, 180.0);
        this.addPointToDoc("foo", document, 90.0, -180.0);
        this.addPointToDoc("foo", document, -90.0, 180.0);
        this.addPointToDoc("foo", document, -90.0, -180.0);
    }

    public void testIndexOutOfRangeValues() {
        Document document = new Document();
        IllegalArgumentException expected = BaseGeoPointTestCase.expectThrows(IllegalArgumentException.class, () -> this.addPointToDoc("foo", document, Math.nextUp(90.0), 50.0));
        BaseGeoPointTestCase.assertTrue((boolean)expected.getMessage().contains("invalid latitude"));
        expected = BaseGeoPointTestCase.expectThrows(IllegalArgumentException.class, () -> this.addPointToDoc("foo", document, Math.nextDown(-90.0), 50.0));
        BaseGeoPointTestCase.assertTrue((boolean)expected.getMessage().contains("invalid latitude"));
        expected = BaseGeoPointTestCase.expectThrows(IllegalArgumentException.class, () -> this.addPointToDoc("foo", document, 90.0, Math.nextUp(180.0)));
        BaseGeoPointTestCase.assertTrue((boolean)expected.getMessage().contains("invalid longitude"));
        expected = BaseGeoPointTestCase.expectThrows(IllegalArgumentException.class, () -> this.addPointToDoc("foo", document, 90.0, Math.nextDown(-180.0)));
        BaseGeoPointTestCase.assertTrue((boolean)expected.getMessage().contains("invalid longitude"));
    }

    public void testIndexNaNValues() {
        Document document = new Document();
        IllegalArgumentException expected = BaseGeoPointTestCase.expectThrows(IllegalArgumentException.class, () -> this.addPointToDoc("foo", document, Double.NaN, 50.0));
        BaseGeoPointTestCase.assertTrue((boolean)expected.getMessage().contains("invalid latitude"));
        expected = BaseGeoPointTestCase.expectThrows(IllegalArgumentException.class, () -> this.addPointToDoc("foo", document, 50.0, Double.NaN));
        BaseGeoPointTestCase.assertTrue((boolean)expected.getMessage().contains("invalid longitude"));
    }

    public void testIndexInfValues() {
        Document document = new Document();
        IllegalArgumentException expected = BaseGeoPointTestCase.expectThrows(IllegalArgumentException.class, () -> this.addPointToDoc("foo", document, Double.POSITIVE_INFINITY, 50.0));
        BaseGeoPointTestCase.assertTrue((boolean)expected.getMessage().contains("invalid latitude"));
        expected = BaseGeoPointTestCase.expectThrows(IllegalArgumentException.class, () -> this.addPointToDoc("foo", document, Double.NEGATIVE_INFINITY, 50.0));
        BaseGeoPointTestCase.assertTrue((boolean)expected.getMessage().contains("invalid latitude"));
        expected = BaseGeoPointTestCase.expectThrows(IllegalArgumentException.class, () -> this.addPointToDoc("foo", document, 50.0, Double.POSITIVE_INFINITY));
        BaseGeoPointTestCase.assertTrue((boolean)expected.getMessage().contains("invalid longitude"));
        expected = BaseGeoPointTestCase.expectThrows(IllegalArgumentException.class, () -> this.addPointToDoc("foo", document, 50.0, Double.NEGATIVE_INFINITY));
        BaseGeoPointTestCase.assertTrue((boolean)expected.getMessage().contains("invalid longitude"));
    }

    public void testBoxBasics() throws Exception {
        BaseDirectoryWrapper dir = BaseGeoPointTestCase.newDirectory();
        RandomIndexWriter writer = new RandomIndexWriter(BaseGeoPointTestCase.random(), (Directory)dir);
        Document document = new Document();
        this.addPointToDoc("field", document, 18.313694, -65.227444);
        writer.addDocument(document);
        DirectoryReader reader = writer.getReader();
        IndexSearcher searcher = BaseGeoPointTestCase.newSearcher((IndexReader)reader);
        BaseGeoPointTestCase.assertEquals((long)1L, (long)searcher.count(this.newRectQuery("field", 18.0, 19.0, -66.0, -65.0)));
        reader.close();
        writer.close();
        dir.close();
    }

    public void testBoxNull() {
        IllegalArgumentException expected = BaseGeoPointTestCase.expectThrows(IllegalArgumentException.class, () -> this.newRectQuery(null, 18.0, 19.0, -66.0, -65.0));
        BaseGeoPointTestCase.assertTrue((boolean)expected.getMessage().contains("field must not be null"));
    }

    public void testBoxInvalidCoordinates() throws Exception {
        BaseGeoPointTestCase.expectThrows(Exception.class, () -> this.newRectQuery("field", -92.0, -91.0, 179.0, 181.0));
    }

    public void testDistanceBasics() throws Exception {
        BaseDirectoryWrapper dir = BaseGeoPointTestCase.newDirectory();
        RandomIndexWriter writer = new RandomIndexWriter(BaseGeoPointTestCase.random(), (Directory)dir);
        Document document = new Document();
        this.addPointToDoc("field", document, 18.313694, -65.227444);
        writer.addDocument(document);
        DirectoryReader reader = writer.getReader();
        IndexSearcher searcher = BaseGeoPointTestCase.newSearcher((IndexReader)reader);
        BaseGeoPointTestCase.assertEquals((long)1L, (long)searcher.count(this.newDistanceQuery("field", 18.0, -65.0, 50000.0)));
        reader.close();
        writer.close();
        dir.close();
    }

    public void testDistanceNull() {
        IllegalArgumentException expected = BaseGeoPointTestCase.expectThrows(IllegalArgumentException.class, () -> this.newDistanceQuery(null, 18.0, -65.0, 50000.0));
        BaseGeoPointTestCase.assertTrue((boolean)expected.getMessage().contains("field must not be null"));
    }

    public void testDistanceIllegal() throws Exception {
        BaseGeoPointTestCase.expectThrows(Exception.class, () -> this.newDistanceQuery("field", 92.0, 181.0, 120000.0));
    }

    public void testDistanceNegative() {
        IllegalArgumentException expected = BaseGeoPointTestCase.expectThrows(IllegalArgumentException.class, () -> this.newDistanceQuery("field", 18.0, 19.0, -1.0));
        BaseGeoPointTestCase.assertTrue((boolean)expected.getMessage().contains("radiusMeters"));
        BaseGeoPointTestCase.assertTrue((boolean)expected.getMessage().contains("invalid"));
    }

    public void testDistanceNaN() {
        IllegalArgumentException expected = BaseGeoPointTestCase.expectThrows(IllegalArgumentException.class, () -> this.newDistanceQuery("field", 18.0, 19.0, Double.NaN));
        BaseGeoPointTestCase.assertTrue((boolean)expected.getMessage().contains("radiusMeters"));
        BaseGeoPointTestCase.assertTrue((boolean)expected.getMessage().contains("invalid"));
    }

    public void testDistanceInf() {
        IllegalArgumentException expected = BaseGeoPointTestCase.expectThrows(IllegalArgumentException.class, () -> this.newDistanceQuery("field", 18.0, 19.0, Double.POSITIVE_INFINITY));
        BaseGeoPointTestCase.assertTrue((boolean)expected.getMessage().contains("radiusMeters"));
        BaseGeoPointTestCase.assertTrue((boolean)expected.getMessage().contains("invalid"));
        expected = BaseGeoPointTestCase.expectThrows(IllegalArgumentException.class, () -> this.newDistanceQuery("field", 18.0, 19.0, Double.NEGATIVE_INFINITY));
        BaseGeoPointTestCase.assertTrue((String)expected.getMessage(), (boolean)expected.getMessage().contains("radiusMeters"));
        BaseGeoPointTestCase.assertTrue((boolean)expected.getMessage().contains("invalid"));
    }

    public void testPolygonBasics() throws Exception {
        BaseGeoPointTestCase.assumeTrue("Impl does not support polygons", this.supportsPolygons());
        BaseDirectoryWrapper dir = BaseGeoPointTestCase.newDirectory();
        RandomIndexWriter writer = new RandomIndexWriter(BaseGeoPointTestCase.random(), (Directory)dir);
        Document document = new Document();
        this.addPointToDoc("field", document, 18.313694, -65.227444);
        writer.addDocument(document);
        DirectoryReader reader = writer.getReader();
        IndexSearcher searcher = BaseGeoPointTestCase.newSearcher((IndexReader)reader);
        BaseGeoPointTestCase.assertEquals((long)1L, (long)searcher.count(this.newPolygonQuery("field", new Polygon(new double[]{18.0, 18.0, 19.0, 19.0, 18.0}, new double[]{-66.0, -65.0, -65.0, -66.0, -66.0}, new Polygon[0]))));
        reader.close();
        writer.close();
        dir.close();
    }

    public void testPolygonHole() throws Exception {
        BaseGeoPointTestCase.assumeTrue("Impl does not support polygons", this.supportsPolygons());
        BaseDirectoryWrapper dir = BaseGeoPointTestCase.newDirectory();
        RandomIndexWriter writer = new RandomIndexWriter(BaseGeoPointTestCase.random(), (Directory)dir);
        Document document = new Document();
        this.addPointToDoc("field", document, 18.313694, -65.227444);
        writer.addDocument(document);
        DirectoryReader reader = writer.getReader();
        IndexSearcher searcher = BaseGeoPointTestCase.newSearcher((IndexReader)reader);
        Polygon inner = new Polygon(new double[]{18.5, 18.5, 18.7, 18.7, 18.5}, new double[]{-65.7, -65.4, -65.4, -65.7, -65.7}, new Polygon[0]);
        Polygon outer = new Polygon(new double[]{18.0, 18.0, 19.0, 19.0, 18.0}, new double[]{-66.0, -65.0, -65.0, -66.0, -66.0}, new Polygon[]{inner});
        BaseGeoPointTestCase.assertEquals((long)1L, (long)searcher.count(this.newPolygonQuery("field", outer)));
        reader.close();
        writer.close();
        dir.close();
    }

    public void testPolygonHoleExcludes() throws Exception {
        BaseGeoPointTestCase.assumeTrue("Impl does not support polygons", this.supportsPolygons());
        BaseDirectoryWrapper dir = BaseGeoPointTestCase.newDirectory();
        RandomIndexWriter writer = new RandomIndexWriter(BaseGeoPointTestCase.random(), (Directory)dir);
        Document document = new Document();
        this.addPointToDoc("field", document, 18.313694, -65.227444);
        writer.addDocument(document);
        DirectoryReader reader = writer.getReader();
        IndexSearcher searcher = BaseGeoPointTestCase.newSearcher((IndexReader)reader);
        Polygon inner = new Polygon(new double[]{18.2, 18.2, 18.4, 18.4, 18.2}, new double[]{-65.3, -65.2, -65.2, -65.3, -65.3}, new Polygon[0]);
        Polygon outer = new Polygon(new double[]{18.0, 18.0, 19.0, 19.0, 18.0}, new double[]{-66.0, -65.0, -65.0, -66.0, -66.0}, new Polygon[]{inner});
        BaseGeoPointTestCase.assertEquals((long)0L, (long)searcher.count(this.newPolygonQuery("field", outer)));
        reader.close();
        writer.close();
        dir.close();
    }

    public void testMultiPolygonBasics() throws Exception {
        BaseGeoPointTestCase.assumeTrue("Impl does not support polygons", this.supportsPolygons());
        BaseDirectoryWrapper dir = BaseGeoPointTestCase.newDirectory();
        RandomIndexWriter writer = new RandomIndexWriter(BaseGeoPointTestCase.random(), (Directory)dir);
        Document document = new Document();
        this.addPointToDoc("field", document, 18.313694, -65.227444);
        writer.addDocument(document);
        DirectoryReader reader = writer.getReader();
        IndexSearcher searcher = BaseGeoPointTestCase.newSearcher((IndexReader)reader);
        Polygon a = new Polygon(new double[]{28.0, 28.0, 29.0, 29.0, 28.0}, new double[]{-56.0, -55.0, -55.0, -56.0, -56.0}, new Polygon[0]);
        Polygon b = new Polygon(new double[]{18.0, 18.0, 19.0, 19.0, 18.0}, new double[]{-66.0, -65.0, -65.0, -66.0, -66.0}, new Polygon[0]);
        BaseGeoPointTestCase.assertEquals((long)1L, (long)searcher.count(this.newPolygonQuery("field", a, b)));
        reader.close();
        writer.close();
        dir.close();
    }

    public void testPolygonNullField() {
        BaseGeoPointTestCase.assumeTrue("Impl does not support polygons", this.supportsPolygons());
        IllegalArgumentException expected = BaseGeoPointTestCase.expectThrows(IllegalArgumentException.class, () -> this.newPolygonQuery(null, new Polygon(new double[]{18.0, 18.0, 19.0, 19.0, 18.0}, new double[]{-66.0, -65.0, -65.0, -66.0, -66.0}, new Polygon[0])));
        BaseGeoPointTestCase.assertTrue((boolean)expected.getMessage().contains("field must not be null"));
    }

    public void testSamePointManyTimes() throws Exception {
        int numPoints = BaseGeoPointTestCase.atLeast(1000);
        double theLat = this.nextLatitude();
        double theLon = this.nextLongitude();
        double[] lats = new double[numPoints];
        Arrays.fill(lats, theLat);
        double[] lons = new double[numPoints];
        Arrays.fill(lons, theLon);
        this.verify(lats, lons);
    }

    public void testAllLatEqual() throws Exception {
        int numPoints = BaseGeoPointTestCase.atLeast(10000);
        double lat = this.nextLatitude();
        double[] lats = new double[numPoints];
        double[] lons = new double[numPoints];
        boolean haveRealDoc = false;
        for (int docID = 0; docID < numPoints; ++docID) {
            int x = BaseGeoPointTestCase.random().nextInt(20);
            if (x == 17) {
                lats[docID] = Double.NaN;
                if (!VERBOSE) continue;
                System.out.println("  doc=" + docID + " is missing");
                continue;
            }
            if (docID > 0 && x == 14 && haveRealDoc) {
                int oldDocID;
                while (Double.isNaN(lats[oldDocID = BaseGeoPointTestCase.random().nextInt(docID)])) {
                }
                lons[docID] = lons[oldDocID];
                if (VERBOSE) {
                    System.out.println("  doc=" + docID + " lat=" + lat + " lon=" + lons[docID] + " (same lat/lon as doc=" + oldDocID + ")");
                }
            } else {
                lons[docID] = this.nextLongitude();
                haveRealDoc = true;
                if (VERBOSE) {
                    System.out.println("  doc=" + docID + " lat=" + lat + " lon=" + lons[docID]);
                }
            }
            lats[docID] = lat;
        }
        this.verify(lats, lons);
    }

    public void testAllLonEqual() throws Exception {
        int numPoints = BaseGeoPointTestCase.atLeast(10000);
        double theLon = this.nextLongitude();
        double[] lats = new double[numPoints];
        double[] lons = new double[numPoints];
        boolean haveRealDoc = false;
        for (int docID = 0; docID < numPoints; ++docID) {
            int x = BaseGeoPointTestCase.random().nextInt(20);
            if (x == 17) {
                lats[docID] = Double.NaN;
                if (!VERBOSE) continue;
                System.out.println("  doc=" + docID + " is missing");
                continue;
            }
            if (docID > 0 && x == 14 && haveRealDoc) {
                int oldDocID;
                while (Double.isNaN(lats[oldDocID = BaseGeoPointTestCase.random().nextInt(docID)])) {
                }
                lats[docID] = lats[oldDocID];
                if (VERBOSE) {
                    System.out.println("  doc=" + docID + " lat=" + lats[docID] + " lon=" + theLon + " (same lat/lon as doc=" + oldDocID + ")");
                }
            } else {
                lats[docID] = this.nextLatitude();
                haveRealDoc = true;
                if (VERBOSE) {
                    System.out.println("  doc=" + docID + " lat=" + lats[docID] + " lon=" + theLon);
                }
            }
            lons[docID] = theLon;
        }
        this.verify(lats, lons);
    }

    public void testMultiValued() throws Exception {
        int numPoints = BaseGeoPointTestCase.atLeast(10000);
        double[] lats = new double[2 * numPoints];
        double[] lons = new double[2 * numPoints];
        BaseDirectoryWrapper dir = BaseGeoPointTestCase.newDirectory();
        IndexWriterConfig iwc = BaseGeoPointTestCase.newIndexWriterConfig();
        iwc.setMergePolicy((MergePolicy)BaseGeoPointTestCase.newLogMergePolicy());
        iwc.setMergeScheduler((MergeScheduler)new SerialMergeScheduler());
        RandomIndexWriter w = new RandomIndexWriter(BaseGeoPointTestCase.random(), (Directory)dir, iwc);
        for (int id = 0; id < numPoints; ++id) {
            Document doc = new Document();
            lats[2 * id] = this.quantizeLat(this.nextLatitude());
            lons[2 * id] = this.quantizeLon(this.nextLongitude());
            doc.add((IndexableField)BaseGeoPointTestCase.newStringField("id", "" + id, Field.Store.YES));
            this.addPointToDoc(FIELD_NAME, doc, lats[2 * id], lons[2 * id]);
            lats[2 * id + 1] = this.quantizeLat(this.nextLatitude());
            lons[2 * id + 1] = this.quantizeLon(this.nextLongitude());
            this.addPointToDoc(FIELD_NAME, doc, lats[2 * id + 1], lons[2 * id + 1]);
            if (VERBOSE) {
                System.out.println("id=" + id);
                System.out.println("  lat=" + lats[2 * id] + " lon=" + lons[2 * id]);
                System.out.println("  lat=" + lats[2 * id + 1] + " lon=" + lons[2 * id + 1]);
            }
            w.addDocument(doc);
        }
        if (BaseGeoPointTestCase.random().nextBoolean()) {
            w.forceMerge(1);
        }
        DirectoryReader r = w.getReader();
        w.close();
        IndexSearcher s = BaseGeoPointTestCase.newSearcher((IndexReader)r);
        int iters = BaseGeoPointTestCase.atLeast(25);
        for (int iter = 0; iter < iters; ++iter) {
            Rectangle rect = this.nextBox();
            if (VERBOSE) {
                System.out.println("\nTEST: iter=" + iter + " rect=" + rect);
            }
            Query query = this.newRectQuery(FIELD_NAME, rect.minLat, rect.maxLat, rect.minLon, rect.maxLon);
            final FixedBitSet hits = new FixedBitSet(r.maxDoc());
            s.search(query, (Collector)new SimpleCollector(){
                private int docBase;

                public boolean needsScores() {
                    return false;
                }

                protected void doSetNextReader(LeafReaderContext context) throws IOException {
                    this.docBase = context.docBase;
                }

                public void collect(int doc) {
                    hits.set(this.docBase + doc);
                }
            });
            boolean fail = false;
            for (int docID = 0; docID < lats.length / 2; ++docID) {
                boolean expected;
                double latDoc1 = lats[2 * docID];
                double lonDoc1 = lons[2 * docID];
                double latDoc2 = lats[2 * docID + 1];
                double lonDoc2 = lons[2 * docID + 1];
                boolean result1 = BaseGeoPointTestCase.rectContainsPoint(rect, latDoc1, lonDoc1);
                boolean result2 = BaseGeoPointTestCase.rectContainsPoint(rect, latDoc2, lonDoc2);
                boolean bl = expected = result1 || result2;
                if (hits.get(docID) == expected) continue;
                String id = s.doc(docID).get("id");
                if (expected) {
                    System.out.println("TEST: id=" + id + " docID=" + docID + " should match but did not");
                } else {
                    System.out.println("TEST: id=" + id + " docID=" + docID + " should not match but did");
                }
                System.out.println("  rect=" + rect);
                System.out.println("  lat=" + latDoc1 + " lon=" + lonDoc1 + "\n  lat=" + latDoc2 + " lon=" + lonDoc2);
                System.out.println("  result1=" + result1 + " result2=" + result2);
                fail = true;
            }
            if (!fail) continue;
            BaseGeoPointTestCase.fail((String)"some hits were wrong");
        }
        r.close();
        dir.close();
    }

    public void testRandomTiny() throws Exception {
        this.doTestRandom(10);
    }

    public void testRandomMedium() throws Exception {
        this.doTestRandom(10000);
    }

    @LuceneTestCase.Nightly
    public void testRandomBig() throws Exception {
        BaseGeoPointTestCase.assumeFalse("Direct codec can OOME on this test", TestUtil.getDocValuesFormat(FIELD_NAME).equals("Direct"));
        BaseGeoPointTestCase.assumeFalse("Memory codec can OOME on this test", TestUtil.getDocValuesFormat(FIELD_NAME).equals("Memory"));
        this.doTestRandom(200000);
    }

    private void doTestRandom(int count) throws Exception {
        int numPoints = BaseGeoPointTestCase.atLeast(count);
        if (VERBOSE) {
            System.out.println("TEST: numPoints=" + numPoints);
        }
        double[] lats = new double[numPoints];
        double[] lons = new double[numPoints];
        boolean haveRealDoc = false;
        for (int id = 0; id < numPoints; ++id) {
            int x = BaseGeoPointTestCase.random().nextInt(20);
            if (x == 17) {
                lats[id] = Double.NaN;
                if (!VERBOSE) continue;
                System.out.println("  id=" + id + " is missing");
                continue;
            }
            if (id > 0 && x < 3 && haveRealDoc) {
                int oldID;
                while (Double.isNaN(lats[oldID = BaseGeoPointTestCase.random().nextInt(id)])) {
                }
                if (x == 0) {
                    lats[id] = lats[oldID];
                    lons[id] = this.nextLongitude();
                    if (!VERBOSE) continue;
                    System.out.println("  id=" + id + " lat=" + lats[id] + " lon=" + lons[id] + " (same lat as doc=" + oldID + ")");
                    continue;
                }
                if (x == 1) {
                    lats[id] = this.nextLatitude();
                    lons[id] = lons[oldID];
                    if (!VERBOSE) continue;
                    System.out.println("  id=" + id + " lat=" + lats[id] + " lon=" + lons[id] + " (same lon as doc=" + oldID + ")");
                    continue;
                }
                assert (x == 2);
                lats[id] = lats[oldID];
                lons[id] = lons[oldID];
                if (!VERBOSE) continue;
                System.out.println("  id=" + id + " lat=" + lats[id] + " lon=" + lons[id] + " (same lat/lon as doc=" + oldID + ")");
                continue;
            }
            lats[id] = this.nextLatitude();
            lons[id] = this.nextLongitude();
            haveRealDoc = true;
            if (!VERBOSE) continue;
            System.out.println("  id=" + id + " lat=" + lats[id] + " lon=" + lons[id]);
        }
        this.verify(lats, lons);
    }

    protected double quantizeLat(double lat) {
        return lat;
    }

    protected double quantizeLon(double lon) {
        return lon;
    }

    protected abstract void addPointToDoc(String var1, Document var2, double var3, double var5);

    protected abstract Query newRectQuery(String var1, double var2, double var4, double var6, double var8);

    protected abstract Query newDistanceQuery(String var1, double var2, double var4, double var6);

    protected abstract Query newPolygonQuery(String var1, Polygon ... var2);

    static final boolean rectContainsPoint(Rectangle rect, double pointLat, double pointLon) {
        assert (!Double.isNaN(pointLat));
        if (pointLat < rect.minLat || pointLat > rect.maxLat) {
            return false;
        }
        if (rect.minLon <= rect.maxLon) {
            return pointLon >= rect.minLon && pointLon <= rect.maxLon;
        }
        return pointLon <= rect.maxLon || pointLon >= rect.minLon;
    }

    private void verify(double[] lats, double[] lons) throws Exception {
        int i;
        for (i = 0; i < lats.length; ++i) {
            if (Double.isNaN(lats[i])) continue;
            lats[i] = this.quantizeLat(lats[i]);
        }
        for (i = 0; i < lons.length; ++i) {
            if (Double.isNaN(lons[i])) continue;
            lons[i] = this.quantizeLon(lons[i]);
        }
        this.verifyRandomRectangles(lats, lons);
        this.verifyRandomDistances(lats, lons);
        if (this.supportsPolygons()) {
            this.verifyRandomPolygons(lats, lons);
        }
    }

    protected void verifyRandomRectangles(double[] lats, double[] lons) throws Exception {
        IndexWriterConfig iwc = BaseGeoPointTestCase.newIndexWriterConfig();
        iwc.setMergeScheduler((MergeScheduler)new SerialMergeScheduler());
        int mbd = iwc.getMaxBufferedDocs();
        if (mbd != -1 && mbd < lats.length / 100) {
            iwc.setMaxBufferedDocs(lats.length / 100);
        }
        BaseDirectoryWrapper dir = lats.length > 100000 ? BaseGeoPointTestCase.newFSDirectory(BaseGeoPointTestCase.createTempDir(((Object)((Object)this)).getClass().getSimpleName())) : BaseGeoPointTestCase.newDirectory();
        HashSet<Integer> deleted = new HashSet<Integer>();
        IndexWriter w = new IndexWriter((Directory)dir, iwc);
        for (int id = 0; id < lats.length; ++id) {
            Document doc = new Document();
            doc.add((IndexableField)BaseGeoPointTestCase.newStringField("id", "" + id, Field.Store.NO));
            doc.add((IndexableField)new NumericDocValuesField("id", (long)id));
            if (!Double.isNaN(lats[id])) {
                this.addPointToDoc(FIELD_NAME, doc, lats[id], lons[id]);
            }
            w.addDocument((Iterable)doc);
            if (id <= 0 || BaseGeoPointTestCase.random().nextInt(100) != 42) continue;
            int idToDelete = BaseGeoPointTestCase.random().nextInt(id);
            w.deleteDocuments(new Term[]{new Term("id", "" + idToDelete)});
            deleted.add(idToDelete);
            if (!VERBOSE) continue;
            System.out.println("  delete id=" + idToDelete);
        }
        if (BaseGeoPointTestCase.random().nextBoolean()) {
            w.forceMerge(1);
        }
        DirectoryReader r = DirectoryReader.open((IndexWriter)w);
        w.close();
        IndexSearcher s = BaseGeoPointTestCase.newSearcher((IndexReader)r);
        int iters = BaseGeoPointTestCase.atLeast(25);
        Bits liveDocs = MultiFields.getLiveDocs((IndexReader)s.getIndexReader());
        int maxDoc = s.getIndexReader().maxDoc();
        for (int iter = 0; iter < iters; ++iter) {
            if (VERBOSE) {
                System.out.println("\nTEST: iter=" + iter + " s=" + s);
            }
            Rectangle rect = this.nextBox();
            Query query = this.newRectQuery(FIELD_NAME, rect.minLat, rect.maxLat, rect.minLon, rect.maxLon);
            if (VERBOSE) {
                System.out.println("  query=" + query);
            }
            final FixedBitSet hits = new FixedBitSet(maxDoc);
            s.search(query, (Collector)new SimpleCollector(){
                private int docBase;

                public boolean needsScores() {
                    return false;
                }

                protected void doSetNextReader(LeafReaderContext context) throws IOException {
                    this.docBase = context.docBase;
                }

                public void collect(int doc) {
                    hits.set(this.docBase + doc);
                }
            });
            boolean fail = false;
            NumericDocValues docIDToID = MultiDocValues.getNumericValues((IndexReader)r, (String)"id");
            for (int docID = 0; docID < maxDoc; ++docID) {
                BaseGeoPointTestCase.assertEquals((long)docID, (long)docIDToID.nextDoc());
                int id = (int)docIDToID.longValue();
                boolean expected = liveDocs != null && !liveDocs.get(docID) ? false : (Double.isNaN(lats[id]) ? false : BaseGeoPointTestCase.rectContainsPoint(rect, lats[id], lons[id]));
                if (hits.get(docID) == expected) continue;
                StringBuilder b = new StringBuilder();
                b.append("docID=(" + docID + ")\n");
                if (expected) {
                    b.append("FAIL: id=" + id + " should match but did not\n");
                } else {
                    b.append("FAIL: id=" + id + " should not match but did\n");
                }
                b.append("  box=" + rect + "\n");
                b.append("  query=" + query + " docID=" + docID + "\n");
                b.append("  lat=" + lats[id] + " lon=" + lons[id] + "\n");
                b.append("  deleted?=" + (liveDocs != null && !liveDocs.get(docID)));
                BaseGeoPointTestCase.fail((String)("wrong hit (first of possibly more):\n\n" + b));
            }
            if (!fail) continue;
            BaseGeoPointTestCase.fail((String)"some hits were wrong");
        }
        IOUtils.close((Closeable[])new Closeable[]{r, dir});
    }

    protected void verifyRandomDistances(double[] lats, double[] lons) throws Exception {
        IndexWriterConfig iwc = BaseGeoPointTestCase.newIndexWriterConfig();
        iwc.setMergeScheduler((MergeScheduler)new SerialMergeScheduler());
        int mbd = iwc.getMaxBufferedDocs();
        if (mbd != -1 && mbd < lats.length / 100) {
            iwc.setMaxBufferedDocs(lats.length / 100);
        }
        BaseDirectoryWrapper dir = lats.length > 100000 ? BaseGeoPointTestCase.newFSDirectory(BaseGeoPointTestCase.createTempDir(((Object)((Object)this)).getClass().getSimpleName())) : BaseGeoPointTestCase.newDirectory();
        HashSet<Integer> deleted = new HashSet<Integer>();
        IndexWriter w = new IndexWriter((Directory)dir, iwc);
        for (int id = 0; id < lats.length; ++id) {
            Document doc = new Document();
            doc.add((IndexableField)BaseGeoPointTestCase.newStringField("id", "" + id, Field.Store.NO));
            doc.add((IndexableField)new NumericDocValuesField("id", (long)id));
            if (!Double.isNaN(lats[id])) {
                this.addPointToDoc(FIELD_NAME, doc, lats[id], lons[id]);
            }
            w.addDocument((Iterable)doc);
            if (id <= 0 || BaseGeoPointTestCase.random().nextInt(100) != 42) continue;
            int idToDelete = BaseGeoPointTestCase.random().nextInt(id);
            w.deleteDocuments(new Term[]{new Term("id", "" + idToDelete)});
            deleted.add(idToDelete);
            if (!VERBOSE) continue;
            System.out.println("  delete id=" + idToDelete);
        }
        if (BaseGeoPointTestCase.random().nextBoolean()) {
            w.forceMerge(1);
        }
        DirectoryReader r = DirectoryReader.open((IndexWriter)w);
        w.close();
        IndexSearcher s = BaseGeoPointTestCase.newSearcher((IndexReader)r);
        int iters = BaseGeoPointTestCase.atLeast(25);
        Bits liveDocs = MultiFields.getLiveDocs((IndexReader)s.getIndexReader());
        int maxDoc = s.getIndexReader().maxDoc();
        for (int iter = 0; iter < iters; ++iter) {
            if (VERBOSE) {
                System.out.println("\nTEST: iter=" + iter + " s=" + s);
            }
            double centerLat = this.nextLatitude();
            double centerLon = this.nextLongitude();
            double radiusMeters = BaseGeoPointTestCase.random().nextDouble() * 6371008.7714 * Math.PI / 2.0 + 1.0;
            if (VERBOSE) {
                DecimalFormat df = new DecimalFormat("#,###.00", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
                System.out.println("  radiusMeters = " + df.format(radiusMeters));
            }
            Query query = this.newDistanceQuery(FIELD_NAME, centerLat, centerLon, radiusMeters);
            if (VERBOSE) {
                System.out.println("  query=" + query);
            }
            final FixedBitSet hits = new FixedBitSet(maxDoc);
            s.search(query, (Collector)new SimpleCollector(){
                private int docBase;

                public boolean needsScores() {
                    return false;
                }

                protected void doSetNextReader(LeafReaderContext context) throws IOException {
                    this.docBase = context.docBase;
                }

                public void collect(int doc) {
                    hits.set(this.docBase + doc);
                }
            });
            boolean fail = false;
            NumericDocValues docIDToID = MultiDocValues.getNumericValues((IndexReader)r, (String)"id");
            for (int docID = 0; docID < maxDoc; ++docID) {
                boolean expected;
                BaseGeoPointTestCase.assertEquals((long)docID, (long)docIDToID.nextDoc());
                int id = (int)docIDToID.longValue();
                if (liveDocs != null && !liveDocs.get(docID)) {
                    expected = false;
                } else if (Double.isNaN(lats[id])) {
                    expected = false;
                } else {
                    boolean bl = expected = SloppyMath.haversinMeters((double)centerLat, (double)centerLon, (double)lats[id], (double)lons[id]) <= radiusMeters;
                }
                if (hits.get(docID) == expected) continue;
                StringBuilder b = new StringBuilder();
                if (expected) {
                    b.append("FAIL: id=" + id + " should match but did not\n");
                } else {
                    b.append("FAIL: id=" + id + " should not match but did\n");
                }
                b.append("  query=" + query + " docID=" + docID + "\n");
                b.append("  lat=" + lats[id] + " lon=" + lons[id] + "\n");
                b.append("  deleted?=" + (liveDocs != null && !liveDocs.get(docID)));
                if (!Double.isNaN(lats[id])) {
                    double distanceMeters = SloppyMath.haversinMeters((double)centerLat, (double)centerLon, (double)lats[id], (double)lons[id]);
                    b.append("  centerLat=" + centerLat + " centerLon=" + centerLon + " distanceMeters=" + distanceMeters + " vs radiusMeters=" + radiusMeters);
                }
                BaseGeoPointTestCase.fail((String)("wrong hit (first of possibly more):\n\n" + b));
            }
            if (!fail) continue;
            BaseGeoPointTestCase.fail((String)"some hits were wrong");
        }
        IOUtils.close((Closeable[])new Closeable[]{r, dir});
    }

    protected void verifyRandomPolygons(double[] lats, double[] lons) throws Exception {
        IndexWriterConfig iwc = BaseGeoPointTestCase.newIndexWriterConfig();
        iwc.setMergeScheduler((MergeScheduler)new SerialMergeScheduler());
        int mbd = iwc.getMaxBufferedDocs();
        if (mbd != -1 && mbd < lats.length / 100) {
            iwc.setMaxBufferedDocs(lats.length / 100);
        }
        BaseDirectoryWrapper dir = lats.length > 100000 ? BaseGeoPointTestCase.newFSDirectory(BaseGeoPointTestCase.createTempDir(((Object)((Object)this)).getClass().getSimpleName())) : BaseGeoPointTestCase.newDirectory();
        HashSet<Integer> deleted = new HashSet<Integer>();
        IndexWriter w = new IndexWriter((Directory)dir, iwc);
        for (int id = 0; id < lats.length; ++id) {
            Document doc = new Document();
            doc.add((IndexableField)BaseGeoPointTestCase.newStringField("id", "" + id, Field.Store.NO));
            doc.add((IndexableField)new NumericDocValuesField("id", (long)id));
            if (!Double.isNaN(lats[id])) {
                this.addPointToDoc(FIELD_NAME, doc, lats[id], lons[id]);
            }
            w.addDocument((Iterable)doc);
            if (id <= 0 || BaseGeoPointTestCase.random().nextInt(100) != 42) continue;
            int idToDelete = BaseGeoPointTestCase.random().nextInt(id);
            w.deleteDocuments(new Term[]{new Term("id", "" + idToDelete)});
            deleted.add(idToDelete);
            if (!VERBOSE) continue;
            System.out.println("  delete id=" + idToDelete);
        }
        if (BaseGeoPointTestCase.random().nextBoolean()) {
            w.forceMerge(1);
        }
        DirectoryReader r = DirectoryReader.open((IndexWriter)w);
        w.close();
        IndexSearcher s = BaseGeoPointTestCase.newSearcher((IndexReader)r);
        int iters = BaseGeoPointTestCase.atLeast(75);
        Bits liveDocs = MultiFields.getLiveDocs((IndexReader)s.getIndexReader());
        int maxDoc = s.getIndexReader().maxDoc();
        for (int iter = 0; iter < iters; ++iter) {
            if (VERBOSE) {
                System.out.println("\nTEST: iter=" + iter + " s=" + s);
            }
            Polygon polygon = this.nextPolygon();
            Query query = this.newPolygonQuery(FIELD_NAME, polygon);
            if (VERBOSE) {
                System.out.println("  query=" + query);
            }
            final FixedBitSet hits = new FixedBitSet(maxDoc);
            s.search(query, (Collector)new SimpleCollector(){
                private int docBase;

                public boolean needsScores() {
                    return false;
                }

                protected void doSetNextReader(LeafReaderContext context) throws IOException {
                    this.docBase = context.docBase;
                }

                public void collect(int doc) {
                    hits.set(this.docBase + doc);
                }
            });
            boolean fail = false;
            NumericDocValues docIDToID = MultiDocValues.getNumericValues((IndexReader)r, (String)"id");
            for (int docID = 0; docID < maxDoc; ++docID) {
                BaseGeoPointTestCase.assertEquals((long)docID, (long)docIDToID.nextDoc());
                int id = (int)docIDToID.longValue();
                boolean expected = liveDocs != null && !liveDocs.get(docID) ? false : (Double.isNaN(lats[id]) ? false : GeoTestUtil.containsSlowly(polygon, lats[id], lons[id]));
                if (hits.get(docID) == expected) continue;
                StringBuilder b = new StringBuilder();
                if (expected) {
                    b.append("FAIL: id=" + id + " should match but did not\n");
                } else {
                    b.append("FAIL: id=" + id + " should not match but did\n");
                }
                b.append("  query=" + query + " docID=" + docID + "\n");
                b.append("  lat=" + lats[id] + " lon=" + lons[id] + "\n");
                b.append("  deleted?=" + (liveDocs != null && !liveDocs.get(docID)));
                b.append("  polygon=" + polygon);
                BaseGeoPointTestCase.fail((String)("wrong hit (first of possibly more):\n\n" + b));
            }
            if (!fail) continue;
            BaseGeoPointTestCase.fail((String)"some hits were wrong");
        }
        IOUtils.close((Closeable[])new Closeable[]{r, dir});
    }

    public void testRectBoundariesAreInclusive() throws Exception {
        Rectangle rect;
        while ((rect = this.nextBox()).crossesDateline()) {
        }
        rect = new Rectangle(this.quantizeLat(rect.minLat), this.quantizeLat(rect.maxLat), this.quantizeLon(rect.minLon), this.quantizeLon(rect.maxLon));
        BaseDirectoryWrapper dir = BaseGeoPointTestCase.newDirectory();
        IndexWriterConfig iwc = BaseGeoPointTestCase.newIndexWriterConfig();
        iwc.setMergeScheduler((MergeScheduler)new SerialMergeScheduler());
        RandomIndexWriter w = new RandomIndexWriter(BaseGeoPointTestCase.random(), (Directory)dir, iwc);
        for (int x = 0; x < 3; ++x) {
            double lat = x == 0 ? rect.minLat : (x == 1 ? this.quantizeLat((rect.minLat + rect.maxLat) / 2.0) : rect.maxLat);
            for (int y = 0; y < 3; ++y) {
                double lon;
                if (y == 0) {
                    lon = rect.minLon;
                } else if (y == 1) {
                    if (x == 1) continue;
                    lon = this.quantizeLon((rect.minLon + rect.maxLon) / 2.0);
                } else {
                    lon = rect.maxLon;
                }
                Document doc = new Document();
                this.addPointToDoc(FIELD_NAME, doc, lat, lon);
                w.addDocument(doc);
            }
        }
        DirectoryReader r = w.getReader();
        IndexSearcher s = BaseGeoPointTestCase.newSearcher((IndexReader)r, false);
        BaseGeoPointTestCase.assertEquals((long)8L, (long)s.count(this.newRectQuery(FIELD_NAME, rect.minLat, rect.maxLat, rect.minLon, rect.maxLon)));
        if (rect.minLat != -90.0) {
            BaseGeoPointTestCase.assertEquals((long)8L, (long)s.count(this.newRectQuery(FIELD_NAME, Math.nextDown(rect.minLat), rect.maxLat, rect.minLon, rect.maxLon)));
        }
        if (rect.maxLat != 90.0) {
            BaseGeoPointTestCase.assertEquals((long)8L, (long)s.count(this.newRectQuery(FIELD_NAME, rect.minLat, Math.nextUp(rect.maxLat), rect.minLon, rect.maxLon)));
        }
        if (rect.minLon != -180.0) {
            BaseGeoPointTestCase.assertEquals((long)8L, (long)s.count(this.newRectQuery(FIELD_NAME, rect.minLat, rect.maxLat, Math.nextDown(rect.minLon), rect.maxLon)));
        }
        if (rect.maxLon != 180.0) {
            BaseGeoPointTestCase.assertEquals((long)8L, (long)s.count(this.newRectQuery(FIELD_NAME, rect.minLat, rect.maxLat, rect.minLon, Math.nextUp(rect.maxLon))));
        }
        if (rect.minLat != 90.0 && rect.maxLat != -90.0 && rect.minLon != 80.0 && rect.maxLon != -180.0 && rect.minLon != rect.maxLon) {
            BaseGeoPointTestCase.assertEquals((long)0L, (long)s.count(this.newRectQuery(FIELD_NAME, Math.nextUp(rect.minLat), Math.nextDown(rect.maxLat), Math.nextUp(rect.minLon), Math.nextDown(rect.maxLon))));
        }
        r.close();
        w.close();
        dir.close();
    }

    public void testRandomDistance() throws Exception {
        for (int iters = 0; iters < 100; ++iters) {
            this.doRandomDistanceTest(10, 100);
        }
    }

    @LuceneTestCase.Nightly
    public void testRandomDistanceHuge() throws Exception {
        for (int iters = 0; iters < 10; ++iters) {
            this.doRandomDistanceTest(2000, 100);
        }
    }

    private void doRandomDistanceTest(int numDocs, int numQueries) throws IOException {
        BaseDirectoryWrapper dir = BaseGeoPointTestCase.newDirectory();
        IndexWriterConfig iwc = BaseGeoPointTestCase.newIndexWriterConfig();
        iwc.setMergeScheduler((MergeScheduler)new SerialMergeScheduler());
        final int pointsInLeaf = 2 + BaseGeoPointTestCase.random().nextInt(4);
        iwc.setCodec((Codec)new FilterCodec("Lucene70", TestUtil.getDefaultCodec()){

            public PointsFormat pointsFormat() {
                return new PointsFormat(){

                    public PointsWriter fieldsWriter(SegmentWriteState writeState) throws IOException {
                        return new Lucene60PointsWriter(writeState, pointsInLeaf, 16.0);
                    }

                    public PointsReader fieldsReader(SegmentReadState readState) throws IOException {
                        return new Lucene60PointsReader(readState);
                    }
                };
            }
        });
        RandomIndexWriter writer = new RandomIndexWriter(BaseGeoPointTestCase.random(), (Directory)dir, iwc);
        for (int i = 0; i < numDocs; ++i) {
            double latRaw = this.nextLatitude();
            double lonRaw = this.nextLongitude();
            double lat = this.quantizeLat(latRaw);
            double lon = this.quantizeLon(lonRaw);
            Document doc = new Document();
            this.addPointToDoc("field", doc, lat, lon);
            doc.add((IndexableField)new StoredField("lat", lat));
            doc.add((IndexableField)new StoredField("lon", lon));
            writer.addDocument(doc);
        }
        DirectoryReader reader = writer.getReader();
        IndexSearcher searcher = BaseGeoPointTestCase.newSearcher((IndexReader)reader);
        for (int i = 0; i < numQueries; ++i) {
            double lat = this.nextLatitude();
            double lon = this.nextLongitude();
            double radius = 5.0E7 * BaseGeoPointTestCase.random().nextDouble();
            BitSet expected = new BitSet();
            for (int doc = 0; doc < reader.maxDoc(); ++doc) {
                double docLongitude;
                double docLatitude = reader.document(doc).getField("lat").numericValue().doubleValue();
                double distance = SloppyMath.haversinMeters((double)lat, (double)lon, (double)docLatitude, (double)(docLongitude = reader.document(doc).getField("lon").numericValue().doubleValue()));
                if (!(distance <= radius)) continue;
                expected.set(doc);
            }
            TopFieldDocs topDocs = searcher.search(this.newDistanceQuery("field", lat, lon, radius), reader.maxDoc(), Sort.INDEXORDER);
            BitSet actual = new BitSet();
            for (ScoreDoc doc : topDocs.scoreDocs) {
                actual.set(doc.doc);
            }
            try {
                BaseGeoPointTestCase.assertEquals((Object)expected, (Object)actual);
                continue;
            }
            catch (AssertionError e) {
                System.out.println("center: (" + lat + "," + lon + "), radius=" + radius);
                for (int doc = 0; doc < reader.maxDoc(); ++doc) {
                    double docLatitude = reader.document(doc).getField("lat").numericValue().doubleValue();
                    double docLongitude = reader.document(doc).getField("lon").numericValue().doubleValue();
                    double distance = SloppyMath.haversinMeters((double)lat, (double)lon, (double)docLatitude, (double)docLongitude);
                    System.out.println("" + doc + ": (" + docLatitude + "," + docLongitude + "), distance=" + distance);
                }
                throw e;
            }
        }
        reader.close();
        writer.close();
        dir.close();
    }

    public void testEquals() throws Exception {
        Rectangle rect = this.nextBox();
        Query q1 = this.newRectQuery("field", rect.minLat, rect.maxLat, rect.minLon, rect.maxLon);
        Query q2 = this.newRectQuery("field", rect.minLat, rect.maxLat, rect.minLon, rect.maxLon);
        BaseGeoPointTestCase.assertEquals((Object)q1, (Object)q2);
        if (!(q1 instanceof MatchNoDocsQuery)) {
            BaseGeoPointTestCase.assertFalse((boolean)q1.equals((Object)this.newRectQuery("field2", rect.minLat, rect.maxLat, rect.minLon, rect.maxLon)));
        }
        double lat = this.nextLatitude();
        double lon = this.nextLongitude();
        q1 = this.newDistanceQuery("field", lat, lon, 10000.0);
        q2 = this.newDistanceQuery("field", lat, lon, 10000.0);
        BaseGeoPointTestCase.assertEquals((Object)q1, (Object)q2);
        BaseGeoPointTestCase.assertFalse((boolean)q1.equals((Object)this.newDistanceQuery("field2", lat, lon, 10000.0)));
        double[] lats = new double[5];
        double[] lons = new double[5];
        lats[0] = rect.minLat;
        lons[0] = rect.minLon;
        lats[1] = rect.maxLat;
        lons[1] = rect.minLon;
        lats[2] = rect.maxLat;
        lons[2] = rect.maxLon;
        lats[3] = rect.minLat;
        lons[3] = rect.maxLon;
        lats[4] = rect.minLat;
        lons[4] = rect.minLon;
        if (this.supportsPolygons()) {
            q1 = this.newPolygonQuery("field", new Polygon(lats, lons, new Polygon[0]));
            q2 = this.newPolygonQuery("field", new Polygon(lats, lons, new Polygon[0]));
            BaseGeoPointTestCase.assertEquals((Object)q1, (Object)q2);
            BaseGeoPointTestCase.assertFalse((boolean)q1.equals((Object)this.newPolygonQuery("field2", new Polygon(lats, lons, new Polygon[0]))));
        }
    }

    private TopDocs searchSmallSet(Query query, int size) throws Exception {
        int i;
        double[][] pts = new double[][]{{32.76342, -96.774}, {32.7559529921407, -96.7759895324707}, {32.77866942010977, -96.77701950073242}, {32.7756745755423, -96.7706036567688}, {27.703618681345585, -139.73458170890808}, {32.94823588839368, -96.4538113027811}, {33.06047141970814, -96.65084838867188}, {32.77865, -96.7772}, {-88.56029371730983, -177.23537676036358}, {33.541429799076354, -26.779373834241003}, {26.774024500421728, -77.35379276106497}, {-90.0, -14.796283808944777}, {32.94823588839368, -178.8538113027811}, {32.94823588839368, 178.8538113027811}, {40.720611, -73.998776}, {-44.5, -179.5}};
        BaseDirectoryWrapper directory = BaseGeoPointTestCase.newDirectory();
        IndexWriterConfig iwc = BaseGeoPointTestCase.newIndexWriterConfig(new MockAnalyzer(BaseGeoPointTestCase.random()));
        iwc.setMaxBufferedDocs(TestUtil.nextInt(BaseGeoPointTestCase.random(), 100, 1000));
        iwc.setMergePolicy((MergePolicy)BaseGeoPointTestCase.newLogMergePolicy());
        iwc.setMergeScheduler((MergeScheduler)new SerialMergeScheduler());
        RandomIndexWriter writer = new RandomIndexWriter(BaseGeoPointTestCase.random(), (Directory)directory, iwc);
        for (double[] p : pts) {
            Document doc = new Document();
            this.addPointToDoc(FIELD_NAME, doc, p[0], p[1]);
            writer.addDocument(doc);
        }
        for (i = 0; i < pts.length; i += 2) {
            Document doc = new Document();
            this.addPointToDoc(FIELD_NAME, doc, pts[i][0], pts[i][1]);
            this.addPointToDoc(FIELD_NAME, doc, pts[i + 1][0], pts[i + 1][1]);
            writer.addDocument(doc);
        }
        for (i = 0; i < BaseGeoPointTestCase.random().nextInt(10); ++i) {
            Document doc = new Document();
            doc.add((IndexableField)new StringField("string", Integer.toString(i), Field.Store.NO));
            writer.addDocument(doc);
        }
        DirectoryReader reader = writer.getReader();
        writer.close();
        IndexSearcher searcher = BaseGeoPointTestCase.newSearcher((IndexReader)reader);
        TopDocs topDocs = searcher.search(query, size);
        reader.close();
        directory.close();
        return topDocs;
    }

    public void testSmallSetRect() throws Exception {
        TopDocs td = this.searchSmallSet(this.newRectQuery(FIELD_NAME, 32.778, 32.779, -96.778, -96.777), 5);
        BaseGeoPointTestCase.assertEquals((long)4L, (long)td.totalHits);
    }

    public void testSmallSetDateline() throws Exception {
        TopDocs td = this.searchSmallSet(this.newRectQuery(FIELD_NAME, -45.0, -44.0, 179.0, -179.0), 20);
        BaseGeoPointTestCase.assertEquals((long)2L, (long)td.totalHits);
    }

    public void testSmallSetMultiValued() throws Exception {
        TopDocs td = this.searchSmallSet(this.newRectQuery(FIELD_NAME, 32.755, 32.776, -96.454, -96.77), 20);
        BaseGeoPointTestCase.assertEquals((long)5L, (long)td.totalHits);
    }

    public void testSmallSetWholeMap() throws Exception {
        TopDocs td = this.searchSmallSet(this.newRectQuery(FIELD_NAME, -90.0, 90.0, -180.0, 180.0), 20);
        BaseGeoPointTestCase.assertEquals((long)24L, (long)td.totalHits);
    }

    public void testSmallSetPoly() throws Exception {
        BaseGeoPointTestCase.assumeTrue("Impl does not support polygons", this.supportsPolygons());
        TopDocs td = this.searchSmallSet(this.newPolygonQuery(FIELD_NAME, new Polygon(new double[]{33.07313, 32.9942669, 32.938386, 33.0374494, 33.1369762, 33.1162747, 33.07313, 33.07313}, new double[]{-96.7682647, -96.8280029, -96.6288757, -96.4929199, -96.6041564, -96.7449188, -96.76826477, -96.7682647}, new Polygon[0])), 5);
        BaseGeoPointTestCase.assertEquals((long)2L, (long)td.totalHits);
    }

    public void testSmallSetPolyWholeMap() throws Exception {
        BaseGeoPointTestCase.assumeTrue("Impl does not support polygons", this.supportsPolygons());
        TopDocs td = this.searchSmallSet(this.newPolygonQuery(FIELD_NAME, new Polygon(new double[]{-90.0, 90.0, 90.0, -90.0, -90.0}, new double[]{-180.0, -180.0, 180.0, 180.0, -180.0}, new Polygon[0])), 20);
        BaseGeoPointTestCase.assertEquals((String)"testWholeMap failed", (long)24L, (long)td.totalHits);
    }

    public void testSmallSetDistance() throws Exception {
        TopDocs td = this.searchSmallSet(this.newDistanceQuery(FIELD_NAME, 32.94823588839368, -96.4538113027811, 6000.0), 20);
        BaseGeoPointTestCase.assertEquals((long)2L, (long)td.totalHits);
    }

    public void testSmallSetTinyDistance() throws Exception {
        TopDocs td = this.searchSmallSet(this.newDistanceQuery(FIELD_NAME, 40.720611, -73.998776, 1.0), 20);
        BaseGeoPointTestCase.assertEquals((long)2L, (long)td.totalHits);
    }

    public void testSmallSetDistanceNotEmpty() throws Exception {
        TopDocs td = this.searchSmallSet(this.newDistanceQuery(FIELD_NAME, -88.56029371730983, -177.23537676036358, 7757.999232959935), 20);
        BaseGeoPointTestCase.assertEquals((long)2L, (long)td.totalHits);
    }

    public void testSmallSetHugeDistance() throws Exception {
        TopDocs td = this.searchSmallSet(this.newDistanceQuery(FIELD_NAME, 32.94823588839368, -96.4538113027811, 6000000.0), 20);
        BaseGeoPointTestCase.assertEquals((long)16L, (long)td.totalHits);
    }

    public void testSmallSetDistanceDateline() throws Exception {
        TopDocs td = this.searchSmallSet(this.newDistanceQuery(FIELD_NAME, 32.94823588839368, -179.9538113027811, 120000.0), 20);
        BaseGeoPointTestCase.assertEquals((long)3L, (long)td.totalHits);
    }
}

