/*
 * Decompiled with CFR 0.152.
 */
package Utility.com.parablu;

import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.parablu.pcbd.domain.BackUpImage;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;

public class UserOdbLoginIdUpdate {
    public static void main(String[] args) throws ConfigurationException {
        try {
            PropertiesConfiguration config = new PropertiesConfiguration(args[0]);
            String mongoIP = config.getProperty("mongoIP").toString();
            String mongoPort = config.getProperty("mongoPort").toString();
            boolean update = config.getBoolean("updateFlag");
            if (StringUtils.isEmpty(mongoIP) || StringUtils.isEmpty(mongoPort)) {
                System.out.println("mongoIP or port cannot be empty in config file...Please configure and run again :)");
                throw new ArrayIndexOutOfBoundsException();
            }
            System.out.println(String.valueOf(update) + "....mongo IP:" + mongoIP);
            MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu001");
            MongoClient client = new MongoClient(uri);
            MongoDatabase db = client.getDatabase(uri.getDatabase());
            System.out.println("connectivity success  ");
            MongoCollection<Document> usersDB = db.getCollection("USER");
            BasicDBObject andQuery = new BasicDBObject();
            ArrayList<BasicDBObject> whereQuery = new ArrayList<BasicDBObject>();
            whereQuery.add(new BasicDBObject("backupTargetErrorCode", (Object)204));
            andQuery.put("$and", whereQuery);
            FindIterable<Document> users = usersDB.find(andQuery);
            ArrayList recipents = new ArrayList();
            long count = usersDB.count(andQuery);
            System.out.println("total users is...." + count);
            int i = 0;
            for (Document user : users) {
                String emailId = user.getString("emailId");
                if (!update) continue;
                BasicDBObject andQuery1 = new BasicDBObject();
                ArrayList<BasicDBObject> whereQuery1 = new ArrayList<BasicDBObject>();
                whereQuery1.add(new BasicDBObject("_id", user.getObjectId("_id")));
                andQuery1.put("$and", whereQuery1);
                BasicDBObject updateFields = new BasicDBObject();
                BasicDBObject updateQuery = new BasicDBObject();
                updateFields.append("odbLoginId", emailId);
                updateFields.append("backupTargetErrorCode", 0);
                updateFields.append("backupTargetAssigned", true);
                updateQuery.append("$set", updateFields);
                usersDB.updateOne(andQuery1, updateQuery);
                System.out.println(String.valueOf(++i) + "/" + count + ".... emailId...." + emailId);
            }
        }
        catch (Exception e) {
            System.out.println("Exception..." + e.getMessage());
            e.printStackTrace();
        }
    }

    private static List<BackUpImage> getFilteredBackupImageList(List<BackUpImage> backUpImages) {
        System.out.println("Inside grouping backup images");
        ArrayList<BackUpImage> filteredBackUpImages = new ArrayList<BackUpImage>();
        Map<String, Map<String, List<BackUpImage>>> map = backUpImages.stream().collect(Collectors.groupingBy(BackUpImage::getDevicePath, Collectors.groupingBy(BackUpImage::getFileName)));
        for (Map.Entry<String, Map<String, List<BackUpImage>>> entry : map.entrySet()) {
            entry.getValue().entrySet().stream().forEach(p -> filteredBackUpImages.add(((List)p.getValue()).stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).findFirst().get()));
        }
        return filteredBackUpImages;
    }
}

