/*
 * Decompiled with CFR 0.152.
 */
package Utility.com.parablu;

import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.result.UpdateResult;
import com.parablu.pcbd.domain.BackUpImage;
import com.parablu.pcbd.domain.Device;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;
import org.bson.types.ObjectId;

public class PathUpdater {
    public static Date convertToDateFrom(String objectId) {
        return new Date(PathUpdater.convertToTimestampFrom(objectId));
    }

    public static long convertToTimestampFrom(String objectId) {
        return Long.parseLong(objectId.substring(0, 8), 16) * 1000L;
    }

    /*
     * WARNING - void declaration
     */
    public static void main(String[] args) throws ConfigurationException {
        try {
            String mongoIP = "embassystagepvn.parablu.com";
            String mongoPort = "48765";
            String deviceUUIDList = "a84fe29e8c4b24438122d3f43434ad56";
            if (StringUtils.isEmpty(mongoIP) || StringUtils.isEmpty(mongoPort)) {
                System.out.println("mongoIP or port cannot be empty in config file...Please configure and run again :)");
                throw new ArrayIndexOutOfBoundsException();
            }
            System.out.println("mongo IP:" + mongoIP);
            MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu001");
            MongoClient client = new MongoClient(uri);
            MongoDatabase db = client.getDatabase(uri.getDatabase());
            System.out.println("connectivity success  ");
            MongoCollection<Document> deviceColl = db.getCollection("DEVICE");
            FindIterable<Document> devices = null;
            if (StringUtils.isEmpty(deviceUUIDList)) {
                devices = deviceColl.find();
            } else {
                String[] deviceUUIDs = deviceUUIDList.split(",");
                ArrayList<String> uuids = new ArrayList<String>();
                String[] stringArray = deviceUUIDs;
                int n = deviceUUIDs.length;
                int n2 = 0;
                while (n2 < n) {
                    String uuid = stringArray[n2];
                    uuid = uuid.replace("[", "");
                    uuid = uuid.replace("]", "");
                    uuid = uuid.trim();
                    uuids.add(uuid);
                    ++n2;
                }
                System.out.println("uuids ..." + uuids);
                BasicDBObject inQuery = new BasicDBObject();
                inQuery.append("deviceUUID", new BasicDBObject("$in", uuids));
                devices = deviceColl.find(inQuery);
            }
            System.out.println("Converting device Db object to list of  device ...");
            ArrayList<Device> devList = new ArrayList<Device>();
            for (Document dev : devices) {
                Device device = new Device();
                device.setDeviceUUID(dev.getString("deviceUUID"));
                device.setDestCollection(dev.getString("destCollection"));
                devList.add(device);
            }
            System.out.println("total device size is...." + devList.size());
            for (Device device : devList) {
                void var26_31;
                FindIterable<Document> folders;
                Date date = Calendar.getInstance().getTime();
                SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy hh:mm:ss");
                String strDate = dateFormat.format(date);
                System.out.println("....STARTDEVICE......" + strDate);
                MongoCollection<Document> bkpColl = db.getCollection(device.getDestCollection());
                String deviceUUID = device.getDeviceUUID();
                BasicDBObject andQuery = new BasicDBObject();
                ArrayList<BasicDBObject> whereQuery = new ArrayList<BasicDBObject>();
                whereQuery.add(new BasicDBObject("deviceUUID", deviceUUID));
                whereQuery.add(new BasicDBObject("folder", true));
                whereQuery.add(new BasicDBObject("present", true));
                andQuery.put("$and", whereQuery);
                ArrayList<Document> allFoldersList = new ArrayList<Document>();
                int skip = 0;
                System.out.println("getting folders................");
                while ((folders = bkpColl.find(andQuery).skip(skip * 500).limit(500)).first() != null) {
                    for (Document document : folders) {
                        allFoldersList.add(document);
                    }
                    ++skip;
                }
                System.out.println("Done folders   " + allFoldersList.size() + " for deviceUUID " + deviceUUID);
                long allFilesSizes = 0L;
                HashMap<String, ObjectId> map = new HashMap<String, ObjectId>();
                HashMap<String, String> updatemap = new HashMap<String, String>();
                HashMap<String, ObjectId> folderIdAndPathMap = new HashMap<String, ObjectId>();
                for (Document document : allFoldersList) {
                    String folderName = "";
                    folderName = StringUtils.isEmpty(document.getString("devicePath")) ? document.getString("fileName") : String.valueOf(document.getString("devicePath")) + "/" + document.getString("fileName");
                    ObjectId val = (ObjectId)document.get("_id");
                    folderIdAndPathMap.put(folderName, val);
                    if (!folderName.toLowerCase().equals("d:/SAP/SAP/BD_NW_7.0_Presentation_7.40_Comp._1_/PRES1/GUI/WINDOWS/WIN32/SapGui/etc/PDFL_Resources".toLowerCase())) continue;
                    System.out.println(String.valueOf(folderName) + "...updd...");
                    System.out.println(String.valueOf(val.toString()) + "...updd..." + PathUpdater.convertToDateFrom(val.toString()));
                    boolean keyExists = false;
                    for (Map.Entry entry : map.entrySet()) {
                        String key = (String)entry.getKey();
                        ObjectId existId = (ObjectId)entry.getValue();
                        if (key.equals(folderName)) continue;
                        if (key.toLowerCase().equalsIgnoreCase(folderName.toLowerCase())) {
                            keyExists = true;
                        }
                        if (!keyExists) continue;
                        if (existId.compareTo(val) > 0) {
                            updatemap.put(folderName, key);
                            break;
                        }
                        updatemap.put(key, folderName);
                        break;
                    }
                    if (keyExists) continue;
                    map.put(folderName, val);
                }
                System.out.println(String.valueOf(updatemap.size()) + "......." + map.size());
                for (Map.Entry entry : updatemap.entrySet()) {
                    System.out.println("...." + (String)entry.getKey() + ".....value... with ...." + (String)entry.getValue());
                }
                System.exit(0);
                boolean bl = false;
                int count = 0;
                for (Map.Entry entry : updatemap.entrySet()) {
                    if (((String)entry.getKey()).equals(entry.getValue())) continue;
                    System.out.println("....update...." + (String)entry.getKey() + ".....value... with ...." + (String)entry.getValue());
                    BasicDBObject andQuery1 = new BasicDBObject();
                    ArrayList<BasicDBObject> whereQuery1 = new ArrayList<BasicDBObject>();
                    whereQuery1.add(new BasicDBObject("deviceUUID", deviceUUID).append("devicePath", entry.getKey()));
                    andQuery1.put("$and", whereQuery1);
                    BasicDBObject updateFields = new BasicDBObject();
                    BasicDBObject updateQuery = new BasicDBObject();
                    updateFields.append("devicePath", entry.getValue());
                    updateQuery.append("$set", updateFields);
                    UpdateResult updateMany = bkpColl.updateMany(andQuery1, updateQuery);
                    var26_31 += (int)updateMany.getModifiedCount();
                    System.out.println(String.valueOf(updateMany.getMatchedCount()) + "....modified count ...." + updateMany.getModifiedCount());
                    ObjectId id = (ObjectId)folderIdAndPathMap.get(entry.getKey());
                    andQuery1 = new BasicDBObject();
                    whereQuery1 = new ArrayList();
                    whereQuery1.add(new BasicDBObject("deviceUUID", deviceUUID));
                    whereQuery.add(new BasicDBObject("_id", id));
                    andQuery1.put("$and", whereQuery1);
                    bkpColl.findOneAndDelete(andQuery1);
                    System.out.println("updated and deleted path...." + (String)entry.getKey());
                    System.out.println("remaining...." + ++count + "/" + updatemap.size());
                }
                System.out.println(String.valueOf((int)var26_31) + "...completed...." + updatemap.size());
            }
        }
        catch (Exception e) {
            System.out.println("Exception..." + e.getMessage());
            e.printStackTrace();
        }
    }

    private static List<BackUpImage> getFilteredBackupImageList(List<BackUpImage> backUpImages) {
        System.out.println("Inside grouping backup images");
        ArrayList<BackUpImage> filteredBackUpImages = new ArrayList<BackUpImage>();
        Map<String, Map<String, List<BackUpImage>>> map = backUpImages.stream().collect(Collectors.groupingBy(BackUpImage::getDevicePath, Collectors.groupingBy(BackUpImage::getFileName)));
        for (Map.Entry<String, Map<String, List<BackUpImage>>> entry : map.entrySet()) {
            entry.getValue().entrySet().stream().forEach(p -> filteredBackUpImages.add(((List)p.getValue()).stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).findFirst().get()));
        }
        return filteredBackUpImages;
    }
}

