/*
 * Decompiled with CFR 0.152.
 */
package Utility.com.parablu;

import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;

public class CheckChunkDetailExists {
    public static Date convertToDateFrom(String objectId) {
        return new Date(CheckChunkDetailExists.convertToTimestampFrom(objectId));
    }

    public static long convertToTimestampFrom(String objectId) {
        return Long.parseLong(objectId.substring(0, 8), 16) * 1000L;
    }

    private static String getDateInFormat(Long deviceCreatedDate) {
        SimpleDateFormat df2 = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
        Date dateD = new Date(deviceCreatedDate);
        return df2.format(dateD);
    }

    public static void main(String[] args) throws ConfigurationException {
        try {
            System.out.println("....started....");
            System.out.println(CheckChunkDetailExists.getChunkNewCollectionName("574ae2ea28bda63ace42ab2854a5336d"));
            PropertiesConfiguration config = null;
            config = new PropertiesConfiguration(args[0]);
            String mongoIP = "lodhastageiknew.parablu.com";
            String mongoPort = "48765";
            String filePath = "/home/inba/Downloads/11017latest.txt";
            File file = new File(filePath);
            String userName = config.getProperty("userName").toString();
            filePath = config.getProperty("filePath").toString();
            if (!file.exists()) {
                System.out.println("....file path .... " + filePath + "...does not exist.... ");
                System.exit(0);
            }
            try {
                Scanner sc = new Scanner(file);
                AtomicInteger noOfFiles = new AtomicInteger(0);
                MongoClientURI pburi = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu");
                MongoClient pbclient = new MongoClient(pburi);
                MongoDatabase pbdb = pbclient.getDatabase(pburi.getDatabase());
                MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu001");
                MongoClient client = new MongoClient(uri);
                MongoDatabase db = client.getDatabase(uri.getDatabase());
                System.out.println("connectivity success  ");
                boolean isUserExists = CheckChunkDetailExists.checkIfUserExists(userName, db);
                if (isUserExists) {
                    System.out.println("....user exists so break pls verify if user is deleted user or not..... ");
                    System.exit(1);
                }
                MongoCollection<Document> cloudCredentialColl = pbdb.getCollection("CLOUD_CREDENTIALS");
                FindIterable<Document> cloudCredentials = cloudCredentialColl.find();
                String localStoragePath = "";
                for (Document document : cloudCredentials) {
                    localStoragePath = document.getString("endPointUrl");
                    System.out.println("...localstoragePath ......" + localStoragePath);
                }
                if (StringUtils.isEmpty(localStoragePath)) {
                    System.out.println("....localStoragePath is not present in cloud credentials..... ");
                    System.exit(1);
                }
                String pathhh = localStoragePath;
                Date date = Calendar.getInstance().getTime();
                SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy hh:mm:ss");
                String strDate = dateFormat.format(date);
                System.out.println("....STARTprocessing for user......" + strDate);
                FileWriter fileWriter = new FileWriter(String.valueOf(file.getParent()) + "/" + userName + "_delete_list.sh");
                PrintWriter printWriter = new PrintWriter(fileWriter);
                AtomicInteger deletenoOfFiles = new AtomicInteger(0);
                ArrayList<String> pathList = new ArrayList<String>();
                while (sc.hasNextLine()) {
                    String fileName = sc.nextLine();
                    pathList.add(fileName);
                }
                sc.close();
                pathList.parallelStream().forEach(p -> {
                    String fileName = p;
                    System.out.println("..filename..." + fileName);
                    String completeFilePath = String.valueOf(pathhh) + "/backup/" + userName + "/1/" + fileName;
                    System.out.println(deletenoOfFiles + "/" + pathList.size() + "....completepath .... " + completeFilePath);
                    String md5 = CheckChunkDetailExists.getMd5FromFileName(fileName);
                    String chunkDetailCollection = CheckChunkDetailExists.getChunkNewCollectionName(md5);
                    System.out.println(String.valueOf(md5) + "....md51 and table .... " + chunkDetailCollection);
                    MongoCollection<Document> chunkDetailTable = db.getCollection(chunkDetailCollection);
                    ArrayList<BasicDBObject> whereQuery = new ArrayList<BasicDBObject>();
                    whereQuery.add(new BasicDBObject("md5", md5));
                    BasicDBObject andQuery = new BasicDBObject();
                    andQuery.put("$and", whereQuery);
                    FindIterable<Document> chunkDetailsList = chunkDetailTable.find(andQuery);
                    boolean eligibleForDeletion = true;
                    for (Document document : chunkDetailsList) {
                        Integer refCount = document.getInteger("refCount");
                        String chunkUser = document.getString("userName");
                        if (refCount > 0) {
                            System.out.println(refCount + "...chunk refcount and user ......" + chunkUser);
                            eligibleForDeletion = false;
                        }
                        if (refCount != 1 || userName.equalsIgnoreCase(chunkUser)) continue;
                        String newPath = String.valueOf(pathhh) + "/backup/" + chunkUser + "/1/" + fileName;
                        System.out.println(String.valueOf(userName) + "..check this user!@!@....." + chunkUser + "....." + newPath);
                        if (!new File(newPath).exists()) continue;
                        System.out.println(".....file..." + fileName + "....exists ... in diff user..." + chunkUser);
                        eligibleForDeletion = true;
                    }
                    if (eligibleForDeletion) {
                        deletenoOfFiles.incrementAndGet();
                        printWriter.println("rm " + completeFilePath);
                    }
                    noOfFiles.incrementAndGet();
                    System.out.println(deletenoOfFiles + "/" + pathList.size() + "....chunkdelet..." + noOfFiles + "/" + pathList.size());
                });
                String endDate = CheckChunkDetailExists.getDateInFormat(System.currentTimeMillis());
                System.out.println(String.valueOf(strDate) + "....completed..." + endDate);
                printWriter.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(1);
            }
            System.exit(0);
        }
        catch (Exception e) {
            System.out.println("Exception..." + e.getMessage());
            e.printStackTrace();
        }
    }

    private static String getChunkNewCollectionName(String md5) {
        int hashCode = Arrays.hashCode(md5.getBytes());
        int chunkDetailDest = Math.abs(hashCode % 101);
        return "CHUNK_DETAIL_" + chunkDetailDest;
    }

    private static boolean checkIfUserExists(String userName, MongoDatabase db) {
        boolean isUserExists = false;
        MongoCollection<Document> userColl = db.getCollection("USER");
        BasicDBObject userQuery = CheckChunkDetailExists.userQuery(userName);
        FindIterable<Document> users = userColl.find(userQuery);
        for (Document document : users) {
            System.out.println("....user.... " + document.getString("userName"));
            isUserExists = true;
        }
        MongoCollection<Document> deletedUserColl = db.getCollection("DELETED_USER");
        users = deletedUserColl.find(userQuery);
        for (Document document : users) {
            System.out.println(".... deleteduser.... " + document.getString("userName"));
            isUserExists = true;
        }
        return isUserExists;
    }

    private static BasicDBObject userQuery(String userName) {
        ArrayList<BasicDBObject> whereQuery = new ArrayList<BasicDBObject>();
        whereQuery.add(new BasicDBObject("userName", userName));
        BasicDBObject andQuery = new BasicDBObject();
        andQuery.put("$and", whereQuery);
        return andQuery;
    }

    private static String getMd5FromFileName(String fileName) {
        int occurance = StringUtils.countMatches(fileName, ".");
        String md5 = "";
        if (occurance == 0) {
            md5 = fileName;
        } else if (occurance == 1) {
            md5 = fileName.substring(0, fileName.lastIndexOf(46));
        } else if (occurance > 1) {
            md5 = fileName.substring(fileName.indexOf(46) + 1, fileName.lastIndexOf(46));
        }
        if (StringUtils.isNotEmpty(md5) && md5.contains("_")) {
            md5 = md5.substring(0, md5.lastIndexOf("_"));
        }
        return md5;
    }
}

