# Create log file with timestamp in a persistent location
LOG_DIR="/var/log/parablu"
LOG_FILE="$LOG_DIR/parablu_script_$(date +%Y%m%d_%H%M%S).log"

# Create log directory if it doesn't exist
mkdir -p "$LOG_DIR" 2>/dev/null || {
    # Fallback to /var/log if we can't create /var/log/parablu
    LOG_FILE="/var/log/parablu_script_$(date +%Y%m%d_%H%M%S).log"
}

echo "Script execution started. Detailed logs will be written to: $LOG_FILE"

# Function to log commands while keeping echo visible
log_exec() {
    echo "[$(/bin/date '+%Y-%m-%d %H:%M:%S')] $*" >> "$LOG_FILE" 2>&1
    "$@" >> "$LOG_FILE" 2>&1
}

PARABLU_COMPONENT_SCRIPT_PATH=../../config/parablu_component_config.sh
PARABLU_CONFIG_SCRIPT_PATH=../../config/parablu_config.sh

source $PARABLU_COMPONENT_SCRIPT_PATH
source $PARABLU_CONFIG_SCRIPT_PATH

if [ "$SERVER_TYPE" == "0" ] || [ "$SERVER_TYPE" == "1 2" ] || [ "$SERVER_TYPE" == "3 1" ]; then
        FILE2=Portal_V2.zip
        if [ -f "$FILE2" ]; then
                echo "Setting up Portal V2..."
                log_exec rm -rf /var/www/portal/*
                log_exec cp -r Portal_V2.zip /var/www/portal/
                cd /var/www/portal/
                        ##new portal extraction
                        echo "Extracting Portal V2..."
                        log_exec unzip -oqq Portal_V2.zip
                        log_exec rm -rf Portal_V2.zip
                        log_exec chmod -R 755 *
                        log_exec chown -R www-data:www-data *
                cd -

                        ##newportal config.json changes
                        echo "Configuring Portal V2 settings..."
                        log_exec sed -i "s|devangular|$NG_IP|"  /var/www/portal/assets/config.json
                        log_exec sed -i "s|multicloud|$CLOUD_NAME|"  /var/www/portal/assets/config.json
                        log_exec sed -i "s|pbengg-redirect.parablu.com|$NG_RL|" /var/www/portal/assets/config.json
                        log_exec sed -i "s|mycloud.parablu.com|$BLUVAULT_IP|" /var/www/portal/assets/config.json

                        ##new portal index.html changes
                        log_exec sed -i '6s|<base href="/">|<base href="/devangular/portal/">|' /var/www/portal/index.html
                        log_exec sed -i "s|devangular|$NG_IP|" /var/www/portal/index.html

			##old .htacess
			log_exec sed -i "s|HOST|$NG_IP|"  indexnew.html
                	log_exec cp -rp  indexnew.html index.html
                	log_exec cp -rp index.html /var/www/

        fi
fi

if [ "$SERVER_TYPE" == "0" ] || [ "$SERVER_TYPE" == "1 2" ] || [ "$SERVER_TYPE" == "3 1" ]; then

         ##new portal .htaccess
                        echo "Configuring portal .htaccess..."
                        log_exec cp -rp  htaccessnginix .htaccess
                        log_exec chown -R  www-data:www-data .htaccess
                        log_exec cp -rp .htaccess /var/www/portal/
fi

if [ "$SERVER_TYPE" == "0" ] || [ "$SERVER_TYPE" == "1 2" ] || [ "$SERVER_TYPE" == "3 1" ]; then
	dbport=$(grep port: /etc/mongod.conf)
        MONGODB_PORT=$(echo $dbport | sed -e 's/port://' | sed 's/"//g' | tr -d ' ')

        echo "Configuring Tomcat services..."
        log_exec cp -r /parablu/pb-cloudproperty.properties /var/lib/tomcat-pcb1/webapps/paralite/WEB-INF/classes/
        log_exec cp -r /parablu/pb-credential.properties /var/lib/tomcat-pcb1/webapps/paralite/WEB-INF/classes/
        echo "Stopping Tomcat services..."
        log_exec service tomcat-pcb1 stop
        log_exec service tomcat-job1 stop
        sleep 2s
        cd /var/lib/tomcat-pcb1/webapps/
        log_exec rm -rf paralite.war
        sleep 1s
        cd -
        sleep 2s
        echo "Starting Tomcat services..."
        log_exec service tomcat-pcb1 restart
        log_exec service tomcat-job1 restart
fi

if [ "$SERVER_TYPE" == "0" ] || [ "$SERVER_TYPE" == "3" ] || [ "$SERVER_TYPE" == "3 1" ]; then
	dbport=$(grep port: /etc/mongod.conf)
        MONGODB_PORT=$(echo $dbport | sed -e 's/port://' | sed 's/"//g' | tr -d ' ')

        echo "Setting up Excel files..."
        log_exec chown -R tomcat:parablu Users.xlsx
        log_exec cp -rp Users.xlsx /parablu/bkpOverview/

        log_exec chown -R tomcat:parablu bulkCreateUsers.xlsx
        log_exec cp -rp bulkCreateUsers.xlsx /parablu/bkpOverview/

        log_exec chown -R tomcat:parablu  bulkBlockUnblockDeleteAssets.xlsx
        log_exec cp -rp bulkBlockUnblockDeleteAssets.xlsx /parablu/bkpOverview/

        log_exec chown -R tomcat:parablu bulkBlockUnblockDeleteUsers.xlsx
        log_exec cp -rp bulkBlockUnblockDeleteUsers.xlsx /parablu/bkpOverview/

        log_exec chown -R tomcat:parablu bulkBlockUnblockDeleteUsersAdvanced.xlsx
        log_exec cp -rp bulkBlockUnblockDeleteUsersAdvanced.xlsx /parablu/bkpOverview/

	log_exec chown -R tomcat:parablu  bulkBackupTargetMapping.xlsx
        log_exec cp -rp bulkBackupTargetMapping.xlsx /parablu/bkpOverview/

fi

if [ "$SERVER_TYPE" == "0" ] || [ "$SERVER_TYPE" == "1 2" ] || [ "$SERVER_TYPE" == "3 1" ] || [ "$SERVER_TYPE" == "2" ]; then
    # Get MongoDB port
    dbport=$(grep port: /etc/mongod.conf)
    MONGODB_PORT=$(echo $dbport | sed -e 's/port://' | sed 's/"//g' | tr -d ' ')
	
    # ==========================================
    # Extract DNS credentials from MongoDB
    # ==========================================
    echo "Extracting DNS credentials from MongoDB..."

    cat > getdnsdetails.js <<'EOF'
use parablu

var usernameval = db.CLOUD_PROPERTIES.findOne({}, { _id: 0, dnsUserName: 1 });
print("DNS_USERNAME=" + (usernameval && usernameval.dnsUserName));

var passwordval = db.CLOUD_PROPERTIES.findOne({}, { _id: 0, dnsPassword: 1 });
print("DNS_PASSWORD=" + (passwordval && passwordval.dnsPassword));
EOF

    sudo mongo --quiet localhost:$MONGODB_PORT -u "neil" -p "parablu" --authenticationDatabase "admin" \
        < getdnsdetails.js > getdnsdetails

    # Log the MongoDB command execution
    echo "[$(/bin/date '+%Y-%m-%d %H:%M:%S')] MongoDB getdnsdetails.js executed" >> "$LOG_FILE"

    DNS_USERNAME=$(grep "DNS_USERNAME=" getdnsdetails | cut -d= -f2 | tr -d '[:space:]')
    DNS_PASSWORD=$(grep "DNS_PASSWORD=" getdnsdetails | cut -d= -f2 | tr -d '[:space:]')

    echo "Extracted DNS_USERNAME: $DNS_USERNAME" >> "$LOG_FILE"
    echo "Extracted DNS_PASSWORD: [REDACTED]" >> "$LOG_FILE"

    # Clean up temporary file
    log_exec rm -f getdnsdetails.js getdnsdetails

    # ==========================================
    # IDP Migration: Check and Run UpdateIDPSettings.jar
    # ==========================================
    echo "Checking IDENTITY_PROVIDER_SETTINGS collection..."

    cat > check_idp_collection.js << 'EOF'
use parablu001
var count = db.IDENTITY_PROVIDER_SETTINGS.find().count();
print("IDP_COUNT=" + count);
EOF

    sudo mongo --quiet localhost:$MONGODB_PORT -u "neil" -p "parablu" --authenticationDatabase "admin" \
        < check_idp_collection.js > check_idp_collection

    # Log the MongoDB command execution
    echo "[$(/bin/date '+%Y-%m-%d %H:%M:%S')] MongoDB check_idp_collection.js executed" >> "$LOG_FILE"

    IDP_COUNT=$(grep "IDP_COUNT=" check_idp_collection | cut -d= -f2 | tr -d '[:space:]')

    if [ "$IDP_COUNT" -eq 0 ]; then
        echo "IDENTITY_PROVIDER_SETTINGS collection not found. Running UpdateIDPSettings.jar..."

        # Create temporary directory for JAR execution
        TEMP_DIR="/tmp/idp_update"
        log_exec mkdir -p "$TEMP_DIR"
        cd "$TEMP_DIR"

        # Download the JAR file and config
        JAR_URL="https://dns.parablu.com/parablu_installables/release/PRE_POST/2.6.3/post-commands/UpdateIDPSettings.jar"
        CONFIG_URL="https://dns.parablu.com/parablu_installables/release/PRE_POST/2.6.3/post-commands/config.txt"

        echo "Downloading UpdateIDPSettings.jar..."
        log_exec wget --user="${DNS_USERNAME}" --password="${DNS_PASSWORD}" \
            --no-check-certificate \
            -O "UpdateIDPSettings.jar" \
            "$JAR_URL"

        if [ $? -ne 0 ] || [ ! -f "UpdateIDPSettings.jar" ] || [ ! -s "UpdateIDPSettings.jar" ]; then
            echo "ERROR: Failed to download UpdateIDPSettings.jar"
            cd -
            log_exec rm -rf "$TEMP_DIR"
        else
            echo "Downloading config.txt..."
            log_exec wget --user="${DNS_USERNAME}" --password="${DNS_PASSWORD}" \
                --no-check-certificate \
                -O "config.txt" \
                "$CONFIG_URL"

            if [ $? -ne 0 ] || [ ! -f "config.txt" ] || [ ! -s "config.txt" ]; then
                echo "ERROR: Failed to download config.txt"
                cd -
                log_exec rm -rf "$TEMP_DIR"
            else
                echo "Files downloaded successfully. Executing UpdateIDPSettings.jar..."

                # Execute the JAR with config parameter
                java -jar UpdateIDPSettings.jar config.txt >> "$LOG_FILE" 2>&1

                JAR_EXIT_CODE=$?

                if [ $JAR_EXIT_CODE -eq 0 ]; then
                    echo "UpdateIDPSettings.jar executed successfully"
                else
                    echo "ERROR: UpdateIDPSettings.jar execution failed with exit code: $JAR_EXIT_CODE"
                fi

                # Clean up
                cd -
                log_exec rm -rf "$TEMP_DIR"

                echo "UpdateIDPSettings.jar execution completed."
            fi
        fi
    else
        echo "IDENTITY_PROVIDER_SETTINGS collection already exists (count: $IDP_COUNT). Skipping IDP migration."
    fi
fi
