# Create log file with timestamp in a persistent location
LOG_DIR="/var/log/parablu"
LOG_FILE="$LOG_DIR/parablu_script_$(date +%Y%m%d_%H%M%S).log"

# Create log directory if it doesn't exist
mkdir -p "$LOG_DIR" 2>/dev/null || {
    # Fallback to /var/log if we can't create /var/log/parablu
    LOG_FILE="/var/log/parablu_script_$(date +%Y%m%d_%H%M%S).log"
}

echo "Script execution started. Detailed logs will be written to: $LOG_FILE"

# Function to log commands while keeping echo visible
log_exec() {
    echo "[$(/bin/date '+%Y-%m-%d %H:%M:%S')] $*" >> "$LOG_FILE" 2>&1
    "$@" >> "$LOG_FILE" 2>&1
}

PARABLU_COMPONENT_SCRIPT_PATH=../../config/parablu_component_config.sh
PARABLU_CONFIG_SCRIPT_PATH=../../config/parablu_config.sh

source $PARABLU_COMPONENT_SCRIPT_PATH
source $PARABLU_CONFIG_SCRIPT_PATH

if [ "$SERVER_TYPE" == "0" ] || [ "$SERVER_TYPE" == "1 2" ] || [ "$SERVER_TYPE" == "3 1" ]; then
        FILE2=Portal_V2.zip
        if [ -f "$FILE2" ]; then
                echo "Setting up Portal V2..."
                log_exec rm -rf /var/www/portal/*
                log_exec cp -r Portal_V2.zip /var/www/portal/
                cd /var/www/portal/
                        ##new portal extraction
                        echo "Extracting Portal V2..."
                        log_exec unzip -oqq Portal_V2.zip
                        log_exec rm -rf Portal_V2.zip
                        log_exec chmod -R 755 *
                        log_exec chown -R www-data:www-data *
                cd -

                        ##newportal config.json changes
                        echo "Configuring Portal V2 settings..."
                        log_exec sed -i "s|devangular|$NG_IP|"  /var/www/portal/assets/config.json
                        log_exec sed -i "s|multicloud|$CLOUD_NAME|"  /var/www/portal/assets/config.json
                        log_exec sed -i "s|pbengg-redirect.parablu.com|$NG_RL|" /var/www/portal/assets/config.json
                        log_exec sed -i "s|mycloud.parablu.com|$BLUVAULT_IP|" /var/www/portal/assets/config.json

                        ##new portal index.html changes
                        log_exec sed -i '6s|<base href="/">|<base href="/devangular/portal/">|' /var/www/portal/index.html
                        log_exec sed -i "s|devangular|$NG_IP|" /var/www/portal/index.html

			##old .htacess
			log_exec sed -i "s|HOST|$NG_IP|"  indexnew.html
                	log_exec cp -rp  indexnew.html index.html
                	log_exec cp -rp index.html /var/www/

        fi
fi

if [ "$SERVER_TYPE" == "0" ] || [ "$SERVER_TYPE" == "1 2" ] || [ "$SERVER_TYPE" == "3 1" ]; then

         ##new portal .htaccess
                        echo "Configuring portal .htaccess..."
                        log_exec cp -rp  htaccessnginix .htaccess
                        log_exec chown -R  www-data:www-data .htaccess
                        log_exec cp -rp .htaccess /var/www/portal/
fi

if [ "$SERVER_TYPE" == "0" ] || [ "$SERVER_TYPE" == "1 2" ] || [ "$SERVER_TYPE" == "3 1" ]; then
	dbport=$(grep port: /etc/mongod.conf)
        MONGODB_PORT=$(echo $dbport | sed -e 's/port://' | sed 's/"//g' | tr -d ' ')

        echo "Configuring Tomcat services..."
        #log_exec cp -r /parablu/pb-cloudproperty.properties /var/lib/tomcat-pcb1/webapps/paralite/WEB-INF/classes/
        #log_exec cp -r /parablu/pb-credential.properties /var/lib/tomcat-pcb1/webapps/paralite/WEB-INF/classes/
	#log_exec cp -r /parablu/paracloud-pb-credential/pb-credential.properties /var/lib/tomcat-pcb1/webapps/paracloud/WEB-INF/classes/
	#log_exec cp -r /parablu/paracloudjob-pb-credential/pb-credential.properties /var/lib/tomcat-job1/webapps/paracloudjob/WEB-INF/classes/
	#log_exec cp -r /parablu/support-pb-credential/pb-credential.properties /var/lib/tomcat-pcb1/webapps/support/WEB-INF/classes/
	#log_exec cp -r /parablu/paramail-pb-credential/pb-credential.properties /var/lib/tomcat-pcb1/webapps/paramail/WEB-INF/classes/

        echo "Stopping Tomcat services..."
        log_exec service tomcat-pcb1 stop
        log_exec service tomcat-job1 stop
        sleep 2s
        cd /var/lib/tomcat-pcb1/webapps/
        log_exec rm -rf paralite.war
        sleep 1s
        cd -
        sleep 2s
        echo "Starting Tomcat services..."
        log_exec service tomcat-pcb1 restart
        log_exec service tomcat-job1 restart
fi

if [ "$SERVER_TYPE" == "0" ] || [ "$SERVER_TYPE" == "3" ] || [ "$SERVER_TYPE" == "3 1" ]; then
	dbport=$(grep port: /etc/mongod.conf)
        MONGODB_PORT=$(echo $dbport | sed -e 's/port://' | sed 's/"//g' | tr -d ' ')

        echo "Setting up Excel files..."
        log_exec chown -R tomcat:parablu Users.xlsx
        log_exec cp -rp Users.xlsx /parablu/bkpOverview/

        log_exec chown -R tomcat:parablu bulkCreateUsers.xlsx
        log_exec cp -rp bulkCreateUsers.xlsx /parablu/bkpOverview/

        log_exec chown -R tomcat:parablu  bulkBlockUnblockDeleteAssets.xlsx
        log_exec cp -rp bulkBlockUnblockDeleteAssets.xlsx /parablu/bkpOverview/

        log_exec chown -R tomcat:parablu bulkBlockUnblockDeleteUsers.xlsx
        log_exec cp -rp bulkBlockUnblockDeleteUsers.xlsx /parablu/bkpOverview/

        log_exec chown -R tomcat:parablu bulkBlockUnblockDeleteUsersAdvanced.xlsx
        log_exec cp -rp bulkBlockUnblockDeleteUsersAdvanced.xlsx /parablu/bkpOverview/

	log_exec chown -R tomcat:parablu  bulkBackupTargetMapping.xlsx
        log_exec cp -rp bulkBackupTargetMapping.xlsx /parablu/bkpOverview/

fi

if [ "$SERVER_TYPE" == "0" ] || [ "$SERVER_TYPE" == "1 2" ] || [ "$SERVER_TYPE" == "3 1" ] || [ "$SERVER_TYPE" == "2" ]; then
    # ==========================================
    # COMMON CHANGES FOR SINGLE AND MULTI TENANCY SETUPS
    # ==========================================

    echo "Stopping Tomcat services..."
    log_exec service tomcat-pcb1 stop
    log_exec service tomcat-job1 stop
    sleep 2s
    cd /var/lib/tomcat-pcb1/webapps/
    log_exec rm -rf paralite.war
    sleep 1s
    cd -
    sleep 2s
    echo "Starting Tomcat services..."
    log_exec service tomcat-pcb1 restart
    log_exec service tomcat-job1 restart

    # ==========================================
    # Update /var/www/index.html with Redirect
    # ==========================================
    echo "=== Updating /var/www/index.html with redirect code ==="

    INDEX_HTML="/var/www/index.html"

    if [ -f "$INDEX_HTML" ]; then
        echo "Processing $INDEX_HTML..."

        # Create backup
        log_exec cp "$INDEX_HTML" "${INDEX_HTML}.backup_$(date +%Y%m%d_%H%M%S)"
        echo "Backup created for $INDEX_HTML"

        # Replace entire content with new redirect HTML
        cat > "$INDEX_HTML" << 'INDEX_HTML_EOF'
<!DOCTYPE html>
<html>
<head>
    <title>Redirecting Page</title>
    <script type="text/javascript">
        // This script will run as soon as the browser processes it
        window.location.href = "./portal/";
    </script>
</head>
<body>
    <p>If you are not redirected automatically, follow this <a href="./portal/">link to the portal</a>.</p>
</body>
INDEX_HTML_EOF

        echo "Successfully updated $INDEX_HTML with redirect code"
        echo "[$(/bin/date '+%Y-%m-%d %H:%M:%S')] Updated /var/www/index.html with portal redirect" >> "$LOG_FILE"
    else
        echo "Warning: File $INDEX_HTML not found - skipping."
    fi

    echo "/var/www/index.html update completed."

    echo "Restarting Apache 4..."
    if service apache4 restart >> "$LOG_FILE" 2>&1; then
        echo "Apache 4 restarted successfully"
    else
        echo "ERROR: Failed to restart Apache 4"
        echo "[$(/bin/date '+%Y-%m-%d %H:%M:%S')] ERROR: Apache 4 restart failed" >> "$LOG_FILE"
    fi

    # ==========================================
    # 14-10-2025: Add <bean> configuration (COMMON CHANGE)
    # ==========================================
    XML_FILES=(
        "/var/lib/tomcat-pcb1/webapps/paralite/WEB-INF/classes/spring-config/dao-context.xml"
        "/var/lib/tomcat-job1/webapps/paracloudjob/WEB-INF/classes/spring-config/dao-context.xml"
    )

    for XML_FILE in "${XML_FILES[@]}"; do
        if [ ! -f "$XML_FILE" ]; then
            echo "File not found: $XML_FILE skipping."
            continue
        fi

        echo "Processing $XML_FILE..."

        if grep -q 'id="syncFileDao"' "$XML_FILE"; then
            echo "Warning: syncFileDao bean already exists in $XML_FILE. No changes made."
        else
            sed -i '/<\/beans>/i \
                    <bean id="syncFileDao" class="com.parablu.pcsd.dao.impl.SyncFileDaoImpl">\
                            <property name="paracloudMongoFactoryUtils" ref="paracloudMongoFactoryUtils" />\
                    </bean>' "$XML_FILE"

            echo "syncFileDao bean successfully added to $XML_FILE"
        fi
    done

    # ==========================================
    # TENANCY TYPE SELECTION
    # ==========================================
    echo ""
    echo "=== Tenancy Setup Selection ==="

    while true; do
        echo "Is this a Single Tenancy or Multi Tenancy setup?"
        echo "1. Single Tenancy Setup"
        echo "2. Multi Tenancy Setup"
        read -p "Please select (1 or 2): " TENANCY_TYPE

        if [ "$TENANCY_TYPE" == "1" ]; then
            echo "You selected: Single Tenancy Setup"
            echo "[$(/bin/date '+%Y-%m-%d %H:%M:%S')] Selected: Single Tenancy Setup" >> "$LOG_FILE"
            echo ""
            echo "Single Tenancy setup is already configured. Skipping folder movement operations."
            echo "[$(/bin/date '+%Y-%m-%d %H:%M:%S')] Single Tenancy setup already done - skipping folder operations" >> "$LOG_FILE"
            break

        elif [ "$TENANCY_TYPE" == "2" ]; then
            echo "You selected: Multi Tenancy Setup"
            echo "[$(/bin/date '+%Y-%m-%d %H:%M:%S')] Selected: Multi Tenancy Setup" >> "$LOG_FILE"

            # ==========================================
            # Move BluKryptBuilder, ParacloudSearch, and paracloud to Home Directory
            # ==========================================
            echo "=== Moving BluKryptBuilder, ParacloudSearch, and paracloud to Home Directory ==="

            WEBAPPS_PCB1_DIR="/var/lib/tomcat-pcb1/webapps"
            PCB1_TARGETS=("BluKryptBuilder" "ParacloudSearch" "paracloud")

            echo "Starting cleanup in: $WEBAPPS_PCB1_DIR"
            cd "$WEBAPPS_PCB1_DIR" || { echo "Directory not found: $WEBAPPS_PCB1_DIR"; exit 1; }

            for dir in "${PCB1_TARGETS[@]}"; do
                if [ -d "$dir" ]; then
                    echo "Moving directory: $dir"
                    # Delete destination if it exists
                    if [ -d "/home/ubuntu/$dir" ]; then
                        echo "Removing existing directory at destination: /home/ubuntu/$dir"
                        log_exec sudo rm -rf "/home/ubuntu/$dir"
                    fi
                    log_exec sudo mv "$dir" /home/ubuntu/
                else
                    echo "Directory not found, skipping: $dir"
                fi
            done

            echo "BluKryptBuilder, ParacloudSearch, and paracloud moved successfully."


            # ==========================================
            # Move BluKryptJob, MSJob and paracloudjob to Home Directory
            # ==========================================
            echo "=== Moving BluKryptJob, MSJob and paracloudjob to Home Directory ==="

            WEBAPPS_JOB1_DIR="/var/lib/tomcat-job1/webapps"
            JOB1_TARGETS=("BluKryptJob" "MSJob" "paracloudjob")

            echo "Starting cleanup in: $WEBAPPS_JOB1_DIR"
            cd "$WEBAPPS_JOB1_DIR" || { echo "Directory not found: $WEBAPPS_JOB1_DIR"; exit 1; }

            for dir in "${JOB1_TARGETS[@]}"; do
                if [ -d "$dir" ]; then
                    echo "Moving directory: $dir"
                    # Delete destination if it exists
                    if [ -d "/home/ubuntu/$dir" ]; then
                        echo "Removing existing directory at destination: /home/ubuntu/$dir"
                        log_exec sudo rm -rf "/home/ubuntu/$dir"
                    fi
                    log_exec sudo mv "$dir" /home/ubuntu/
                else
                    echo "Directory not found, skipping: $dir"
                fi
            done

            echo "BluKryptJob, MSJob and paracloudjob moved successfully."
            break

        else
            echo "Invalid selection. Please choose 1 or 2."
            echo ""
        fi
    done

fi
