# Create log file with timestamp in a persistent location
LOG_DIR="/var/log/parablu"
LOG_FILE="$LOG_DIR/parablu_script_$(date +%Y%m%d_%H%M%S).log"

# Create log directory if it doesn't exist
mkdir -p "$LOG_DIR" 2>/dev/null || {
    # Fallback to /var/log if we can't create /var/log/parablu
    LOG_FILE="/var/log/parablu_script_$(date +%Y%m%d_%H%M%S).log"
}

echo "Script execution started. Detailed logs will be written to: $LOG_FILE"

# Function to log commands while keeping echo visible
log_exec() {
    echo "[$(/bin/date '+%Y-%m-%d %H:%M:%S')] $*" >> "$LOG_FILE" 2>&1
    "$@" >> "$LOG_FILE" 2>&1
}

PARABLU_COMPONENT_SCRIPT_PATH=../../config/parablu_component_config.sh
PARABLU_CONFIG_SCRIPT_PATH=../../config/parablu_config.sh

source $PARABLU_COMPONENT_SCRIPT_PATH
source $PARABLU_CONFIG_SCRIPT_PATH

if [ "$SERVER_TYPE" == "0" ] || [ "$SERVER_TYPE" == "1 2" ] || [ "$SERVER_TYPE" == "3 1" ]; then
        FILE2=Portal_V2.zip
        if [ -f "$FILE2" ]; then
                echo "Setting up Portal V2..."
                log_exec rm -rf /var/www/portal/*
                log_exec cp -r Portal_V2.zip /var/www/portal/
                cd /var/www/portal/
                        ##new portal extraction
                        echo "Extracting Portal V2..."
                        log_exec unzip -oqq Portal_V2.zip
                        log_exec rm -rf Portal_V2.zip
                        log_exec chmod -R 755 *
                        log_exec chown -R www-data:www-data *
                cd -

                        ##newportal config.json changes
                        echo "Configuring Portal V2 settings..."
                        log_exec sed -i "s|devangular|$NG_IP|"  /var/www/portal/assets/config.json
                        log_exec sed -i "s|multicloud|$CLOUD_NAME|"  /var/www/portal/assets/config.json
                        log_exec sed -i "s|pbengg-redirect.parablu.com|$NG_RL|" /var/www/portal/assets/config.json
                        log_exec sed -i "s|mycloud.parablu.com|$BLUVAULT_IP|" /var/www/portal/assets/config.json

                        ##new portal index.html changes
                        log_exec sed -i '6s|<base href="/">|<base href="/devangular/portal/">|' /var/www/portal/index.html
                        log_exec sed -i "s|devangular|$NG_IP|" /var/www/portal/index.html

			##old .htacess
			log_exec sed -i "s|HOST|$NG_IP|"  indexnew.html
                	log_exec cp -rp  indexnew.html index.html
                	log_exec cp -rp index.html /var/www/

        fi
fi

if [ "$SERVER_TYPE" == "0" ] || [ "$SERVER_TYPE" == "1 2" ] || [ "$SERVER_TYPE" == "3 1" ]; then

         ##new portal .htaccess
                        echo "Configuring portal .htaccess..."
                        log_exec cp -rp  htaccessnginix .htaccess
                        log_exec chown -R  www-data:www-data .htaccess
                        log_exec cp -rp .htaccess /var/www/portal/
fi

if [ "$SERVER_TYPE" == "0" ] || [ "$SERVER_TYPE" == "1 2" ] || [ "$SERVER_TYPE" == "3 1" ]; then
	dbport=$(grep port: /etc/mongod.conf)
        MONGODB_PORT=$(echo $dbport | sed -e 's/port://' | sed 's/"//g' | tr -d ' ')

        echo "Configuring Tomcat services..."
        log_exec cp -r /var/lib/tomcat-pcb1/webapps/paracloud/WEB-INF/classes/pb-cloudproperty.properties /var/lib/tomcat-pcb1/webapps/paralite/WEB-INF/classes/
        log_exec cp -r /var/lib/tomcat-pcb1/webapps/paracloud/WEB-INF/classes/pb-credential.properties /var/lib/tomcat-pcb1/webapps/paralite/WEB-INF/classes/
        echo "Stopping Tomcat services..."
        log_exec service tomcat-pcb1 stop 
        log_exec service tomcat-job1 stop
        sleep 2s
        cd /var/lib/tomcat-pcb1/webapps/
        log_exec rm -rf paralite.war
        sleep 1s
        cd -
        sleep 2s
        echo "Starting Tomcat services..."
        log_exec service tomcat-pcb1 restart 
        log_exec service tomcat-job1 restart
fi

if [ "$SERVER_TYPE" == "0" ] || [ "$SERVER_TYPE" == "1 2" ] || [ "$SERVER_TYPE" == "3 1" ] || [ "$SERVER_TYPE" == "2" ]; then
        # 24-07-2025: [PC-301] Run ClamAV Script
        echo "Configuring DNS details and ClamAV..."

cat > getdnsdetails.js <<'EOF'
use parablu

var usernameval = db.CLOUD_PROPERTIES.findOne({}, { _id: 0, dnsUserName: 1 });
print("DNS_USERNAME=" + (usernameval && usernameval.dnsUserName));

var passwordval = db.CLOUD_PROPERTIES.findOne({}, { _id: 0, dnsPassword: 1 });
print("DNS_PASSWORD=" + (passwordval && passwordval.dnsPassword));
EOF

	if [ "$SERVER_TYPE" == "2" ]; then
            sudo mongo --quiet $DB1_IP:$MONGODB_PORT -u "neil" -p "parablu" --authenticationDatabase "admin" \
                < getdnsdetails.js > getdnsdetails
        else
            sudo mongo --quiet localhost:$MONGODB_PORT -u "neil" -p "parablu" --authenticationDatabase "admin" \
                < getdnsdetails.js > getdnsdetails
        fi

        # Log the MongoDB command execution to log file
        echo "[$(/bin/date '+%Y-%m-%d %H:%M:%S')] MongoDB getdnsdetails.js executed" >> "$LOG_FILE"
        
        DNS_USERNAME=$(grep "DNS_USERNAME=" getdnsdetails | cut -d= -f2 | tr -d '[:space:]')
        DNS_PASSWORD=$(grep "DNS_PASSWORD=" getdnsdetails | cut -d= -f2 | tr -d '[:space:]')
        
        echo "Extracted DNS_USERNAME: $DNS_USERNAME" >> "$LOG_FILE"
        echo "Extracted DNS_PASSWORD: [REDACTED]" >> "$LOG_FILE"

	    if dpkg -l | grep -q clamav >> "$LOG_FILE" 2>&1; then
            echo "ClamAV already installed. Applying configuration changes..."

            # Only change MaxFileSize to 4000M
            if grep -q "^MaxFileSize" /etc/clamav/clamd.conf; then
                log_exec sed -i 's/^MaxFileSize.*/MaxFileSize 4000M/' /etc/clamav/clamd.conf
            else
                echo "MaxFileSize 4000M" >> /etc/clamav/clamd.conf
            fi

            echo "ClamAV configuration completed."
        else
            echo "ClamAV not installed. Running installation script..."

            # Download and run the official ClamAV installation script
            CLAM_SCRIPT_URL="https://dns.parablu.com/parablu_installables/release/PRE_POST/2.6.3/post-commands/clam.sh"
            CLAM_SCRIPT_LOCAL="/tmp/clam_install.sh"

            echo "Downloading ClamAV script from $CLAM_SCRIPT_URL..."

            log_exec wget --user="${DNS_USERNAME}" --password="${DNS_PASSWORD}" \
                --no-check-certificate \
                -O "$CLAM_SCRIPT_LOCAL" \
                "$CLAM_SCRIPT_URL"

            if [ $? -eq 0 ] && [ -f "$CLAM_SCRIPT_LOCAL" ] && [ -s "$CLAM_SCRIPT_LOCAL" ]; then
                echo "Download successful. Running ClamAV installation script..."
                log_exec chmod +x "$CLAM_SCRIPT_LOCAL"
                log_exec bash "$CLAM_SCRIPT_LOCAL"
                log_exec rm -f "$CLAM_SCRIPT_LOCAL"
            else
                echo "Failed to download ClamAV installation script"
            fi
        fi
fi

if [ "$SERVER_TYPE" == "0" ] || [ "$SERVER_TYPE" == "3" ] || [ "$SERVER_TYPE" == "3 1" ]; then
	dbport=$(grep port: /etc/mongod.conf)
        MONGODB_PORT=$(echo $dbport | sed -e 's/port://' | sed 's/"//g' | tr -d ' ')

        echo "Setting up Excel files..."
        log_exec chown -R tomcat:parablu Users.xlsx
        log_exec cp -rp Users.xlsx /parablu/bkpOverview/

        log_exec chown -R tomcat:parablu bulkCreateUsers.xlsx
        log_exec cp -rp bulkCreateUsers.xlsx /parablu/bkpOverview/

        log_exec chown -R tomcat:parablu  bulkBlockUnblockDeleteAssets.xlsx
        log_exec cp -rp bulkBlockUnblockDeleteAssets.xlsx /parablu/bkpOverview/

        log_exec chown -R tomcat:parablu bulkBlockUnblockDeleteUsers.xlsx
        log_exec cp -rp bulkBlockUnblockDeleteUsers.xlsx /parablu/bkpOverview/

        log_exec chown -R tomcat:parablu bulkBlockUnblockDeleteUsersAdvanced.xlsx
        log_exec cp -rp bulkBlockUnblockDeleteUsersAdvanced.xlsx /parablu/bkpOverview/

	log_exec chown -R tomcat:parablu  bulkBackupTargetMapping.xlsx
        log_exec cp -rp bulkBackupTargetMapping.xlsx /parablu/bkpOverview/

	# 24-07-2025: [PC-324] Excel File
        log_exec chown -R tomcat:parablu bulkBlockUnblockDeleteSites.xlsx
        log_exec cp -rp bulkBlockUnblockDeleteSites.xlsx /parablu/bkpOverview/

	# 17-07-2025: [PC-314], [PC-313] and [PC-326]
        # Enable technical support access in CLOUD_PROPERTIES
        # Add 'Endpoint Restore AV Scan' to CLOUD_CUSTOMIZABLE_DETAILS
        # Set daysToKeepServerLogs to '7' in CLOUD_PROPERTIES
	# 31-07-2025: [PC-340] Update clientMailName and clientSupportMailName

        echo "Applying CLOUD_PROPERTIES updates: techsupportaccess, Endpoint Restore AV Scan, and daysToKeepServerLogs..."

        cat > update_cloud_props_and_customizable_details.js << EOF
use parablu

db.CLOUD_PROPERTIES.updateMany({}, { \$set: { "techsupportaccess": true } })

db.CLOUD_CUSTOMIZABLE_DETAILS.updateOne(
  { "_id": ObjectId("58afc0c3fe617d5c50854d23") },
  { \$set: { "name": "Endpoint Restore AV Scan" } },
  { upsert: true }
)

db.CLOUD_PROPERTIES.updateMany({}, { "\$set": {"daysToKeepServerLogs": 7}})

db.CLOUD_PROPERTIES.updateMany({}, { "\$set": {"clientMailName": "CrashPlan"}})

db.CLOUD_PROPERTIES.updateMany({}, { "\$set": {"clientSupportMailName": "support@crashplan.com"}})

db.CLOUD_PROPERTIES.updateMany({}, { "\$set": {"maxItemsAllowedInPstExportWhileSearch": 500}})

db.CLOUD_PROPERTIES.updateMany({}, { "\$set": {"localSolr": true}});

db.CLOUD.updateMany({}, { "\$set": {"cloudSizeAllowedPercentage": 100}})
EOF

        log_exec sudo mongo --quiet localhost:$MONGODB_PORT -u "neil" -p "parablu" --authenticationDatabase "admin" \
            < update_cloud_props_and_customizable_details.js

        echo "CLOUD_PROPERTIES and CLOUD_CUSTOMIZABLE_DETAILS updated successfully."

        # 21-07-2025: [PC-306]
        # Configure serviceaccount.json
        echo "Configuring service account..."

        cat > geturldetails.js <<'EOF'
use parablu

var cloudval = db.CLOUD.findOne({}, { _id: 0, cloudName: 1 });
print("CLOUD_NAME=" + (cloudval && cloudval.cloudName));

var usernameval = db.CLOUD_PROPERTIES.findOne({}, { _id: 0, dnsUserName: 1 });
print("DNS_USERNAME=" + (usernameval && usernameval.dnsUserName));

var passwordval = db.CLOUD_PROPERTIES.findOne({}, { _id: 0, dnsPassword: 1 });
print("DNS_PASSWORD=" + (passwordval && passwordval.dnsPassword));

use parablu001

var portalurlval = db.PRIVACY_GATEWAY.findOne({}, { _id: 0, "componentsProperties.paracloudUrl": 1 });
print("PORTAL_URL=" + (portalurlval && portalurlval.componentsProperties && portalurlval.componentsProperties.paracloudUrl));
EOF

        sudo mongo --quiet localhost:$MONGODB_PORT -u "neil" -p "parablu" --authenticationDatabase "admin" \
            < geturldetails.js > geturldetails

        # Log the MongoDB command execution to log file
        echo "[$(/bin/date '+%Y-%m-%d %H:%M:%S')] MongoDB geturldetails.js executed" >> "$LOG_FILE"

        CLOUD_NAME=$(grep "CLOUD_NAME=" geturldetails | cut -d= -f2 | tr -d '[:space:]')
        DNS_USERNAME=$(grep "DNS_USERNAME=" geturldetails | cut -d= -f2 | tr -d '[:space:]')
        DNS_PASSWORD=$(grep "DNS_PASSWORD=" geturldetails | cut -d= -f2 | tr -d '[:space:]')
        PORTAL_URL=$(grep "PORTAL_URL=" geturldetails | cut -d= -f2 | tr -d '[:space:]')
        
        echo "Extracted CLOUD_NAME: $CLOUD_NAME" >> "$LOG_FILE"
        echo "Extracted DNS_USERNAME: $DNS_USERNAME" >> "$LOG_FILE"
        echo "Extracted DNS_PASSWORD: [REDACTED]" >> "$LOG_FILE"
        echo "Extracted PORTAL_URL: $PORTAL_URL" >> "$LOG_FILE"

        # Initial setup
        echo "Preparing installation directory..."

        # Create service account directory
        log_exec sudo mkdir -p /parablu/Serviceaccount

        # Download service account file
        echo "Downloading service account file..."
        log_exec sudo wget --user="${DNS_USERNAME}" --password="${DNS_PASSWORD}" -O /parablu/Serviceaccount/serviceaccount.json https://dns.parablu.com/parablu_installables/gmail/serviceaccount.json

        if [ ! -f "/parablu/Serviceaccount/serviceaccount.json" ] || [ ! -s "/parablu/Serviceaccount/serviceaccount.json" ]; then
            echo "ERROR: serviceaccount.json download failed or file is empty"
        else
            echo "serviceaccount.json downloaded successfully"
        fi

        # Set permissions and ownership
        log_exec sudo chmod -R 775 /parablu/Serviceaccount/
        log_exec sudo chown -R tomcat:tomcat /parablu/Serviceaccount/
        
	# Pinging ParaLite
        for i in {1..5}; do
            echo "Pinging paralite (Attempt $i)..."
            echo "URL: https://localhost/paralite/ping/"
            
            # Capture the HTTP status code
            STATUS_CODE=$(curl -s -o /dev/null -w "%{http_code}" \
            --connect-timeout 60 --max-time 180 \
            -X GET "https://localhost/paralite/ping/" \
            -H "key: test" --insecure 2>> "$LOG_FILE")

            echo "Status Code: $STATUS_CODE"

            if [ "$STATUS_CODE" -eq 400 ]; then
                echo "Paralite responded with 400 (acceptable), continuing..."
                break
            elif [ "$i" -eq 5 ]; then
                echo "ParaLite ping failed after 5 attempts."
            else
                echo "Attempt $i failed with status $STATUS_CODE. Retrying in 20 seconds..."
                sleep 60
            fi
        done

        # Service Account POST Command
        echo "Configuring Service Account for ${CLOUD_NAME}..."

        SUCCESS=false
        
	for i in {1..3}; do
            echo "Attempt $i to configure service account..."

            RESPONSE=$(curl -s -w "\nHTTP_STATUS_CODE:%{http_code}" \
                --connect-timeout 60 --max-time 180 \
                -X POST "https://localhost/paralite/cloud/${CLOUD_NAME}/save/serviceaccount/" \
                -H "internalCall: true" \
                -H "Content-Type: application/json" \
                -H "fileName: serviceaccount.json" \
                --insecure 2>> "$LOG_FILE")

            HTTP_CODE=$(echo "$RESPONSE" | tail -n1 | cut -d: -f2)

            echo "Response Status Code: $HTTP_CODE"

            if [[ "$HTTP_CODE" == "200" ]]; then
                SUCCESS=true
                break
            else
                echo "Configuring Service Account failed on attempt $i with HTTP $HTTP_CODE"
                [ $i -eq 3 ] && echo "Giving up after 3 attempts." || sleep 30
            fi
        done

        if [ "$SUCCESS" = true ]; then
            echo "Successfully configured Service Account for ${CLOUD_NAME}."
        else
            echo "Failed to configure Service Account after 3 attempts."
        fi

	# 28-07-2025: [PC-325] Run .jar file to mitigate AAD settings to ID settings
        echo "Downloading and executing UpdateIDPSettings.jar..."

        # Create temporary directory for JAR execution
        TEMP_DIR="/tmp/idp_update"
        log_exec mkdir -p "$TEMP_DIR"
        cd "$TEMP_DIR"
        
        # Download the JAR file and config
        JAR_URL="https://dns.parablu.com/parablu_installables/release/PRE_POST/2.6.3/post-commands/UpdateIDPSettings.jar"
        CONFIG_URL="https://dns.parablu.com/parablu_installables/release/PRE_POST/2.6.3/post-commands/config.txt"
        
        echo "Downloading UpdateIDPSettings.jar..."
        log_exec wget --user="${DNS_USERNAME}" --password="${DNS_PASSWORD}" \
            --no-check-certificate \
            -O "UpdateIDPSettings.jar" \
            "$JAR_URL"
        
        if [ $? -ne 0 ] || [ ! -f "UpdateIDPSettings.jar" ] || [ ! -s "UpdateIDPSettings.jar" ]; then
            echo "ERROR: Failed to download UpdateIDPSettings.jar"
            cd -
            log_exec rm -rf "$TEMP_DIR"
        fi
            
        echo "Downloading config.txt..."
        log_exec wget --user="${DNS_USERNAME}" --password="${DNS_PASSWORD}" \
            --no-check-certificate \
            -O "config.txt" \
            "$CONFIG_URL"
        
        if [ $? -ne 0 ] || [ ! -f "config.txt" ] || [ ! -s "config.txt" ]; then
            echo "ERROR: Failed to download config.txt"
            cd -
            log_exec rm -rf "$TEMP_DIR"
        fi
        
        echo "Files downloaded successfully. Executing UpdateIDPSettings.jar..."
        
        # Execute the JAR with config parameter
        java -jar UpdateIDPSettings.jar config.txt >> "$LOG_FILE" 2>&1
        
        JAR_EXIT_CODE=$?
        
        if [ $JAR_EXIT_CODE -eq 0 ]; then
            echo "UpdateIDPSettings.jar executed successfully"
        else
            echo "ERROR: UpdateIDPSettings.jar execution failed with exit code: $JAR_EXIT_CODE"
        fi
        
        # Clean up
        cd -
        log_exec rm -rf "$TEMP_DIR"
        
        echo "UpdateIDPSettings.jar execution completed."

	# 24-07-2025: [PC-323] Apply JOB_CONFIG, REPORT_SCHEDULER, and CLOUD_PROPERTIES updates
        echo "Applying MongoDB updates for JOB_CONFIG, REPORT_SCHEDULER, and CLOUD_PROPERTIES..."

        cat > apply_mongo_updates.js << EOF
db = db.getSiblingDB("parablu001");

db.JOB_CONFIG.updateMany({}, { "\$set": { "job.deleteOldDownloadsJobCleaner": true } });

db.REPORT_SCHEDULER.updateOne(
    { "schedulerName": "deleteOldDownloadsJobTimer" },
    {
        "\$set": {
            "schedulerName": "deleteOldDownloadsJobTimer",
            "cronExprestion": "0 0 5 ? * *"
        }
    },
    { upsert: true }
);

db = db.getSiblingDB("parablu");

db.CLOUD_PROPERTIES.updateMany({}, { "\$set": { "noOfFoldersAllowedForZipDownload": 1000 } });
db.CLOUD_PROPERTIES.updateMany({}, { "\$set": { "noOfFilesAllowedForZipDownload": 10000 } });
db.CLOUD_PROPERTIES.updateMany({}, { "\$set": { "sizeAllowedForZipDownloadInMB": 25600 } });
db.CLOUD_PROPERTIES.updateMany({}, { "\$set": { "downloadRetentionDays": 14 } });
EOF

        # Run the script
        log_exec sudo mongo --quiet localhost:$MONGODB_PORT -u "neil" -p "parablu" --authenticationDatabase "admin" \
            < apply_mongo_updates.js

        echo "MongoDB updates completed."

	# 25-07-2025: [PC-309] Insert Blob Credential Details in BLOB_CREDENTIALS
        echo "Configuring blob credentials..."
        LOCATION=$(echo "$PORTAL_URL" | grep -oP 'portal-[^./]+')
        DECRYPTION_KEY="mK9pL2xQ7vN4wR8zE1"

        # Download encrypted file for this location
        log_exec wget --user="${DNS_USERNAME}" --password="${DNS_PASSWORD}" \
            -O /tmp/${LOCATION}.enc \
            https://dns.parablu.com/parablu_installables/release/PRE_POST/blob_credentials/${LOCATION}.enc

        # Decrypt credentials function
        decrypt_credentials() {
            local file="$1"
            local key="$2"
            openssl enc -aes-256-cbc -d -salt -pbkdf2 -iter 100000 -in "$file" -k "$key" 2>> "$LOG_FILE"
        }

        # Decrypt and extract values
	DECRYPTED_DATA=$(decrypt_credentials "/tmp/${LOCATION}.enc" "$DECRYPTION_KEY")
        IDENTITY=$(echo "$DECRYPTED_DATA" | grep "IDENTITY=" | cut -d= -f2)
        CREDENTIAL=$(echo "$DECRYPTED_DATA" | grep "CREDENTIAL=" | cut -d= -f2)

        # Clean up
        log_exec rm -f /tmp/${LOCATION}.enc

        # Use decrypted values in if-else
        if [ "$LOCATION" == "portal-in" ]; then
            BLOB_IDENTITY="$IDENTITY"
            BLOB_CREDENTIAL="$CREDENTIAL"
        elif [ "$LOCATION" == "portal-use" ]; then
            BLOB_IDENTITY="$IDENTITY"
            BLOB_CREDENTIAL="$CREDENTIAL"
        elif [ "$LOCATION" == "portal-me" ]; then
            BLOB_IDENTITY="$IDENTITY"
            BLOB_CREDENTIAL="$CREDENTIAL"
        elif [ "$LOCATION" == "portal-usw" ]; then
            BLOB_IDENTITY="$IDENTITY"
            BLOB_CREDENTIAL="$CREDENTIAL"
        else
            echo "Unknown location '$LOCATION', using India (portal-in) credentials as default..."
            
            # Download and decrypt India credentials as fallback
            log_exec wget --user="${DNS_USERNAME}" --password="${DNS_PASSWORD}" \
                -O /tmp/portal-in.enc \
                https://dns.parablu.com/parablu_installables/release/PRE_POST/blob_credentials/portal-in.enc
            
            INDIA_DECRYPTED_DATA=$(decrypt_credentials "/tmp/portal-in.enc" "$DECRYPTION_KEY")
            BLOB_IDENTITY=$(echo "$INDIA_DECRYPTED_DATA" | grep "IDENTITY=" | cut -d= -f2)
            BLOB_CREDENTIAL=$(echo "$INDIA_DECRYPTED_DATA" | grep "CREDENTIAL=" | cut -d= -f2)
            
            # Clean up
            log_exec rm -f /tmp/portal-in.enc
        fi

        # Insert BLOB_CREDENTIALS into MongoDB
        cat > insert_blob_credentials.js << EOF
use parablu

db.BLOB_CREDENTIALS.updateOne(
    { _id: ObjectId('686ba14a66f51160266aa80a') },
    {
        \$set: {
            cloudName: 'azureBlob',
            provider: 'azureblob',
            identity: '$BLOB_IDENTITY',
            credential: '$BLOB_CREDENTIAL',
            endPointUrl: '',
            containerName: '',
            blobTagName: 'APN\\/1.0 ParaBluInc/1.0 BluVault/2.5.4.6',
            _class: 'com.parablu.pcbd.domain.CloudCredentials'
        }
    },
    { upsert: true }
)
EOF

        log_exec sudo mongo --quiet localhost:$MONGODB_PORT -u "neil" -p "parablu" --authenticationDatabase "admin" \
            < insert_blob_credentials.js

        echo "BLOB_CREDENTIALS inserted successfully."

	# 05-08-2025: [PC-327] Tenant Status Consent Management
        # Check and create TENANT_CONSENT_STATUS collection
        echo "Checking TENANT_CONSENT_STATUS collection..."

cat > check_tenant_consent_status.js << 'EOF'
use parablu001

// Step 1: Check if TENANT_CONSENT_STATUS collection exists
var consentStatusExists = db.getCollectionNames().indexOf('TENANT_CONSENT_STATUS') > -1;

if (consentStatusExists) {
    print("TENANT_CONSENT_STATUS collection already exists. No action needed.");
} else {
    print("TENANT_CONSENT_STATUS collection does not exist. Proceeding with checks...");

    // Step 2: Check if MS_APP_SETTING.tenantId != 'PB_CUST_TENANTID'
    var msAppSettings = db.MS_APP_SETTING.findOne({});

    if (msAppSettings && msAppSettings.tenantId && msAppSettings.tenantId !== 'PB_CUST_TENANTID') {
        print("MS_APP_SETTING.tenantId found: " + msAppSettings.tenantId);

        var tenantId = msAppSettings.tenantId;
        var ewsAppConsented = false;

        // Step 3: Check EWS_APP_SETTING.tenantId != 'PB_CUST_TENANTID'
        var ewsAppSettings = db.EWS_APP_SETTING.findOne({});

        if (ewsAppSettings && ewsAppSettings.tenantId && ewsAppSettings.tenantId !== 'PB_CUST_TENANTID') {
            print("EWS_APP_SETTING.tenantId found: " + ewsAppSettings.tenantId);
            ewsAppConsented = true;
        } else {
            print("EWS_APP_SETTING.tenantId is either 'PB_CUST_TENANTID' or not found. Setting ewsAppConsented to false.");
        }

        // Step 4: Create TENANT_CONSENT_STATUS collection with the document
        var consentStatusDoc = {
            tenantId: tenantId,
            tenantIdUpdated: true,
            msAppConsented: true,
            ewsAppConsented: ewsAppConsented,
            assetsConfigured: false,
            _class: 'com.parablu.pcbd.domain.TenantConsentStatus'
        };

        var result = db.TENANT_CONSENT_STATUS.insertOne(consentStatusDoc);

        if (result.acknowledged) {
            print("TENANT_CONSENT_STATUS collection created successfully with document:");
            printjson(consentStatusDoc);
        } else {
            print("ERROR: Failed to create TENANT_CONSENT_STATUS collection");
        }

    } else {
        print("MS_APP_SETTING.tenantId is either 'PB_CUST_TENANTID' or not found. No action needed.");
    }
}
EOF

    # Execute the MongoDB script
    log_exec sudo mongo --quiet localhost:$MONGODB_PORT -u "neil" -p "parablu" --authenticationDatabase "admin" \
        < check_tenant_consent_status.js

    echo "TENANT_CONSENT_STATUS check completed."

    # Clean up the temporary script file
    log_exec rm -f check_tenant_consent_status.js

    # 07-08-2025 [BK-29] Update spadmin Email in USER Collection
    echo "Updating spadmin email in USER collection..."

    cat > update_spadmin_email.js << EOF
use parablu001

db.USER.update({ "userName": "spadmin" },{ "\$set": { "emailId": "1AFqStHtJbiAeENvcoVux3NzfSu/ajnfU5iXYhcT9wOAuPXXee74Y4R7KmOHTe7UqqW/us0=" } })
EOF

    log_exec sudo mongo --quiet localhost:$MONGODB_PORT -u "neil" -p "parablu" --authenticationDatabase "admin" \
        < update_spadmin_email.js

    echo "spadmin email in USER collection updated successfully."

fi

# List of JAR files to remove
JAR_FILES=(
    "google-api-client-1.22.0.jar"
    "google-http-client-1.22.0.jar"
    "google-oauth-client-1.22.0.jar"
    "google-http-client-jackson2-1.22.0.jar"
    "jackson-annotations-2.17.2.jar"
    "jackson-core-2.17.2.jar"
)

if [ "$SERVER_TYPE" == "0" ] || [ "$SERVER_TYPE" == "1 2" ] || [ "$SERVER_TYPE" == "3 1" ]; then
    echo "Removing old JAR files..."
    echo "Stopping Tomcat services..."
    log_exec service tomcat-pcb1 stop 
    log_exec service tomcat-job1 stop
    sleep 2s

    # Remove files from tomcat-pcb1 repo
    cd /var/lib/tomcat-pcb1/repo
    for jar_file in "${JAR_FILES[@]}"; do
        if [ -f "$jar_file" ]; then
            log_exec rm -f "$jar_file"
        fi
    done
    cd -

    sleep 1s

    # Remove files from tomcat-job1 repo
    cd /var/lib/tomcat-job1/repo
    for jar_file in "${JAR_FILES[@]}"; do
        if [ -f "$jar_file" ]; then
            log_exec rm -f "$jar_file"
        fi
    done
    cd -

    sleep 2s

    echo "Starting Tomcat services..."
    log_exec service tomcat-pcb1 restart 
    log_exec service tomcat-job1 restart
fi

if [ "$SERVER_TYPE" == "0" ] || [ "$SERVER_TYPE" == "1 2" ] || [ "$SERVER_TYPE" == "3 1" ]; then

    SCHEDULER_FILE="/var/lib/tomcat-job1/webapps/MSJob/WEB-INF/classes/spring-config/scheduler-context.xml"
    dbport=$(grep port: /etc/mongod.conf)
    MONGODB_PORT=$(echo $dbport | sed -e 's/port://' | sed 's/"//g' | tr -d ' ')

    cat > checkmulti.js <<'EOF'
use parablu
var doc = db.CLOUD_PROPERTIES.findOne({}, { _id: 0, multiTenancy: 1 });
print("MULTI_TENANCY=" + (doc && doc.multiTenancy));
EOF

    sudo mongo --quiet localhost:$MONGODB_PORT -u "neil" -p "parablu" --authenticationDatabase "admin" \
        < checkmulti.js > checkmulti

    # Log the MongoDB command execution to log file
    echo "[$(/bin/date '+%Y-%m-%d %H:%M:%S')] MongoDB checkmulti.js executed" >> "$LOG_FILE"

    MULTI_TEN=$(grep "MULTI_TENANCY=" checkmulti | tail -1 | cut -d= -f2 | tr -d '[:space:]')
    echo "Multi-tenancy setting: $MULTI_TEN"

    if [ "$MULTI_TEN" == "true" ]; then
        echo "Disabling Job Triggers in Scheduler Context file"

	log_exec sed -i 's|^\s*<ref bean="odbAutoCrawlJobTrigger" />|<!--ref bean="odbAutoCrawlJobTrigger" />|' "$SCHEDULER_FILE"
        log_exec sed -i 's|^\s*<ref bean\s*=\s*"msStorageBackupJobTrigger" />|<ref bean ="msStorageBackupJobTrigger" /-->|' "$SCHEDULER_FILE"

        echo "Job Triggers in Scheduler Context file successfully disabled"
    fi
fi

echo "Script execution completed. Check $LOG_FILE for detailed logs."
