/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.io.Serializable;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SealedObject;
import javax.crypto.SecretKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class SealedTest
implements Test {
    static final String provider = "BC";

    public String getName() {
        return "SealedObject";
    }

    public TestResult perform() {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance("DES", provider);
            SecretKey secretKey = keyGenerator.generateKey();
            Cipher cipher = Cipher.getInstance("DES/ECB/PKCS5Padding", provider);
            cipher.init(1, secretKey);
            String string = "Hello world";
            SealedObject sealedObject = new SealedObject((Serializable)((Object)string), cipher);
            cipher.init(2, secretKey);
            Object object = sealedObject.getObject(cipher);
            if (!object.equals(string)) {
                return new SimpleTestResult(false, "Result object 1 not equalorig: " + string + " res: " + object);
            }
            object = sealedObject.getObject(secretKey);
            if (!object.equals(string)) {
                return new SimpleTestResult(false, "Result object 2 not equalorig: " + string + " res: " + object);
            }
            object = sealedObject.getObject(secretKey, provider);
            if (!object.equals(string)) {
                return new SimpleTestResult(false, "Result object 3 not equalorig: " + string + " res: " + object);
            }
            return new SimpleTestResult(true, this.getName() + ": Okay");
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": failed excpetion - " + exception.toString());
        }
    }

    public static void main(String[] stringArray) {
        Security.addProvider(new BouncyCastleProvider());
        SealedTest sealedTest = new SealedTest();
        TestResult testResult = sealedTest.perform();
        System.out.println(testResult.toString());
    }
}

