/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.dao;

import com.parablu.epa.common.dao.BaseDAO;
import com.parablu.epa.core.constant.BluSyncSQLConstants;
import com.parablu.epa.core.constant.StringLiterals;
import com.parablu.epa.core.dao.ImageTableHistoryDAO;
import com.parablu.epa.core.to.ActivityTO;
import com.parablu.epa.core.to.CrawlDbTo;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageTableHistoryImpl
extends BaseDAO
implements ImageTableHistoryDAO {
    private Logger logger = LoggerFactory.getLogger(ImageTableHistoryImpl.class);
    protected final String tableTimeStamp;
    protected final String baseURL;
    private static final String WHERE = " where ";
    private static final String SELECT = "select ";
    private static final String FROM = " from ";
    private static final String LIKE_ORDERBY_IMGTABLE = " like \"ImageTable%\" order by ";

    public ImageTableHistoryImpl(String connectionURL, String timeStamp, String folderURLOfDB) {
        super(connectionURL);
        this.tableTimeStamp = timeStamp;
        this.baseURL = folderURLOfDB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createImageTableHistory() {
        boolean success = false;
        this.statement = null;
        boolean gotConnection = this.getConnectionForCreatingDatabase();
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement(CREATE_IMAGE_TABLE_HISTORY_SQLQUERY);
                this.statement.execute();
                this.statement.close();
                success = true;
            }
            catch (SQLException e) {
                this.logger.error("SQLException while Creating new Image Table History", (Throwable)e);
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeFromImageTableHistory(String imagetableName) {
        String sqlQuery = "delete from ImageTableHistory where name=?;";
        this.statement = null;
        boolean success = false;
        boolean gotConnection = this.getConnection();
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement(sqlQuery);
                this.statement.setString(1, imagetableName);
                this.statement.execute();
                this.statement.close();
                success = true;
            }
            catch (SQLException e) {
                this.logger.error("SQLException while removing From Image Table History", (Throwable)e);
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    protected void attachImageTableDataInCurrentTable(String dbToattach) throws SQLException {
        StringBuilder sb = new StringBuilder().append(this.baseURL).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append(dbToattach);
        String sqlQuery = "attach database \"" + sb.toString() + "\" as ? ;";
        this.statement = this.conn.prepareStatement(sqlQuery);
        this.statement.setString(1, dbToattach);
        this.statement.execute();
        this.statement.close();
    }

    protected void detachImageTableDataInCurrentTable(String attachedDB) throws SQLException {
        String sqlQuery = "DETACH DATABASE ? ;";
        this.statement = this.conn.prepareStatement(sqlQuery);
        this.statement.setString(1, attachedDB);
        this.statement.execute();
        this.statement.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CrawlDbTo createImageTable(ActivityTO activity) {
        String tableName = null;
        long columnId = 0L;
        String tempActivityName = activity.getActivityName();
        String tempActivityTimeStamp = String.valueOf(activity.getActivityTimeStamp().getTime());
        String tempActivityUpload = activity.getUploadCount();
        String tempActivitydownload = activity.getDownloadCount();
        String batchId = activity.getBatchId();
        CrawlDbTo crawlDbTo = null;
        String sqlQuery = BluSyncSQLConstants.createImageTable((String)this.tableTimeStamp);
        this.statement = null;
        ResultSet result = null;
        StringBuilder sb = new StringBuilder().append(this.baseURL).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("ImageTable").append(this.tableTimeStamp);
        String sqlQueryForActivityTable = new StringBuffer().append("INSERT INTO ").append("ActivityTable").append(".").append("ActivityHistory").append(" (").append("timestamp").append(",").append("currentactivity").append(",").append("uploadcount").append(",").append("batchID").append(",").append("downloadcount").append(")").append(" Values(?,?,?,?,?);").toString();
        String sqlQueryForInsertingIntoImageTableHistory = "insert into ImageTableHistory.ImageTableHistory values(?);";
        boolean gotConnection = this.getConnectionForCreatingDatabase(sb.toString());
        if (gotConnection) {
            try {
                this.attachImageTableDataInCurrentTable("ActivityTable");
                this.attachImageTableDataInCurrentTable("ImageTableHistory");
                this.conn.setAutoCommit(false);
                this.statement = this.conn.prepareStatement(sqlQuery);
                this.statement.execute();
                this.statement.close();
                tableName = "ImageTable" + this.tableTimeStamp;
                this.statement = this.conn.prepareStatement(sqlQueryForActivityTable, 1);
                this.statement.setString(1, tempActivityTimeStamp);
                this.statement.setString(2, tempActivityName);
                this.statement.setString(3, tempActivityUpload);
                this.statement.setString(4, batchId);
                this.statement.setString(5, tempActivitydownload);
                this.statement.execute();
                result = this.statement.getGeneratedKeys();
                if (result != null && result.next()) {
                    columnId = result.getLong(1);
                    result.close();
                }
                this.statement.close();
                this.statement = this.conn.prepareStatement("insert into ImageTableHistory.ImageTableHistory values(?);");
                this.statement.setString(1, tableName);
                this.statement.execute();
                this.statement.close();
                this.conn.commit();
                this.conn.setAutoCommit(true);
                this.detachImageTableDataInCurrentTable("ActivityTable");
                this.detachImageTableDataInCurrentTable("ImageTableHistory");
                crawlDbTo = new CrawlDbTo();
                crawlDbTo.setActivityId(columnId);
                crawlDbTo.setImageTableName(tableName);
            }
            catch (SQLException e) {
                this.logger.error("SQLException while creating Image Table", (Throwable)e);
            }
            finally {
                if (result != null) {
                    try {
                        result.close();
                    }
                    catch (SQLException exception) {
                        this.logger.error("SQLException while closing result set for creating Image Table" + exception);
                    }
                }
                this.closeConnection();
            }
        }
        this.logger.debug("The Created table name is:" + tableName);
        return crawlDbTo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteImageTable(String imageTableName, ActivityTO activity) {
        this.statement = null;
        long activityId = activity.getActivityID();
        String tempActivityUpload = activity.getUploadCount();
        String tempActivitydownload = activity.getDownloadCount();
        String activityName = activity.getActivityName();
        String dropTableQuery = "Drop Table ";
        String sqlQueryToUpdateActivityTable = "Update ActivityTable.ActivityHistory set uploadcount=?,downloadcount=?,currentactivity=? where id=?;";
        StringBuilder sb = new StringBuilder().append(this.baseURL).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append(imageTableName);
        boolean gotConnection = this.getConnection(sb.toString());
        String query = dropTableQuery + imageTableName;
        if (gotConnection) {
            try {
                if (imageTableName != null) {
                    this.attachImageTableDataInCurrentTable("ActivityTable");
                    this.conn.setAutoCommit(false);
                    this.statement = this.conn.prepareStatement(query);
                    this.statement.execute();
                    this.statement.close();
                    this.statement = this.conn.prepareStatement("Update ActivityTable.ActivityHistory set uploadcount=?,downloadcount=?,currentactivity=? where id=?;");
                    this.statement.setString(1, tempActivityUpload);
                    this.statement.setString(2, tempActivitydownload);
                    this.statement.setString(3, activityName);
                    this.statement.setLong(4, activityId);
                    this.statement.execute();
                    this.statement.close();
                    this.conn.commit();
                    this.conn.setAutoCommit(true);
                    this.detachImageTableDataInCurrentTable("ActivityTable");
                }
            }
            catch (SQLException e) {
                this.logger.error("SQLException while deleting Image Table", (Throwable)e);
            }
            finally {
                this.closeConnection();
            }
        }
        boolean success = this.removeFromImageTableHistory(imageTableName);
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCurrentImageTableName() {
        String tableName = null;
        String sqlQuery = new StringBuffer().append(SELECT).append("name").append(FROM).append("ImageTableHistory").append(WHERE).append("name").append(LIKE_ORDERBY_IMGTABLE).append("name").append(" DESC LIMIT 1").toString();
        this.statement = null;
        ResultSet getcurNameRes = null;
        boolean gotConnection = this.getConnection();
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement(sqlQuery);
                getcurNameRes = this.statement.executeQuery();
                if (getcurNameRes != null && getcurNameRes.next()) {
                    tableName = getcurNameRes.getString("name");
                }
                this.statement.close();
            }
            catch (SQLException e) {
                this.logger.error("SQLException while geting Current Image Table Name", (Throwable)e);
            }
            finally {
                if (getcurNameRes != null) {
                    try {
                        getcurNameRes.close();
                    }
                    catch (SQLException e) {
                        this.logger.error("SQLException while closing result set" + e);
                    }
                }
                this.closeConnection();
            }
            getcurNameRes = null;
        }
        return tableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPreviousImageTableName() {
        String tableName = null;
        String sqlQuery = new StringBuffer().append(SELECT).append("name").append(FROM).append("ImageTableHistory").append(WHERE).append("name").append(LIKE_ORDERBY_IMGTABLE).append("name").append(" DESC LIMIT 2").toString();
        this.statement = null;
        ResultSet getcurNameRes = null;
        boolean gotConnection = this.getConnection();
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement(sqlQuery);
                getcurNameRes = this.statement.executeQuery();
                if (getcurNameRes != null && getcurNameRes.next() && getcurNameRes.next()) {
                    tableName = getcurNameRes.getString("name");
                }
                this.statement.close();
            }
            catch (SQLException e) {
                this.logger.error("SQLException while geting Previous Image Table Name", (Throwable)e);
            }
            finally {
                if (getcurNameRes != null) {
                    try {
                        getcurNameRes.close();
                    }
                    catch (SQLException e) {
                        this.logger.error("SQLException while closing result set for geting Previous Image Table Name" + e);
                    }
                }
                this.closeConnection();
            }
            getcurNameRes = null;
        }
        return tableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOldestImageTableName() {
        String tableName = null;
        String sqlQuery = new StringBuffer().append(SELECT).append("name").append(FROM).append("ImageTableHistory").append(WHERE).append("name").append(LIKE_ORDERBY_IMGTABLE).append("name").append(" ASC LIMIT 1").toString();
        this.statement = null;
        ResultSet getcurNameRes = null;
        boolean gotConnection = this.getConnection();
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement(sqlQuery);
                getcurNameRes = this.statement.executeQuery();
                if (getcurNameRes != null && getcurNameRes.next()) {
                    tableName = getcurNameRes.getString("name");
                }
                this.statement.close();
            }
            catch (SQLException e) {
                this.logger.error("SQLException while geting Oldest Image Table Name", (Throwable)e);
            }
            finally {
                if (getcurNameRes != null) {
                    try {
                        getcurNameRes.close();
                    }
                    catch (SQLException e) {
                        this.logger.error("SQLException while closing result set for geting Oldest Image Table Name" + e);
                    }
                }
                this.closeConnection();
            }
            getcurNameRes = null;
        }
        return tableName;
    }
}

