/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.lang.annotation.Annotation;
import org.simpleframework.xml.ElementMap;
import org.simpleframework.xml.core.ClassType;
import org.simpleframework.xml.core.CompositeInlineMap;
import org.simpleframework.xml.core.CompositeMap;
import org.simpleframework.xml.core.Contact;
import org.simpleframework.xml.core.Context;
import org.simpleframework.xml.core.Converter;
import org.simpleframework.xml.core.Decorator;
import org.simpleframework.xml.core.ElementException;
import org.simpleframework.xml.core.Entry;
import org.simpleframework.xml.core.Expression;
import org.simpleframework.xml.core.Factory;
import org.simpleframework.xml.core.Introspector;
import org.simpleframework.xml.core.MapFactory;
import org.simpleframework.xml.core.Qualifier;
import org.simpleframework.xml.core.TemplateLabel;
import org.simpleframework.xml.strategy.Type;
import org.simpleframework.xml.stream.Format;
import org.simpleframework.xml.stream.Style;

class ElementMapLabel
extends TemplateLabel {
    private Decorator decorator;
    private Introspector detail;
    private ElementMap label;
    private Format format;
    private Entry entry;
    private Class type;
    private Class[] items;
    private String parent;
    private String name;

    public ElementMapLabel(Contact contact, ElementMap label, Format format) {
        this.detail = new Introspector(contact, this, format);
        this.decorator = new Qualifier(contact);
        this.entry = new Entry(contact, label);
        this.type = contact.getType();
        this.name = label.name();
        this.format = format;
        this.label = label;
    }

    public Decorator getDecorator() throws Exception {
        return this.decorator;
    }

    public Converter getConverter(Context context) throws Exception {
        Type type = this.getMap();
        if (!this.label.inline()) {
            return new CompositeMap(context, this.entry, type);
        }
        return new CompositeInlineMap(context, this.entry, type);
    }

    public Object getEmpty(Context context) throws Exception {
        ClassType map = new ClassType(this.type);
        MapFactory factory = new MapFactory(context, map);
        if (!this.label.empty()) {
            return ((Factory)factory).getInstance();
        }
        return null;
    }

    public Type getDependent() throws Exception {
        Contact contact = this.getContact();
        if (this.items == null) {
            this.items = contact.getDependents();
        }
        if (this.items == null) {
            throw new ElementException("Unable to determine type for %s", contact);
        }
        if (this.items.length == 0) {
            return new ClassType(Object.class);
        }
        return new ClassType(this.items[0]);
    }

    public String getEntry() throws Exception {
        Style style = this.format.getStyle();
        if (this.detail.isEmpty(this.parent)) {
            this.parent = this.detail.getEntry();
        }
        return style.getElement(this.parent);
    }

    public String getName() throws Exception {
        Style style = this.format.getStyle();
        String name = this.entry.getEntry();
        if (!this.label.inline()) {
            name = this.detail.getName();
        }
        return style.getElement(name);
    }

    public String getPath() throws Exception {
        Expression path = this.getExpression();
        String name = this.getName();
        return path.getElement(name);
    }

    public Expression getExpression() throws Exception {
        return this.detail.getExpression();
    }

    private Type getMap() {
        return new ClassType(this.type);
    }

    public Annotation getAnnotation() {
        return this.label;
    }

    public Class getType() {
        return this.type;
    }

    public Contact getContact() {
        return this.detail.getContact();
    }

    public String getOverride() {
        return this.name;
    }

    public boolean isData() {
        return this.label.data();
    }

    public boolean isCollection() {
        return true;
    }

    public boolean isRequired() {
        return this.label.required();
    }

    public boolean isInline() {
        return this.label.inline();
    }

    public String toString() {
        return this.detail.toString();
    }
}

