/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.service.backup;

import com.parablu.epa.common.service.backup.MultiThreadResendFilesUpload;
import com.parablu.epa.common.service.backup.ReSendFilesJob;
import com.parablu.epa.common.service.notification.NotificationHelper;
import com.parablu.epa.common.service.settings.PolicyManagementServerHelper;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.core.to.BackupFolderTO;
import com.parablu.epa.core.to.BackupTO;
import com.parablu.epa.helper.BackupCrawlUtility;
import com.parablu.epa.service.backup.MacResendFilesUploadJob;
import com.parablu.epa.service.notifications.UIHelper;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacResendFilesJob
extends ReSendFilesJob {
    private Logger logger = LoggerFactory.getLogger(MacResendFilesJob.class);
    int lastSuccessfulCrawledTime = 0;
    private MultiThreadResendFilesUpload backUpUpload = null;

    public MacResendFilesJob(boolean manualVal) {
        super(manualVal);
    }

    public void startBackUpThread(List<BackupTO> backUpList) throws InterruptedException, InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        this.logger.debug("BACKUP JOB UPLOAD START");
        this.backUpUpload = new MacResendFilesUploadJob(SettingHelper.getCurrentCloudIpAddress(), this.currentPort, SettingHelper.getCloudName(), SettingHelper.readTokenFromFile(), SettingHelper.getBackUpDbUrl(), backUpList);
        this.backUpUpload.setName("BackUpUpload");
        this.backUpUpload.start();
        this.backUpUpload.join();
    }

    public void updateSystrayToolTipNotification(String toolTipMessage, String toolTipmessage1) {
        UIHelper.updateSystrayToolTipNotification(toolTipMessage, toolTipmessage1);
    }

    protected void scanFileSystemByType(BackupFolderTO backupFolderTO) {
        BackupCrawlUtility backupCrawlUtility = new BackupCrawlUtility();
        backupCrawlUtility.crawlFolderEfficientStoringFullPaths(backupFolderTO.getFolderPath(), null);
    }

    public void updateSystrayImageAccordingToStage(String syncingImage) {
        if (NotificationHelper.getMainStatus() == 100) {
            UIHelper.updateSystrayImageAccordingToStage(syncingImage);
        } else {
            UIHelper.displaySyncingGif();
        }
    }

    public void pauseBackup(boolean isManualStop) {
        if (this.backUpUpload != null && this.backUpUpload.isAlive()) {
            try {
                this.logger.debug("stopping the thread");
                if (isManualStop) {
                    PolicyManagementServerHelper.updateFailCodeToActivityHistory((int)1992);
                }
                this.backUpUpload.interrupt();
                this.logger.debug("Interrupted backup thread");
                this.backUpUpload.join(10000L);
                this.backUpUpload.interrupt();
                this.logger.debug("Interrupted backup thread again");
            }
            catch (Exception e) {
                this.logger.trace("" + e);
                this.logger.error("Exception" + e.getMessage());
            }
        }
    }

    public void deleteVsnapshot(List<BackupFolderTO> listOfFolder) {
    }

    public void createVsnapshot(List<BackupFolderTO> listOfFolder) {
    }

    public boolean runScripts(String type, boolean isManual) {
        return isManual;
    }
}

