/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import org.bouncycastle.asn1.DERConstructedSequence;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTCTime;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;
import org.bouncycastle.asn1.x509.X509Name;

public class V1TBSCertificateGenerator {
    DERTaggedObject version = new DERTaggedObject(0, new DERInteger(0));
    DERInteger serialNumber;
    AlgorithmIdentifier signature;
    X509Name issuer;
    DERUTCTime startDate;
    DERUTCTime endDate;
    X509Name subject;
    SubjectPublicKeyInfo subjectPublicKeyInfo;

    public void setSerialNumber(DERInteger dERInteger) {
        this.serialNumber = dERInteger;
    }

    public void setSignature(AlgorithmIdentifier algorithmIdentifier) {
        this.signature = algorithmIdentifier;
    }

    public void setIssuer(X509Name x509Name) {
        this.issuer = x509Name;
    }

    public void setStartDate(DERUTCTime dERUTCTime) {
        this.startDate = dERUTCTime;
    }

    public void setEndDate(DERUTCTime dERUTCTime) {
        this.endDate = dERUTCTime;
    }

    public void setSubject(X509Name x509Name) {
        this.subject = x509Name;
    }

    public void setSubjectPublicKeyInfo(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        this.subjectPublicKeyInfo = subjectPublicKeyInfo;
    }

    public TBSCertificateStructure generateTBSCertificate() {
        if (this.serialNumber == null || this.signature == null || this.issuer == null || this.startDate == null || this.endDate == null || this.subject == null || this.subjectPublicKeyInfo == null) {
            throw new IllegalStateException("not all mandatory fields set in V1 TBScertificate generator");
        }
        DERConstructedSequence dERConstructedSequence = new DERConstructedSequence();
        dERConstructedSequence.addObject(this.version);
        dERConstructedSequence.addObject(this.serialNumber);
        dERConstructedSequence.addObject(this.signature);
        dERConstructedSequence.addObject(this.issuer);
        DERConstructedSequence dERConstructedSequence2 = new DERConstructedSequence();
        dERConstructedSequence2.addObject(this.startDate);
        dERConstructedSequence2.addObject(this.endDate);
        dERConstructedSequence.addObject(dERConstructedSequence2);
        dERConstructedSequence.addObject(this.subject);
        dERConstructedSequence.addObject(this.subjectPublicKeyInfo);
        return new TBSCertificateStructure(dERConstructedSequence);
    }
}

