/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import java.util.Vector;
import org.bouncycastle.asn1.DERConstructedSet;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.cms.Attribute;

public class AuthAttributes
implements DEREncodable {
    private DERConstructedSet attributes;

    public AuthAttributes(Vector vector) {
        this.setAttributes(vector);
    }

    public AuthAttributes(DERConstructedSet dERConstructedSet) {
        this.attributes = dERConstructedSet;
    }

    public AuthAttributes(AuthAttributes authAttributes) {
        this.attributes = authAttributes.attributes;
    }

    public static AuthAttributes getInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof AuthAttributes) {
            return (AuthAttributes)object;
        }
        if (object instanceof DERConstructedSet) {
            return new AuthAttributes((DERConstructedSet)object);
        }
        if (object instanceof DERTaggedObject) {
            return AuthAttributes.getInstance(((DERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid AuthAttributes");
    }

    public static AuthAttributes newInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof AuthAttributes) {
            return new AuthAttributes((AuthAttributes)object);
        }
        if (object instanceof DERConstructedSet) {
            return new AuthAttributes((DERConstructedSet)object);
        }
        if (object instanceof DERTaggedObject) {
            return AuthAttributes.getInstance(((DERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid AuthAttributes");
    }

    public Vector getAttributes() {
        int n = this.attributes.getSize();
        Vector<Attribute> vector = new Vector<Attribute>();
        int n2 = 0;
        while (n2 < n) {
            vector.addElement(Attribute.getInstance(this.attributes.getObjectAt(n2)));
            ++n2;
        }
        return vector;
    }

    private void setAttributes(Vector vector) {
        int n = vector.size();
        this.attributes = new DERConstructedSet();
        int n2 = 0;
        while (n2 < n) {
            this.attributes.addObject(Attribute.getInstance(vector.elementAt(n2)));
            ++n2;
        }
    }

    public DERObject getDERObject() {
        return this.attributes;
    }
}

