/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.core.service.transformer;

import com.parablu.epa.core.element.BackupElement;
import com.parablu.epa.core.element.BackupStatElement;
import com.parablu.epa.core.element.BackupValidationElement;
import com.parablu.epa.core.element.ChunkFileElement;
import com.parablu.epa.core.element.CrawlDeviceElement;
import com.parablu.epa.core.element.CrawlDeviceElementList;
import com.parablu.epa.core.element.CrawlResponseElement;
import com.parablu.epa.core.element.DeviceCertElement;
import com.parablu.epa.core.element.DeviceElement;
import com.parablu.epa.core.element.FileElement;
import com.parablu.epa.core.element.FileListElement;
import com.parablu.epa.core.element.FolderDeviceElement;
import com.parablu.epa.core.element.MediaValidationElement;
import com.parablu.epa.core.element.NewSupportElement;
import com.parablu.epa.core.element.RestoreElement;
import com.parablu.epa.core.element.RestoreElementList;
import com.parablu.epa.core.helper.ObjectUtils;
import com.parablu.epa.core.helper.PropertyHelper;
import com.parablu.epa.core.to.FileTO;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang.StringUtils;
import org.simpleframework.xml.Serializer;
import org.simpleframework.xml.core.Persister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CreateXmlObject {
    private static final String EXEP_STRING = "Exception ";
    private static final String END_OF_METHOD = "End of method ";
    private static Logger logger = LoggerFactory.getLogger(CreateXmlObject.class);

    private CreateXmlObject() {
    }

    public static String createGzipFileForCrawl(List<FileTO> listofFileTOAdd, List<FileTO> listofFileTOMod, List<FileTO> listofFileTODel, String curTimeStamp, String lastSuccessfulTimeStamp, String fileUrl) {
        CrawlDeviceElement deviceElement = null;
        String fileUrlTemp = fileUrl;
        try {
            deviceElement = CreateXmlObject.formTheCrawlDeviceElement(null, null, listofFileTOAdd, listofFileTOMod, listofFileTODel, curTimeStamp, lastSuccessfulTimeStamp);
            fileUrlTemp = CreateXmlObject.createGzipFileUsingSerializer(deviceElement, fileUrlTemp);
        }
        catch (Exception e) {
            logger.error(EXEP_STRING + e);
        }
        logger.debug(END_OF_METHOD + Runtime.getRuntime().freeMemory());
        return fileUrlTemp;
    }

    public static String createBackupElementXml(BackupElement backupElement) {
        Persister serializer = new Persister();
        StringWriter stringWriter = new StringWriter();
        try {
            serializer.write((Object)backupElement, (Writer)stringWriter);
        }
        catch (Exception e) {
            logger.error(EXEP_STRING + e);
        }
        return stringWriter.toString();
    }

    public static byte[] createXmlByteArrayForCrawl(List<CrawlDeviceElement> crawlDeviceElementList) {
        byte[] gzipByteAyyar = null;
        try {
            gzipByteAyyar = CreateXmlObject.createByteArrayForCrawlDeviceElementsUsingSerializer(crawlDeviceElementList);
        }
        catch (Exception e) {
            logger.error(EXEP_STRING + e);
        }
        logger.debug(END_OF_METHOD + Runtime.getRuntime().freeMemory());
        return gzipByteAyyar;
    }

    public static CrawlDeviceElement formTheCrawlDeviceElement(String miniCloudId, String miniCloudName, List<FileTO> listofFileTOAdd, List<FileTO> listofFileTOMod, List<FileTO> listofFileTODel, String curTimeStamp, String lastSuccessfulTimeStamp) throws InterruptedException {
        logger.debug("Memory available before conversion " + Runtime.getRuntime().freeMemory());
        CrawlDeviceElement deviceElement = new CrawlDeviceElement();
        ArrayList<FileElement> addFileElementList = new ArrayList<FileElement>();
        ArrayList<FileElement> modifyFileElementList = new ArrayList<FileElement>();
        ArrayList<FileElement> deleteFileElementList = new ArrayList<FileElement>();
        deviceElement.setMiniCloudId(miniCloudId);
        deviceElement.setMiniCloudName(miniCloudName);
        FileListElement fileListElement = CreateXmlObject.convertFromFileToToFileElementAndPerformGC(listofFileTOAdd, addFileElementList);
        deviceElement.setNewFilesToAddList(fileListElement);
        fileListElement = CreateXmlObject.convertFromFileToToFileElementAndPerformGC(listofFileTOMod, modifyFileElementList);
        deviceElement.setModifiedFileList(fileListElement);
        String isSkipSeletedFiles = PropertyHelper.getMessageResourceString("Sync-Skip-Deleted-Files");
        logger.debug("is Skip deleted Files ....." + isSkipSeletedFiles);
        if (StringUtils.isNotEmpty((String)isSkipSeletedFiles) && "true".equalsIgnoreCase(isSkipSeletedFiles)) {
            logger.debug("skip sending deleted files .....");
        } else {
            fileListElement = CreateXmlObject.convertFromFileToToFileElementAndPerformGC(listofFileTODel, deleteFileElementList);
            deviceElement.setDeletedFileList(fileListElement);
        }
        deviceElement.setCurrentCrawlTimestamp(curTimeStamp);
        deviceElement.setLastsuccessfulCrawlTimeStamp(lastSuccessfulTimeStamp);
        return deviceElement;
    }

    private static FileListElement convertFromFileToToFileElementAndPerformGC(List<FileTO> listofFileTO, List<FileElement> fileElementList) throws InterruptedException {
        int noOfFiles = listofFileTO.size();
        CreateXmlObject.convertFileToListToElementList(listofFileTO, fileElementList);
        FileListElement fileListElement = new FileListElement();
        fileListElement.setFileElementList(fileElementList);
        if (noOfFiles > 1000) {
            Thread.sleep((long)noOfFiles / 25L);
        }
        logger.debug("Free memory after converting file  to element " + Runtime.getRuntime().freeMemory());
        return fileListElement;
    }

    private static void convertFileToListToElementList(List<FileTO> listofFileTO, List<FileElement> fileElementList) {
        for (FileTO file : listofFileTO) {
            FileElement fileElement = new FileElement();
            ObjectUtils.copyFileTOtoFileElement(file, fileElement);
            fileElementList.add(fileElement);
        }
    }

    private static String createGzipFileUsingSerializer(CrawlDeviceElement deviceElement, String outputFile) {
        Persister serializer = new Persister();
        String outputFileTemp = outputFile;
        try (FileOutputStream fs = new FileOutputStream(new File(outputFileTemp));
             GZIPOutputStream gzipOS = new GZIPOutputStream(fs);){
            serializer.write((Object)deviceElement, (OutputStream)gzipOS);
        }
        catch (Exception e) {
            logger.error(EXEP_STRING + e);
            outputFileTemp = null;
        }
        return outputFileTemp;
    }

    private static byte[] createByteArrayUsingSerializer(CrawlDeviceElement deviceElement) {
        Persister serializer = new Persister();
        byte[] byteArray = null;
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
             GZIPOutputStream gzipOS = new GZIPOutputStream((OutputStream)bos);){
            logger.debug("Free memory creating byte array: " + Runtime.getRuntime().freeMemory());
            serializer.write((Object)deviceElement, (OutputStream)gzipOS);
            logger.debug("Free memory creating gzip  " + Runtime.getRuntime().freeMemory());
            gzipOS.close();
            byteArray = bos.toByteArray();
            logger.debug("Free memory creating byte array " + Runtime.getRuntime().freeMemory());
        }
        catch (Exception e) {
            logger.error(EXEP_STRING + e);
        }
        return byteArray;
    }

    private static byte[] createByteArrayForCrawlDeviceElementsUsingSerializer(List<CrawlDeviceElement> deviceElementList) {
        Persister serializer = new Persister();
        byte[] byteArray = null;
        CrawlDeviceElementList crawlDeviceElementList = new CrawlDeviceElementList();
        crawlDeviceElementList.setCrawlDeviceElements(deviceElementList);
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
             GZIPOutputStream gzipOS = new GZIPOutputStream((OutputStream)bos);){
            logger.debug("Free memory creating byte array: " + Runtime.getRuntime().freeMemory());
            serializer.write((Object)crawlDeviceElementList, (OutputStream)gzipOS);
            logger.debug("Free memory creating gzip  " + Runtime.getRuntime().freeMemory());
            gzipOS.close();
            byteArray = bos.toByteArray();
            logger.debug("Free memory creating byte array " + Runtime.getRuntime().freeMemory());
        }
        catch (Exception e) {
            logger.error(EXEP_STRING + e);
        }
        return byteArray;
    }

    public static String createXmlStringForDeviceRegistration(String deviceName, String deviceUUID, String osType, String osVersion) {
        String deviceXmlString = null;
        try {
            long curDate = System.currentTimeMillis();
            DeviceElement deviceElement = new DeviceElement();
            deviceElement.setDeviceName(deviceName);
            deviceElement.setDeviceUUID(deviceUUID);
            deviceElement.setOsType(osType);
            deviceElement.setOsVersion(osVersion);
            deviceElement.setDeviceCreatedDate(String.valueOf(curDate));
            deviceElement.setLastModifiedTimestamp(curDate);
            StringWriter writer = new StringWriter();
            Persister serializer = new Persister();
            deviceXmlString = CreateXmlObject.createXmlForDevice((Serializer)serializer, deviceElement, writer, deviceXmlString);
        }
        catch (Exception e) {
            logger.error(EXEP_STRING + e);
        }
        return deviceXmlString;
    }

    private static String createXmlForDevice(Serializer serializer, DeviceElement deviceElement, Writer writer, String deviceXmlString) {
        String deviceXmlStringTemp = deviceXmlString;
        try {
            serializer.write((Object)deviceElement, writer);
            deviceXmlStringTemp = writer.toString();
            writer.close();
        }
        catch (Exception e) {
            logger.error(EXEP_STRING + e);
        }
        return deviceXmlStringTemp;
    }

    public static String createXmlForSupportElement(NewSupportElement supportElement) {
        String xmlString = null;
        try {
            StringWriter writer = new StringWriter();
            Persister serializer = new Persister();
            xmlString = CreateXmlObject.createXmlForSupport((Serializer)serializer, supportElement, writer, xmlString);
        }
        catch (Exception e) {
            logger.error(EXEP_STRING + e);
        }
        return xmlString;
    }

    private static String createXmlForSupport(Serializer serializer, NewSupportElement supportElement, Writer writer, String xmlString) {
        String xmlStringTemp = xmlString;
        try {
            serializer.write((Object)supportElement, writer);
            xmlStringTemp = writer.toString();
            writer.close();
        }
        catch (Exception e) {
            logger.error(EXEP_STRING + e);
        }
        return xmlStringTemp;
    }

    public static String createXmlForDeviceElement(DeviceElement deviceElement) {
        String xmlString = null;
        try {
            StringWriter writer = new StringWriter();
            Persister serializer = new Persister();
            xmlString = CreateXmlObject.createXmlForDeviceElement1((Serializer)serializer, deviceElement, writer, xmlString);
        }
        catch (Exception e) {
            logger.error(EXEP_STRING + e);
        }
        logger.debug("The Request is" + xmlString);
        return xmlString;
    }

    private static String createXmlForDeviceElement1(Serializer serializer, DeviceElement deviceElement, Writer writer, String xmlString) {
        String xmlStringTemp = xmlString;
        try {
            serializer.write((Object)deviceElement, writer);
            xmlStringTemp = writer.toString();
            writer.close();
        }
        catch (Exception e) {
            logger.error(EXEP_STRING + e);
        }
        return xmlStringTemp;
    }

    public static String createXmlForFolderDeviceElement(FolderDeviceElement folderDeviceElement) {
        String xmlString = null;
        try {
            StringWriter writer = new StringWriter();
            Persister serializer = new Persister();
            xmlString = CreateXmlObject.createXmlForFolderDeviceElement1((Serializer)serializer, folderDeviceElement, writer, xmlString);
        }
        catch (Exception e) {
            logger.error(EXEP_STRING + e);
        }
        return xmlString;
    }

    private static String createXmlForFolderDeviceElement1(Serializer serializer, FolderDeviceElement folderDeviceElement, Writer writer, String xmlString) {
        String xmlStringTemp = xmlString;
        try {
            serializer.write((Object)folderDeviceElement, writer);
            xmlStringTemp = writer.toString();
            writer.close();
        }
        catch (Exception e) {
            logger.error(EXEP_STRING + e);
        }
        return xmlStringTemp;
    }

    public static String createXmlForFileElement(FileElement fileElement) {
        String xmlString = null;
        try {
            StringWriter writer = new StringWriter();
            Persister serializer = new Persister();
            xmlString = CreateXmlObject.createXmlForFileElement1((Serializer)serializer, fileElement, writer, xmlString);
        }
        catch (Exception e) {
            logger.error(EXEP_STRING + e);
        }
        return xmlString;
    }

    private static String createXmlForFileElement1(Serializer serializer, FileElement fileElement, Writer writer, String xmlString) {
        String xmlStringTemp = xmlString;
        try {
            serializer.write((Object)fileElement, writer);
            xmlStringTemp = writer.toString();
            writer.close();
        }
        catch (Exception e) {
            logger.error(EXEP_STRING + e);
        }
        return xmlStringTemp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] createGzipByteArrayForValidateBackUpRequest(BackupValidationElement backupListElement) {
        Persister serializer = new Persister();
        GZIPOutputStream gzipOS = null;
        byte[] bs = null;
        try {
            try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                logger.debug("Memory free before  writing  " + Runtime.getRuntime().freeMemory());
                gzipOS = new GZIPOutputStream((OutputStream)byteArrayOutputStream);
                serializer.write((Object)backupListElement, (OutputStream)gzipOS);
                logger.debug("Converting memory free to String  " + Runtime.getRuntime().freeMemory());
                gzipOS.close();
                bs = byteArrayOutputStream.toByteArray();
                gzipOS = null;
                logger.debug("After  Write " + Runtime.getRuntime().freeMemory());
                serializer = null;
            }
            IOUtils.closeQuietly((OutputStream)gzipOS);
        }
        catch (Exception e) {
            logger.error(EXEP_STRING + e);
        }
        finally {
            IOUtils.closeQuietly(gzipOS);
        }
        return bs;
    }

    public static byte[] createGzipByteArrayForValidateMediaRequest(MediaValidationElement backupListElement) {
        Persister serializer = new Persister();
        byte[] bs = null;
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
             GZIPOutputStream gzipOS = new GZIPOutputStream((OutputStream)byteArrayOutputStream);){
            logger.debug(" Memory free before  writing " + Runtime.getRuntime().freeMemory());
            serializer.write((Object)backupListElement, (OutputStream)gzipOS);
            logger.debug("Convertin  memory free to String  " + Runtime.getRuntime().freeMemory());
            bs = byteArrayOutputStream.toByteArray();
            logger.debug("After  Writing  memory free  " + Runtime.getRuntime().freeMemory());
        }
        catch (Exception e) {
            logger.error(EXEP_STRING + e);
        }
        return bs;
    }

    public static String createChunkFileElementXml(ChunkFileElement chunkFileElement) {
        Persister serializer = new Persister();
        StringWriter stringWriter = new StringWriter();
        try {
            serializer.write((Object)chunkFileElement, (Writer)stringWriter);
        }
        catch (Exception e) {
            logger.error(EXEP_STRING + e);
        }
        return stringWriter.toString();
    }

    public static String createXmlStringForDeviceCertAuthentication(String deviceCertName) {
        String deviceCertXmlString = null;
        try {
            DeviceCertElement deviceCertElement = new DeviceCertElement();
            deviceCertElement.setCertAuthString(deviceCertName);
            StringWriter writer = new StringWriter();
            Persister serializer = new Persister();
            deviceCertXmlString = CreateXmlObject.createXmlStringForDeviceCertAuthentication1((Serializer)serializer, deviceCertElement, writer, deviceCertXmlString);
        }
        catch (Exception e) {
            logger.error(EXEP_STRING + e);
        }
        return deviceCertXmlString;
    }

    private static String createXmlStringForDeviceCertAuthentication1(Serializer serializer, DeviceCertElement deviceCertElement, Writer writer, String deviceCertXmlString) {
        String deviceCertXmlStringTemp = deviceCertXmlString;
        try {
            serializer.write((Object)deviceCertElement, writer);
            deviceCertXmlStringTemp = writer.toString();
            writer.close();
        }
        catch (Exception e) {
            logger.error(EXEP_STRING + e);
        }
        return deviceCertXmlStringTemp;
    }

    public static String createXmlForBackupStatElement(BackupStatElement backupStatElement) {
        String xmlString = null;
        try {
            StringWriter writer = new StringWriter();
            Persister serializer = new Persister();
            xmlString = CreateXmlObject.createXmlForBackupStatElement1((Serializer)serializer, backupStatElement, writer, xmlString);
        }
        catch (Exception e) {
            logger.error(EXEP_STRING + e);
        }
        return xmlString;
    }

    private static String createXmlForBackupStatElement1(Serializer serializer, BackupStatElement backupStatElement, Writer writer, String xmlString) {
        String xmlStringTemp = xmlString;
        try {
            serializer.write((Object)backupStatElement, writer);
            xmlStringTemp = writer.toString();
            writer.close();
        }
        catch (Exception e) {
            logger.error(EXEP_STRING + e);
        }
        return xmlStringTemp;
    }

    public static String createXmlForRestoreElement(RestoreElement restoreElement) {
        String xmlString = null;
        try {
            StringWriter writer = new StringWriter();
            Persister serializer = new Persister();
            xmlString = CreateXmlObject.createXmlForRestoreElement1((Serializer)serializer, restoreElement, writer, xmlString);
        }
        catch (Exception e) {
            logger.error(EXEP_STRING + e);
        }
        return xmlString;
    }

    private static String createXmlForRestoreElement1(Serializer serializer, RestoreElement restoreElement, Writer writer, String xmlString) {
        String xmlStringTemp = xmlString;
        try {
            serializer.write((Object)restoreElement, writer);
            xmlStringTemp = writer.toString();
            writer.close();
        }
        catch (Exception e) {
            logger.error(EXEP_STRING + e);
        }
        return xmlStringTemp;
    }

    public static String createXmlForRestoreElementList(List<RestoreElement> restoreElements) {
        String xmlString = null;
        try {
            RestoreElementList restoreElementList = new RestoreElementList();
            restoreElementList.setRestoreElements(restoreElements);
            StringWriter writer = new StringWriter();
            Persister serializer = new Persister();
            serializer.write((Object)restoreElementList, (Writer)writer);
            xmlString = ((Object)writer).toString();
            ((Writer)writer).close();
        }
        catch (Exception e) {
            logger.error(EXEP_STRING + e);
        }
        return xmlString;
    }

    public static byte[] createXmlByteArrayForDownload(List<FileTO> listofFileTODownload) {
        CrawlResponseElement responseElement = null;
        byte[] gzipByteAyyar = null;
        try {
            responseElement = CreateXmlObject.formTheDownloadListElement(listofFileTODownload);
            gzipByteAyyar = CreateXmlObject.createByteArrayUsingSerializerForDownload(responseElement.getDownloadFileList());
        }
        catch (Exception e) {
            logger.error(EXEP_STRING + e);
        }
        logger.debug(END_OF_METHOD + Runtime.getRuntime().freeMemory());
        return gzipByteAyyar;
    }

    public static String createXmlForDownloadListElement(List<FileTO> listofFileTODownload) throws InterruptedException {
        CrawlResponseElement crawlResponseElement = CreateXmlObject.formTheDownloadListElement(listofFileTODownload);
        String xmlString = null;
        try {
            StringWriter writer = new StringWriter();
            Persister serializer = new Persister();
            xmlString = CreateXmlObject.createXmlForDownloadListElement1((Serializer)serializer, crawlResponseElement, writer, xmlString);
        }
        catch (Exception e) {
            logger.error(EXEP_STRING + e);
        }
        return xmlString;
    }

    private static String createXmlForDownloadListElement1(Serializer serializer, CrawlResponseElement crawlResponseElement, Writer writer, String xmlString) {
        String xmlStringTemp = xmlString;
        try {
            serializer.write((Object)crawlResponseElement.getDownloadFileList(), writer);
            xmlStringTemp = writer.toString();
            writer.close();
        }
        catch (Exception e) {
            logger.error(EXEP_STRING + e);
        }
        return xmlStringTemp;
    }

    private static CrawlResponseElement formTheDownloadListElement(List<FileTO> listofFileTODownload) throws InterruptedException {
        logger.debug("Memory available before conversion " + Runtime.getRuntime().freeMemory());
        CrawlResponseElement crawlResponseElement = new CrawlResponseElement();
        ArrayList<FileElement> downloadFileElementList = new ArrayList<FileElement>();
        FileListElement fileListElement = CreateXmlObject.convertFromFileToToFileElementAndPerformGC(listofFileTODownload, downloadFileElementList);
        crawlResponseElement.setDownloadFileList(fileListElement);
        return crawlResponseElement;
    }

    private static byte[] createByteArrayUsingSerializerForDownload(FileListElement responseElement) {
        Persister serializer = new Persister();
        byte[] byteArray = null;
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
             GZIPOutputStream gzipOS = new GZIPOutputStream((OutputStream)bos);){
            logger.debug("Free memory creating byte array: " + Runtime.getRuntime().freeMemory());
            serializer.write((Object)responseElement, (OutputStream)gzipOS);
            logger.debug("Free memory creating gzip  " + Runtime.getRuntime().freeMemory());
            byteArray = bos.toByteArray();
            logger.debug("Free memory creating byte array " + Runtime.getRuntime().freeMemory());
        }
        catch (Exception e) {
            logger.error(EXEP_STRING + e);
        }
        return byteArray;
    }

    public static String decompress(byte[] compressed) throws IOException {
        int bytesRead;
        int bufferSize = 32;
        ByteArrayInputStream is = new ByteArrayInputStream(compressed);
        GZIPInputStream gis = new GZIPInputStream((InputStream)is, 32);
        StringBuilder string = new StringBuilder();
        byte[] data = new byte[32];
        while ((bytesRead = gis.read(data)) != -1) {
            string.append(new String(data, 0, bytesRead));
        }
        gis.close();
        is.close();
        return string.toString();
    }

    public static byte[] createXmlByteArrayForDownload(List<FileTO> listofFileTOAdd, List<FileTO> listofFileTOMod, List<FileTO> listofFileTODel, String curTimeStamp, String lastSuccessfulTimeStamp) {
        CrawlDeviceElement deviceElement = null;
        byte[] gzipByteAyyar = null;
        try {
            deviceElement = CreateXmlObject.formTheCrawlDeviceElement(null, null, listofFileTOAdd, listofFileTOMod, listofFileTODel, curTimeStamp, lastSuccessfulTimeStamp);
            gzipByteAyyar = CreateXmlObject.createByteArrayUsingSerializer(deviceElement);
        }
        catch (Exception e) {
            logger.error(EXEP_STRING + e);
        }
        logger.debug(END_OF_METHOD + Runtime.getRuntime().freeMemory());
        return gzipByteAyyar;
    }
}

