/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.service.settings;

import com.jacob.activeX.ActiveXComponent;
import com.jacob.com.Dispatch;
import com.jacob.com.EnumVariant;
import com.jacob.com.JacobObject;
import com.jacob.com.Variant;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class WinDrives {
    private static <T extends Enum<T>> T fromNative(Class<T> clazz, int value) {
        for (Enum c : (Enum[])clazz.getEnumConstants()) {
            if (((HasNativeValue)((Object)c)).getNativeValue() != value) continue;
            return (T)c;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Drive> getDrives() {
        ArrayList<Drive> result = new ArrayList<Drive>();
        ActiveXComponent axWMI = new ActiveXComponent("winmgmts://");
        try {
            Variant devices = axWMI.invoke("ExecQuery", new Variant((Object)"Select DeviceID,DriveType,FileSystem from Win32_LogicalDisk"));
            EnumVariant deviceList = new EnumVariant(devices.toDispatch());
            while (deviceList.hasMoreElements()) {
                Dispatch item = deviceList.nextElement().toDispatch();
                String drive = Dispatch.call((Dispatch)item, (String)"DeviceID").toString().toUpperCase();
                File file = new File(drive + "/");
                DriveTypeEnum driveType = WinDrives.fromNative(DriveTypeEnum.class, Dispatch.call((Dispatch)item, (String)"DriveType").getInt());
                String fileSystem = Dispatch.call((Dispatch)item, (String)"FileSystem").toString();
                result.add(new Drive(fileSystem, driveType, file));
            }
            ArrayList<Drive> arrayList = result;
            return arrayList;
        }
        finally {
            WinDrives.closeQuietly((JacobObject)axWMI);
        }
    }

    private static void closeQuietly(JacobObject jacobObject) {
        try {
            jacobObject.safeRelease();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static interface HasNativeValue {
        public int getNativeValue();
    }

    public static enum DriveTypeEnum implements HasNativeValue
    {
        Unknown(0),
        NoRootDirectory(1),
        RemovableDisk(2),
        LocalDisk(3),
        NetworkDrive(4),
        CompactDisc(5),
        RAMDisk(6);

        public final int nativeValue;

        private DriveTypeEnum(int nativeValue) {
            this.nativeValue = nativeValue;
        }

        @Override
        public int getNativeValue() {
            return this.nativeValue;
        }
    }

    public static final class Drive {
        public final String fileSystem;
        public final DriveTypeEnum driveType;
        public final File file;

        public Drive(String fileSystem, DriveTypeEnum driveType, File file) {
            this.fileSystem = fileSystem;
            this.driveType = driveType;
            this.file = file;
        }

        public String toString() {
            return "Drive{" + this.file + ": " + this.driveType + ", fileSystem=" + this.fileSystem + "}";
        }
    }
}

